<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Tax StructType
 * @subpackage Structs
 */
class Tax extends Entity
{
    /**
     * The CalculateOn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CalculateOn;
    /**
     * The CashDiscount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CashDiscount;
    /**
     * The CreatedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $CreatedDateTime;
    /**
     * The DeductibleVAT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $DeductibleVAT;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Description;
    /**
     * The EnterFromTaxBill
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $EnterFromTaxBill;
    /**
     * The ExcludeFromTaxonTaxCalculation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $ExcludeFromTaxonTaxCalculation;
    /**
     * The IncludeInVATExemptTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $IncludeInVATExemptTotal;
    /**
     * The IncludeInVATTaxableTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $IncludeInVATTaxableTotal;
    /**
     * The LastModifiedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $LastModifiedDateTime;
    /**
     * The NotValidAfter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $NotValidAfter;
    /**
     * The PendingVAT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $PendingVAT;
    /**
     * The ReverseVAT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $ReverseVAT;
    /**
     * The StatisticalVAT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $StatisticalVAT;
    /**
     * The TaxAgency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $TaxAgency;
    /**
     * The TaxClaimableAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $TaxClaimableAccount;
    /**
     * The TaxClaimableSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $TaxClaimableSubaccount;
    /**
     * The TaxExpenseAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $TaxExpenseAccount;
    /**
     * The TaxExpenseSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $TaxExpenseSubaccount;
    /**
     * The TaxID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $TaxID;
    /**
     * The TaxPayableAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $TaxPayableAccount;
    /**
     * The TaxPayableSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $TaxPayableSubaccount;
    /**
     * The TaxSchedule
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TaxSchedule
     */
    public $TaxSchedule;
    /**
     * The TaxType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $TaxType;
    /**
     * The Zones
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Zones
     */
    public $Zones;
    /**
     * Constructor method for Tax
     * @uses Tax::setCalculateOn()
     * @uses Tax::setCashDiscount()
     * @uses Tax::setCreatedDateTime()
     * @uses Tax::setDeductibleVAT()
     * @uses Tax::setDescription()
     * @uses Tax::setEnterFromTaxBill()
     * @uses Tax::setExcludeFromTaxonTaxCalculation()
     * @uses Tax::setIncludeInVATExemptTotal()
     * @uses Tax::setIncludeInVATTaxableTotal()
     * @uses Tax::setLastModifiedDateTime()
     * @uses Tax::setNotValidAfter()
     * @uses Tax::setPendingVAT()
     * @uses Tax::setReverseVAT()
     * @uses Tax::setStatisticalVAT()
     * @uses Tax::setTaxAgency()
     * @uses Tax::setTaxClaimableAccount()
     * @uses Tax::setTaxClaimableSubaccount()
     * @uses Tax::setTaxExpenseAccount()
     * @uses Tax::setTaxExpenseSubaccount()
     * @uses Tax::setTaxID()
     * @uses Tax::setTaxPayableAccount()
     * @uses Tax::setTaxPayableSubaccount()
     * @uses Tax::setTaxSchedule()
     * @uses Tax::setTaxType()
     * @uses Tax::setZones()
     * @param \StructType\StringValue $calculateOn
     * @param \StructType\StringValue $cashDiscount
     * @param \StructType\DateTimeValue $createdDateTime
     * @param \StructType\BooleanValue $deductibleVAT
     * @param \StructType\StringValue $description
     * @param \StructType\BooleanValue $enterFromTaxBill
     * @param \StructType\BooleanValue $excludeFromTaxonTaxCalculation
     * @param \StructType\BooleanValue $includeInVATExemptTotal
     * @param \StructType\BooleanValue $includeInVATTaxableTotal
     * @param \StructType\DateTimeValue $lastModifiedDateTime
     * @param \StructType\DateTimeValue $notValidAfter
     * @param \StructType\BooleanValue $pendingVAT
     * @param \StructType\BooleanValue $reverseVAT
     * @param \StructType\BooleanValue $statisticalVAT
     * @param \StructType\StringValue $taxAgency
     * @param \StructType\StringValue $taxClaimableAccount
     * @param \StructType\StringValue $taxClaimableSubaccount
     * @param \StructType\StringValue $taxExpenseAccount
     * @param \StructType\StringValue $taxExpenseSubaccount
     * @param \StructType\StringValue $taxID
     * @param \StructType\StringValue $taxPayableAccount
     * @param \StructType\StringValue $taxPayableSubaccount
     * @param \StructType\TaxSchedule $taxSchedule
     * @param \StructType\StringValue $taxType
     * @param \StructType\Zones $zones
     */
    public function __construct(\StructType\StringValue $calculateOn = null, \StructType\StringValue $cashDiscount = null, \StructType\DateTimeValue $createdDateTime = null, \StructType\BooleanValue $deductibleVAT = null, \StructType\StringValue $description = null, \StructType\BooleanValue $enterFromTaxBill = null, \StructType\BooleanValue $excludeFromTaxonTaxCalculation = null, \StructType\BooleanValue $includeInVATExemptTotal = null, \StructType\BooleanValue $includeInVATTaxableTotal = null, \StructType\DateTimeValue $lastModifiedDateTime = null, \StructType\DateTimeValue $notValidAfter = null, \StructType\BooleanValue $pendingVAT = null, \StructType\BooleanValue $reverseVAT = null, \StructType\BooleanValue $statisticalVAT = null, \StructType\StringValue $taxAgency = null, \StructType\StringValue $taxClaimableAccount = null, \StructType\StringValue $taxClaimableSubaccount = null, \StructType\StringValue $taxExpenseAccount = null, \StructType\StringValue $taxExpenseSubaccount = null, \StructType\StringValue $taxID = null, \StructType\StringValue $taxPayableAccount = null, \StructType\StringValue $taxPayableSubaccount = null, \StructType\TaxSchedule $taxSchedule = null, \StructType\StringValue $taxType = null, \StructType\Zones $zones = null)
    {
        $this
            ->setCalculateOn($calculateOn)
            ->setCashDiscount($cashDiscount)
            ->setCreatedDateTime($createdDateTime)
            ->setDeductibleVAT($deductibleVAT)
            ->setDescription($description)
            ->setEnterFromTaxBill($enterFromTaxBill)
            ->setExcludeFromTaxonTaxCalculation($excludeFromTaxonTaxCalculation)
            ->setIncludeInVATExemptTotal($includeInVATExemptTotal)
            ->setIncludeInVATTaxableTotal($includeInVATTaxableTotal)
            ->setLastModifiedDateTime($lastModifiedDateTime)
            ->setNotValidAfter($notValidAfter)
            ->setPendingVAT($pendingVAT)
            ->setReverseVAT($reverseVAT)
            ->setStatisticalVAT($statisticalVAT)
            ->setTaxAgency($taxAgency)
            ->setTaxClaimableAccount($taxClaimableAccount)
            ->setTaxClaimableSubaccount($taxClaimableSubaccount)
            ->setTaxExpenseAccount($taxExpenseAccount)
            ->setTaxExpenseSubaccount($taxExpenseSubaccount)
            ->setTaxID($taxID)
            ->setTaxPayableAccount($taxPayableAccount)
            ->setTaxPayableSubaccount($taxPayableSubaccount)
            ->setTaxSchedule($taxSchedule)
            ->setTaxType($taxType)
            ->setZones($zones);
    }
    /**
     * Get CalculateOn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCalculateOn()
    {
        return isset($this->CalculateOn) ? $this->CalculateOn : null;
    }
    /**
     * Set CalculateOn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $calculateOn
     * @return \StructType\Tax
     */
    public function setCalculateOn(\StructType\StringValue $calculateOn = null)
    {
        if (is_null($calculateOn) || (is_array($calculateOn) && empty($calculateOn))) {
            unset($this->CalculateOn);
        } else {
            $this->CalculateOn = $calculateOn;
        }
        return $this;
    }
    /**
     * Get CashDiscount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCashDiscount()
    {
        return isset($this->CashDiscount) ? $this->CashDiscount : null;
    }
    /**
     * Set CashDiscount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $cashDiscount
     * @return \StructType\Tax
     */
    public function setCashDiscount(\StructType\StringValue $cashDiscount = null)
    {
        if (is_null($cashDiscount) || (is_array($cashDiscount) && empty($cashDiscount))) {
            unset($this->CashDiscount);
        } else {
            $this->CashDiscount = $cashDiscount;
        }
        return $this;
    }
    /**
     * Get CreatedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getCreatedDateTime()
    {
        return isset($this->CreatedDateTime) ? $this->CreatedDateTime : null;
    }
    /**
     * Set CreatedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $createdDateTime
     * @return \StructType\Tax
     */
    public function setCreatedDateTime(\StructType\DateTimeValue $createdDateTime = null)
    {
        if (is_null($createdDateTime) || (is_array($createdDateTime) && empty($createdDateTime))) {
            unset($this->CreatedDateTime);
        } else {
            $this->CreatedDateTime = $createdDateTime;
        }
        return $this;
    }
    /**
     * Get DeductibleVAT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getDeductibleVAT()
    {
        return isset($this->DeductibleVAT) ? $this->DeductibleVAT : null;
    }
    /**
     * Set DeductibleVAT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $deductibleVAT
     * @return \StructType\Tax
     */
    public function setDeductibleVAT(\StructType\BooleanValue $deductibleVAT = null)
    {
        if (is_null($deductibleVAT) || (is_array($deductibleVAT) && empty($deductibleVAT))) {
            unset($this->DeductibleVAT);
        } else {
            $this->DeductibleVAT = $deductibleVAT;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $description
     * @return \StructType\Tax
     */
    public function setDescription(\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get EnterFromTaxBill value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getEnterFromTaxBill()
    {
        return isset($this->EnterFromTaxBill) ? $this->EnterFromTaxBill : null;
    }
    /**
     * Set EnterFromTaxBill value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $enterFromTaxBill
     * @return \StructType\Tax
     */
    public function setEnterFromTaxBill(\StructType\BooleanValue $enterFromTaxBill = null)
    {
        if (is_null($enterFromTaxBill) || (is_array($enterFromTaxBill) && empty($enterFromTaxBill))) {
            unset($this->EnterFromTaxBill);
        } else {
            $this->EnterFromTaxBill = $enterFromTaxBill;
        }
        return $this;
    }
    /**
     * Get ExcludeFromTaxonTaxCalculation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getExcludeFromTaxonTaxCalculation()
    {
        return isset($this->ExcludeFromTaxonTaxCalculation) ? $this->ExcludeFromTaxonTaxCalculation : null;
    }
    /**
     * Set ExcludeFromTaxonTaxCalculation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $excludeFromTaxonTaxCalculation
     * @return \StructType\Tax
     */
    public function setExcludeFromTaxonTaxCalculation(\StructType\BooleanValue $excludeFromTaxonTaxCalculation = null)
    {
        if (is_null($excludeFromTaxonTaxCalculation) || (is_array($excludeFromTaxonTaxCalculation) && empty($excludeFromTaxonTaxCalculation))) {
            unset($this->ExcludeFromTaxonTaxCalculation);
        } else {
            $this->ExcludeFromTaxonTaxCalculation = $excludeFromTaxonTaxCalculation;
        }
        return $this;
    }
    /**
     * Get IncludeInVATExemptTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getIncludeInVATExemptTotal()
    {
        return isset($this->IncludeInVATExemptTotal) ? $this->IncludeInVATExemptTotal : null;
    }
    /**
     * Set IncludeInVATExemptTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $includeInVATExemptTotal
     * @return \StructType\Tax
     */
    public function setIncludeInVATExemptTotal(\StructType\BooleanValue $includeInVATExemptTotal = null)
    {
        if (is_null($includeInVATExemptTotal) || (is_array($includeInVATExemptTotal) && empty($includeInVATExemptTotal))) {
            unset($this->IncludeInVATExemptTotal);
        } else {
            $this->IncludeInVATExemptTotal = $includeInVATExemptTotal;
        }
        return $this;
    }
    /**
     * Get IncludeInVATTaxableTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getIncludeInVATTaxableTotal()
    {
        return isset($this->IncludeInVATTaxableTotal) ? $this->IncludeInVATTaxableTotal : null;
    }
    /**
     * Set IncludeInVATTaxableTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $includeInVATTaxableTotal
     * @return \StructType\Tax
     */
    public function setIncludeInVATTaxableTotal(\StructType\BooleanValue $includeInVATTaxableTotal = null)
    {
        if (is_null($includeInVATTaxableTotal) || (is_array($includeInVATTaxableTotal) && empty($includeInVATTaxableTotal))) {
            unset($this->IncludeInVATTaxableTotal);
        } else {
            $this->IncludeInVATTaxableTotal = $includeInVATTaxableTotal;
        }
        return $this;
    }
    /**
     * Get LastModifiedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getLastModifiedDateTime()
    {
        return isset($this->LastModifiedDateTime) ? $this->LastModifiedDateTime : null;
    }
    /**
     * Set LastModifiedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $lastModifiedDateTime
     * @return \StructType\Tax
     */
    public function setLastModifiedDateTime(\StructType\DateTimeValue $lastModifiedDateTime = null)
    {
        if (is_null($lastModifiedDateTime) || (is_array($lastModifiedDateTime) && empty($lastModifiedDateTime))) {
            unset($this->LastModifiedDateTime);
        } else {
            $this->LastModifiedDateTime = $lastModifiedDateTime;
        }
        return $this;
    }
    /**
     * Get NotValidAfter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getNotValidAfter()
    {
        return isset($this->NotValidAfter) ? $this->NotValidAfter : null;
    }
    /**
     * Set NotValidAfter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $notValidAfter
     * @return \StructType\Tax
     */
    public function setNotValidAfter(\StructType\DateTimeValue $notValidAfter = null)
    {
        if (is_null($notValidAfter) || (is_array($notValidAfter) && empty($notValidAfter))) {
            unset($this->NotValidAfter);
        } else {
            $this->NotValidAfter = $notValidAfter;
        }
        return $this;
    }
    /**
     * Get PendingVAT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getPendingVAT()
    {
        return isset($this->PendingVAT) ? $this->PendingVAT : null;
    }
    /**
     * Set PendingVAT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $pendingVAT
     * @return \StructType\Tax
     */
    public function setPendingVAT(\StructType\BooleanValue $pendingVAT = null)
    {
        if (is_null($pendingVAT) || (is_array($pendingVAT) && empty($pendingVAT))) {
            unset($this->PendingVAT);
        } else {
            $this->PendingVAT = $pendingVAT;
        }
        return $this;
    }
    /**
     * Get ReverseVAT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getReverseVAT()
    {
        return isset($this->ReverseVAT) ? $this->ReverseVAT : null;
    }
    /**
     * Set ReverseVAT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $reverseVAT
     * @return \StructType\Tax
     */
    public function setReverseVAT(\StructType\BooleanValue $reverseVAT = null)
    {
        if (is_null($reverseVAT) || (is_array($reverseVAT) && empty($reverseVAT))) {
            unset($this->ReverseVAT);
        } else {
            $this->ReverseVAT = $reverseVAT;
        }
        return $this;
    }
    /**
     * Get StatisticalVAT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getStatisticalVAT()
    {
        return isset($this->StatisticalVAT) ? $this->StatisticalVAT : null;
    }
    /**
     * Set StatisticalVAT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $statisticalVAT
     * @return \StructType\Tax
     */
    public function setStatisticalVAT(\StructType\BooleanValue $statisticalVAT = null)
    {
        if (is_null($statisticalVAT) || (is_array($statisticalVAT) && empty($statisticalVAT))) {
            unset($this->StatisticalVAT);
        } else {
            $this->StatisticalVAT = $statisticalVAT;
        }
        return $this;
    }
    /**
     * Get TaxAgency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getTaxAgency()
    {
        return isset($this->TaxAgency) ? $this->TaxAgency : null;
    }
    /**
     * Set TaxAgency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $taxAgency
     * @return \StructType\Tax
     */
    public function setTaxAgency(\StructType\StringValue $taxAgency = null)
    {
        if (is_null($taxAgency) || (is_array($taxAgency) && empty($taxAgency))) {
            unset($this->TaxAgency);
        } else {
            $this->TaxAgency = $taxAgency;
        }
        return $this;
    }
    /**
     * Get TaxClaimableAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getTaxClaimableAccount()
    {
        return isset($this->TaxClaimableAccount) ? $this->TaxClaimableAccount : null;
    }
    /**
     * Set TaxClaimableAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $taxClaimableAccount
     * @return \StructType\Tax
     */
    public function setTaxClaimableAccount(\StructType\StringValue $taxClaimableAccount = null)
    {
        if (is_null($taxClaimableAccount) || (is_array($taxClaimableAccount) && empty($taxClaimableAccount))) {
            unset($this->TaxClaimableAccount);
        } else {
            $this->TaxClaimableAccount = $taxClaimableAccount;
        }
        return $this;
    }
    /**
     * Get TaxClaimableSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getTaxClaimableSubaccount()
    {
        return isset($this->TaxClaimableSubaccount) ? $this->TaxClaimableSubaccount : null;
    }
    /**
     * Set TaxClaimableSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $taxClaimableSubaccount
     * @return \StructType\Tax
     */
    public function setTaxClaimableSubaccount(\StructType\StringValue $taxClaimableSubaccount = null)
    {
        if (is_null($taxClaimableSubaccount) || (is_array($taxClaimableSubaccount) && empty($taxClaimableSubaccount))) {
            unset($this->TaxClaimableSubaccount);
        } else {
            $this->TaxClaimableSubaccount = $taxClaimableSubaccount;
        }
        return $this;
    }
    /**
     * Get TaxExpenseAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getTaxExpenseAccount()
    {
        return isset($this->TaxExpenseAccount) ? $this->TaxExpenseAccount : null;
    }
    /**
     * Set TaxExpenseAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $taxExpenseAccount
     * @return \StructType\Tax
     */
    public function setTaxExpenseAccount(\StructType\StringValue $taxExpenseAccount = null)
    {
        if (is_null($taxExpenseAccount) || (is_array($taxExpenseAccount) && empty($taxExpenseAccount))) {
            unset($this->TaxExpenseAccount);
        } else {
            $this->TaxExpenseAccount = $taxExpenseAccount;
        }
        return $this;
    }
    /**
     * Get TaxExpenseSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getTaxExpenseSubaccount()
    {
        return isset($this->TaxExpenseSubaccount) ? $this->TaxExpenseSubaccount : null;
    }
    /**
     * Set TaxExpenseSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $taxExpenseSubaccount
     * @return \StructType\Tax
     */
    public function setTaxExpenseSubaccount(\StructType\StringValue $taxExpenseSubaccount = null)
    {
        if (is_null($taxExpenseSubaccount) || (is_array($taxExpenseSubaccount) && empty($taxExpenseSubaccount))) {
            unset($this->TaxExpenseSubaccount);
        } else {
            $this->TaxExpenseSubaccount = $taxExpenseSubaccount;
        }
        return $this;
    }
    /**
     * Get TaxID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getTaxID()
    {
        return isset($this->TaxID) ? $this->TaxID : null;
    }
    /**
     * Set TaxID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $taxID
     * @return \StructType\Tax
     */
    public function setTaxID(\StructType\StringValue $taxID = null)
    {
        if (is_null($taxID) || (is_array($taxID) && empty($taxID))) {
            unset($this->TaxID);
        } else {
            $this->TaxID = $taxID;
        }
        return $this;
    }
    /**
     * Get TaxPayableAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getTaxPayableAccount()
    {
        return isset($this->TaxPayableAccount) ? $this->TaxPayableAccount : null;
    }
    /**
     * Set TaxPayableAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $taxPayableAccount
     * @return \StructType\Tax
     */
    public function setTaxPayableAccount(\StructType\StringValue $taxPayableAccount = null)
    {
        if (is_null($taxPayableAccount) || (is_array($taxPayableAccount) && empty($taxPayableAccount))) {
            unset($this->TaxPayableAccount);
        } else {
            $this->TaxPayableAccount = $taxPayableAccount;
        }
        return $this;
    }
    /**
     * Get TaxPayableSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getTaxPayableSubaccount()
    {
        return isset($this->TaxPayableSubaccount) ? $this->TaxPayableSubaccount : null;
    }
    /**
     * Set TaxPayableSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $taxPayableSubaccount
     * @return \StructType\Tax
     */
    public function setTaxPayableSubaccount(\StructType\StringValue $taxPayableSubaccount = null)
    {
        if (is_null($taxPayableSubaccount) || (is_array($taxPayableSubaccount) && empty($taxPayableSubaccount))) {
            unset($this->TaxPayableSubaccount);
        } else {
            $this->TaxPayableSubaccount = $taxPayableSubaccount;
        }
        return $this;
    }
    /**
     * Get TaxSchedule value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TaxSchedule|null
     */
    public function getTaxSchedule()
    {
        return isset($this->TaxSchedule) ? $this->TaxSchedule : null;
    }
    /**
     * Set TaxSchedule value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\TaxSchedule $taxSchedule
     * @return \StructType\Tax
     */
    public function setTaxSchedule(\StructType\TaxSchedule $taxSchedule = null)
    {
        if (is_null($taxSchedule) || (is_array($taxSchedule) && empty($taxSchedule))) {
            unset($this->TaxSchedule);
        } else {
            $this->TaxSchedule = $taxSchedule;
        }
        return $this;
    }
    /**
     * Get TaxType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getTaxType()
    {
        return isset($this->TaxType) ? $this->TaxType : null;
    }
    /**
     * Set TaxType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $taxType
     * @return \StructType\Tax
     */
    public function setTaxType(\StructType\StringValue $taxType = null)
    {
        if (is_null($taxType) || (is_array($taxType) && empty($taxType))) {
            unset($this->TaxType);
        } else {
            $this->TaxType = $taxType;
        }
        return $this;
    }
    /**
     * Get Zones value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Zones|null
     */
    public function getZones()
    {
        return isset($this->Zones) ? $this->Zones : null;
    }
    /**
     * Set Zones value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Zones $zones
     * @return \StructType\Tax
     */
    public function setZones(\StructType\Zones $zones = null)
    {
        if (is_null($zones) || (is_array($zones) && empty($zones))) {
            unset($this->Zones);
        } else {
            $this->Zones = $zones;
        }
        return $this;
    }
}
