<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShippingInstructions StructType
 * @subpackage Structs
 */
class ShippingInstructions extends Entity
{
    /**
     * The ShippingDestinationType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ShippingDestinationType;
    /**
     * The ShippingLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ShippingLocation;
    /**
     * The ShipTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ShipTo;
    /**
     * The ShipToAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Address
     */
    public $ShipToAddress;
    /**
     * The ShipToAddressOverride
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $ShipToAddressOverride;
    /**
     * The ShipToAddressValidated
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $ShipToAddressValidated;
    /**
     * The ShipToContact
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DocContact
     */
    public $ShipToContact;
    /**
     * The ShipToContactOverride
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $ShipToContactOverride;
    /**
     * The Warehouse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Warehouse;
    /**
     * Constructor method for ShippingInstructions
     * @uses ShippingInstructions::setShippingDestinationType()
     * @uses ShippingInstructions::setShippingLocation()
     * @uses ShippingInstructions::setShipTo()
     * @uses ShippingInstructions::setShipToAddress()
     * @uses ShippingInstructions::setShipToAddressOverride()
     * @uses ShippingInstructions::setShipToAddressValidated()
     * @uses ShippingInstructions::setShipToContact()
     * @uses ShippingInstructions::setShipToContactOverride()
     * @uses ShippingInstructions::setWarehouse()
     * @param \StructType\StringValue $shippingDestinationType
     * @param \StructType\StringValue $shippingLocation
     * @param \StructType\StringValue $shipTo
     * @param \StructType\Address $shipToAddress
     * @param \StructType\BooleanValue $shipToAddressOverride
     * @param \StructType\BooleanValue $shipToAddressValidated
     * @param \StructType\DocContact $shipToContact
     * @param \StructType\BooleanValue $shipToContactOverride
     * @param \StructType\StringValue $warehouse
     */
    public function __construct(\StructType\StringValue $shippingDestinationType = null, \StructType\StringValue $shippingLocation = null, \StructType\StringValue $shipTo = null, \StructType\Address $shipToAddress = null, \StructType\BooleanValue $shipToAddressOverride = null, \StructType\BooleanValue $shipToAddressValidated = null, \StructType\DocContact $shipToContact = null, \StructType\BooleanValue $shipToContactOverride = null, \StructType\StringValue $warehouse = null)
    {
        $this
            ->setShippingDestinationType($shippingDestinationType)
            ->setShippingLocation($shippingLocation)
            ->setShipTo($shipTo)
            ->setShipToAddress($shipToAddress)
            ->setShipToAddressOverride($shipToAddressOverride)
            ->setShipToAddressValidated($shipToAddressValidated)
            ->setShipToContact($shipToContact)
            ->setShipToContactOverride($shipToContactOverride)
            ->setWarehouse($warehouse);
    }
    /**
     * Get ShippingDestinationType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getShippingDestinationType()
    {
        return isset($this->ShippingDestinationType) ? $this->ShippingDestinationType : null;
    }
    /**
     * Set ShippingDestinationType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $shippingDestinationType
     * @return \StructType\ShippingInstructions
     */
    public function setShippingDestinationType(\StructType\StringValue $shippingDestinationType = null)
    {
        if (is_null($shippingDestinationType) || (is_array($shippingDestinationType) && empty($shippingDestinationType))) {
            unset($this->ShippingDestinationType);
        } else {
            $this->ShippingDestinationType = $shippingDestinationType;
        }
        return $this;
    }
    /**
     * Get ShippingLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getShippingLocation()
    {
        return isset($this->ShippingLocation) ? $this->ShippingLocation : null;
    }
    /**
     * Set ShippingLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $shippingLocation
     * @return \StructType\ShippingInstructions
     */
    public function setShippingLocation(\StructType\StringValue $shippingLocation = null)
    {
        if (is_null($shippingLocation) || (is_array($shippingLocation) && empty($shippingLocation))) {
            unset($this->ShippingLocation);
        } else {
            $this->ShippingLocation = $shippingLocation;
        }
        return $this;
    }
    /**
     * Get ShipTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getShipTo()
    {
        return isset($this->ShipTo) ? $this->ShipTo : null;
    }
    /**
     * Set ShipTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $shipTo
     * @return \StructType\ShippingInstructions
     */
    public function setShipTo(\StructType\StringValue $shipTo = null)
    {
        if (is_null($shipTo) || (is_array($shipTo) && empty($shipTo))) {
            unset($this->ShipTo);
        } else {
            $this->ShipTo = $shipTo;
        }
        return $this;
    }
    /**
     * Get ShipToAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Address|null
     */
    public function getShipToAddress()
    {
        return isset($this->ShipToAddress) ? $this->ShipToAddress : null;
    }
    /**
     * Set ShipToAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Address $shipToAddress
     * @return \StructType\ShippingInstructions
     */
    public function setShipToAddress(\StructType\Address $shipToAddress = null)
    {
        if (is_null($shipToAddress) || (is_array($shipToAddress) && empty($shipToAddress))) {
            unset($this->ShipToAddress);
        } else {
            $this->ShipToAddress = $shipToAddress;
        }
        return $this;
    }
    /**
     * Get ShipToAddressOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getShipToAddressOverride()
    {
        return isset($this->ShipToAddressOverride) ? $this->ShipToAddressOverride : null;
    }
    /**
     * Set ShipToAddressOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $shipToAddressOverride
     * @return \StructType\ShippingInstructions
     */
    public function setShipToAddressOverride(\StructType\BooleanValue $shipToAddressOverride = null)
    {
        if (is_null($shipToAddressOverride) || (is_array($shipToAddressOverride) && empty($shipToAddressOverride))) {
            unset($this->ShipToAddressOverride);
        } else {
            $this->ShipToAddressOverride = $shipToAddressOverride;
        }
        return $this;
    }
    /**
     * Get ShipToAddressValidated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getShipToAddressValidated()
    {
        return isset($this->ShipToAddressValidated) ? $this->ShipToAddressValidated : null;
    }
    /**
     * Set ShipToAddressValidated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $shipToAddressValidated
     * @return \StructType\ShippingInstructions
     */
    public function setShipToAddressValidated(\StructType\BooleanValue $shipToAddressValidated = null)
    {
        if (is_null($shipToAddressValidated) || (is_array($shipToAddressValidated) && empty($shipToAddressValidated))) {
            unset($this->ShipToAddressValidated);
        } else {
            $this->ShipToAddressValidated = $shipToAddressValidated;
        }
        return $this;
    }
    /**
     * Get ShipToContact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DocContact|null
     */
    public function getShipToContact()
    {
        return isset($this->ShipToContact) ? $this->ShipToContact : null;
    }
    /**
     * Set ShipToContact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DocContact $shipToContact
     * @return \StructType\ShippingInstructions
     */
    public function setShipToContact(\StructType\DocContact $shipToContact = null)
    {
        if (is_null($shipToContact) || (is_array($shipToContact) && empty($shipToContact))) {
            unset($this->ShipToContact);
        } else {
            $this->ShipToContact = $shipToContact;
        }
        return $this;
    }
    /**
     * Get ShipToContactOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getShipToContactOverride()
    {
        return isset($this->ShipToContactOverride) ? $this->ShipToContactOverride : null;
    }
    /**
     * Set ShipToContactOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $shipToContactOverride
     * @return \StructType\ShippingInstructions
     */
    public function setShipToContactOverride(\StructType\BooleanValue $shipToContactOverride = null)
    {
        if (is_null($shipToContactOverride) || (is_array($shipToContactOverride) && empty($shipToContactOverride))) {
            unset($this->ShipToContactOverride);
        } else {
            $this->ShipToContactOverride = $shipToContactOverride;
        }
        return $this;
    }
    /**
     * Get Warehouse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getWarehouse()
    {
        return isset($this->Warehouse) ? $this->Warehouse : null;
    }
    /**
     * Set Warehouse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $warehouse
     * @return \StructType\ShippingInstructions
     */
    public function setWarehouse(\StructType\StringValue $warehouse = null)
    {
        if (is_null($warehouse) || (is_array($warehouse) && empty($warehouse))) {
            unset($this->Warehouse);
        } else {
            $this->Warehouse = $warehouse;
        }
        return $this;
    }
}
