<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesPersons StructType
 * @subpackage Structs
 */
class SalesPersons_1 extends AbstractStructBase
{
    /**
     * The SalesPersonDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SalesPersonDetail[]
     */
    public $SalesPersonDetail;
    /**
     * The SalesInvoiceSalesPersonDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SalesInvoiceSalesPersonDetail[]
     */
    public $SalesInvoiceSalesPersonDetail;
    /**
     * Constructor method for SalesPersons
     * @uses SalesPersons_1::setSalesPersonDetail()
     * @uses SalesPersons_1::setSalesInvoiceSalesPersonDetail()
     * @param \StructType\SalesPersonDetail[] $salesPersonDetail
     * @param \StructType\SalesInvoiceSalesPersonDetail[] $salesInvoiceSalesPersonDetail
     */
    public function __construct(array $salesPersonDetail = array(), array $salesInvoiceSalesPersonDetail = array())
    {
        $this
            ->setSalesPersonDetail($salesPersonDetail)
            ->setSalesInvoiceSalesPersonDetail($salesInvoiceSalesPersonDetail);
    }
    /**
     * Get SalesPersonDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SalesPersonDetail[]|null
     */
    public function getSalesPersonDetail()
    {
        return isset($this->SalesPersonDetail) ? $this->SalesPersonDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSalesPersonDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSalesPersonDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSalesPersonDetailForArrayConstraintsFromSetSalesPersonDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $salesPersonsSalesPersonDetailItem) {
            // validation for constraint: itemType
            if (!$salesPersonsSalesPersonDetailItem instanceof \StructType\SalesPersonDetail) {
                $invalidValues[] = is_object($salesPersonsSalesPersonDetailItem) ? get_class($salesPersonsSalesPersonDetailItem) : sprintf('%s(%s)', gettype($salesPersonsSalesPersonDetailItem), var_export($salesPersonsSalesPersonDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SalesPersonDetail property can only contain items of type \StructType\SalesPersonDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SalesPersonDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SalesPersonDetail[] $salesPersonDetail
     * @return \StructType\SalesPersons_1
     */
    public function setSalesPersonDetail(array $salesPersonDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($salesPersonDetailArrayErrorMessage = self::validateSalesPersonDetailForArrayConstraintsFromSetSalesPersonDetail($salesPersonDetail))) {
            throw new \InvalidArgumentException($salesPersonDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($salesPersonDetail) || (is_array($salesPersonDetail) && empty($salesPersonDetail))) {
            unset($this->SalesPersonDetail);
        } else {
            $this->SalesPersonDetail = $salesPersonDetail;
        }
        return $this;
    }
    /**
     * Add item to SalesPersonDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\SalesPersonDetail $item
     * @return \StructType\SalesPersons_1
     */
    public function addToSalesPersonDetail(\StructType\SalesPersonDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SalesPersonDetail) {
            throw new \InvalidArgumentException(sprintf('The SalesPersonDetail property can only contain items of type \StructType\SalesPersonDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SalesPersonDetail[] = $item;
        return $this;
    }
    /**
     * Get SalesInvoiceSalesPersonDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SalesInvoiceSalesPersonDetail[]|null
     */
    public function getSalesInvoiceSalesPersonDetail()
    {
        return isset($this->SalesInvoiceSalesPersonDetail) ? $this->SalesInvoiceSalesPersonDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSalesInvoiceSalesPersonDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSalesInvoiceSalesPersonDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSalesInvoiceSalesPersonDetailForArrayConstraintsFromSetSalesInvoiceSalesPersonDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $salesPersonsSalesInvoiceSalesPersonDetailItem) {
            // validation for constraint: itemType
            if (!$salesPersonsSalesInvoiceSalesPersonDetailItem instanceof \StructType\SalesInvoiceSalesPersonDetail) {
                $invalidValues[] = is_object($salesPersonsSalesInvoiceSalesPersonDetailItem) ? get_class($salesPersonsSalesInvoiceSalesPersonDetailItem) : sprintf('%s(%s)', gettype($salesPersonsSalesInvoiceSalesPersonDetailItem), var_export($salesPersonsSalesInvoiceSalesPersonDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SalesInvoiceSalesPersonDetail property can only contain items of type \StructType\SalesInvoiceSalesPersonDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SalesInvoiceSalesPersonDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SalesInvoiceSalesPersonDetail[] $salesInvoiceSalesPersonDetail
     * @return \StructType\SalesPersons_1
     */
    public function setSalesInvoiceSalesPersonDetail(array $salesInvoiceSalesPersonDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($salesInvoiceSalesPersonDetailArrayErrorMessage = self::validateSalesInvoiceSalesPersonDetailForArrayConstraintsFromSetSalesInvoiceSalesPersonDetail($salesInvoiceSalesPersonDetail))) {
            throw new \InvalidArgumentException($salesInvoiceSalesPersonDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($salesInvoiceSalesPersonDetail) || (is_array($salesInvoiceSalesPersonDetail) && empty($salesInvoiceSalesPersonDetail))) {
            unset($this->SalesInvoiceSalesPersonDetail);
        } else {
            $this->SalesInvoiceSalesPersonDetail = $salesInvoiceSalesPersonDetail;
        }
        return $this;
    }
    /**
     * Add item to SalesInvoiceSalesPersonDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\SalesInvoiceSalesPersonDetail $item
     * @return \StructType\SalesPersons_1
     */
    public function addToSalesInvoiceSalesPersonDetail(\StructType\SalesInvoiceSalesPersonDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SalesInvoiceSalesPersonDetail) {
            throw new \InvalidArgumentException(sprintf('The SalesInvoiceSalesPersonDetail property can only contain items of type \StructType\SalesInvoiceSalesPersonDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SalesInvoiceSalesPersonDetail[] = $item;
        return $this;
    }
}
