<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesOrderDetail StructType
 * @subpackage Structs
 */
class SalesOrderDetail extends Entity
{
    /**
     * The Account
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Account;
    /**
     * The Allocations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Allocations
     */
    public $Allocations;
    /**
     * The AlternateID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $AlternateID;
    /**
     * The AutoCreateIssue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $AutoCreateIssue;
    /**
     * The AverageCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $AverageCost;
    /**
     * The Branch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Branch;
    /**
     * The CalculateDiscountsOnImport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $CalculateDiscountsOnImport;
    /**
     * The Commissionable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $Commissionable;
    /**
     * The Completed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $Completed;
    /**
     * The CostCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CostCode;
    /**
     * The DiscountAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $DiscountAmount;
    /**
     * The DiscountCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $DiscountCode;
    /**
     * The DiscountedUnitPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $DiscountedUnitPrice;
    /**
     * The DiscountPercent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $DiscountPercent;
    /**
     * The ExtendedPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $ExtendedPrice;
    /**
     * The FreeItem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $FreeItem;
    /**
     * The InventoryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $InventoryID;
    /**
     * The LastModifiedDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $LastModifiedDate;
    /**
     * The LineDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $LineDescription;
    /**
     * The LineNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IntValue
     */
    public $LineNbr;
    /**
     * The LineType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $LineType;
    /**
     * The Location
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Location;
    /**
     * The ManualDiscount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $ManualDiscount;
    /**
     * The MarkForPO
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $MarkForPO;
    /**
     * The OpenQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $OpenQty;
    /**
     * The Operation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Operation;
    /**
     * The OrderQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $OrderQty;
    /**
     * The OvershipThreshold
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $OvershipThreshold;
    /**
     * The POSource
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $POSource;
    /**
     * The ProjectTask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ProjectTask;
    /**
     * The PurchasingSettings
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PurchaseSettings
     */
    public $PurchasingSettings;
    /**
     * The QtyOnShipments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $QtyOnShipments;
    /**
     * The ReasonCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ReasonCode;
    /**
     * The RequestedOn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $RequestedOn;
    /**
     * The SalespersonID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $SalespersonID;
    /**
     * The ShipOn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $ShipOn;
    /**
     * The ShippingRule
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ShippingRule;
    /**
     * The Subitem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Subitem;
    /**
     * The TaxCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $TaxCategory;
    /**
     * The UnbilledAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $UnbilledAmount;
    /**
     * The UndershipThreshold
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $UndershipThreshold;
    /**
     * The UnitCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $UnitCost;
    /**
     * The UnitPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $UnitPrice;
    /**
     * The UOM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $UOM;
    /**
     * The WarehouseID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $WarehouseID;
    /**
     * Constructor method for SalesOrderDetail
     * @uses SalesOrderDetail::setAccount()
     * @uses SalesOrderDetail::setAllocations()
     * @uses SalesOrderDetail::setAlternateID()
     * @uses SalesOrderDetail::setAutoCreateIssue()
     * @uses SalesOrderDetail::setAverageCost()
     * @uses SalesOrderDetail::setBranch()
     * @uses SalesOrderDetail::setCalculateDiscountsOnImport()
     * @uses SalesOrderDetail::setCommissionable()
     * @uses SalesOrderDetail::setCompleted()
     * @uses SalesOrderDetail::setCostCode()
     * @uses SalesOrderDetail::setDiscountAmount()
     * @uses SalesOrderDetail::setDiscountCode()
     * @uses SalesOrderDetail::setDiscountedUnitPrice()
     * @uses SalesOrderDetail::setDiscountPercent()
     * @uses SalesOrderDetail::setExtendedPrice()
     * @uses SalesOrderDetail::setFreeItem()
     * @uses SalesOrderDetail::setInventoryID()
     * @uses SalesOrderDetail::setLastModifiedDate()
     * @uses SalesOrderDetail::setLineDescription()
     * @uses SalesOrderDetail::setLineNbr()
     * @uses SalesOrderDetail::setLineType()
     * @uses SalesOrderDetail::setLocation()
     * @uses SalesOrderDetail::setManualDiscount()
     * @uses SalesOrderDetail::setMarkForPO()
     * @uses SalesOrderDetail::setOpenQty()
     * @uses SalesOrderDetail::setOperation()
     * @uses SalesOrderDetail::setOrderQty()
     * @uses SalesOrderDetail::setOvershipThreshold()
     * @uses SalesOrderDetail::setPOSource()
     * @uses SalesOrderDetail::setProjectTask()
     * @uses SalesOrderDetail::setPurchasingSettings()
     * @uses SalesOrderDetail::setQtyOnShipments()
     * @uses SalesOrderDetail::setReasonCode()
     * @uses SalesOrderDetail::setRequestedOn()
     * @uses SalesOrderDetail::setSalespersonID()
     * @uses SalesOrderDetail::setShipOn()
     * @uses SalesOrderDetail::setShippingRule()
     * @uses SalesOrderDetail::setSubitem()
     * @uses SalesOrderDetail::setTaxCategory()
     * @uses SalesOrderDetail::setUnbilledAmount()
     * @uses SalesOrderDetail::setUndershipThreshold()
     * @uses SalesOrderDetail::setUnitCost()
     * @uses SalesOrderDetail::setUnitPrice()
     * @uses SalesOrderDetail::setUOM()
     * @uses SalesOrderDetail::setWarehouseID()
     * @param \StructType\StringValue $account
     * @param \StructType\Allocations $allocations
     * @param \StructType\StringValue $alternateID
     * @param \StructType\BooleanValue $autoCreateIssue
     * @param \StructType\DecimalValue $averageCost
     * @param \StructType\StringValue $branch
     * @param \StructType\BooleanValue $calculateDiscountsOnImport
     * @param \StructType\BooleanValue $commissionable
     * @param \StructType\BooleanValue $completed
     * @param \StructType\StringValue $costCode
     * @param \StructType\DecimalValue $discountAmount
     * @param \StructType\StringValue $discountCode
     * @param \StructType\DecimalValue $discountedUnitPrice
     * @param \StructType\DecimalValue $discountPercent
     * @param \StructType\DecimalValue $extendedPrice
     * @param \StructType\BooleanValue $freeItem
     * @param \StructType\StringValue $inventoryID
     * @param \StructType\StringValue $lastModifiedDate
     * @param \StructType\StringValue $lineDescription
     * @param \StructType\IntValue $lineNbr
     * @param \StructType\StringValue $lineType
     * @param \StructType\StringValue $location
     * @param \StructType\BooleanValue $manualDiscount
     * @param \StructType\BooleanValue $markForPO
     * @param \StructType\DecimalValue $openQty
     * @param \StructType\StringValue $operation
     * @param \StructType\DecimalValue $orderQty
     * @param \StructType\DecimalValue $overshipThreshold
     * @param \StructType\StringValue $pOSource
     * @param \StructType\StringValue $projectTask
     * @param \StructType\PurchaseSettings $purchasingSettings
     * @param \StructType\DecimalValue $qtyOnShipments
     * @param \StructType\StringValue $reasonCode
     * @param \StructType\DateTimeValue $requestedOn
     * @param \StructType\StringValue $salespersonID
     * @param \StructType\DateTimeValue $shipOn
     * @param \StructType\StringValue $shippingRule
     * @param \StructType\StringValue $subitem
     * @param \StructType\StringValue $taxCategory
     * @param \StructType\DecimalValue $unbilledAmount
     * @param \StructType\DecimalValue $undershipThreshold
     * @param \StructType\DecimalValue $unitCost
     * @param \StructType\DecimalValue $unitPrice
     * @param \StructType\StringValue $uOM
     * @param \StructType\StringValue $warehouseID
     */
    public function __construct(\StructType\StringValue $account = null, \StructType\Allocations $allocations = null, \StructType\StringValue $alternateID = null, \StructType\BooleanValue $autoCreateIssue = null, \StructType\DecimalValue $averageCost = null, \StructType\StringValue $branch = null, \StructType\BooleanValue $calculateDiscountsOnImport = null, \StructType\BooleanValue $commissionable = null, \StructType\BooleanValue $completed = null, \StructType\StringValue $costCode = null, \StructType\DecimalValue $discountAmount = null, \StructType\StringValue $discountCode = null, \StructType\DecimalValue $discountedUnitPrice = null, \StructType\DecimalValue $discountPercent = null, \StructType\DecimalValue $extendedPrice = null, \StructType\BooleanValue $freeItem = null, \StructType\StringValue $inventoryID = null, \StructType\StringValue $lastModifiedDate = null, \StructType\StringValue $lineDescription = null, \StructType\IntValue $lineNbr = null, \StructType\StringValue $lineType = null, \StructType\StringValue $location = null, \StructType\BooleanValue $manualDiscount = null, \StructType\BooleanValue $markForPO = null, \StructType\DecimalValue $openQty = null, \StructType\StringValue $operation = null, \StructType\DecimalValue $orderQty = null, \StructType\DecimalValue $overshipThreshold = null, \StructType\StringValue $pOSource = null, \StructType\StringValue $projectTask = null, \StructType\PurchaseSettings $purchasingSettings = null, \StructType\DecimalValue $qtyOnShipments = null, \StructType\StringValue $reasonCode = null, \StructType\DateTimeValue $requestedOn = null, \StructType\StringValue $salespersonID = null, \StructType\DateTimeValue $shipOn = null, \StructType\StringValue $shippingRule = null, \StructType\StringValue $subitem = null, \StructType\StringValue $taxCategory = null, \StructType\DecimalValue $unbilledAmount = null, \StructType\DecimalValue $undershipThreshold = null, \StructType\DecimalValue $unitCost = null, \StructType\DecimalValue $unitPrice = null, \StructType\StringValue $uOM = null, \StructType\StringValue $warehouseID = null)
    {
        $this
            ->setAccount($account)
            ->setAllocations($allocations)
            ->setAlternateID($alternateID)
            ->setAutoCreateIssue($autoCreateIssue)
            ->setAverageCost($averageCost)
            ->setBranch($branch)
            ->setCalculateDiscountsOnImport($calculateDiscountsOnImport)
            ->setCommissionable($commissionable)
            ->setCompleted($completed)
            ->setCostCode($costCode)
            ->setDiscountAmount($discountAmount)
            ->setDiscountCode($discountCode)
            ->setDiscountedUnitPrice($discountedUnitPrice)
            ->setDiscountPercent($discountPercent)
            ->setExtendedPrice($extendedPrice)
            ->setFreeItem($freeItem)
            ->setInventoryID($inventoryID)
            ->setLastModifiedDate($lastModifiedDate)
            ->setLineDescription($lineDescription)
            ->setLineNbr($lineNbr)
            ->setLineType($lineType)
            ->setLocation($location)
            ->setManualDiscount($manualDiscount)
            ->setMarkForPO($markForPO)
            ->setOpenQty($openQty)
            ->setOperation($operation)
            ->setOrderQty($orderQty)
            ->setOvershipThreshold($overshipThreshold)
            ->setPOSource($pOSource)
            ->setProjectTask($projectTask)
            ->setPurchasingSettings($purchasingSettings)
            ->setQtyOnShipments($qtyOnShipments)
            ->setReasonCode($reasonCode)
            ->setRequestedOn($requestedOn)
            ->setSalespersonID($salespersonID)
            ->setShipOn($shipOn)
            ->setShippingRule($shippingRule)
            ->setSubitem($subitem)
            ->setTaxCategory($taxCategory)
            ->setUnbilledAmount($unbilledAmount)
            ->setUndershipThreshold($undershipThreshold)
            ->setUnitCost($unitCost)
            ->setUnitPrice($unitPrice)
            ->setUOM($uOM)
            ->setWarehouseID($warehouseID);
    }
    /**
     * Get Account value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getAccount()
    {
        return isset($this->Account) ? $this->Account : null;
    }
    /**
     * Set Account value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $account
     * @return \StructType\SalesOrderDetail
     */
    public function setAccount(\StructType\StringValue $account = null)
    {
        if (is_null($account) || (is_array($account) && empty($account))) {
            unset($this->Account);
        } else {
            $this->Account = $account;
        }
        return $this;
    }
    /**
     * Get Allocations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Allocations|null
     */
    public function getAllocations()
    {
        return isset($this->Allocations) ? $this->Allocations : null;
    }
    /**
     * Set Allocations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Allocations $allocations
     * @return \StructType\SalesOrderDetail
     */
    public function setAllocations(\StructType\Allocations $allocations = null)
    {
        if (is_null($allocations) || (is_array($allocations) && empty($allocations))) {
            unset($this->Allocations);
        } else {
            $this->Allocations = $allocations;
        }
        return $this;
    }
    /**
     * Get AlternateID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getAlternateID()
    {
        return isset($this->AlternateID) ? $this->AlternateID : null;
    }
    /**
     * Set AlternateID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $alternateID
     * @return \StructType\SalesOrderDetail
     */
    public function setAlternateID(\StructType\StringValue $alternateID = null)
    {
        if (is_null($alternateID) || (is_array($alternateID) && empty($alternateID))) {
            unset($this->AlternateID);
        } else {
            $this->AlternateID = $alternateID;
        }
        return $this;
    }
    /**
     * Get AutoCreateIssue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getAutoCreateIssue()
    {
        return isset($this->AutoCreateIssue) ? $this->AutoCreateIssue : null;
    }
    /**
     * Set AutoCreateIssue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $autoCreateIssue
     * @return \StructType\SalesOrderDetail
     */
    public function setAutoCreateIssue(\StructType\BooleanValue $autoCreateIssue = null)
    {
        if (is_null($autoCreateIssue) || (is_array($autoCreateIssue) && empty($autoCreateIssue))) {
            unset($this->AutoCreateIssue);
        } else {
            $this->AutoCreateIssue = $autoCreateIssue;
        }
        return $this;
    }
    /**
     * Get AverageCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getAverageCost()
    {
        return isset($this->AverageCost) ? $this->AverageCost : null;
    }
    /**
     * Set AverageCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $averageCost
     * @return \StructType\SalesOrderDetail
     */
    public function setAverageCost(\StructType\DecimalValue $averageCost = null)
    {
        if (is_null($averageCost) || (is_array($averageCost) && empty($averageCost))) {
            unset($this->AverageCost);
        } else {
            $this->AverageCost = $averageCost;
        }
        return $this;
    }
    /**
     * Get Branch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getBranch()
    {
        return isset($this->Branch) ? $this->Branch : null;
    }
    /**
     * Set Branch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $branch
     * @return \StructType\SalesOrderDetail
     */
    public function setBranch(\StructType\StringValue $branch = null)
    {
        if (is_null($branch) || (is_array($branch) && empty($branch))) {
            unset($this->Branch);
        } else {
            $this->Branch = $branch;
        }
        return $this;
    }
    /**
     * Get CalculateDiscountsOnImport value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getCalculateDiscountsOnImport()
    {
        return isset($this->CalculateDiscountsOnImport) ? $this->CalculateDiscountsOnImport : null;
    }
    /**
     * Set CalculateDiscountsOnImport value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $calculateDiscountsOnImport
     * @return \StructType\SalesOrderDetail
     */
    public function setCalculateDiscountsOnImport(\StructType\BooleanValue $calculateDiscountsOnImport = null)
    {
        if (is_null($calculateDiscountsOnImport) || (is_array($calculateDiscountsOnImport) && empty($calculateDiscountsOnImport))) {
            unset($this->CalculateDiscountsOnImport);
        } else {
            $this->CalculateDiscountsOnImport = $calculateDiscountsOnImport;
        }
        return $this;
    }
    /**
     * Get Commissionable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getCommissionable()
    {
        return isset($this->Commissionable) ? $this->Commissionable : null;
    }
    /**
     * Set Commissionable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $commissionable
     * @return \StructType\SalesOrderDetail
     */
    public function setCommissionable(\StructType\BooleanValue $commissionable = null)
    {
        if (is_null($commissionable) || (is_array($commissionable) && empty($commissionable))) {
            unset($this->Commissionable);
        } else {
            $this->Commissionable = $commissionable;
        }
        return $this;
    }
    /**
     * Get Completed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getCompleted()
    {
        return isset($this->Completed) ? $this->Completed : null;
    }
    /**
     * Set Completed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $completed
     * @return \StructType\SalesOrderDetail
     */
    public function setCompleted(\StructType\BooleanValue $completed = null)
    {
        if (is_null($completed) || (is_array($completed) && empty($completed))) {
            unset($this->Completed);
        } else {
            $this->Completed = $completed;
        }
        return $this;
    }
    /**
     * Get CostCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCostCode()
    {
        return isset($this->CostCode) ? $this->CostCode : null;
    }
    /**
     * Set CostCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $costCode
     * @return \StructType\SalesOrderDetail
     */
    public function setCostCode(\StructType\StringValue $costCode = null)
    {
        if (is_null($costCode) || (is_array($costCode) && empty($costCode))) {
            unset($this->CostCode);
        } else {
            $this->CostCode = $costCode;
        }
        return $this;
    }
    /**
     * Get DiscountAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getDiscountAmount()
    {
        return isset($this->DiscountAmount) ? $this->DiscountAmount : null;
    }
    /**
     * Set DiscountAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $discountAmount
     * @return \StructType\SalesOrderDetail
     */
    public function setDiscountAmount(\StructType\DecimalValue $discountAmount = null)
    {
        if (is_null($discountAmount) || (is_array($discountAmount) && empty($discountAmount))) {
            unset($this->DiscountAmount);
        } else {
            $this->DiscountAmount = $discountAmount;
        }
        return $this;
    }
    /**
     * Get DiscountCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDiscountCode()
    {
        return isset($this->DiscountCode) ? $this->DiscountCode : null;
    }
    /**
     * Set DiscountCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $discountCode
     * @return \StructType\SalesOrderDetail
     */
    public function setDiscountCode(\StructType\StringValue $discountCode = null)
    {
        if (is_null($discountCode) || (is_array($discountCode) && empty($discountCode))) {
            unset($this->DiscountCode);
        } else {
            $this->DiscountCode = $discountCode;
        }
        return $this;
    }
    /**
     * Get DiscountedUnitPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getDiscountedUnitPrice()
    {
        return isset($this->DiscountedUnitPrice) ? $this->DiscountedUnitPrice : null;
    }
    /**
     * Set DiscountedUnitPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $discountedUnitPrice
     * @return \StructType\SalesOrderDetail
     */
    public function setDiscountedUnitPrice(\StructType\DecimalValue $discountedUnitPrice = null)
    {
        if (is_null($discountedUnitPrice) || (is_array($discountedUnitPrice) && empty($discountedUnitPrice))) {
            unset($this->DiscountedUnitPrice);
        } else {
            $this->DiscountedUnitPrice = $discountedUnitPrice;
        }
        return $this;
    }
    /**
     * Get DiscountPercent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getDiscountPercent()
    {
        return isset($this->DiscountPercent) ? $this->DiscountPercent : null;
    }
    /**
     * Set DiscountPercent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $discountPercent
     * @return \StructType\SalesOrderDetail
     */
    public function setDiscountPercent(\StructType\DecimalValue $discountPercent = null)
    {
        if (is_null($discountPercent) || (is_array($discountPercent) && empty($discountPercent))) {
            unset($this->DiscountPercent);
        } else {
            $this->DiscountPercent = $discountPercent;
        }
        return $this;
    }
    /**
     * Get ExtendedPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getExtendedPrice()
    {
        return isset($this->ExtendedPrice) ? $this->ExtendedPrice : null;
    }
    /**
     * Set ExtendedPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $extendedPrice
     * @return \StructType\SalesOrderDetail
     */
    public function setExtendedPrice(\StructType\DecimalValue $extendedPrice = null)
    {
        if (is_null($extendedPrice) || (is_array($extendedPrice) && empty($extendedPrice))) {
            unset($this->ExtendedPrice);
        } else {
            $this->ExtendedPrice = $extendedPrice;
        }
        return $this;
    }
    /**
     * Get FreeItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getFreeItem()
    {
        return isset($this->FreeItem) ? $this->FreeItem : null;
    }
    /**
     * Set FreeItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $freeItem
     * @return \StructType\SalesOrderDetail
     */
    public function setFreeItem(\StructType\BooleanValue $freeItem = null)
    {
        if (is_null($freeItem) || (is_array($freeItem) && empty($freeItem))) {
            unset($this->FreeItem);
        } else {
            $this->FreeItem = $freeItem;
        }
        return $this;
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $inventoryID
     * @return \StructType\SalesOrderDetail
     */
    public function setInventoryID(\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $lastModifiedDate
     * @return \StructType\SalesOrderDetail
     */
    public function setLastModifiedDate(\StructType\StringValue $lastModifiedDate = null)
    {
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get LineDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getLineDescription()
    {
        return isset($this->LineDescription) ? $this->LineDescription : null;
    }
    /**
     * Set LineDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $lineDescription
     * @return \StructType\SalesOrderDetail
     */
    public function setLineDescription(\StructType\StringValue $lineDescription = null)
    {
        if (is_null($lineDescription) || (is_array($lineDescription) && empty($lineDescription))) {
            unset($this->LineDescription);
        } else {
            $this->LineDescription = $lineDescription;
        }
        return $this;
    }
    /**
     * Get LineNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IntValue|null
     */
    public function getLineNbr()
    {
        return isset($this->LineNbr) ? $this->LineNbr : null;
    }
    /**
     * Set LineNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\IntValue $lineNbr
     * @return \StructType\SalesOrderDetail
     */
    public function setLineNbr(\StructType\IntValue $lineNbr = null)
    {
        if (is_null($lineNbr) || (is_array($lineNbr) && empty($lineNbr))) {
            unset($this->LineNbr);
        } else {
            $this->LineNbr = $lineNbr;
        }
        return $this;
    }
    /**
     * Get LineType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getLineType()
    {
        return isset($this->LineType) ? $this->LineType : null;
    }
    /**
     * Set LineType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $lineType
     * @return \StructType\SalesOrderDetail
     */
    public function setLineType(\StructType\StringValue $lineType = null)
    {
        if (is_null($lineType) || (is_array($lineType) && empty($lineType))) {
            unset($this->LineType);
        } else {
            $this->LineType = $lineType;
        }
        return $this;
    }
    /**
     * Get Location value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getLocation()
    {
        return isset($this->Location) ? $this->Location : null;
    }
    /**
     * Set Location value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $location
     * @return \StructType\SalesOrderDetail
     */
    public function setLocation(\StructType\StringValue $location = null)
    {
        if (is_null($location) || (is_array($location) && empty($location))) {
            unset($this->Location);
        } else {
            $this->Location = $location;
        }
        return $this;
    }
    /**
     * Get ManualDiscount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getManualDiscount()
    {
        return isset($this->ManualDiscount) ? $this->ManualDiscount : null;
    }
    /**
     * Set ManualDiscount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $manualDiscount
     * @return \StructType\SalesOrderDetail
     */
    public function setManualDiscount(\StructType\BooleanValue $manualDiscount = null)
    {
        if (is_null($manualDiscount) || (is_array($manualDiscount) && empty($manualDiscount))) {
            unset($this->ManualDiscount);
        } else {
            $this->ManualDiscount = $manualDiscount;
        }
        return $this;
    }
    /**
     * Get MarkForPO value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getMarkForPO()
    {
        return isset($this->MarkForPO) ? $this->MarkForPO : null;
    }
    /**
     * Set MarkForPO value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $markForPO
     * @return \StructType\SalesOrderDetail
     */
    public function setMarkForPO(\StructType\BooleanValue $markForPO = null)
    {
        if (is_null($markForPO) || (is_array($markForPO) && empty($markForPO))) {
            unset($this->MarkForPO);
        } else {
            $this->MarkForPO = $markForPO;
        }
        return $this;
    }
    /**
     * Get OpenQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getOpenQty()
    {
        return isset($this->OpenQty) ? $this->OpenQty : null;
    }
    /**
     * Set OpenQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $openQty
     * @return \StructType\SalesOrderDetail
     */
    public function setOpenQty(\StructType\DecimalValue $openQty = null)
    {
        if (is_null($openQty) || (is_array($openQty) && empty($openQty))) {
            unset($this->OpenQty);
        } else {
            $this->OpenQty = $openQty;
        }
        return $this;
    }
    /**
     * Get Operation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getOperation()
    {
        return isset($this->Operation) ? $this->Operation : null;
    }
    /**
     * Set Operation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $operation
     * @return \StructType\SalesOrderDetail
     */
    public function setOperation(\StructType\StringValue $operation = null)
    {
        if (is_null($operation) || (is_array($operation) && empty($operation))) {
            unset($this->Operation);
        } else {
            $this->Operation = $operation;
        }
        return $this;
    }
    /**
     * Get OrderQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getOrderQty()
    {
        return isset($this->OrderQty) ? $this->OrderQty : null;
    }
    /**
     * Set OrderQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $orderQty
     * @return \StructType\SalesOrderDetail
     */
    public function setOrderQty(\StructType\DecimalValue $orderQty = null)
    {
        if (is_null($orderQty) || (is_array($orderQty) && empty($orderQty))) {
            unset($this->OrderQty);
        } else {
            $this->OrderQty = $orderQty;
        }
        return $this;
    }
    /**
     * Get OvershipThreshold value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getOvershipThreshold()
    {
        return isset($this->OvershipThreshold) ? $this->OvershipThreshold : null;
    }
    /**
     * Set OvershipThreshold value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $overshipThreshold
     * @return \StructType\SalesOrderDetail
     */
    public function setOvershipThreshold(\StructType\DecimalValue $overshipThreshold = null)
    {
        if (is_null($overshipThreshold) || (is_array($overshipThreshold) && empty($overshipThreshold))) {
            unset($this->OvershipThreshold);
        } else {
            $this->OvershipThreshold = $overshipThreshold;
        }
        return $this;
    }
    /**
     * Get POSource value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getPOSource()
    {
        return isset($this->POSource) ? $this->POSource : null;
    }
    /**
     * Set POSource value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $pOSource
     * @return \StructType\SalesOrderDetail
     */
    public function setPOSource(\StructType\StringValue $pOSource = null)
    {
        if (is_null($pOSource) || (is_array($pOSource) && empty($pOSource))) {
            unset($this->POSource);
        } else {
            $this->POSource = $pOSource;
        }
        return $this;
    }
    /**
     * Get ProjectTask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getProjectTask()
    {
        return isset($this->ProjectTask) ? $this->ProjectTask : null;
    }
    /**
     * Set ProjectTask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $projectTask
     * @return \StructType\SalesOrderDetail
     */
    public function setProjectTask(\StructType\StringValue $projectTask = null)
    {
        if (is_null($projectTask) || (is_array($projectTask) && empty($projectTask))) {
            unset($this->ProjectTask);
        } else {
            $this->ProjectTask = $projectTask;
        }
        return $this;
    }
    /**
     * Get PurchasingSettings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PurchaseSettings|null
     */
    public function getPurchasingSettings()
    {
        return isset($this->PurchasingSettings) ? $this->PurchasingSettings : null;
    }
    /**
     * Set PurchasingSettings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PurchaseSettings $purchasingSettings
     * @return \StructType\SalesOrderDetail
     */
    public function setPurchasingSettings(\StructType\PurchaseSettings $purchasingSettings = null)
    {
        if (is_null($purchasingSettings) || (is_array($purchasingSettings) && empty($purchasingSettings))) {
            unset($this->PurchasingSettings);
        } else {
            $this->PurchasingSettings = $purchasingSettings;
        }
        return $this;
    }
    /**
     * Get QtyOnShipments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getQtyOnShipments()
    {
        return isset($this->QtyOnShipments) ? $this->QtyOnShipments : null;
    }
    /**
     * Set QtyOnShipments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $qtyOnShipments
     * @return \StructType\SalesOrderDetail
     */
    public function setQtyOnShipments(\StructType\DecimalValue $qtyOnShipments = null)
    {
        if (is_null($qtyOnShipments) || (is_array($qtyOnShipments) && empty($qtyOnShipments))) {
            unset($this->QtyOnShipments);
        } else {
            $this->QtyOnShipments = $qtyOnShipments;
        }
        return $this;
    }
    /**
     * Get ReasonCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getReasonCode()
    {
        return isset($this->ReasonCode) ? $this->ReasonCode : null;
    }
    /**
     * Set ReasonCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $reasonCode
     * @return \StructType\SalesOrderDetail
     */
    public function setReasonCode(\StructType\StringValue $reasonCode = null)
    {
        if (is_null($reasonCode) || (is_array($reasonCode) && empty($reasonCode))) {
            unset($this->ReasonCode);
        } else {
            $this->ReasonCode = $reasonCode;
        }
        return $this;
    }
    /**
     * Get RequestedOn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getRequestedOn()
    {
        return isset($this->RequestedOn) ? $this->RequestedOn : null;
    }
    /**
     * Set RequestedOn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $requestedOn
     * @return \StructType\SalesOrderDetail
     */
    public function setRequestedOn(\StructType\DateTimeValue $requestedOn = null)
    {
        if (is_null($requestedOn) || (is_array($requestedOn) && empty($requestedOn))) {
            unset($this->RequestedOn);
        } else {
            $this->RequestedOn = $requestedOn;
        }
        return $this;
    }
    /**
     * Get SalespersonID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getSalespersonID()
    {
        return isset($this->SalespersonID) ? $this->SalespersonID : null;
    }
    /**
     * Set SalespersonID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $salespersonID
     * @return \StructType\SalesOrderDetail
     */
    public function setSalespersonID(\StructType\StringValue $salespersonID = null)
    {
        if (is_null($salespersonID) || (is_array($salespersonID) && empty($salespersonID))) {
            unset($this->SalespersonID);
        } else {
            $this->SalespersonID = $salespersonID;
        }
        return $this;
    }
    /**
     * Get ShipOn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getShipOn()
    {
        return isset($this->ShipOn) ? $this->ShipOn : null;
    }
    /**
     * Set ShipOn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $shipOn
     * @return \StructType\SalesOrderDetail
     */
    public function setShipOn(\StructType\DateTimeValue $shipOn = null)
    {
        if (is_null($shipOn) || (is_array($shipOn) && empty($shipOn))) {
            unset($this->ShipOn);
        } else {
            $this->ShipOn = $shipOn;
        }
        return $this;
    }
    /**
     * Get ShippingRule value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getShippingRule()
    {
        return isset($this->ShippingRule) ? $this->ShippingRule : null;
    }
    /**
     * Set ShippingRule value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $shippingRule
     * @return \StructType\SalesOrderDetail
     */
    public function setShippingRule(\StructType\StringValue $shippingRule = null)
    {
        if (is_null($shippingRule) || (is_array($shippingRule) && empty($shippingRule))) {
            unset($this->ShippingRule);
        } else {
            $this->ShippingRule = $shippingRule;
        }
        return $this;
    }
    /**
     * Get Subitem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getSubitem()
    {
        return isset($this->Subitem) ? $this->Subitem : null;
    }
    /**
     * Set Subitem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $subitem
     * @return \StructType\SalesOrderDetail
     */
    public function setSubitem(\StructType\StringValue $subitem = null)
    {
        if (is_null($subitem) || (is_array($subitem) && empty($subitem))) {
            unset($this->Subitem);
        } else {
            $this->Subitem = $subitem;
        }
        return $this;
    }
    /**
     * Get TaxCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getTaxCategory()
    {
        return isset($this->TaxCategory) ? $this->TaxCategory : null;
    }
    /**
     * Set TaxCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $taxCategory
     * @return \StructType\SalesOrderDetail
     */
    public function setTaxCategory(\StructType\StringValue $taxCategory = null)
    {
        if (is_null($taxCategory) || (is_array($taxCategory) && empty($taxCategory))) {
            unset($this->TaxCategory);
        } else {
            $this->TaxCategory = $taxCategory;
        }
        return $this;
    }
    /**
     * Get UnbilledAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getUnbilledAmount()
    {
        return isset($this->UnbilledAmount) ? $this->UnbilledAmount : null;
    }
    /**
     * Set UnbilledAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $unbilledAmount
     * @return \StructType\SalesOrderDetail
     */
    public function setUnbilledAmount(\StructType\DecimalValue $unbilledAmount = null)
    {
        if (is_null($unbilledAmount) || (is_array($unbilledAmount) && empty($unbilledAmount))) {
            unset($this->UnbilledAmount);
        } else {
            $this->UnbilledAmount = $unbilledAmount;
        }
        return $this;
    }
    /**
     * Get UndershipThreshold value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getUndershipThreshold()
    {
        return isset($this->UndershipThreshold) ? $this->UndershipThreshold : null;
    }
    /**
     * Set UndershipThreshold value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $undershipThreshold
     * @return \StructType\SalesOrderDetail
     */
    public function setUndershipThreshold(\StructType\DecimalValue $undershipThreshold = null)
    {
        if (is_null($undershipThreshold) || (is_array($undershipThreshold) && empty($undershipThreshold))) {
            unset($this->UndershipThreshold);
        } else {
            $this->UndershipThreshold = $undershipThreshold;
        }
        return $this;
    }
    /**
     * Get UnitCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getUnitCost()
    {
        return isset($this->UnitCost) ? $this->UnitCost : null;
    }
    /**
     * Set UnitCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $unitCost
     * @return \StructType\SalesOrderDetail
     */
    public function setUnitCost(\StructType\DecimalValue $unitCost = null)
    {
        if (is_null($unitCost) || (is_array($unitCost) && empty($unitCost))) {
            unset($this->UnitCost);
        } else {
            $this->UnitCost = $unitCost;
        }
        return $this;
    }
    /**
     * Get UnitPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getUnitPrice()
    {
        return isset($this->UnitPrice) ? $this->UnitPrice : null;
    }
    /**
     * Set UnitPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $unitPrice
     * @return \StructType\SalesOrderDetail
     */
    public function setUnitPrice(\StructType\DecimalValue $unitPrice = null)
    {
        if (is_null($unitPrice) || (is_array($unitPrice) && empty($unitPrice))) {
            unset($this->UnitPrice);
        } else {
            $this->UnitPrice = $unitPrice;
        }
        return $this;
    }
    /**
     * Get UOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getUOM()
    {
        return isset($this->UOM) ? $this->UOM : null;
    }
    /**
     * Set UOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $uOM
     * @return \StructType\SalesOrderDetail
     */
    public function setUOM(\StructType\StringValue $uOM = null)
    {
        if (is_null($uOM) || (is_array($uOM) && empty($uOM))) {
            unset($this->UOM);
        } else {
            $this->UOM = $uOM;
        }
        return $this;
    }
    /**
     * Get WarehouseID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getWarehouseID()
    {
        return isset($this->WarehouseID) ? $this->WarehouseID : null;
    }
    /**
     * Set WarehouseID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $warehouseID
     * @return \StructType\SalesOrderDetail
     */
    public function setWarehouseID(\StructType\StringValue $warehouseID = null)
    {
        if (is_null($warehouseID) || (is_array($warehouseID) && empty($warehouseID))) {
            unset($this->WarehouseID);
        } else {
            $this->WarehouseID = $warehouseID;
        }
        return $this;
    }
}
