<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesInvoiceDetail StructType
 * @subpackage Structs
 */
class SalesInvoiceDetail extends Entity
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $Amount;
    /**
     * The BranchID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $BranchID;
    /**
     * The CalculateDiscountsOnImport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $CalculateDiscountsOnImport;
    /**
     * The CostCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CostCode;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Description;
    /**
     * The DiscountAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $DiscountAmount;
    /**
     * The DiscountPercent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $DiscountPercent;
    /**
     * The ExpirationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $ExpirationDate;
    /**
     * The InventoryDocType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $InventoryDocType;
    /**
     * The InventoryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $InventoryID;
    /**
     * The InventoryRefNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $InventoryRefNbr;
    /**
     * The LineNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IntValue
     */
    public $LineNbr;
    /**
     * The Location
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Location;
    /**
     * The LotSerialNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $LotSerialNbr;
    /**
     * The ManualDiscount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $ManualDiscount;
    /**
     * The OrderLineNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IntValue
     */
    public $OrderLineNbr;
    /**
     * The OrderNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $OrderNbr;
    /**
     * The OrderType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $OrderType;
    /**
     * The OrigInvLineNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IntValue
     */
    public $OrigInvLineNbr;
    /**
     * The OrigInvNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $OrigInvNbr;
    /**
     * The OrigInvType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $OrigInvType;
    /**
     * The ProjectTask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ProjectTask;
    /**
     * The Qty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $Qty;
    /**
     * The ShipmentNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ShipmentNbr;
    /**
     * The Subitem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Subitem;
    /**
     * The TaxCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $TaxCategory;
    /**
     * The TransactionDescr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $TransactionDescr;
    /**
     * The UnitPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $UnitPrice;
    /**
     * The UOM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $UOM;
    /**
     * The WarehouseID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $WarehouseID;
    /**
     * Constructor method for SalesInvoiceDetail
     * @uses SalesInvoiceDetail::setAmount()
     * @uses SalesInvoiceDetail::setBranchID()
     * @uses SalesInvoiceDetail::setCalculateDiscountsOnImport()
     * @uses SalesInvoiceDetail::setCostCode()
     * @uses SalesInvoiceDetail::setDescription()
     * @uses SalesInvoiceDetail::setDiscountAmount()
     * @uses SalesInvoiceDetail::setDiscountPercent()
     * @uses SalesInvoiceDetail::setExpirationDate()
     * @uses SalesInvoiceDetail::setInventoryDocType()
     * @uses SalesInvoiceDetail::setInventoryID()
     * @uses SalesInvoiceDetail::setInventoryRefNbr()
     * @uses SalesInvoiceDetail::setLineNbr()
     * @uses SalesInvoiceDetail::setLocation()
     * @uses SalesInvoiceDetail::setLotSerialNbr()
     * @uses SalesInvoiceDetail::setManualDiscount()
     * @uses SalesInvoiceDetail::setOrderLineNbr()
     * @uses SalesInvoiceDetail::setOrderNbr()
     * @uses SalesInvoiceDetail::setOrderType()
     * @uses SalesInvoiceDetail::setOrigInvLineNbr()
     * @uses SalesInvoiceDetail::setOrigInvNbr()
     * @uses SalesInvoiceDetail::setOrigInvType()
     * @uses SalesInvoiceDetail::setProjectTask()
     * @uses SalesInvoiceDetail::setQty()
     * @uses SalesInvoiceDetail::setShipmentNbr()
     * @uses SalesInvoiceDetail::setSubitem()
     * @uses SalesInvoiceDetail::setTaxCategory()
     * @uses SalesInvoiceDetail::setTransactionDescr()
     * @uses SalesInvoiceDetail::setUnitPrice()
     * @uses SalesInvoiceDetail::setUOM()
     * @uses SalesInvoiceDetail::setWarehouseID()
     * @param \StructType\DecimalValue $amount
     * @param \StructType\StringValue $branchID
     * @param \StructType\BooleanValue $calculateDiscountsOnImport
     * @param \StructType\StringValue $costCode
     * @param \StructType\StringValue $description
     * @param \StructType\DecimalValue $discountAmount
     * @param \StructType\DecimalValue $discountPercent
     * @param \StructType\DateTimeValue $expirationDate
     * @param \StructType\StringValue $inventoryDocType
     * @param \StructType\StringValue $inventoryID
     * @param \StructType\StringValue $inventoryRefNbr
     * @param \StructType\IntValue $lineNbr
     * @param \StructType\StringValue $location
     * @param \StructType\StringValue $lotSerialNbr
     * @param \StructType\BooleanValue $manualDiscount
     * @param \StructType\IntValue $orderLineNbr
     * @param \StructType\StringValue $orderNbr
     * @param \StructType\StringValue $orderType
     * @param \StructType\IntValue $origInvLineNbr
     * @param \StructType\StringValue $origInvNbr
     * @param \StructType\StringValue $origInvType
     * @param \StructType\StringValue $projectTask
     * @param \StructType\DecimalValue $qty
     * @param \StructType\StringValue $shipmentNbr
     * @param \StructType\StringValue $subitem
     * @param \StructType\StringValue $taxCategory
     * @param \StructType\StringValue $transactionDescr
     * @param \StructType\DecimalValue $unitPrice
     * @param \StructType\StringValue $uOM
     * @param \StructType\StringValue $warehouseID
     */
    public function __construct(\StructType\DecimalValue $amount = null, \StructType\StringValue $branchID = null, \StructType\BooleanValue $calculateDiscountsOnImport = null, \StructType\StringValue $costCode = null, \StructType\StringValue $description = null, \StructType\DecimalValue $discountAmount = null, \StructType\DecimalValue $discountPercent = null, \StructType\DateTimeValue $expirationDate = null, \StructType\StringValue $inventoryDocType = null, \StructType\StringValue $inventoryID = null, \StructType\StringValue $inventoryRefNbr = null, \StructType\IntValue $lineNbr = null, \StructType\StringValue $location = null, \StructType\StringValue $lotSerialNbr = null, \StructType\BooleanValue $manualDiscount = null, \StructType\IntValue $orderLineNbr = null, \StructType\StringValue $orderNbr = null, \StructType\StringValue $orderType = null, \StructType\IntValue $origInvLineNbr = null, \StructType\StringValue $origInvNbr = null, \StructType\StringValue $origInvType = null, \StructType\StringValue $projectTask = null, \StructType\DecimalValue $qty = null, \StructType\StringValue $shipmentNbr = null, \StructType\StringValue $subitem = null, \StructType\StringValue $taxCategory = null, \StructType\StringValue $transactionDescr = null, \StructType\DecimalValue $unitPrice = null, \StructType\StringValue $uOM = null, \StructType\StringValue $warehouseID = null)
    {
        $this
            ->setAmount($amount)
            ->setBranchID($branchID)
            ->setCalculateDiscountsOnImport($calculateDiscountsOnImport)
            ->setCostCode($costCode)
            ->setDescription($description)
            ->setDiscountAmount($discountAmount)
            ->setDiscountPercent($discountPercent)
            ->setExpirationDate($expirationDate)
            ->setInventoryDocType($inventoryDocType)
            ->setInventoryID($inventoryID)
            ->setInventoryRefNbr($inventoryRefNbr)
            ->setLineNbr($lineNbr)
            ->setLocation($location)
            ->setLotSerialNbr($lotSerialNbr)
            ->setManualDiscount($manualDiscount)
            ->setOrderLineNbr($orderLineNbr)
            ->setOrderNbr($orderNbr)
            ->setOrderType($orderType)
            ->setOrigInvLineNbr($origInvLineNbr)
            ->setOrigInvNbr($origInvNbr)
            ->setOrigInvType($origInvType)
            ->setProjectTask($projectTask)
            ->setQty($qty)
            ->setShipmentNbr($shipmentNbr)
            ->setSubitem($subitem)
            ->setTaxCategory($taxCategory)
            ->setTransactionDescr($transactionDescr)
            ->setUnitPrice($unitPrice)
            ->setUOM($uOM)
            ->setWarehouseID($warehouseID);
    }
    /**
     * Get Amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * Set Amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $amount
     * @return \StructType\SalesInvoiceDetail
     */
    public function setAmount(\StructType\DecimalValue $amount = null)
    {
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get BranchID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getBranchID()
    {
        return isset($this->BranchID) ? $this->BranchID : null;
    }
    /**
     * Set BranchID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $branchID
     * @return \StructType\SalesInvoiceDetail
     */
    public function setBranchID(\StructType\StringValue $branchID = null)
    {
        if (is_null($branchID) || (is_array($branchID) && empty($branchID))) {
            unset($this->BranchID);
        } else {
            $this->BranchID = $branchID;
        }
        return $this;
    }
    /**
     * Get CalculateDiscountsOnImport value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getCalculateDiscountsOnImport()
    {
        return isset($this->CalculateDiscountsOnImport) ? $this->CalculateDiscountsOnImport : null;
    }
    /**
     * Set CalculateDiscountsOnImport value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $calculateDiscountsOnImport
     * @return \StructType\SalesInvoiceDetail
     */
    public function setCalculateDiscountsOnImport(\StructType\BooleanValue $calculateDiscountsOnImport = null)
    {
        if (is_null($calculateDiscountsOnImport) || (is_array($calculateDiscountsOnImport) && empty($calculateDiscountsOnImport))) {
            unset($this->CalculateDiscountsOnImport);
        } else {
            $this->CalculateDiscountsOnImport = $calculateDiscountsOnImport;
        }
        return $this;
    }
    /**
     * Get CostCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCostCode()
    {
        return isset($this->CostCode) ? $this->CostCode : null;
    }
    /**
     * Set CostCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $costCode
     * @return \StructType\SalesInvoiceDetail
     */
    public function setCostCode(\StructType\StringValue $costCode = null)
    {
        if (is_null($costCode) || (is_array($costCode) && empty($costCode))) {
            unset($this->CostCode);
        } else {
            $this->CostCode = $costCode;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $description
     * @return \StructType\SalesInvoiceDetail
     */
    public function setDescription(\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DiscountAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getDiscountAmount()
    {
        return isset($this->DiscountAmount) ? $this->DiscountAmount : null;
    }
    /**
     * Set DiscountAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $discountAmount
     * @return \StructType\SalesInvoiceDetail
     */
    public function setDiscountAmount(\StructType\DecimalValue $discountAmount = null)
    {
        if (is_null($discountAmount) || (is_array($discountAmount) && empty($discountAmount))) {
            unset($this->DiscountAmount);
        } else {
            $this->DiscountAmount = $discountAmount;
        }
        return $this;
    }
    /**
     * Get DiscountPercent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getDiscountPercent()
    {
        return isset($this->DiscountPercent) ? $this->DiscountPercent : null;
    }
    /**
     * Set DiscountPercent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $discountPercent
     * @return \StructType\SalesInvoiceDetail
     */
    public function setDiscountPercent(\StructType\DecimalValue $discountPercent = null)
    {
        if (is_null($discountPercent) || (is_array($discountPercent) && empty($discountPercent))) {
            unset($this->DiscountPercent);
        } else {
            $this->DiscountPercent = $discountPercent;
        }
        return $this;
    }
    /**
     * Get ExpirationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getExpirationDate()
    {
        return isset($this->ExpirationDate) ? $this->ExpirationDate : null;
    }
    /**
     * Set ExpirationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $expirationDate
     * @return \StructType\SalesInvoiceDetail
     */
    public function setExpirationDate(\StructType\DateTimeValue $expirationDate = null)
    {
        if (is_null($expirationDate) || (is_array($expirationDate) && empty($expirationDate))) {
            unset($this->ExpirationDate);
        } else {
            $this->ExpirationDate = $expirationDate;
        }
        return $this;
    }
    /**
     * Get InventoryDocType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getInventoryDocType()
    {
        return isset($this->InventoryDocType) ? $this->InventoryDocType : null;
    }
    /**
     * Set InventoryDocType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $inventoryDocType
     * @return \StructType\SalesInvoiceDetail
     */
    public function setInventoryDocType(\StructType\StringValue $inventoryDocType = null)
    {
        if (is_null($inventoryDocType) || (is_array($inventoryDocType) && empty($inventoryDocType))) {
            unset($this->InventoryDocType);
        } else {
            $this->InventoryDocType = $inventoryDocType;
        }
        return $this;
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $inventoryID
     * @return \StructType\SalesInvoiceDetail
     */
    public function setInventoryID(\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get InventoryRefNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getInventoryRefNbr()
    {
        return isset($this->InventoryRefNbr) ? $this->InventoryRefNbr : null;
    }
    /**
     * Set InventoryRefNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $inventoryRefNbr
     * @return \StructType\SalesInvoiceDetail
     */
    public function setInventoryRefNbr(\StructType\StringValue $inventoryRefNbr = null)
    {
        if (is_null($inventoryRefNbr) || (is_array($inventoryRefNbr) && empty($inventoryRefNbr))) {
            unset($this->InventoryRefNbr);
        } else {
            $this->InventoryRefNbr = $inventoryRefNbr;
        }
        return $this;
    }
    /**
     * Get LineNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IntValue|null
     */
    public function getLineNbr()
    {
        return isset($this->LineNbr) ? $this->LineNbr : null;
    }
    /**
     * Set LineNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\IntValue $lineNbr
     * @return \StructType\SalesInvoiceDetail
     */
    public function setLineNbr(\StructType\IntValue $lineNbr = null)
    {
        if (is_null($lineNbr) || (is_array($lineNbr) && empty($lineNbr))) {
            unset($this->LineNbr);
        } else {
            $this->LineNbr = $lineNbr;
        }
        return $this;
    }
    /**
     * Get Location value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getLocation()
    {
        return isset($this->Location) ? $this->Location : null;
    }
    /**
     * Set Location value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $location
     * @return \StructType\SalesInvoiceDetail
     */
    public function setLocation(\StructType\StringValue $location = null)
    {
        if (is_null($location) || (is_array($location) && empty($location))) {
            unset($this->Location);
        } else {
            $this->Location = $location;
        }
        return $this;
    }
    /**
     * Get LotSerialNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getLotSerialNbr()
    {
        return isset($this->LotSerialNbr) ? $this->LotSerialNbr : null;
    }
    /**
     * Set LotSerialNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $lotSerialNbr
     * @return \StructType\SalesInvoiceDetail
     */
    public function setLotSerialNbr(\StructType\StringValue $lotSerialNbr = null)
    {
        if (is_null($lotSerialNbr) || (is_array($lotSerialNbr) && empty($lotSerialNbr))) {
            unset($this->LotSerialNbr);
        } else {
            $this->LotSerialNbr = $lotSerialNbr;
        }
        return $this;
    }
    /**
     * Get ManualDiscount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getManualDiscount()
    {
        return isset($this->ManualDiscount) ? $this->ManualDiscount : null;
    }
    /**
     * Set ManualDiscount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $manualDiscount
     * @return \StructType\SalesInvoiceDetail
     */
    public function setManualDiscount(\StructType\BooleanValue $manualDiscount = null)
    {
        if (is_null($manualDiscount) || (is_array($manualDiscount) && empty($manualDiscount))) {
            unset($this->ManualDiscount);
        } else {
            $this->ManualDiscount = $manualDiscount;
        }
        return $this;
    }
    /**
     * Get OrderLineNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IntValue|null
     */
    public function getOrderLineNbr()
    {
        return isset($this->OrderLineNbr) ? $this->OrderLineNbr : null;
    }
    /**
     * Set OrderLineNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\IntValue $orderLineNbr
     * @return \StructType\SalesInvoiceDetail
     */
    public function setOrderLineNbr(\StructType\IntValue $orderLineNbr = null)
    {
        if (is_null($orderLineNbr) || (is_array($orderLineNbr) && empty($orderLineNbr))) {
            unset($this->OrderLineNbr);
        } else {
            $this->OrderLineNbr = $orderLineNbr;
        }
        return $this;
    }
    /**
     * Get OrderNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getOrderNbr()
    {
        return isset($this->OrderNbr) ? $this->OrderNbr : null;
    }
    /**
     * Set OrderNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $orderNbr
     * @return \StructType\SalesInvoiceDetail
     */
    public function setOrderNbr(\StructType\StringValue $orderNbr = null)
    {
        if (is_null($orderNbr) || (is_array($orderNbr) && empty($orderNbr))) {
            unset($this->OrderNbr);
        } else {
            $this->OrderNbr = $orderNbr;
        }
        return $this;
    }
    /**
     * Get OrderType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getOrderType()
    {
        return isset($this->OrderType) ? $this->OrderType : null;
    }
    /**
     * Set OrderType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $orderType
     * @return \StructType\SalesInvoiceDetail
     */
    public function setOrderType(\StructType\StringValue $orderType = null)
    {
        if (is_null($orderType) || (is_array($orderType) && empty($orderType))) {
            unset($this->OrderType);
        } else {
            $this->OrderType = $orderType;
        }
        return $this;
    }
    /**
     * Get OrigInvLineNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IntValue|null
     */
    public function getOrigInvLineNbr()
    {
        return isset($this->OrigInvLineNbr) ? $this->OrigInvLineNbr : null;
    }
    /**
     * Set OrigInvLineNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\IntValue $origInvLineNbr
     * @return \StructType\SalesInvoiceDetail
     */
    public function setOrigInvLineNbr(\StructType\IntValue $origInvLineNbr = null)
    {
        if (is_null($origInvLineNbr) || (is_array($origInvLineNbr) && empty($origInvLineNbr))) {
            unset($this->OrigInvLineNbr);
        } else {
            $this->OrigInvLineNbr = $origInvLineNbr;
        }
        return $this;
    }
    /**
     * Get OrigInvNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getOrigInvNbr()
    {
        return isset($this->OrigInvNbr) ? $this->OrigInvNbr : null;
    }
    /**
     * Set OrigInvNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $origInvNbr
     * @return \StructType\SalesInvoiceDetail
     */
    public function setOrigInvNbr(\StructType\StringValue $origInvNbr = null)
    {
        if (is_null($origInvNbr) || (is_array($origInvNbr) && empty($origInvNbr))) {
            unset($this->OrigInvNbr);
        } else {
            $this->OrigInvNbr = $origInvNbr;
        }
        return $this;
    }
    /**
     * Get OrigInvType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getOrigInvType()
    {
        return isset($this->OrigInvType) ? $this->OrigInvType : null;
    }
    /**
     * Set OrigInvType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $origInvType
     * @return \StructType\SalesInvoiceDetail
     */
    public function setOrigInvType(\StructType\StringValue $origInvType = null)
    {
        if (is_null($origInvType) || (is_array($origInvType) && empty($origInvType))) {
            unset($this->OrigInvType);
        } else {
            $this->OrigInvType = $origInvType;
        }
        return $this;
    }
    /**
     * Get ProjectTask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getProjectTask()
    {
        return isset($this->ProjectTask) ? $this->ProjectTask : null;
    }
    /**
     * Set ProjectTask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $projectTask
     * @return \StructType\SalesInvoiceDetail
     */
    public function setProjectTask(\StructType\StringValue $projectTask = null)
    {
        if (is_null($projectTask) || (is_array($projectTask) && empty($projectTask))) {
            unset($this->ProjectTask);
        } else {
            $this->ProjectTask = $projectTask;
        }
        return $this;
    }
    /**
     * Get Qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getQty()
    {
        return isset($this->Qty) ? $this->Qty : null;
    }
    /**
     * Set Qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $qty
     * @return \StructType\SalesInvoiceDetail
     */
    public function setQty(\StructType\DecimalValue $qty = null)
    {
        if (is_null($qty) || (is_array($qty) && empty($qty))) {
            unset($this->Qty);
        } else {
            $this->Qty = $qty;
        }
        return $this;
    }
    /**
     * Get ShipmentNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getShipmentNbr()
    {
        return isset($this->ShipmentNbr) ? $this->ShipmentNbr : null;
    }
    /**
     * Set ShipmentNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $shipmentNbr
     * @return \StructType\SalesInvoiceDetail
     */
    public function setShipmentNbr(\StructType\StringValue $shipmentNbr = null)
    {
        if (is_null($shipmentNbr) || (is_array($shipmentNbr) && empty($shipmentNbr))) {
            unset($this->ShipmentNbr);
        } else {
            $this->ShipmentNbr = $shipmentNbr;
        }
        return $this;
    }
    /**
     * Get Subitem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getSubitem()
    {
        return isset($this->Subitem) ? $this->Subitem : null;
    }
    /**
     * Set Subitem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $subitem
     * @return \StructType\SalesInvoiceDetail
     */
    public function setSubitem(\StructType\StringValue $subitem = null)
    {
        if (is_null($subitem) || (is_array($subitem) && empty($subitem))) {
            unset($this->Subitem);
        } else {
            $this->Subitem = $subitem;
        }
        return $this;
    }
    /**
     * Get TaxCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getTaxCategory()
    {
        return isset($this->TaxCategory) ? $this->TaxCategory : null;
    }
    /**
     * Set TaxCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $taxCategory
     * @return \StructType\SalesInvoiceDetail
     */
    public function setTaxCategory(\StructType\StringValue $taxCategory = null)
    {
        if (is_null($taxCategory) || (is_array($taxCategory) && empty($taxCategory))) {
            unset($this->TaxCategory);
        } else {
            $this->TaxCategory = $taxCategory;
        }
        return $this;
    }
    /**
     * Get TransactionDescr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getTransactionDescr()
    {
        return isset($this->TransactionDescr) ? $this->TransactionDescr : null;
    }
    /**
     * Set TransactionDescr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $transactionDescr
     * @return \StructType\SalesInvoiceDetail
     */
    public function setTransactionDescr(\StructType\StringValue $transactionDescr = null)
    {
        if (is_null($transactionDescr) || (is_array($transactionDescr) && empty($transactionDescr))) {
            unset($this->TransactionDescr);
        } else {
            $this->TransactionDescr = $transactionDescr;
        }
        return $this;
    }
    /**
     * Get UnitPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getUnitPrice()
    {
        return isset($this->UnitPrice) ? $this->UnitPrice : null;
    }
    /**
     * Set UnitPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $unitPrice
     * @return \StructType\SalesInvoiceDetail
     */
    public function setUnitPrice(\StructType\DecimalValue $unitPrice = null)
    {
        if (is_null($unitPrice) || (is_array($unitPrice) && empty($unitPrice))) {
            unset($this->UnitPrice);
        } else {
            $this->UnitPrice = $unitPrice;
        }
        return $this;
    }
    /**
     * Get UOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getUOM()
    {
        return isset($this->UOM) ? $this->UOM : null;
    }
    /**
     * Set UOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $uOM
     * @return \StructType\SalesInvoiceDetail
     */
    public function setUOM(\StructType\StringValue $uOM = null)
    {
        if (is_null($uOM) || (is_array($uOM) && empty($uOM))) {
            unset($this->UOM);
        } else {
            $this->UOM = $uOM;
        }
        return $this;
    }
    /**
     * Get WarehouseID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getWarehouseID()
    {
        return isset($this->WarehouseID) ? $this->WarehouseID : null;
    }
    /**
     * Set WarehouseID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $warehouseID
     * @return \StructType\SalesInvoiceDetail
     */
    public function setWarehouseID(\StructType\StringValue $warehouseID = null)
    {
        if (is_null($warehouseID) || (is_array($warehouseID) && empty($warehouseID))) {
            unset($this->WarehouseID);
        } else {
            $this->WarehouseID = $warehouseID;
        }
        return $this;
    }
}
