<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelatedActivities StructType
 * @subpackage Structs
 */
class RelatedActivities extends AbstractStructBase
{
    /**
     * The EventRelatedActivity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EventRelatedActivity[]
     */
    public $EventRelatedActivity;
    /**
     * The TaskRelatedActivity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TaskRelatedActivity[]
     */
    public $TaskRelatedActivity;
    /**
     * Constructor method for RelatedActivities
     * @uses RelatedActivities::setEventRelatedActivity()
     * @uses RelatedActivities::setTaskRelatedActivity()
     * @param \StructType\EventRelatedActivity[] $eventRelatedActivity
     * @param \StructType\TaskRelatedActivity[] $taskRelatedActivity
     */
    public function __construct(array $eventRelatedActivity = array(), array $taskRelatedActivity = array())
    {
        $this
            ->setEventRelatedActivity($eventRelatedActivity)
            ->setTaskRelatedActivity($taskRelatedActivity);
    }
    /**
     * Get EventRelatedActivity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EventRelatedActivity[]|null
     */
    public function getEventRelatedActivity()
    {
        return isset($this->EventRelatedActivity) ? $this->EventRelatedActivity : null;
    }
    /**
     * This method is responsible for validating the values passed to the setEventRelatedActivity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEventRelatedActivity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEventRelatedActivityForArrayConstraintsFromSetEventRelatedActivity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $relatedActivitiesEventRelatedActivityItem) {
            // validation for constraint: itemType
            if (!$relatedActivitiesEventRelatedActivityItem instanceof \StructType\EventRelatedActivity) {
                $invalidValues[] = is_object($relatedActivitiesEventRelatedActivityItem) ? get_class($relatedActivitiesEventRelatedActivityItem) : sprintf('%s(%s)', gettype($relatedActivitiesEventRelatedActivityItem), var_export($relatedActivitiesEventRelatedActivityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EventRelatedActivity property can only contain items of type \StructType\EventRelatedActivity, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EventRelatedActivity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EventRelatedActivity[] $eventRelatedActivity
     * @return \StructType\RelatedActivities
     */
    public function setEventRelatedActivity(array $eventRelatedActivity = array())
    {
        // validation for constraint: array
        if ('' !== ($eventRelatedActivityArrayErrorMessage = self::validateEventRelatedActivityForArrayConstraintsFromSetEventRelatedActivity($eventRelatedActivity))) {
            throw new \InvalidArgumentException($eventRelatedActivityArrayErrorMessage, __LINE__);
        }
        if (is_null($eventRelatedActivity) || (is_array($eventRelatedActivity) && empty($eventRelatedActivity))) {
            unset($this->EventRelatedActivity);
        } else {
            $this->EventRelatedActivity = $eventRelatedActivity;
        }
        return $this;
    }
    /**
     * Add item to EventRelatedActivity value
     * @throws \InvalidArgumentException
     * @param \StructType\EventRelatedActivity $item
     * @return \StructType\RelatedActivities
     */
    public function addToEventRelatedActivity(\StructType\EventRelatedActivity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EventRelatedActivity) {
            throw new \InvalidArgumentException(sprintf('The EventRelatedActivity property can only contain items of type \StructType\EventRelatedActivity, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EventRelatedActivity[] = $item;
        return $this;
    }
    /**
     * Get TaskRelatedActivity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TaskRelatedActivity[]|null
     */
    public function getTaskRelatedActivity()
    {
        return isset($this->TaskRelatedActivity) ? $this->TaskRelatedActivity : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTaskRelatedActivity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaskRelatedActivity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaskRelatedActivityForArrayConstraintsFromSetTaskRelatedActivity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $relatedActivitiesTaskRelatedActivityItem) {
            // validation for constraint: itemType
            if (!$relatedActivitiesTaskRelatedActivityItem instanceof \StructType\TaskRelatedActivity) {
                $invalidValues[] = is_object($relatedActivitiesTaskRelatedActivityItem) ? get_class($relatedActivitiesTaskRelatedActivityItem) : sprintf('%s(%s)', gettype($relatedActivitiesTaskRelatedActivityItem), var_export($relatedActivitiesTaskRelatedActivityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaskRelatedActivity property can only contain items of type \StructType\TaskRelatedActivity, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaskRelatedActivity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TaskRelatedActivity[] $taskRelatedActivity
     * @return \StructType\RelatedActivities
     */
    public function setTaskRelatedActivity(array $taskRelatedActivity = array())
    {
        // validation for constraint: array
        if ('' !== ($taskRelatedActivityArrayErrorMessage = self::validateTaskRelatedActivityForArrayConstraintsFromSetTaskRelatedActivity($taskRelatedActivity))) {
            throw new \InvalidArgumentException($taskRelatedActivityArrayErrorMessage, __LINE__);
        }
        if (is_null($taskRelatedActivity) || (is_array($taskRelatedActivity) && empty($taskRelatedActivity))) {
            unset($this->TaskRelatedActivity);
        } else {
            $this->TaskRelatedActivity = $taskRelatedActivity;
        }
        return $this;
    }
    /**
     * Add item to TaskRelatedActivity value
     * @throws \InvalidArgumentException
     * @param \StructType\TaskRelatedActivity $item
     * @return \StructType\RelatedActivities
     */
    public function addToTaskRelatedActivity(\StructType\TaskRelatedActivity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TaskRelatedActivity) {
            throw new \InvalidArgumentException(sprintf('The TaskRelatedActivity property can only contain items of type \StructType\TaskRelatedActivity, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TaskRelatedActivity[] = $item;
        return $this;
    }
}
