<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProjectTemplateTaskProperties StructType
 * @subpackage Structs
 */
class ProjectTemplateTaskProperties extends Entity
{
    /**
     * The Approver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Approver;
    /**
     * The AutomaticallyIncludeInProject
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $AutomaticallyIncludeInProject;
    /**
     * The CompletionMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CompletionMethod;
    /**
     * The Default
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $Default;
    /**
     * Constructor method for ProjectTemplateTaskProperties
     * @uses ProjectTemplateTaskProperties::setApprover()
     * @uses ProjectTemplateTaskProperties::setAutomaticallyIncludeInProject()
     * @uses ProjectTemplateTaskProperties::setCompletionMethod()
     * @uses ProjectTemplateTaskProperties::setDefault()
     * @param \StructType\StringValue $approver
     * @param \StructType\BooleanValue $automaticallyIncludeInProject
     * @param \StructType\StringValue $completionMethod
     * @param \StructType\BooleanValue $default
     */
    public function __construct(\StructType\StringValue $approver = null, \StructType\BooleanValue $automaticallyIncludeInProject = null, \StructType\StringValue $completionMethod = null, \StructType\BooleanValue $default = null)
    {
        $this
            ->setApprover($approver)
            ->setAutomaticallyIncludeInProject($automaticallyIncludeInProject)
            ->setCompletionMethod($completionMethod)
            ->setDefault($default);
    }
    /**
     * Get Approver value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getApprover()
    {
        return isset($this->Approver) ? $this->Approver : null;
    }
    /**
     * Set Approver value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $approver
     * @return \StructType\ProjectTemplateTaskProperties
     */
    public function setApprover(\StructType\StringValue $approver = null)
    {
        if (is_null($approver) || (is_array($approver) && empty($approver))) {
            unset($this->Approver);
        } else {
            $this->Approver = $approver;
        }
        return $this;
    }
    /**
     * Get AutomaticallyIncludeInProject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getAutomaticallyIncludeInProject()
    {
        return isset($this->AutomaticallyIncludeInProject) ? $this->AutomaticallyIncludeInProject : null;
    }
    /**
     * Set AutomaticallyIncludeInProject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $automaticallyIncludeInProject
     * @return \StructType\ProjectTemplateTaskProperties
     */
    public function setAutomaticallyIncludeInProject(\StructType\BooleanValue $automaticallyIncludeInProject = null)
    {
        if (is_null($automaticallyIncludeInProject) || (is_array($automaticallyIncludeInProject) && empty($automaticallyIncludeInProject))) {
            unset($this->AutomaticallyIncludeInProject);
        } else {
            $this->AutomaticallyIncludeInProject = $automaticallyIncludeInProject;
        }
        return $this;
    }
    /**
     * Get CompletionMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCompletionMethod()
    {
        return isset($this->CompletionMethod) ? $this->CompletionMethod : null;
    }
    /**
     * Set CompletionMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $completionMethod
     * @return \StructType\ProjectTemplateTaskProperties
     */
    public function setCompletionMethod(\StructType\StringValue $completionMethod = null)
    {
        if (is_null($completionMethod) || (is_array($completionMethod) && empty($completionMethod))) {
            unset($this->CompletionMethod);
        } else {
            $this->CompletionMethod = $completionMethod;
        }
        return $this;
    }
    /**
     * Get Default value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getDefault()
    {
        return isset($this->Default) ? $this->Default : null;
    }
    /**
     * Set Default value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $default
     * @return \StructType\ProjectTemplateTaskProperties
     */
    public function setDefault(\StructType\BooleanValue $default = null)
    {
        if (is_null($default) || (is_array($default) && empty($default))) {
            unset($this->Default);
        } else {
            $this->Default = $default;
        }
        return $this;
    }
}
