<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project StructType
 * @subpackage Structs
 */
class Project extends Entity
{
    /**
     * The ActivityHistory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ActivityHistory
     */
    public $ActivityHistory;
    /**
     * The ApprovalDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ApprovalDetails
     */
    public $ApprovalDetails;
    /**
     * The Assets
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $Assets;
    /**
     * The Attributes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Attributes
     */
    public $Attributes;
    /**
     * The Balances
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Balances
     */
    public $Balances;
    /**
     * The BillingAndAllocationSettings
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProjectBillingAndAllocationSettings
     */
    public $BillingAndAllocationSettings;
    /**
     * The BillToSettings
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BillToSettings
     */
    public $BillToSettings;
    /**
     * The Customer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Customer;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Description;
    /**
     * The Employees
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Employees
     */
    public $Employees;
    /**
     * The Equipments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Equipments
     */
    public $Equipments;
    /**
     * The Expenses
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $Expenses;
    /**
     * The ExternalRefNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ExternalRefNbr;
    /**
     * The GLAccounts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProjectGLAccount
     */
    public $GLAccounts;
    /**
     * The Hold
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $Hold;
    /**
     * The Income
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $Income;
    /**
     * The Invoices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Invoices
     */
    public $Invoices;
    /**
     * The LastModifiedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $LastModifiedDateTime;
    /**
     * The Liabilities
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $Liabilities;
    /**
     * The ProjectID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ProjectID;
    /**
     * The ProjectProperties
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProjectProperties
     */
    public $ProjectProperties;
    /**
     * The ProjectTemplateID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ProjectTemplateID;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Status;
    /**
     * The UnionLocals
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\UnionLocals
     */
    public $UnionLocals;
    /**
     * The VisibilitySettings
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\VisibilitySettings
     */
    public $VisibilitySettings;
    /**
     * Constructor method for Project
     * @uses Project::setActivityHistory()
     * @uses Project::setApprovalDetails()
     * @uses Project::setAssets()
     * @uses Project::setAttributes()
     * @uses Project::setBalances()
     * @uses Project::setBillingAndAllocationSettings()
     * @uses Project::setBillToSettings()
     * @uses Project::setCustomer()
     * @uses Project::setDescription()
     * @uses Project::setEmployees()
     * @uses Project::setEquipments()
     * @uses Project::setExpenses()
     * @uses Project::setExternalRefNbr()
     * @uses Project::setGLAccounts()
     * @uses Project::setHold()
     * @uses Project::setIncome()
     * @uses Project::setInvoices()
     * @uses Project::setLastModifiedDateTime()
     * @uses Project::setLiabilities()
     * @uses Project::setProjectID()
     * @uses Project::setProjectProperties()
     * @uses Project::setProjectTemplateID()
     * @uses Project::setStatus()
     * @uses Project::setUnionLocals()
     * @uses Project::setVisibilitySettings()
     * @param \StructType\ActivityHistory $activityHistory
     * @param \StructType\ApprovalDetails $approvalDetails
     * @param \StructType\DecimalValue $assets
     * @param \StructType\Attributes $attributes
     * @param \StructType\Balances $balances
     * @param \StructType\ProjectBillingAndAllocationSettings $billingAndAllocationSettings
     * @param \StructType\BillToSettings $billToSettings
     * @param \StructType\StringValue $customer
     * @param \StructType\StringValue $description
     * @param \StructType\Employees $employees
     * @param \StructType\Equipments $equipments
     * @param \StructType\DecimalValue $expenses
     * @param \StructType\StringValue $externalRefNbr
     * @param \StructType\ProjectGLAccount $gLAccounts
     * @param \StructType\BooleanValue $hold
     * @param \StructType\DecimalValue $income
     * @param \StructType\Invoices $invoices
     * @param \StructType\DateTimeValue $lastModifiedDateTime
     * @param \StructType\DecimalValue $liabilities
     * @param \StructType\StringValue $projectID
     * @param \StructType\ProjectProperties $projectProperties
     * @param \StructType\StringValue $projectTemplateID
     * @param \StructType\StringValue $status
     * @param \StructType\UnionLocals $unionLocals
     * @param \StructType\VisibilitySettings $visibilitySettings
     */
    public function __construct(\StructType\ActivityHistory $activityHistory = null, \StructType\ApprovalDetails $approvalDetails = null, \StructType\DecimalValue $assets = null, \StructType\Attributes $attributes = null, \StructType\Balances $balances = null, \StructType\ProjectBillingAndAllocationSettings $billingAndAllocationSettings = null, \StructType\BillToSettings $billToSettings = null, \StructType\StringValue $customer = null, \StructType\StringValue $description = null, \StructType\Employees $employees = null, \StructType\Equipments $equipments = null, \StructType\DecimalValue $expenses = null, \StructType\StringValue $externalRefNbr = null, \StructType\ProjectGLAccount $gLAccounts = null, \StructType\BooleanValue $hold = null, \StructType\DecimalValue $income = null, \StructType\Invoices $invoices = null, \StructType\DateTimeValue $lastModifiedDateTime = null, \StructType\DecimalValue $liabilities = null, \StructType\StringValue $projectID = null, \StructType\ProjectProperties $projectProperties = null, \StructType\StringValue $projectTemplateID = null, \StructType\StringValue $status = null, \StructType\UnionLocals $unionLocals = null, \StructType\VisibilitySettings $visibilitySettings = null)
    {
        $this
            ->setActivityHistory($activityHistory)
            ->setApprovalDetails($approvalDetails)
            ->setAssets($assets)
            ->setAttributes($attributes)
            ->setBalances($balances)
            ->setBillingAndAllocationSettings($billingAndAllocationSettings)
            ->setBillToSettings($billToSettings)
            ->setCustomer($customer)
            ->setDescription($description)
            ->setEmployees($employees)
            ->setEquipments($equipments)
            ->setExpenses($expenses)
            ->setExternalRefNbr($externalRefNbr)
            ->setGLAccounts($gLAccounts)
            ->setHold($hold)
            ->setIncome($income)
            ->setInvoices($invoices)
            ->setLastModifiedDateTime($lastModifiedDateTime)
            ->setLiabilities($liabilities)
            ->setProjectID($projectID)
            ->setProjectProperties($projectProperties)
            ->setProjectTemplateID($projectTemplateID)
            ->setStatus($status)
            ->setUnionLocals($unionLocals)
            ->setVisibilitySettings($visibilitySettings);
    }
    /**
     * Get ActivityHistory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ActivityHistory|null
     */
    public function getActivityHistory()
    {
        return isset($this->ActivityHistory) ? $this->ActivityHistory : null;
    }
    /**
     * Set ActivityHistory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ActivityHistory $activityHistory
     * @return \StructType\Project
     */
    public function setActivityHistory(\StructType\ActivityHistory $activityHistory = null)
    {
        if (is_null($activityHistory) || (is_array($activityHistory) && empty($activityHistory))) {
            unset($this->ActivityHistory);
        } else {
            $this->ActivityHistory = $activityHistory;
        }
        return $this;
    }
    /**
     * Get ApprovalDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ApprovalDetails|null
     */
    public function getApprovalDetails()
    {
        return isset($this->ApprovalDetails) ? $this->ApprovalDetails : null;
    }
    /**
     * Set ApprovalDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ApprovalDetails $approvalDetails
     * @return \StructType\Project
     */
    public function setApprovalDetails(\StructType\ApprovalDetails $approvalDetails = null)
    {
        if (is_null($approvalDetails) || (is_array($approvalDetails) && empty($approvalDetails))) {
            unset($this->ApprovalDetails);
        } else {
            $this->ApprovalDetails = $approvalDetails;
        }
        return $this;
    }
    /**
     * Get Assets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getAssets()
    {
        return isset($this->Assets) ? $this->Assets : null;
    }
    /**
     * Set Assets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $assets
     * @return \StructType\Project
     */
    public function setAssets(\StructType\DecimalValue $assets = null)
    {
        if (is_null($assets) || (is_array($assets) && empty($assets))) {
            unset($this->Assets);
        } else {
            $this->Assets = $assets;
        }
        return $this;
    }
    /**
     * Get Attributes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Attributes|null
     */
    public function getAttributes()
    {
        return isset($this->Attributes) ? $this->Attributes : null;
    }
    /**
     * Set Attributes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Attributes $attributes
     * @return \StructType\Project
     */
    public function setAttributes(\StructType\Attributes $attributes = null)
    {
        if (is_null($attributes) || (is_array($attributes) && empty($attributes))) {
            unset($this->Attributes);
        } else {
            $this->Attributes = $attributes;
        }
        return $this;
    }
    /**
     * Get Balances value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Balances|null
     */
    public function getBalances()
    {
        return isset($this->Balances) ? $this->Balances : null;
    }
    /**
     * Set Balances value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Balances $balances
     * @return \StructType\Project
     */
    public function setBalances(\StructType\Balances $balances = null)
    {
        if (is_null($balances) || (is_array($balances) && empty($balances))) {
            unset($this->Balances);
        } else {
            $this->Balances = $balances;
        }
        return $this;
    }
    /**
     * Get BillingAndAllocationSettings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProjectBillingAndAllocationSettings|null
     */
    public function getBillingAndAllocationSettings()
    {
        return isset($this->BillingAndAllocationSettings) ? $this->BillingAndAllocationSettings : null;
    }
    /**
     * Set BillingAndAllocationSettings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ProjectBillingAndAllocationSettings $billingAndAllocationSettings
     * @return \StructType\Project
     */
    public function setBillingAndAllocationSettings(\StructType\ProjectBillingAndAllocationSettings $billingAndAllocationSettings = null)
    {
        if (is_null($billingAndAllocationSettings) || (is_array($billingAndAllocationSettings) && empty($billingAndAllocationSettings))) {
            unset($this->BillingAndAllocationSettings);
        } else {
            $this->BillingAndAllocationSettings = $billingAndAllocationSettings;
        }
        return $this;
    }
    /**
     * Get BillToSettings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BillToSettings|null
     */
    public function getBillToSettings()
    {
        return isset($this->BillToSettings) ? $this->BillToSettings : null;
    }
    /**
     * Set BillToSettings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BillToSettings $billToSettings
     * @return \StructType\Project
     */
    public function setBillToSettings(\StructType\BillToSettings $billToSettings = null)
    {
        if (is_null($billToSettings) || (is_array($billToSettings) && empty($billToSettings))) {
            unset($this->BillToSettings);
        } else {
            $this->BillToSettings = $billToSettings;
        }
        return $this;
    }
    /**
     * Get Customer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCustomer()
    {
        return isset($this->Customer) ? $this->Customer : null;
    }
    /**
     * Set Customer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $customer
     * @return \StructType\Project
     */
    public function setCustomer(\StructType\StringValue $customer = null)
    {
        if (is_null($customer) || (is_array($customer) && empty($customer))) {
            unset($this->Customer);
        } else {
            $this->Customer = $customer;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $description
     * @return \StructType\Project
     */
    public function setDescription(\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Employees value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Employees|null
     */
    public function getEmployees()
    {
        return isset($this->Employees) ? $this->Employees : null;
    }
    /**
     * Set Employees value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Employees $employees
     * @return \StructType\Project
     */
    public function setEmployees(\StructType\Employees $employees = null)
    {
        if (is_null($employees) || (is_array($employees) && empty($employees))) {
            unset($this->Employees);
        } else {
            $this->Employees = $employees;
        }
        return $this;
    }
    /**
     * Get Equipments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Equipments|null
     */
    public function getEquipments()
    {
        return isset($this->Equipments) ? $this->Equipments : null;
    }
    /**
     * Set Equipments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Equipments $equipments
     * @return \StructType\Project
     */
    public function setEquipments(\StructType\Equipments $equipments = null)
    {
        if (is_null($equipments) || (is_array($equipments) && empty($equipments))) {
            unset($this->Equipments);
        } else {
            $this->Equipments = $equipments;
        }
        return $this;
    }
    /**
     * Get Expenses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getExpenses()
    {
        return isset($this->Expenses) ? $this->Expenses : null;
    }
    /**
     * Set Expenses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $expenses
     * @return \StructType\Project
     */
    public function setExpenses(\StructType\DecimalValue $expenses = null)
    {
        if (is_null($expenses) || (is_array($expenses) && empty($expenses))) {
            unset($this->Expenses);
        } else {
            $this->Expenses = $expenses;
        }
        return $this;
    }
    /**
     * Get ExternalRefNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getExternalRefNbr()
    {
        return isset($this->ExternalRefNbr) ? $this->ExternalRefNbr : null;
    }
    /**
     * Set ExternalRefNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $externalRefNbr
     * @return \StructType\Project
     */
    public function setExternalRefNbr(\StructType\StringValue $externalRefNbr = null)
    {
        if (is_null($externalRefNbr) || (is_array($externalRefNbr) && empty($externalRefNbr))) {
            unset($this->ExternalRefNbr);
        } else {
            $this->ExternalRefNbr = $externalRefNbr;
        }
        return $this;
    }
    /**
     * Get GLAccounts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProjectGLAccount|null
     */
    public function getGLAccounts()
    {
        return isset($this->GLAccounts) ? $this->GLAccounts : null;
    }
    /**
     * Set GLAccounts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ProjectGLAccount $gLAccounts
     * @return \StructType\Project
     */
    public function setGLAccounts(\StructType\ProjectGLAccount $gLAccounts = null)
    {
        if (is_null($gLAccounts) || (is_array($gLAccounts) && empty($gLAccounts))) {
            unset($this->GLAccounts);
        } else {
            $this->GLAccounts = $gLAccounts;
        }
        return $this;
    }
    /**
     * Get Hold value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getHold()
    {
        return isset($this->Hold) ? $this->Hold : null;
    }
    /**
     * Set Hold value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $hold
     * @return \StructType\Project
     */
    public function setHold(\StructType\BooleanValue $hold = null)
    {
        if (is_null($hold) || (is_array($hold) && empty($hold))) {
            unset($this->Hold);
        } else {
            $this->Hold = $hold;
        }
        return $this;
    }
    /**
     * Get Income value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getIncome()
    {
        return isset($this->Income) ? $this->Income : null;
    }
    /**
     * Set Income value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $income
     * @return \StructType\Project
     */
    public function setIncome(\StructType\DecimalValue $income = null)
    {
        if (is_null($income) || (is_array($income) && empty($income))) {
            unset($this->Income);
        } else {
            $this->Income = $income;
        }
        return $this;
    }
    /**
     * Get Invoices value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Invoices|null
     */
    public function getInvoices()
    {
        return isset($this->Invoices) ? $this->Invoices : null;
    }
    /**
     * Set Invoices value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Invoices $invoices
     * @return \StructType\Project
     */
    public function setInvoices(\StructType\Invoices $invoices = null)
    {
        if (is_null($invoices) || (is_array($invoices) && empty($invoices))) {
            unset($this->Invoices);
        } else {
            $this->Invoices = $invoices;
        }
        return $this;
    }
    /**
     * Get LastModifiedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getLastModifiedDateTime()
    {
        return isset($this->LastModifiedDateTime) ? $this->LastModifiedDateTime : null;
    }
    /**
     * Set LastModifiedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $lastModifiedDateTime
     * @return \StructType\Project
     */
    public function setLastModifiedDateTime(\StructType\DateTimeValue $lastModifiedDateTime = null)
    {
        if (is_null($lastModifiedDateTime) || (is_array($lastModifiedDateTime) && empty($lastModifiedDateTime))) {
            unset($this->LastModifiedDateTime);
        } else {
            $this->LastModifiedDateTime = $lastModifiedDateTime;
        }
        return $this;
    }
    /**
     * Get Liabilities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getLiabilities()
    {
        return isset($this->Liabilities) ? $this->Liabilities : null;
    }
    /**
     * Set Liabilities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $liabilities
     * @return \StructType\Project
     */
    public function setLiabilities(\StructType\DecimalValue $liabilities = null)
    {
        if (is_null($liabilities) || (is_array($liabilities) && empty($liabilities))) {
            unset($this->Liabilities);
        } else {
            $this->Liabilities = $liabilities;
        }
        return $this;
    }
    /**
     * Get ProjectID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getProjectID()
    {
        return isset($this->ProjectID) ? $this->ProjectID : null;
    }
    /**
     * Set ProjectID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $projectID
     * @return \StructType\Project
     */
    public function setProjectID(\StructType\StringValue $projectID = null)
    {
        if (is_null($projectID) || (is_array($projectID) && empty($projectID))) {
            unset($this->ProjectID);
        } else {
            $this->ProjectID = $projectID;
        }
        return $this;
    }
    /**
     * Get ProjectProperties value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProjectProperties|null
     */
    public function getProjectProperties()
    {
        return isset($this->ProjectProperties) ? $this->ProjectProperties : null;
    }
    /**
     * Set ProjectProperties value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ProjectProperties $projectProperties
     * @return \StructType\Project
     */
    public function setProjectProperties(\StructType\ProjectProperties $projectProperties = null)
    {
        if (is_null($projectProperties) || (is_array($projectProperties) && empty($projectProperties))) {
            unset($this->ProjectProperties);
        } else {
            $this->ProjectProperties = $projectProperties;
        }
        return $this;
    }
    /**
     * Get ProjectTemplateID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getProjectTemplateID()
    {
        return isset($this->ProjectTemplateID) ? $this->ProjectTemplateID : null;
    }
    /**
     * Set ProjectTemplateID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $projectTemplateID
     * @return \StructType\Project
     */
    public function setProjectTemplateID(\StructType\StringValue $projectTemplateID = null)
    {
        if (is_null($projectTemplateID) || (is_array($projectTemplateID) && empty($projectTemplateID))) {
            unset($this->ProjectTemplateID);
        } else {
            $this->ProjectTemplateID = $projectTemplateID;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $status
     * @return \StructType\Project
     */
    public function setStatus(\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get UnionLocals value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\UnionLocals|null
     */
    public function getUnionLocals()
    {
        return isset($this->UnionLocals) ? $this->UnionLocals : null;
    }
    /**
     * Set UnionLocals value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\UnionLocals $unionLocals
     * @return \StructType\Project
     */
    public function setUnionLocals(\StructType\UnionLocals $unionLocals = null)
    {
        if (is_null($unionLocals) || (is_array($unionLocals) && empty($unionLocals))) {
            unset($this->UnionLocals);
        } else {
            $this->UnionLocals = $unionLocals;
        }
        return $this;
    }
    /**
     * Get VisibilitySettings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\VisibilitySettings|null
     */
    public function getVisibilitySettings()
    {
        return isset($this->VisibilitySettings) ? $this->VisibilitySettings : null;
    }
    /**
     * Set VisibilitySettings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\VisibilitySettings $visibilitySettings
     * @return \StructType\Project
     */
    public function setVisibilitySettings(\StructType\VisibilitySettings $visibilitySettings = null)
    {
        if (is_null($visibilitySettings) || (is_array($visibilitySettings) && empty($visibilitySettings))) {
            unset($this->VisibilitySettings);
        } else {
            $this->VisibilitySettings = $visibilitySettings;
        }
        return $this;
    }
}
