<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProgressBilling StructType
 * @subpackage Structs
 */
class ProgressBilling extends Entity
{
    /**
     * The ActualAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $ActualAmount;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $Amount;
    /**
     * The AmountToInvoice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $AmountToInvoice;
    /**
     * The Branch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Branch;
    /**
     * The CostCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CostCode;
    /**
     * The CurrentInvoiced
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $CurrentInvoiced;
    /**
     * The DeferralCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $DeferralCode;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Description;
    /**
     * The DraftInvoicesAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $DraftInvoicesAmount;
    /**
     * The InventoryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $InventoryID;
    /**
     * The PreviouslyInvoiced
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $PreviouslyInvoiced;
    /**
     * The ProjectTaskID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ProjectTaskID;
    /**
     * The Retainage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $Retainage;
    /**
     * The RetainageAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $RetainageAmount;
    /**
     * The RevisedBudgetedAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $RevisedBudgetedAmount;
    /**
     * The SalesAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $SalesAccount;
    /**
     * The SalesSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $SalesSubaccount;
    /**
     * The StoredMaterial
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $StoredMaterial;
    /**
     * The TaxCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $TaxCategory;
    /**
     * The TotalCompleted
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $TotalCompleted;
    /**
     * The ProgressBilling
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProgressBilling[]
     */
    public $ProgressBilling;
    /**
     * Constructor method for ProgressBilling
     * @uses ProgressBilling::setActualAmount()
     * @uses ProgressBilling::setAmount()
     * @uses ProgressBilling::setAmountToInvoice()
     * @uses ProgressBilling::setBranch()
     * @uses ProgressBilling::setCostCode()
     * @uses ProgressBilling::setCurrentInvoiced()
     * @uses ProgressBilling::setDeferralCode()
     * @uses ProgressBilling::setDescription()
     * @uses ProgressBilling::setDraftInvoicesAmount()
     * @uses ProgressBilling::setInventoryID()
     * @uses ProgressBilling::setPreviouslyInvoiced()
     * @uses ProgressBilling::setProjectTaskID()
     * @uses ProgressBilling::setRetainage()
     * @uses ProgressBilling::setRetainageAmount()
     * @uses ProgressBilling::setRevisedBudgetedAmount()
     * @uses ProgressBilling::setSalesAccount()
     * @uses ProgressBilling::setSalesSubaccount()
     * @uses ProgressBilling::setStoredMaterial()
     * @uses ProgressBilling::setTaxCategory()
     * @uses ProgressBilling::setTotalCompleted()
     * @uses ProgressBilling::setProgressBilling()
     * @param \StructType\DecimalValue $actualAmount
     * @param \StructType\DecimalValue $amount
     * @param \StructType\DecimalValue $amountToInvoice
     * @param \StructType\StringValue $branch
     * @param \StructType\StringValue $costCode
     * @param \StructType\DecimalValue $currentInvoiced
     * @param \StructType\StringValue $deferralCode
     * @param \StructType\StringValue $description
     * @param \StructType\DecimalValue $draftInvoicesAmount
     * @param \StructType\StringValue $inventoryID
     * @param \StructType\DecimalValue $previouslyInvoiced
     * @param \StructType\StringValue $projectTaskID
     * @param \StructType\DecimalValue $retainage
     * @param \StructType\DecimalValue $retainageAmount
     * @param \StructType\DecimalValue $revisedBudgetedAmount
     * @param \StructType\StringValue $salesAccount
     * @param \StructType\StringValue $salesSubaccount
     * @param \StructType\DecimalValue $storedMaterial
     * @param \StructType\StringValue $taxCategory
     * @param \StructType\DecimalValue $totalCompleted
     * @param \StructType\ProgressBilling[] $progressBilling
     */
    public function __construct(\StructType\DecimalValue $actualAmount = null, \StructType\DecimalValue $amount = null, \StructType\DecimalValue $amountToInvoice = null, \StructType\StringValue $branch = null, \StructType\StringValue $costCode = null, \StructType\DecimalValue $currentInvoiced = null, \StructType\StringValue $deferralCode = null, \StructType\StringValue $description = null, \StructType\DecimalValue $draftInvoicesAmount = null, \StructType\StringValue $inventoryID = null, \StructType\DecimalValue $previouslyInvoiced = null, \StructType\StringValue $projectTaskID = null, \StructType\DecimalValue $retainage = null, \StructType\DecimalValue $retainageAmount = null, \StructType\DecimalValue $revisedBudgetedAmount = null, \StructType\StringValue $salesAccount = null, \StructType\StringValue $salesSubaccount = null, \StructType\DecimalValue $storedMaterial = null, \StructType\StringValue $taxCategory = null, \StructType\DecimalValue $totalCompleted = null, array $progressBilling = array())
    {
        $this
            ->setActualAmount($actualAmount)
            ->setAmount($amount)
            ->setAmountToInvoice($amountToInvoice)
            ->setBranch($branch)
            ->setCostCode($costCode)
            ->setCurrentInvoiced($currentInvoiced)
            ->setDeferralCode($deferralCode)
            ->setDescription($description)
            ->setDraftInvoicesAmount($draftInvoicesAmount)
            ->setInventoryID($inventoryID)
            ->setPreviouslyInvoiced($previouslyInvoiced)
            ->setProjectTaskID($projectTaskID)
            ->setRetainage($retainage)
            ->setRetainageAmount($retainageAmount)
            ->setRevisedBudgetedAmount($revisedBudgetedAmount)
            ->setSalesAccount($salesAccount)
            ->setSalesSubaccount($salesSubaccount)
            ->setStoredMaterial($storedMaterial)
            ->setTaxCategory($taxCategory)
            ->setTotalCompleted($totalCompleted)
            ->setProgressBilling($progressBilling);
    }
    /**
     * Get ActualAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getActualAmount()
    {
        return isset($this->ActualAmount) ? $this->ActualAmount : null;
    }
    /**
     * Set ActualAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $actualAmount
     * @return \StructType\ProgressBilling
     */
    public function setActualAmount(\StructType\DecimalValue $actualAmount = null)
    {
        if (is_null($actualAmount) || (is_array($actualAmount) && empty($actualAmount))) {
            unset($this->ActualAmount);
        } else {
            $this->ActualAmount = $actualAmount;
        }
        return $this;
    }
    /**
     * Get Amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * Set Amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $amount
     * @return \StructType\ProgressBilling
     */
    public function setAmount(\StructType\DecimalValue $amount = null)
    {
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get AmountToInvoice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getAmountToInvoice()
    {
        return isset($this->AmountToInvoice) ? $this->AmountToInvoice : null;
    }
    /**
     * Set AmountToInvoice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $amountToInvoice
     * @return \StructType\ProgressBilling
     */
    public function setAmountToInvoice(\StructType\DecimalValue $amountToInvoice = null)
    {
        if (is_null($amountToInvoice) || (is_array($amountToInvoice) && empty($amountToInvoice))) {
            unset($this->AmountToInvoice);
        } else {
            $this->AmountToInvoice = $amountToInvoice;
        }
        return $this;
    }
    /**
     * Get Branch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getBranch()
    {
        return isset($this->Branch) ? $this->Branch : null;
    }
    /**
     * Set Branch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $branch
     * @return \StructType\ProgressBilling
     */
    public function setBranch(\StructType\StringValue $branch = null)
    {
        if (is_null($branch) || (is_array($branch) && empty($branch))) {
            unset($this->Branch);
        } else {
            $this->Branch = $branch;
        }
        return $this;
    }
    /**
     * Get CostCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCostCode()
    {
        return isset($this->CostCode) ? $this->CostCode : null;
    }
    /**
     * Set CostCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $costCode
     * @return \StructType\ProgressBilling
     */
    public function setCostCode(\StructType\StringValue $costCode = null)
    {
        if (is_null($costCode) || (is_array($costCode) && empty($costCode))) {
            unset($this->CostCode);
        } else {
            $this->CostCode = $costCode;
        }
        return $this;
    }
    /**
     * Get CurrentInvoiced value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getCurrentInvoiced()
    {
        return isset($this->CurrentInvoiced) ? $this->CurrentInvoiced : null;
    }
    /**
     * Set CurrentInvoiced value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $currentInvoiced
     * @return \StructType\ProgressBilling
     */
    public function setCurrentInvoiced(\StructType\DecimalValue $currentInvoiced = null)
    {
        if (is_null($currentInvoiced) || (is_array($currentInvoiced) && empty($currentInvoiced))) {
            unset($this->CurrentInvoiced);
        } else {
            $this->CurrentInvoiced = $currentInvoiced;
        }
        return $this;
    }
    /**
     * Get DeferralCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDeferralCode()
    {
        return isset($this->DeferralCode) ? $this->DeferralCode : null;
    }
    /**
     * Set DeferralCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $deferralCode
     * @return \StructType\ProgressBilling
     */
    public function setDeferralCode(\StructType\StringValue $deferralCode = null)
    {
        if (is_null($deferralCode) || (is_array($deferralCode) && empty($deferralCode))) {
            unset($this->DeferralCode);
        } else {
            $this->DeferralCode = $deferralCode;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $description
     * @return \StructType\ProgressBilling
     */
    public function setDescription(\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DraftInvoicesAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getDraftInvoicesAmount()
    {
        return isset($this->DraftInvoicesAmount) ? $this->DraftInvoicesAmount : null;
    }
    /**
     * Set DraftInvoicesAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $draftInvoicesAmount
     * @return \StructType\ProgressBilling
     */
    public function setDraftInvoicesAmount(\StructType\DecimalValue $draftInvoicesAmount = null)
    {
        if (is_null($draftInvoicesAmount) || (is_array($draftInvoicesAmount) && empty($draftInvoicesAmount))) {
            unset($this->DraftInvoicesAmount);
        } else {
            $this->DraftInvoicesAmount = $draftInvoicesAmount;
        }
        return $this;
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $inventoryID
     * @return \StructType\ProgressBilling
     */
    public function setInventoryID(\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get PreviouslyInvoiced value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getPreviouslyInvoiced()
    {
        return isset($this->PreviouslyInvoiced) ? $this->PreviouslyInvoiced : null;
    }
    /**
     * Set PreviouslyInvoiced value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $previouslyInvoiced
     * @return \StructType\ProgressBilling
     */
    public function setPreviouslyInvoiced(\StructType\DecimalValue $previouslyInvoiced = null)
    {
        if (is_null($previouslyInvoiced) || (is_array($previouslyInvoiced) && empty($previouslyInvoiced))) {
            unset($this->PreviouslyInvoiced);
        } else {
            $this->PreviouslyInvoiced = $previouslyInvoiced;
        }
        return $this;
    }
    /**
     * Get ProjectTaskID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getProjectTaskID()
    {
        return isset($this->ProjectTaskID) ? $this->ProjectTaskID : null;
    }
    /**
     * Set ProjectTaskID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $projectTaskID
     * @return \StructType\ProgressBilling
     */
    public function setProjectTaskID(\StructType\StringValue $projectTaskID = null)
    {
        if (is_null($projectTaskID) || (is_array($projectTaskID) && empty($projectTaskID))) {
            unset($this->ProjectTaskID);
        } else {
            $this->ProjectTaskID = $projectTaskID;
        }
        return $this;
    }
    /**
     * Get Retainage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getRetainage()
    {
        return isset($this->Retainage) ? $this->Retainage : null;
    }
    /**
     * Set Retainage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $retainage
     * @return \StructType\ProgressBilling
     */
    public function setRetainage(\StructType\DecimalValue $retainage = null)
    {
        if (is_null($retainage) || (is_array($retainage) && empty($retainage))) {
            unset($this->Retainage);
        } else {
            $this->Retainage = $retainage;
        }
        return $this;
    }
    /**
     * Get RetainageAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getRetainageAmount()
    {
        return isset($this->RetainageAmount) ? $this->RetainageAmount : null;
    }
    /**
     * Set RetainageAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $retainageAmount
     * @return \StructType\ProgressBilling
     */
    public function setRetainageAmount(\StructType\DecimalValue $retainageAmount = null)
    {
        if (is_null($retainageAmount) || (is_array($retainageAmount) && empty($retainageAmount))) {
            unset($this->RetainageAmount);
        } else {
            $this->RetainageAmount = $retainageAmount;
        }
        return $this;
    }
    /**
     * Get RevisedBudgetedAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getRevisedBudgetedAmount()
    {
        return isset($this->RevisedBudgetedAmount) ? $this->RevisedBudgetedAmount : null;
    }
    /**
     * Set RevisedBudgetedAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $revisedBudgetedAmount
     * @return \StructType\ProgressBilling
     */
    public function setRevisedBudgetedAmount(\StructType\DecimalValue $revisedBudgetedAmount = null)
    {
        if (is_null($revisedBudgetedAmount) || (is_array($revisedBudgetedAmount) && empty($revisedBudgetedAmount))) {
            unset($this->RevisedBudgetedAmount);
        } else {
            $this->RevisedBudgetedAmount = $revisedBudgetedAmount;
        }
        return $this;
    }
    /**
     * Get SalesAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getSalesAccount()
    {
        return isset($this->SalesAccount) ? $this->SalesAccount : null;
    }
    /**
     * Set SalesAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $salesAccount
     * @return \StructType\ProgressBilling
     */
    public function setSalesAccount(\StructType\StringValue $salesAccount = null)
    {
        if (is_null($salesAccount) || (is_array($salesAccount) && empty($salesAccount))) {
            unset($this->SalesAccount);
        } else {
            $this->SalesAccount = $salesAccount;
        }
        return $this;
    }
    /**
     * Get SalesSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getSalesSubaccount()
    {
        return isset($this->SalesSubaccount) ? $this->SalesSubaccount : null;
    }
    /**
     * Set SalesSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $salesSubaccount
     * @return \StructType\ProgressBilling
     */
    public function setSalesSubaccount(\StructType\StringValue $salesSubaccount = null)
    {
        if (is_null($salesSubaccount) || (is_array($salesSubaccount) && empty($salesSubaccount))) {
            unset($this->SalesSubaccount);
        } else {
            $this->SalesSubaccount = $salesSubaccount;
        }
        return $this;
    }
    /**
     * Get StoredMaterial value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getStoredMaterial()
    {
        return isset($this->StoredMaterial) ? $this->StoredMaterial : null;
    }
    /**
     * Set StoredMaterial value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $storedMaterial
     * @return \StructType\ProgressBilling
     */
    public function setStoredMaterial(\StructType\DecimalValue $storedMaterial = null)
    {
        if (is_null($storedMaterial) || (is_array($storedMaterial) && empty($storedMaterial))) {
            unset($this->StoredMaterial);
        } else {
            $this->StoredMaterial = $storedMaterial;
        }
        return $this;
    }
    /**
     * Get TaxCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getTaxCategory()
    {
        return isset($this->TaxCategory) ? $this->TaxCategory : null;
    }
    /**
     * Set TaxCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $taxCategory
     * @return \StructType\ProgressBilling
     */
    public function setTaxCategory(\StructType\StringValue $taxCategory = null)
    {
        if (is_null($taxCategory) || (is_array($taxCategory) && empty($taxCategory))) {
            unset($this->TaxCategory);
        } else {
            $this->TaxCategory = $taxCategory;
        }
        return $this;
    }
    /**
     * Get TotalCompleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getTotalCompleted()
    {
        return isset($this->TotalCompleted) ? $this->TotalCompleted : null;
    }
    /**
     * Set TotalCompleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $totalCompleted
     * @return \StructType\ProgressBilling
     */
    public function setTotalCompleted(\StructType\DecimalValue $totalCompleted = null)
    {
        if (is_null($totalCompleted) || (is_array($totalCompleted) && empty($totalCompleted))) {
            unset($this->TotalCompleted);
        } else {
            $this->TotalCompleted = $totalCompleted;
        }
        return $this;
    }
    /**
     * Get ProgressBilling value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProgressBilling[]|null
     */
    public function getProgressBilling()
    {
        return isset($this->ProgressBilling) ? $this->ProgressBilling : null;
    }
    /**
     * This method is responsible for validating the values passed to the setProgressBilling method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProgressBilling method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProgressBillingForArrayConstraintsFromSetProgressBilling(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $progressBillingProgressBillingItem) {
            // validation for constraint: itemType
            if (!$progressBillingProgressBillingItem instanceof \StructType\ProgressBilling) {
                $invalidValues[] = is_object($progressBillingProgressBillingItem) ? get_class($progressBillingProgressBillingItem) : sprintf('%s(%s)', gettype($progressBillingProgressBillingItem), var_export($progressBillingProgressBillingItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProgressBilling property can only contain items of type \StructType\ProgressBilling, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProgressBilling value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ProgressBilling[] $progressBilling
     * @return \StructType\ProgressBilling
     */
    public function setProgressBilling(array $progressBilling = array())
    {
        // validation for constraint: array
        if ('' !== ($progressBillingArrayErrorMessage = self::validateProgressBillingForArrayConstraintsFromSetProgressBilling($progressBilling))) {
            throw new \InvalidArgumentException($progressBillingArrayErrorMessage, __LINE__);
        }
        if (is_null($progressBilling) || (is_array($progressBilling) && empty($progressBilling))) {
            unset($this->ProgressBilling);
        } else {
            $this->ProgressBilling = $progressBilling;
        }
        return $this;
    }
    /**
     * Add item to ProgressBilling value
     * @throws \InvalidArgumentException
     * @param \StructType\ProgressBilling $item
     * @return \StructType\ProgressBilling
     */
    public function addToProgressBilling(\StructType\ProgressBilling $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProgressBilling) {
            throw new \InvalidArgumentException(sprintf('The ProgressBilling property can only contain items of type \StructType\ProgressBilling, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ProgressBilling[] = $item;
        return $this;
    }
}
