<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PhysicalInventoryReview StructType
 * @subpackage Structs
 */
class PhysicalInventoryReview extends Entity
{
    /**
     * The CreatedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $CreatedDateTime;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Description;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Details
     */
    public $Details;
    /**
     * The FreezeDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $FreezeDate;
    /**
     * The ReferenceNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ReferenceNbr;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Status;
    /**
     * The TotalPhysicalQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $TotalPhysicalQty;
    /**
     * The TotalVarianceCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $TotalVarianceCost;
    /**
     * The TotalVarianceQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $TotalVarianceQty;
    /**
     * The TypeID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $TypeID;
    /**
     * The WarehouseID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $WarehouseID;
    /**
     * Constructor method for PhysicalInventoryReview
     * @uses PhysicalInventoryReview::setCreatedDateTime()
     * @uses PhysicalInventoryReview::setDescription()
     * @uses PhysicalInventoryReview::setDetails()
     * @uses PhysicalInventoryReview::setFreezeDate()
     * @uses PhysicalInventoryReview::setReferenceNbr()
     * @uses PhysicalInventoryReview::setStatus()
     * @uses PhysicalInventoryReview::setTotalPhysicalQty()
     * @uses PhysicalInventoryReview::setTotalVarianceCost()
     * @uses PhysicalInventoryReview::setTotalVarianceQty()
     * @uses PhysicalInventoryReview::setTypeID()
     * @uses PhysicalInventoryReview::setWarehouseID()
     * @param \StructType\DateTimeValue $createdDateTime
     * @param \StructType\StringValue $description
     * @param \StructType\Details $details
     * @param \StructType\DateTimeValue $freezeDate
     * @param \StructType\StringValue $referenceNbr
     * @param \StructType\StringValue $status
     * @param \StructType\DecimalValue $totalPhysicalQty
     * @param \StructType\DecimalValue $totalVarianceCost
     * @param \StructType\DecimalValue $totalVarianceQty
     * @param \StructType\StringValue $typeID
     * @param \StructType\StringValue $warehouseID
     */
    public function __construct(\StructType\DateTimeValue $createdDateTime = null, \StructType\StringValue $description = null, \StructType\Details $details = null, \StructType\DateTimeValue $freezeDate = null, \StructType\StringValue $referenceNbr = null, \StructType\StringValue $status = null, \StructType\DecimalValue $totalPhysicalQty = null, \StructType\DecimalValue $totalVarianceCost = null, \StructType\DecimalValue $totalVarianceQty = null, \StructType\StringValue $typeID = null, \StructType\StringValue $warehouseID = null)
    {
        $this
            ->setCreatedDateTime($createdDateTime)
            ->setDescription($description)
            ->setDetails($details)
            ->setFreezeDate($freezeDate)
            ->setReferenceNbr($referenceNbr)
            ->setStatus($status)
            ->setTotalPhysicalQty($totalPhysicalQty)
            ->setTotalVarianceCost($totalVarianceCost)
            ->setTotalVarianceQty($totalVarianceQty)
            ->setTypeID($typeID)
            ->setWarehouseID($warehouseID);
    }
    /**
     * Get CreatedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getCreatedDateTime()
    {
        return isset($this->CreatedDateTime) ? $this->CreatedDateTime : null;
    }
    /**
     * Set CreatedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $createdDateTime
     * @return \StructType\PhysicalInventoryReview
     */
    public function setCreatedDateTime(\StructType\DateTimeValue $createdDateTime = null)
    {
        if (is_null($createdDateTime) || (is_array($createdDateTime) && empty($createdDateTime))) {
            unset($this->CreatedDateTime);
        } else {
            $this->CreatedDateTime = $createdDateTime;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $description
     * @return \StructType\PhysicalInventoryReview
     */
    public function setDescription(\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Details|null
     */
    public function getDetails()
    {
        return isset($this->Details) ? $this->Details : null;
    }
    /**
     * Set Details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Details $details
     * @return \StructType\PhysicalInventoryReview
     */
    public function setDetails(\StructType\Details $details = null)
    {
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->Details);
        } else {
            $this->Details = $details;
        }
        return $this;
    }
    /**
     * Get FreezeDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getFreezeDate()
    {
        return isset($this->FreezeDate) ? $this->FreezeDate : null;
    }
    /**
     * Set FreezeDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $freezeDate
     * @return \StructType\PhysicalInventoryReview
     */
    public function setFreezeDate(\StructType\DateTimeValue $freezeDate = null)
    {
        if (is_null($freezeDate) || (is_array($freezeDate) && empty($freezeDate))) {
            unset($this->FreezeDate);
        } else {
            $this->FreezeDate = $freezeDate;
        }
        return $this;
    }
    /**
     * Get ReferenceNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getReferenceNbr()
    {
        return isset($this->ReferenceNbr) ? $this->ReferenceNbr : null;
    }
    /**
     * Set ReferenceNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $referenceNbr
     * @return \StructType\PhysicalInventoryReview
     */
    public function setReferenceNbr(\StructType\StringValue $referenceNbr = null)
    {
        if (is_null($referenceNbr) || (is_array($referenceNbr) && empty($referenceNbr))) {
            unset($this->ReferenceNbr);
        } else {
            $this->ReferenceNbr = $referenceNbr;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $status
     * @return \StructType\PhysicalInventoryReview
     */
    public function setStatus(\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TotalPhysicalQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getTotalPhysicalQty()
    {
        return isset($this->TotalPhysicalQty) ? $this->TotalPhysicalQty : null;
    }
    /**
     * Set TotalPhysicalQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $totalPhysicalQty
     * @return \StructType\PhysicalInventoryReview
     */
    public function setTotalPhysicalQty(\StructType\DecimalValue $totalPhysicalQty = null)
    {
        if (is_null($totalPhysicalQty) || (is_array($totalPhysicalQty) && empty($totalPhysicalQty))) {
            unset($this->TotalPhysicalQty);
        } else {
            $this->TotalPhysicalQty = $totalPhysicalQty;
        }
        return $this;
    }
    /**
     * Get TotalVarianceCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getTotalVarianceCost()
    {
        return isset($this->TotalVarianceCost) ? $this->TotalVarianceCost : null;
    }
    /**
     * Set TotalVarianceCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $totalVarianceCost
     * @return \StructType\PhysicalInventoryReview
     */
    public function setTotalVarianceCost(\StructType\DecimalValue $totalVarianceCost = null)
    {
        if (is_null($totalVarianceCost) || (is_array($totalVarianceCost) && empty($totalVarianceCost))) {
            unset($this->TotalVarianceCost);
        } else {
            $this->TotalVarianceCost = $totalVarianceCost;
        }
        return $this;
    }
    /**
     * Get TotalVarianceQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getTotalVarianceQty()
    {
        return isset($this->TotalVarianceQty) ? $this->TotalVarianceQty : null;
    }
    /**
     * Set TotalVarianceQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $totalVarianceQty
     * @return \StructType\PhysicalInventoryReview
     */
    public function setTotalVarianceQty(\StructType\DecimalValue $totalVarianceQty = null)
    {
        if (is_null($totalVarianceQty) || (is_array($totalVarianceQty) && empty($totalVarianceQty))) {
            unset($this->TotalVarianceQty);
        } else {
            $this->TotalVarianceQty = $totalVarianceQty;
        }
        return $this;
    }
    /**
     * Get TypeID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getTypeID()
    {
        return isset($this->TypeID) ? $this->TypeID : null;
    }
    /**
     * Set TypeID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $typeID
     * @return \StructType\PhysicalInventoryReview
     */
    public function setTypeID(\StructType\StringValue $typeID = null)
    {
        if (is_null($typeID) || (is_array($typeID) && empty($typeID))) {
            unset($this->TypeID);
        } else {
            $this->TypeID = $typeID;
        }
        return $this;
    }
    /**
     * Get WarehouseID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getWarehouseID()
    {
        return isset($this->WarehouseID) ? $this->WarehouseID : null;
    }
    /**
     * Set WarehouseID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $warehouseID
     * @return \StructType\PhysicalInventoryReview
     */
    public function setWarehouseID(\StructType\StringValue $warehouseID = null)
    {
        if (is_null($warehouseID) || (is_array($warehouseID) && empty($warehouseID))) {
            unset($this->WarehouseID);
        } else {
            $this->WarehouseID = $warehouseID;
        }
        return $this;
    }
}
