<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payments StructType
 * @subpackage Structs
 */
class Payments extends Entity
{
    /**
     * The Payments
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Payments[]
     */
    public $Payments;
    /**
     * The AppliedToOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $AppliedToOrder;
    /**
     * The Balance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $Balance;
    /**
     * The CashAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CashAccount;
    /**
     * The CurrencyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CurrencyID;
    /**
     * The DocType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $DocType;
    /**
     * The OrderNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $OrderNbr;
    /**
     * The OrderType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $OrderType;
    /**
     * The PaymentAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $PaymentAmount;
    /**
     * The PaymentMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $PaymentMethod;
    /**
     * The PaymentRef
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $PaymentRef;
    /**
     * The ReferenceNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ReferenceNbr;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Status;
    /**
     * The TransferredtoInvoice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $TransferredtoInvoice;
    /**
     * Constructor method for Payments
     * @uses Payments::setPayments()
     * @uses Payments::setAppliedToOrder()
     * @uses Payments::setBalance()
     * @uses Payments::setCashAccount()
     * @uses Payments::setCurrencyID()
     * @uses Payments::setDocType()
     * @uses Payments::setOrderNbr()
     * @uses Payments::setOrderType()
     * @uses Payments::setPaymentAmount()
     * @uses Payments::setPaymentMethod()
     * @uses Payments::setPaymentRef()
     * @uses Payments::setReferenceNbr()
     * @uses Payments::setStatus()
     * @uses Payments::setTransferredtoInvoice()
     * @param \StructType\Payments[] $payments
     * @param \StructType\DecimalValue $appliedToOrder
     * @param \StructType\DecimalValue $balance
     * @param \StructType\StringValue $cashAccount
     * @param \StructType\StringValue $currencyID
     * @param \StructType\StringValue $docType
     * @param \StructType\StringValue $orderNbr
     * @param \StructType\StringValue $orderType
     * @param \StructType\DecimalValue $paymentAmount
     * @param \StructType\StringValue $paymentMethod
     * @param \StructType\StringValue $paymentRef
     * @param \StructType\StringValue $referenceNbr
     * @param \StructType\StringValue $status
     * @param \StructType\DecimalValue $transferredtoInvoice
     */
    public function __construct(array $payments = array(), \StructType\DecimalValue $appliedToOrder = null, \StructType\DecimalValue $balance = null, \StructType\StringValue $cashAccount = null, \StructType\StringValue $currencyID = null, \StructType\StringValue $docType = null, \StructType\StringValue $orderNbr = null, \StructType\StringValue $orderType = null, \StructType\DecimalValue $paymentAmount = null, \StructType\StringValue $paymentMethod = null, \StructType\StringValue $paymentRef = null, \StructType\StringValue $referenceNbr = null, \StructType\StringValue $status = null, \StructType\DecimalValue $transferredtoInvoice = null)
    {
        $this
            ->setPayments($payments)
            ->setAppliedToOrder($appliedToOrder)
            ->setBalance($balance)
            ->setCashAccount($cashAccount)
            ->setCurrencyID($currencyID)
            ->setDocType($docType)
            ->setOrderNbr($orderNbr)
            ->setOrderType($orderType)
            ->setPaymentAmount($paymentAmount)
            ->setPaymentMethod($paymentMethod)
            ->setPaymentRef($paymentRef)
            ->setReferenceNbr($referenceNbr)
            ->setStatus($status)
            ->setTransferredtoInvoice($transferredtoInvoice);
    }
    /**
     * Get Payments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Payments[]|null
     */
    public function getPayments()
    {
        return isset($this->Payments) ? $this->Payments : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPayments method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPayments method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentsForArrayConstraintsFromSetPayments(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentsPaymentsItem) {
            // validation for constraint: itemType
            if (!$paymentsPaymentsItem instanceof \StructType\Payments) {
                $invalidValues[] = is_object($paymentsPaymentsItem) ? get_class($paymentsPaymentsItem) : sprintf('%s(%s)', gettype($paymentsPaymentsItem), var_export($paymentsPaymentsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Payments property can only contain items of type \StructType\Payments, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Payments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Payments[] $payments
     * @return \StructType\Payments
     */
    public function setPayments(array $payments = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentsArrayErrorMessage = self::validatePaymentsForArrayConstraintsFromSetPayments($payments))) {
            throw new \InvalidArgumentException($paymentsArrayErrorMessage, __LINE__);
        }
        if (is_null($payments) || (is_array($payments) && empty($payments))) {
            unset($this->Payments);
        } else {
            $this->Payments = $payments;
        }
        return $this;
    }
    /**
     * Add item to Payments value
     * @throws \InvalidArgumentException
     * @param \StructType\Payments $item
     * @return \StructType\Payments
     */
    public function addToPayments(\StructType\Payments $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Payments) {
            throw new \InvalidArgumentException(sprintf('The Payments property can only contain items of type \StructType\Payments, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Payments[] = $item;
        return $this;
    }
    /**
     * Get AppliedToOrder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getAppliedToOrder()
    {
        return isset($this->AppliedToOrder) ? $this->AppliedToOrder : null;
    }
    /**
     * Set AppliedToOrder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $appliedToOrder
     * @return \StructType\Payments
     */
    public function setAppliedToOrder(\StructType\DecimalValue $appliedToOrder = null)
    {
        if (is_null($appliedToOrder) || (is_array($appliedToOrder) && empty($appliedToOrder))) {
            unset($this->AppliedToOrder);
        } else {
            $this->AppliedToOrder = $appliedToOrder;
        }
        return $this;
    }
    /**
     * Get Balance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getBalance()
    {
        return isset($this->Balance) ? $this->Balance : null;
    }
    /**
     * Set Balance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $balance
     * @return \StructType\Payments
     */
    public function setBalance(\StructType\DecimalValue $balance = null)
    {
        if (is_null($balance) || (is_array($balance) && empty($balance))) {
            unset($this->Balance);
        } else {
            $this->Balance = $balance;
        }
        return $this;
    }
    /**
     * Get CashAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCashAccount()
    {
        return isset($this->CashAccount) ? $this->CashAccount : null;
    }
    /**
     * Set CashAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $cashAccount
     * @return \StructType\Payments
     */
    public function setCashAccount(\StructType\StringValue $cashAccount = null)
    {
        if (is_null($cashAccount) || (is_array($cashAccount) && empty($cashAccount))) {
            unset($this->CashAccount);
        } else {
            $this->CashAccount = $cashAccount;
        }
        return $this;
    }
    /**
     * Get CurrencyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCurrencyID()
    {
        return isset($this->CurrencyID) ? $this->CurrencyID : null;
    }
    /**
     * Set CurrencyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $currencyID
     * @return \StructType\Payments
     */
    public function setCurrencyID(\StructType\StringValue $currencyID = null)
    {
        if (is_null($currencyID) || (is_array($currencyID) && empty($currencyID))) {
            unset($this->CurrencyID);
        } else {
            $this->CurrencyID = $currencyID;
        }
        return $this;
    }
    /**
     * Get DocType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDocType()
    {
        return isset($this->DocType) ? $this->DocType : null;
    }
    /**
     * Set DocType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $docType
     * @return \StructType\Payments
     */
    public function setDocType(\StructType\StringValue $docType = null)
    {
        if (is_null($docType) || (is_array($docType) && empty($docType))) {
            unset($this->DocType);
        } else {
            $this->DocType = $docType;
        }
        return $this;
    }
    /**
     * Get OrderNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getOrderNbr()
    {
        return isset($this->OrderNbr) ? $this->OrderNbr : null;
    }
    /**
     * Set OrderNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $orderNbr
     * @return \StructType\Payments
     */
    public function setOrderNbr(\StructType\StringValue $orderNbr = null)
    {
        if (is_null($orderNbr) || (is_array($orderNbr) && empty($orderNbr))) {
            unset($this->OrderNbr);
        } else {
            $this->OrderNbr = $orderNbr;
        }
        return $this;
    }
    /**
     * Get OrderType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getOrderType()
    {
        return isset($this->OrderType) ? $this->OrderType : null;
    }
    /**
     * Set OrderType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $orderType
     * @return \StructType\Payments
     */
    public function setOrderType(\StructType\StringValue $orderType = null)
    {
        if (is_null($orderType) || (is_array($orderType) && empty($orderType))) {
            unset($this->OrderType);
        } else {
            $this->OrderType = $orderType;
        }
        return $this;
    }
    /**
     * Get PaymentAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getPaymentAmount()
    {
        return isset($this->PaymentAmount) ? $this->PaymentAmount : null;
    }
    /**
     * Set PaymentAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $paymentAmount
     * @return \StructType\Payments
     */
    public function setPaymentAmount(\StructType\DecimalValue $paymentAmount = null)
    {
        if (is_null($paymentAmount) || (is_array($paymentAmount) && empty($paymentAmount))) {
            unset($this->PaymentAmount);
        } else {
            $this->PaymentAmount = $paymentAmount;
        }
        return $this;
    }
    /**
     * Get PaymentMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getPaymentMethod()
    {
        return isset($this->PaymentMethod) ? $this->PaymentMethod : null;
    }
    /**
     * Set PaymentMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $paymentMethod
     * @return \StructType\Payments
     */
    public function setPaymentMethod(\StructType\StringValue $paymentMethod = null)
    {
        if (is_null($paymentMethod) || (is_array($paymentMethod) && empty($paymentMethod))) {
            unset($this->PaymentMethod);
        } else {
            $this->PaymentMethod = $paymentMethod;
        }
        return $this;
    }
    /**
     * Get PaymentRef value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getPaymentRef()
    {
        return isset($this->PaymentRef) ? $this->PaymentRef : null;
    }
    /**
     * Set PaymentRef value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $paymentRef
     * @return \StructType\Payments
     */
    public function setPaymentRef(\StructType\StringValue $paymentRef = null)
    {
        if (is_null($paymentRef) || (is_array($paymentRef) && empty($paymentRef))) {
            unset($this->PaymentRef);
        } else {
            $this->PaymentRef = $paymentRef;
        }
        return $this;
    }
    /**
     * Get ReferenceNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getReferenceNbr()
    {
        return isset($this->ReferenceNbr) ? $this->ReferenceNbr : null;
    }
    /**
     * Set ReferenceNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $referenceNbr
     * @return \StructType\Payments
     */
    public function setReferenceNbr(\StructType\StringValue $referenceNbr = null)
    {
        if (is_null($referenceNbr) || (is_array($referenceNbr) && empty($referenceNbr))) {
            unset($this->ReferenceNbr);
        } else {
            $this->ReferenceNbr = $referenceNbr;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $status
     * @return \StructType\Payments
     */
    public function setStatus(\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TransferredtoInvoice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getTransferredtoInvoice()
    {
        return isset($this->TransferredtoInvoice) ? $this->TransferredtoInvoice : null;
    }
    /**
     * Set TransferredtoInvoice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $transferredtoInvoice
     * @return \StructType\Payments
     */
    public function setTransferredtoInvoice(\StructType\DecimalValue $transferredtoInvoice = null)
    {
        if (is_null($transferredtoInvoice) || (is_array($transferredtoInvoice) && empty($transferredtoInvoice))) {
            unset($this->TransferredtoInvoice);
        } else {
            $this->TransferredtoInvoice = $transferredtoInvoice;
        }
        return $this;
    }
}
