<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NonStockItem StructType
 * @subpackage Structs
 */
class NonStockItem extends Entity
{
    /**
     * The Attributes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Attributes
     */
    public $Attributes;
    /**
     * The BaseUnit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $BaseUnit;
    /**
     * The CrossReferences
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CrossReferences
     */
    public $CrossReferences;
    /**
     * The CurrentCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $CurrentCost;
    /**
     * The DefaultPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $DefaultPrice;
    /**
     * The DeferralAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $DeferralAccount;
    /**
     * The DeferralSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $DeferralSubaccount;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Description;
    /**
     * The EffectiveDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $EffectiveDate;
    /**
     * The ExpenseAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ExpenseAccount;
    /**
     * The ExpenseAccrualAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ExpenseAccrualAccount;
    /**
     * The ExpenseAccrualSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ExpenseAccrualSubaccount;
    /**
     * The ExpenseSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ExpenseSubaccount;
    /**
     * The InventoryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $InventoryID;
    /**
     * The IsKit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $IsKit;
    /**
     * The ItemClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ItemClass;
    /**
     * The ItemStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ItemStatus;
    /**
     * The ItemType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ItemType;
    /**
     * The LastCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $LastCost;
    /**
     * The LastModifiedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $LastModifiedDateTime;
    /**
     * The PendingCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $PendingCost;
    /**
     * The PendingCostDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $PendingCostDate;
    /**
     * The POAccrualAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $POAccrualAccount;
    /**
     * The POAccrualSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $POAccrualSubaccount;
    /**
     * The PostingClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $PostingClass;
    /**
     * The PriceClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $PriceClass;
    /**
     * The PurchasePriceVarianceAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $PurchasePriceVarianceAccount;
    /**
     * The PurchasePriceVarianceSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $PurchasePriceVarianceSubaccount;
    /**
     * The PurchaseUnit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $PurchaseUnit;
    /**
     * The ReasonCodeSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ReasonCodeSubaccount;
    /**
     * The RequireReceipt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $RequireReceipt;
    /**
     * The RequireShipment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $RequireShipment;
    /**
     * The SalesAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $SalesAccount;
    /**
     * The SalesCategories
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SalesCategories
     */
    public $SalesCategories;
    /**
     * The SalesSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $SalesSubaccount;
    /**
     * The SalesUnit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $SalesUnit;
    /**
     * The TaxCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $TaxCategory;
    /**
     * The VendorDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\VendorDetails
     */
    public $VendorDetails;
    /**
     * The Volume
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $Volume;
    /**
     * The VolumeUOM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $VolumeUOM;
    /**
     * The Weight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $Weight;
    /**
     * The WeightUOM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $WeightUOM;
    /**
     * Constructor method for NonStockItem
     * @uses NonStockItem::setAttributes()
     * @uses NonStockItem::setBaseUnit()
     * @uses NonStockItem::setCrossReferences()
     * @uses NonStockItem::setCurrentCost()
     * @uses NonStockItem::setDefaultPrice()
     * @uses NonStockItem::setDeferralAccount()
     * @uses NonStockItem::setDeferralSubaccount()
     * @uses NonStockItem::setDescription()
     * @uses NonStockItem::setEffectiveDate()
     * @uses NonStockItem::setExpenseAccount()
     * @uses NonStockItem::setExpenseAccrualAccount()
     * @uses NonStockItem::setExpenseAccrualSubaccount()
     * @uses NonStockItem::setExpenseSubaccount()
     * @uses NonStockItem::setInventoryID()
     * @uses NonStockItem::setIsKit()
     * @uses NonStockItem::setItemClass()
     * @uses NonStockItem::setItemStatus()
     * @uses NonStockItem::setItemType()
     * @uses NonStockItem::setLastCost()
     * @uses NonStockItem::setLastModifiedDateTime()
     * @uses NonStockItem::setPendingCost()
     * @uses NonStockItem::setPendingCostDate()
     * @uses NonStockItem::setPOAccrualAccount()
     * @uses NonStockItem::setPOAccrualSubaccount()
     * @uses NonStockItem::setPostingClass()
     * @uses NonStockItem::setPriceClass()
     * @uses NonStockItem::setPurchasePriceVarianceAccount()
     * @uses NonStockItem::setPurchasePriceVarianceSubaccount()
     * @uses NonStockItem::setPurchaseUnit()
     * @uses NonStockItem::setReasonCodeSubaccount()
     * @uses NonStockItem::setRequireReceipt()
     * @uses NonStockItem::setRequireShipment()
     * @uses NonStockItem::setSalesAccount()
     * @uses NonStockItem::setSalesCategories()
     * @uses NonStockItem::setSalesSubaccount()
     * @uses NonStockItem::setSalesUnit()
     * @uses NonStockItem::setTaxCategory()
     * @uses NonStockItem::setVendorDetails()
     * @uses NonStockItem::setVolume()
     * @uses NonStockItem::setVolumeUOM()
     * @uses NonStockItem::setWeight()
     * @uses NonStockItem::setWeightUOM()
     * @param \StructType\Attributes $attributes
     * @param \StructType\StringValue $baseUnit
     * @param \StructType\CrossReferences $crossReferences
     * @param \StructType\DecimalValue $currentCost
     * @param \StructType\DecimalValue $defaultPrice
     * @param \StructType\StringValue $deferralAccount
     * @param \StructType\StringValue $deferralSubaccount
     * @param \StructType\StringValue $description
     * @param \StructType\DateTimeValue $effectiveDate
     * @param \StructType\StringValue $expenseAccount
     * @param \StructType\StringValue $expenseAccrualAccount
     * @param \StructType\StringValue $expenseAccrualSubaccount
     * @param \StructType\StringValue $expenseSubaccount
     * @param \StructType\StringValue $inventoryID
     * @param \StructType\BooleanValue $isKit
     * @param \StructType\StringValue $itemClass
     * @param \StructType\StringValue $itemStatus
     * @param \StructType\StringValue $itemType
     * @param \StructType\DecimalValue $lastCost
     * @param \StructType\DateTimeValue $lastModifiedDateTime
     * @param \StructType\DecimalValue $pendingCost
     * @param \StructType\DateTimeValue $pendingCostDate
     * @param \StructType\StringValue $pOAccrualAccount
     * @param \StructType\StringValue $pOAccrualSubaccount
     * @param \StructType\StringValue $postingClass
     * @param \StructType\StringValue $priceClass
     * @param \StructType\StringValue $purchasePriceVarianceAccount
     * @param \StructType\StringValue $purchasePriceVarianceSubaccount
     * @param \StructType\StringValue $purchaseUnit
     * @param \StructType\StringValue $reasonCodeSubaccount
     * @param \StructType\BooleanValue $requireReceipt
     * @param \StructType\BooleanValue $requireShipment
     * @param \StructType\StringValue $salesAccount
     * @param \StructType\SalesCategories $salesCategories
     * @param \StructType\StringValue $salesSubaccount
     * @param \StructType\StringValue $salesUnit
     * @param \StructType\StringValue $taxCategory
     * @param \StructType\VendorDetails $vendorDetails
     * @param \StructType\DecimalValue $volume
     * @param \StructType\StringValue $volumeUOM
     * @param \StructType\DecimalValue $weight
     * @param \StructType\StringValue $weightUOM
     */
    public function __construct(\StructType\Attributes $attributes = null, \StructType\StringValue $baseUnit = null, \StructType\CrossReferences $crossReferences = null, \StructType\DecimalValue $currentCost = null, \StructType\DecimalValue $defaultPrice = null, \StructType\StringValue $deferralAccount = null, \StructType\StringValue $deferralSubaccount = null, \StructType\StringValue $description = null, \StructType\DateTimeValue $effectiveDate = null, \StructType\StringValue $expenseAccount = null, \StructType\StringValue $expenseAccrualAccount = null, \StructType\StringValue $expenseAccrualSubaccount = null, \StructType\StringValue $expenseSubaccount = null, \StructType\StringValue $inventoryID = null, \StructType\BooleanValue $isKit = null, \StructType\StringValue $itemClass = null, \StructType\StringValue $itemStatus = null, \StructType\StringValue $itemType = null, \StructType\DecimalValue $lastCost = null, \StructType\DateTimeValue $lastModifiedDateTime = null, \StructType\DecimalValue $pendingCost = null, \StructType\DateTimeValue $pendingCostDate = null, \StructType\StringValue $pOAccrualAccount = null, \StructType\StringValue $pOAccrualSubaccount = null, \StructType\StringValue $postingClass = null, \StructType\StringValue $priceClass = null, \StructType\StringValue $purchasePriceVarianceAccount = null, \StructType\StringValue $purchasePriceVarianceSubaccount = null, \StructType\StringValue $purchaseUnit = null, \StructType\StringValue $reasonCodeSubaccount = null, \StructType\BooleanValue $requireReceipt = null, \StructType\BooleanValue $requireShipment = null, \StructType\StringValue $salesAccount = null, \StructType\SalesCategories $salesCategories = null, \StructType\StringValue $salesSubaccount = null, \StructType\StringValue $salesUnit = null, \StructType\StringValue $taxCategory = null, \StructType\VendorDetails $vendorDetails = null, \StructType\DecimalValue $volume = null, \StructType\StringValue $volumeUOM = null, \StructType\DecimalValue $weight = null, \StructType\StringValue $weightUOM = null)
    {
        $this
            ->setAttributes($attributes)
            ->setBaseUnit($baseUnit)
            ->setCrossReferences($crossReferences)
            ->setCurrentCost($currentCost)
            ->setDefaultPrice($defaultPrice)
            ->setDeferralAccount($deferralAccount)
            ->setDeferralSubaccount($deferralSubaccount)
            ->setDescription($description)
            ->setEffectiveDate($effectiveDate)
            ->setExpenseAccount($expenseAccount)
            ->setExpenseAccrualAccount($expenseAccrualAccount)
            ->setExpenseAccrualSubaccount($expenseAccrualSubaccount)
            ->setExpenseSubaccount($expenseSubaccount)
            ->setInventoryID($inventoryID)
            ->setIsKit($isKit)
            ->setItemClass($itemClass)
            ->setItemStatus($itemStatus)
            ->setItemType($itemType)
            ->setLastCost($lastCost)
            ->setLastModifiedDateTime($lastModifiedDateTime)
            ->setPendingCost($pendingCost)
            ->setPendingCostDate($pendingCostDate)
            ->setPOAccrualAccount($pOAccrualAccount)
            ->setPOAccrualSubaccount($pOAccrualSubaccount)
            ->setPostingClass($postingClass)
            ->setPriceClass($priceClass)
            ->setPurchasePriceVarianceAccount($purchasePriceVarianceAccount)
            ->setPurchasePriceVarianceSubaccount($purchasePriceVarianceSubaccount)
            ->setPurchaseUnit($purchaseUnit)
            ->setReasonCodeSubaccount($reasonCodeSubaccount)
            ->setRequireReceipt($requireReceipt)
            ->setRequireShipment($requireShipment)
            ->setSalesAccount($salesAccount)
            ->setSalesCategories($salesCategories)
            ->setSalesSubaccount($salesSubaccount)
            ->setSalesUnit($salesUnit)
            ->setTaxCategory($taxCategory)
            ->setVendorDetails($vendorDetails)
            ->setVolume($volume)
            ->setVolumeUOM($volumeUOM)
            ->setWeight($weight)
            ->setWeightUOM($weightUOM);
    }
    /**
     * Get Attributes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Attributes|null
     */
    public function getAttributes()
    {
        return isset($this->Attributes) ? $this->Attributes : null;
    }
    /**
     * Set Attributes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Attributes $attributes
     * @return \StructType\NonStockItem
     */
    public function setAttributes(\StructType\Attributes $attributes = null)
    {
        if (is_null($attributes) || (is_array($attributes) && empty($attributes))) {
            unset($this->Attributes);
        } else {
            $this->Attributes = $attributes;
        }
        return $this;
    }
    /**
     * Get BaseUnit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getBaseUnit()
    {
        return isset($this->BaseUnit) ? $this->BaseUnit : null;
    }
    /**
     * Set BaseUnit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $baseUnit
     * @return \StructType\NonStockItem
     */
    public function setBaseUnit(\StructType\StringValue $baseUnit = null)
    {
        if (is_null($baseUnit) || (is_array($baseUnit) && empty($baseUnit))) {
            unset($this->BaseUnit);
        } else {
            $this->BaseUnit = $baseUnit;
        }
        return $this;
    }
    /**
     * Get CrossReferences value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CrossReferences|null
     */
    public function getCrossReferences()
    {
        return isset($this->CrossReferences) ? $this->CrossReferences : null;
    }
    /**
     * Set CrossReferences value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CrossReferences $crossReferences
     * @return \StructType\NonStockItem
     */
    public function setCrossReferences(\StructType\CrossReferences $crossReferences = null)
    {
        if (is_null($crossReferences) || (is_array($crossReferences) && empty($crossReferences))) {
            unset($this->CrossReferences);
        } else {
            $this->CrossReferences = $crossReferences;
        }
        return $this;
    }
    /**
     * Get CurrentCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getCurrentCost()
    {
        return isset($this->CurrentCost) ? $this->CurrentCost : null;
    }
    /**
     * Set CurrentCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $currentCost
     * @return \StructType\NonStockItem
     */
    public function setCurrentCost(\StructType\DecimalValue $currentCost = null)
    {
        if (is_null($currentCost) || (is_array($currentCost) && empty($currentCost))) {
            unset($this->CurrentCost);
        } else {
            $this->CurrentCost = $currentCost;
        }
        return $this;
    }
    /**
     * Get DefaultPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getDefaultPrice()
    {
        return isset($this->DefaultPrice) ? $this->DefaultPrice : null;
    }
    /**
     * Set DefaultPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $defaultPrice
     * @return \StructType\NonStockItem
     */
    public function setDefaultPrice(\StructType\DecimalValue $defaultPrice = null)
    {
        if (is_null($defaultPrice) || (is_array($defaultPrice) && empty($defaultPrice))) {
            unset($this->DefaultPrice);
        } else {
            $this->DefaultPrice = $defaultPrice;
        }
        return $this;
    }
    /**
     * Get DeferralAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDeferralAccount()
    {
        return isset($this->DeferralAccount) ? $this->DeferralAccount : null;
    }
    /**
     * Set DeferralAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $deferralAccount
     * @return \StructType\NonStockItem
     */
    public function setDeferralAccount(\StructType\StringValue $deferralAccount = null)
    {
        if (is_null($deferralAccount) || (is_array($deferralAccount) && empty($deferralAccount))) {
            unset($this->DeferralAccount);
        } else {
            $this->DeferralAccount = $deferralAccount;
        }
        return $this;
    }
    /**
     * Get DeferralSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDeferralSubaccount()
    {
        return isset($this->DeferralSubaccount) ? $this->DeferralSubaccount : null;
    }
    /**
     * Set DeferralSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $deferralSubaccount
     * @return \StructType\NonStockItem
     */
    public function setDeferralSubaccount(\StructType\StringValue $deferralSubaccount = null)
    {
        if (is_null($deferralSubaccount) || (is_array($deferralSubaccount) && empty($deferralSubaccount))) {
            unset($this->DeferralSubaccount);
        } else {
            $this->DeferralSubaccount = $deferralSubaccount;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $description
     * @return \StructType\NonStockItem
     */
    public function setDescription(\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get EffectiveDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getEffectiveDate()
    {
        return isset($this->EffectiveDate) ? $this->EffectiveDate : null;
    }
    /**
     * Set EffectiveDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $effectiveDate
     * @return \StructType\NonStockItem
     */
    public function setEffectiveDate(\StructType\DateTimeValue $effectiveDate = null)
    {
        if (is_null($effectiveDate) || (is_array($effectiveDate) && empty($effectiveDate))) {
            unset($this->EffectiveDate);
        } else {
            $this->EffectiveDate = $effectiveDate;
        }
        return $this;
    }
    /**
     * Get ExpenseAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getExpenseAccount()
    {
        return isset($this->ExpenseAccount) ? $this->ExpenseAccount : null;
    }
    /**
     * Set ExpenseAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $expenseAccount
     * @return \StructType\NonStockItem
     */
    public function setExpenseAccount(\StructType\StringValue $expenseAccount = null)
    {
        if (is_null($expenseAccount) || (is_array($expenseAccount) && empty($expenseAccount))) {
            unset($this->ExpenseAccount);
        } else {
            $this->ExpenseAccount = $expenseAccount;
        }
        return $this;
    }
    /**
     * Get ExpenseAccrualAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getExpenseAccrualAccount()
    {
        return isset($this->ExpenseAccrualAccount) ? $this->ExpenseAccrualAccount : null;
    }
    /**
     * Set ExpenseAccrualAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $expenseAccrualAccount
     * @return \StructType\NonStockItem
     */
    public function setExpenseAccrualAccount(\StructType\StringValue $expenseAccrualAccount = null)
    {
        if (is_null($expenseAccrualAccount) || (is_array($expenseAccrualAccount) && empty($expenseAccrualAccount))) {
            unset($this->ExpenseAccrualAccount);
        } else {
            $this->ExpenseAccrualAccount = $expenseAccrualAccount;
        }
        return $this;
    }
    /**
     * Get ExpenseAccrualSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getExpenseAccrualSubaccount()
    {
        return isset($this->ExpenseAccrualSubaccount) ? $this->ExpenseAccrualSubaccount : null;
    }
    /**
     * Set ExpenseAccrualSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $expenseAccrualSubaccount
     * @return \StructType\NonStockItem
     */
    public function setExpenseAccrualSubaccount(\StructType\StringValue $expenseAccrualSubaccount = null)
    {
        if (is_null($expenseAccrualSubaccount) || (is_array($expenseAccrualSubaccount) && empty($expenseAccrualSubaccount))) {
            unset($this->ExpenseAccrualSubaccount);
        } else {
            $this->ExpenseAccrualSubaccount = $expenseAccrualSubaccount;
        }
        return $this;
    }
    /**
     * Get ExpenseSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getExpenseSubaccount()
    {
        return isset($this->ExpenseSubaccount) ? $this->ExpenseSubaccount : null;
    }
    /**
     * Set ExpenseSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $expenseSubaccount
     * @return \StructType\NonStockItem
     */
    public function setExpenseSubaccount(\StructType\StringValue $expenseSubaccount = null)
    {
        if (is_null($expenseSubaccount) || (is_array($expenseSubaccount) && empty($expenseSubaccount))) {
            unset($this->ExpenseSubaccount);
        } else {
            $this->ExpenseSubaccount = $expenseSubaccount;
        }
        return $this;
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $inventoryID
     * @return \StructType\NonStockItem
     */
    public function setInventoryID(\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get IsKit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getIsKit()
    {
        return isset($this->IsKit) ? $this->IsKit : null;
    }
    /**
     * Set IsKit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $isKit
     * @return \StructType\NonStockItem
     */
    public function setIsKit(\StructType\BooleanValue $isKit = null)
    {
        if (is_null($isKit) || (is_array($isKit) && empty($isKit))) {
            unset($this->IsKit);
        } else {
            $this->IsKit = $isKit;
        }
        return $this;
    }
    /**
     * Get ItemClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getItemClass()
    {
        return isset($this->ItemClass) ? $this->ItemClass : null;
    }
    /**
     * Set ItemClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $itemClass
     * @return \StructType\NonStockItem
     */
    public function setItemClass(\StructType\StringValue $itemClass = null)
    {
        if (is_null($itemClass) || (is_array($itemClass) && empty($itemClass))) {
            unset($this->ItemClass);
        } else {
            $this->ItemClass = $itemClass;
        }
        return $this;
    }
    /**
     * Get ItemStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getItemStatus()
    {
        return isset($this->ItemStatus) ? $this->ItemStatus : null;
    }
    /**
     * Set ItemStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $itemStatus
     * @return \StructType\NonStockItem
     */
    public function setItemStatus(\StructType\StringValue $itemStatus = null)
    {
        if (is_null($itemStatus) || (is_array($itemStatus) && empty($itemStatus))) {
            unset($this->ItemStatus);
        } else {
            $this->ItemStatus = $itemStatus;
        }
        return $this;
    }
    /**
     * Get ItemType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getItemType()
    {
        return isset($this->ItemType) ? $this->ItemType : null;
    }
    /**
     * Set ItemType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $itemType
     * @return \StructType\NonStockItem
     */
    public function setItemType(\StructType\StringValue $itemType = null)
    {
        if (is_null($itemType) || (is_array($itemType) && empty($itemType))) {
            unset($this->ItemType);
        } else {
            $this->ItemType = $itemType;
        }
        return $this;
    }
    /**
     * Get LastCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getLastCost()
    {
        return isset($this->LastCost) ? $this->LastCost : null;
    }
    /**
     * Set LastCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $lastCost
     * @return \StructType\NonStockItem
     */
    public function setLastCost(\StructType\DecimalValue $lastCost = null)
    {
        if (is_null($lastCost) || (is_array($lastCost) && empty($lastCost))) {
            unset($this->LastCost);
        } else {
            $this->LastCost = $lastCost;
        }
        return $this;
    }
    /**
     * Get LastModifiedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getLastModifiedDateTime()
    {
        return isset($this->LastModifiedDateTime) ? $this->LastModifiedDateTime : null;
    }
    /**
     * Set LastModifiedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $lastModifiedDateTime
     * @return \StructType\NonStockItem
     */
    public function setLastModifiedDateTime(\StructType\DateTimeValue $lastModifiedDateTime = null)
    {
        if (is_null($lastModifiedDateTime) || (is_array($lastModifiedDateTime) && empty($lastModifiedDateTime))) {
            unset($this->LastModifiedDateTime);
        } else {
            $this->LastModifiedDateTime = $lastModifiedDateTime;
        }
        return $this;
    }
    /**
     * Get PendingCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getPendingCost()
    {
        return isset($this->PendingCost) ? $this->PendingCost : null;
    }
    /**
     * Set PendingCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $pendingCost
     * @return \StructType\NonStockItem
     */
    public function setPendingCost(\StructType\DecimalValue $pendingCost = null)
    {
        if (is_null($pendingCost) || (is_array($pendingCost) && empty($pendingCost))) {
            unset($this->PendingCost);
        } else {
            $this->PendingCost = $pendingCost;
        }
        return $this;
    }
    /**
     * Get PendingCostDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getPendingCostDate()
    {
        return isset($this->PendingCostDate) ? $this->PendingCostDate : null;
    }
    /**
     * Set PendingCostDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $pendingCostDate
     * @return \StructType\NonStockItem
     */
    public function setPendingCostDate(\StructType\DateTimeValue $pendingCostDate = null)
    {
        if (is_null($pendingCostDate) || (is_array($pendingCostDate) && empty($pendingCostDate))) {
            unset($this->PendingCostDate);
        } else {
            $this->PendingCostDate = $pendingCostDate;
        }
        return $this;
    }
    /**
     * Get POAccrualAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getPOAccrualAccount()
    {
        return isset($this->POAccrualAccount) ? $this->POAccrualAccount : null;
    }
    /**
     * Set POAccrualAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $pOAccrualAccount
     * @return \StructType\NonStockItem
     */
    public function setPOAccrualAccount(\StructType\StringValue $pOAccrualAccount = null)
    {
        if (is_null($pOAccrualAccount) || (is_array($pOAccrualAccount) && empty($pOAccrualAccount))) {
            unset($this->POAccrualAccount);
        } else {
            $this->POAccrualAccount = $pOAccrualAccount;
        }
        return $this;
    }
    /**
     * Get POAccrualSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getPOAccrualSubaccount()
    {
        return isset($this->POAccrualSubaccount) ? $this->POAccrualSubaccount : null;
    }
    /**
     * Set POAccrualSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $pOAccrualSubaccount
     * @return \StructType\NonStockItem
     */
    public function setPOAccrualSubaccount(\StructType\StringValue $pOAccrualSubaccount = null)
    {
        if (is_null($pOAccrualSubaccount) || (is_array($pOAccrualSubaccount) && empty($pOAccrualSubaccount))) {
            unset($this->POAccrualSubaccount);
        } else {
            $this->POAccrualSubaccount = $pOAccrualSubaccount;
        }
        return $this;
    }
    /**
     * Get PostingClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getPostingClass()
    {
        return isset($this->PostingClass) ? $this->PostingClass : null;
    }
    /**
     * Set PostingClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $postingClass
     * @return \StructType\NonStockItem
     */
    public function setPostingClass(\StructType\StringValue $postingClass = null)
    {
        if (is_null($postingClass) || (is_array($postingClass) && empty($postingClass))) {
            unset($this->PostingClass);
        } else {
            $this->PostingClass = $postingClass;
        }
        return $this;
    }
    /**
     * Get PriceClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getPriceClass()
    {
        return isset($this->PriceClass) ? $this->PriceClass : null;
    }
    /**
     * Set PriceClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $priceClass
     * @return \StructType\NonStockItem
     */
    public function setPriceClass(\StructType\StringValue $priceClass = null)
    {
        if (is_null($priceClass) || (is_array($priceClass) && empty($priceClass))) {
            unset($this->PriceClass);
        } else {
            $this->PriceClass = $priceClass;
        }
        return $this;
    }
    /**
     * Get PurchasePriceVarianceAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getPurchasePriceVarianceAccount()
    {
        return isset($this->PurchasePriceVarianceAccount) ? $this->PurchasePriceVarianceAccount : null;
    }
    /**
     * Set PurchasePriceVarianceAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $purchasePriceVarianceAccount
     * @return \StructType\NonStockItem
     */
    public function setPurchasePriceVarianceAccount(\StructType\StringValue $purchasePriceVarianceAccount = null)
    {
        if (is_null($purchasePriceVarianceAccount) || (is_array($purchasePriceVarianceAccount) && empty($purchasePriceVarianceAccount))) {
            unset($this->PurchasePriceVarianceAccount);
        } else {
            $this->PurchasePriceVarianceAccount = $purchasePriceVarianceAccount;
        }
        return $this;
    }
    /**
     * Get PurchasePriceVarianceSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getPurchasePriceVarianceSubaccount()
    {
        return isset($this->PurchasePriceVarianceSubaccount) ? $this->PurchasePriceVarianceSubaccount : null;
    }
    /**
     * Set PurchasePriceVarianceSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $purchasePriceVarianceSubaccount
     * @return \StructType\NonStockItem
     */
    public function setPurchasePriceVarianceSubaccount(\StructType\StringValue $purchasePriceVarianceSubaccount = null)
    {
        if (is_null($purchasePriceVarianceSubaccount) || (is_array($purchasePriceVarianceSubaccount) && empty($purchasePriceVarianceSubaccount))) {
            unset($this->PurchasePriceVarianceSubaccount);
        } else {
            $this->PurchasePriceVarianceSubaccount = $purchasePriceVarianceSubaccount;
        }
        return $this;
    }
    /**
     * Get PurchaseUnit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getPurchaseUnit()
    {
        return isset($this->PurchaseUnit) ? $this->PurchaseUnit : null;
    }
    /**
     * Set PurchaseUnit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $purchaseUnit
     * @return \StructType\NonStockItem
     */
    public function setPurchaseUnit(\StructType\StringValue $purchaseUnit = null)
    {
        if (is_null($purchaseUnit) || (is_array($purchaseUnit) && empty($purchaseUnit))) {
            unset($this->PurchaseUnit);
        } else {
            $this->PurchaseUnit = $purchaseUnit;
        }
        return $this;
    }
    /**
     * Get ReasonCodeSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getReasonCodeSubaccount()
    {
        return isset($this->ReasonCodeSubaccount) ? $this->ReasonCodeSubaccount : null;
    }
    /**
     * Set ReasonCodeSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $reasonCodeSubaccount
     * @return \StructType\NonStockItem
     */
    public function setReasonCodeSubaccount(\StructType\StringValue $reasonCodeSubaccount = null)
    {
        if (is_null($reasonCodeSubaccount) || (is_array($reasonCodeSubaccount) && empty($reasonCodeSubaccount))) {
            unset($this->ReasonCodeSubaccount);
        } else {
            $this->ReasonCodeSubaccount = $reasonCodeSubaccount;
        }
        return $this;
    }
    /**
     * Get RequireReceipt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getRequireReceipt()
    {
        return isset($this->RequireReceipt) ? $this->RequireReceipt : null;
    }
    /**
     * Set RequireReceipt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $requireReceipt
     * @return \StructType\NonStockItem
     */
    public function setRequireReceipt(\StructType\BooleanValue $requireReceipt = null)
    {
        if (is_null($requireReceipt) || (is_array($requireReceipt) && empty($requireReceipt))) {
            unset($this->RequireReceipt);
        } else {
            $this->RequireReceipt = $requireReceipt;
        }
        return $this;
    }
    /**
     * Get RequireShipment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getRequireShipment()
    {
        return isset($this->RequireShipment) ? $this->RequireShipment : null;
    }
    /**
     * Set RequireShipment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $requireShipment
     * @return \StructType\NonStockItem
     */
    public function setRequireShipment(\StructType\BooleanValue $requireShipment = null)
    {
        if (is_null($requireShipment) || (is_array($requireShipment) && empty($requireShipment))) {
            unset($this->RequireShipment);
        } else {
            $this->RequireShipment = $requireShipment;
        }
        return $this;
    }
    /**
     * Get SalesAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getSalesAccount()
    {
        return isset($this->SalesAccount) ? $this->SalesAccount : null;
    }
    /**
     * Set SalesAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $salesAccount
     * @return \StructType\NonStockItem
     */
    public function setSalesAccount(\StructType\StringValue $salesAccount = null)
    {
        if (is_null($salesAccount) || (is_array($salesAccount) && empty($salesAccount))) {
            unset($this->SalesAccount);
        } else {
            $this->SalesAccount = $salesAccount;
        }
        return $this;
    }
    /**
     * Get SalesCategories value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SalesCategories|null
     */
    public function getSalesCategories()
    {
        return isset($this->SalesCategories) ? $this->SalesCategories : null;
    }
    /**
     * Set SalesCategories value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\SalesCategories $salesCategories
     * @return \StructType\NonStockItem
     */
    public function setSalesCategories(\StructType\SalesCategories $salesCategories = null)
    {
        if (is_null($salesCategories) || (is_array($salesCategories) && empty($salesCategories))) {
            unset($this->SalesCategories);
        } else {
            $this->SalesCategories = $salesCategories;
        }
        return $this;
    }
    /**
     * Get SalesSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getSalesSubaccount()
    {
        return isset($this->SalesSubaccount) ? $this->SalesSubaccount : null;
    }
    /**
     * Set SalesSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $salesSubaccount
     * @return \StructType\NonStockItem
     */
    public function setSalesSubaccount(\StructType\StringValue $salesSubaccount = null)
    {
        if (is_null($salesSubaccount) || (is_array($salesSubaccount) && empty($salesSubaccount))) {
            unset($this->SalesSubaccount);
        } else {
            $this->SalesSubaccount = $salesSubaccount;
        }
        return $this;
    }
    /**
     * Get SalesUnit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getSalesUnit()
    {
        return isset($this->SalesUnit) ? $this->SalesUnit : null;
    }
    /**
     * Set SalesUnit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $salesUnit
     * @return \StructType\NonStockItem
     */
    public function setSalesUnit(\StructType\StringValue $salesUnit = null)
    {
        if (is_null($salesUnit) || (is_array($salesUnit) && empty($salesUnit))) {
            unset($this->SalesUnit);
        } else {
            $this->SalesUnit = $salesUnit;
        }
        return $this;
    }
    /**
     * Get TaxCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getTaxCategory()
    {
        return isset($this->TaxCategory) ? $this->TaxCategory : null;
    }
    /**
     * Set TaxCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $taxCategory
     * @return \StructType\NonStockItem
     */
    public function setTaxCategory(\StructType\StringValue $taxCategory = null)
    {
        if (is_null($taxCategory) || (is_array($taxCategory) && empty($taxCategory))) {
            unset($this->TaxCategory);
        } else {
            $this->TaxCategory = $taxCategory;
        }
        return $this;
    }
    /**
     * Get VendorDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\VendorDetails|null
     */
    public function getVendorDetails()
    {
        return isset($this->VendorDetails) ? $this->VendorDetails : null;
    }
    /**
     * Set VendorDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\VendorDetails $vendorDetails
     * @return \StructType\NonStockItem
     */
    public function setVendorDetails(\StructType\VendorDetails $vendorDetails = null)
    {
        if (is_null($vendorDetails) || (is_array($vendorDetails) && empty($vendorDetails))) {
            unset($this->VendorDetails);
        } else {
            $this->VendorDetails = $vendorDetails;
        }
        return $this;
    }
    /**
     * Get Volume value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getVolume()
    {
        return isset($this->Volume) ? $this->Volume : null;
    }
    /**
     * Set Volume value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $volume
     * @return \StructType\NonStockItem
     */
    public function setVolume(\StructType\DecimalValue $volume = null)
    {
        if (is_null($volume) || (is_array($volume) && empty($volume))) {
            unset($this->Volume);
        } else {
            $this->Volume = $volume;
        }
        return $this;
    }
    /**
     * Get VolumeUOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getVolumeUOM()
    {
        return isset($this->VolumeUOM) ? $this->VolumeUOM : null;
    }
    /**
     * Set VolumeUOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $volumeUOM
     * @return \StructType\NonStockItem
     */
    public function setVolumeUOM(\StructType\StringValue $volumeUOM = null)
    {
        if (is_null($volumeUOM) || (is_array($volumeUOM) && empty($volumeUOM))) {
            unset($this->VolumeUOM);
        } else {
            $this->VolumeUOM = $volumeUOM;
        }
        return $this;
    }
    /**
     * Get Weight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getWeight()
    {
        return isset($this->Weight) ? $this->Weight : null;
    }
    /**
     * Set Weight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $weight
     * @return \StructType\NonStockItem
     */
    public function setWeight(\StructType\DecimalValue $weight = null)
    {
        if (is_null($weight) || (is_array($weight) && empty($weight))) {
            unset($this->Weight);
        } else {
            $this->Weight = $weight;
        }
        return $this;
    }
    /**
     * Get WeightUOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getWeightUOM()
    {
        return isset($this->WeightUOM) ? $this->WeightUOM : null;
    }
    /**
     * Set WeightUOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $weightUOM
     * @return \StructType\NonStockItem
     */
    public function setWeightUOM(\StructType\StringValue $weightUOM = null)
    {
        if (is_null($weightUOM) || (is_array($weightUOM) && empty($weightUOM))) {
            unset($this->WeightUOM);
        } else {
            $this->WeightUOM = $weightUOM;
        }
        return $this;
    }
}
