<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KitStockComponent StructType
 * @subpackage Structs
 */
class KitStockComponent extends Entity
{
    /**
     * The AllowComponentQtyVariance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $AllowComponentQtyVariance;
    /**
     * The ComponentQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $ComponentQty;
    /**
     * The MaxComponentQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $MaxComponentQty;
    /**
     * The MinComponentQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $MinComponentQty;
    /**
     * The StockInventoryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $StockInventoryID;
    /**
     * The Subitem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Subitem;
    /**
     * The UOM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $UOM;
    /**
     * Constructor method for KitStockComponent
     * @uses KitStockComponent::setAllowComponentQtyVariance()
     * @uses KitStockComponent::setComponentQty()
     * @uses KitStockComponent::setMaxComponentQty()
     * @uses KitStockComponent::setMinComponentQty()
     * @uses KitStockComponent::setStockInventoryID()
     * @uses KitStockComponent::setSubitem()
     * @uses KitStockComponent::setUOM()
     * @param \StructType\BooleanValue $allowComponentQtyVariance
     * @param \StructType\DecimalValue $componentQty
     * @param \StructType\DecimalValue $maxComponentQty
     * @param \StructType\DecimalValue $minComponentQty
     * @param \StructType\StringValue $stockInventoryID
     * @param \StructType\StringValue $subitem
     * @param \StructType\StringValue $uOM
     */
    public function __construct(\StructType\BooleanValue $allowComponentQtyVariance = null, \StructType\DecimalValue $componentQty = null, \StructType\DecimalValue $maxComponentQty = null, \StructType\DecimalValue $minComponentQty = null, \StructType\StringValue $stockInventoryID = null, \StructType\StringValue $subitem = null, \StructType\StringValue $uOM = null)
    {
        $this
            ->setAllowComponentQtyVariance($allowComponentQtyVariance)
            ->setComponentQty($componentQty)
            ->setMaxComponentQty($maxComponentQty)
            ->setMinComponentQty($minComponentQty)
            ->setStockInventoryID($stockInventoryID)
            ->setSubitem($subitem)
            ->setUOM($uOM);
    }
    /**
     * Get AllowComponentQtyVariance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getAllowComponentQtyVariance()
    {
        return isset($this->AllowComponentQtyVariance) ? $this->AllowComponentQtyVariance : null;
    }
    /**
     * Set AllowComponentQtyVariance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $allowComponentQtyVariance
     * @return \StructType\KitStockComponent
     */
    public function setAllowComponentQtyVariance(\StructType\BooleanValue $allowComponentQtyVariance = null)
    {
        if (is_null($allowComponentQtyVariance) || (is_array($allowComponentQtyVariance) && empty($allowComponentQtyVariance))) {
            unset($this->AllowComponentQtyVariance);
        } else {
            $this->AllowComponentQtyVariance = $allowComponentQtyVariance;
        }
        return $this;
    }
    /**
     * Get ComponentQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getComponentQty()
    {
        return isset($this->ComponentQty) ? $this->ComponentQty : null;
    }
    /**
     * Set ComponentQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $componentQty
     * @return \StructType\KitStockComponent
     */
    public function setComponentQty(\StructType\DecimalValue $componentQty = null)
    {
        if (is_null($componentQty) || (is_array($componentQty) && empty($componentQty))) {
            unset($this->ComponentQty);
        } else {
            $this->ComponentQty = $componentQty;
        }
        return $this;
    }
    /**
     * Get MaxComponentQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getMaxComponentQty()
    {
        return isset($this->MaxComponentQty) ? $this->MaxComponentQty : null;
    }
    /**
     * Set MaxComponentQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $maxComponentQty
     * @return \StructType\KitStockComponent
     */
    public function setMaxComponentQty(\StructType\DecimalValue $maxComponentQty = null)
    {
        if (is_null($maxComponentQty) || (is_array($maxComponentQty) && empty($maxComponentQty))) {
            unset($this->MaxComponentQty);
        } else {
            $this->MaxComponentQty = $maxComponentQty;
        }
        return $this;
    }
    /**
     * Get MinComponentQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getMinComponentQty()
    {
        return isset($this->MinComponentQty) ? $this->MinComponentQty : null;
    }
    /**
     * Set MinComponentQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $minComponentQty
     * @return \StructType\KitStockComponent
     */
    public function setMinComponentQty(\StructType\DecimalValue $minComponentQty = null)
    {
        if (is_null($minComponentQty) || (is_array($minComponentQty) && empty($minComponentQty))) {
            unset($this->MinComponentQty);
        } else {
            $this->MinComponentQty = $minComponentQty;
        }
        return $this;
    }
    /**
     * Get StockInventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getStockInventoryID()
    {
        return isset($this->StockInventoryID) ? $this->StockInventoryID : null;
    }
    /**
     * Set StockInventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $stockInventoryID
     * @return \StructType\KitStockComponent
     */
    public function setStockInventoryID(\StructType\StringValue $stockInventoryID = null)
    {
        if (is_null($stockInventoryID) || (is_array($stockInventoryID) && empty($stockInventoryID))) {
            unset($this->StockInventoryID);
        } else {
            $this->StockInventoryID = $stockInventoryID;
        }
        return $this;
    }
    /**
     * Get Subitem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getSubitem()
    {
        return isset($this->Subitem) ? $this->Subitem : null;
    }
    /**
     * Set Subitem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $subitem
     * @return \StructType\KitStockComponent
     */
    public function setSubitem(\StructType\StringValue $subitem = null)
    {
        if (is_null($subitem) || (is_array($subitem) && empty($subitem))) {
            unset($this->Subitem);
        } else {
            $this->Subitem = $subitem;
        }
        return $this;
    }
    /**
     * Get UOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getUOM()
    {
        return isset($this->UOM) ? $this->UOM : null;
    }
    /**
     * Set UOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $uOM
     * @return \StructType\KitStockComponent
     */
    public function setUOM(\StructType\StringValue $uOM = null)
    {
        if (is_null($uOM) || (is_array($uOM) && empty($uOM))) {
            unset($this->UOM);
        } else {
            $this->UOM = $uOM;
        }
        return $this;
    }
}
