<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExpenseReceipt StructType
 * @subpackage Structs
 */
class ExpenseReceipt extends Entity
{
    /**
     * The Branch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Branch;
    /**
     * The ClaimAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $ClaimAmount;
    /**
     * The ClaimedBy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ClaimedBy;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $Date;
    /**
     * The ExpenseItemID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ExpenseItemID;
    /**
     * The LastModifiedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $LastModifiedDateTime;
    /**
     * The ReceiptDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ExpenseReceiptDetails
     */
    public $ReceiptDetails;
    /**
     * The ReceiptID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IntValue
     */
    public $ReceiptID;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Status;
    /**
     * The TaxDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TaxDetails
     */
    public $TaxDetails;
    /**
     * The TaxTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $TaxTotal;
    /**
     * Constructor method for ExpenseReceipt
     * @uses ExpenseReceipt::setBranch()
     * @uses ExpenseReceipt::setClaimAmount()
     * @uses ExpenseReceipt::setClaimedBy()
     * @uses ExpenseReceipt::setDate()
     * @uses ExpenseReceipt::setExpenseItemID()
     * @uses ExpenseReceipt::setLastModifiedDateTime()
     * @uses ExpenseReceipt::setReceiptDetails()
     * @uses ExpenseReceipt::setReceiptID()
     * @uses ExpenseReceipt::setStatus()
     * @uses ExpenseReceipt::setTaxDetails()
     * @uses ExpenseReceipt::setTaxTotal()
     * @param \StructType\StringValue $branch
     * @param \StructType\DecimalValue $claimAmount
     * @param \StructType\StringValue $claimedBy
     * @param \StructType\DateTimeValue $date
     * @param \StructType\StringValue $expenseItemID
     * @param \StructType\DateTimeValue $lastModifiedDateTime
     * @param \StructType\ExpenseReceiptDetails $receiptDetails
     * @param \StructType\IntValue $receiptID
     * @param \StructType\StringValue $status
     * @param \StructType\TaxDetails $taxDetails
     * @param \StructType\DecimalValue $taxTotal
     */
    public function __construct(\StructType\StringValue $branch = null, \StructType\DecimalValue $claimAmount = null, \StructType\StringValue $claimedBy = null, \StructType\DateTimeValue $date = null, \StructType\StringValue $expenseItemID = null, \StructType\DateTimeValue $lastModifiedDateTime = null, \StructType\ExpenseReceiptDetails $receiptDetails = null, \StructType\IntValue $receiptID = null, \StructType\StringValue $status = null, \StructType\TaxDetails $taxDetails = null, \StructType\DecimalValue $taxTotal = null)
    {
        $this
            ->setBranch($branch)
            ->setClaimAmount($claimAmount)
            ->setClaimedBy($claimedBy)
            ->setDate($date)
            ->setExpenseItemID($expenseItemID)
            ->setLastModifiedDateTime($lastModifiedDateTime)
            ->setReceiptDetails($receiptDetails)
            ->setReceiptID($receiptID)
            ->setStatus($status)
            ->setTaxDetails($taxDetails)
            ->setTaxTotal($taxTotal);
    }
    /**
     * Get Branch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getBranch()
    {
        return isset($this->Branch) ? $this->Branch : null;
    }
    /**
     * Set Branch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $branch
     * @return \StructType\ExpenseReceipt
     */
    public function setBranch(\StructType\StringValue $branch = null)
    {
        if (is_null($branch) || (is_array($branch) && empty($branch))) {
            unset($this->Branch);
        } else {
            $this->Branch = $branch;
        }
        return $this;
    }
    /**
     * Get ClaimAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getClaimAmount()
    {
        return isset($this->ClaimAmount) ? $this->ClaimAmount : null;
    }
    /**
     * Set ClaimAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $claimAmount
     * @return \StructType\ExpenseReceipt
     */
    public function setClaimAmount(\StructType\DecimalValue $claimAmount = null)
    {
        if (is_null($claimAmount) || (is_array($claimAmount) && empty($claimAmount))) {
            unset($this->ClaimAmount);
        } else {
            $this->ClaimAmount = $claimAmount;
        }
        return $this;
    }
    /**
     * Get ClaimedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getClaimedBy()
    {
        return isset($this->ClaimedBy) ? $this->ClaimedBy : null;
    }
    /**
     * Set ClaimedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $claimedBy
     * @return \StructType\ExpenseReceipt
     */
    public function setClaimedBy(\StructType\StringValue $claimedBy = null)
    {
        if (is_null($claimedBy) || (is_array($claimedBy) && empty($claimedBy))) {
            unset($this->ClaimedBy);
        } else {
            $this->ClaimedBy = $claimedBy;
        }
        return $this;
    }
    /**
     * Get Date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getDate()
    {
        return isset($this->Date) ? $this->Date : null;
    }
    /**
     * Set Date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $date
     * @return \StructType\ExpenseReceipt
     */
    public function setDate(\StructType\DateTimeValue $date = null)
    {
        if (is_null($date) || (is_array($date) && empty($date))) {
            unset($this->Date);
        } else {
            $this->Date = $date;
        }
        return $this;
    }
    /**
     * Get ExpenseItemID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getExpenseItemID()
    {
        return isset($this->ExpenseItemID) ? $this->ExpenseItemID : null;
    }
    /**
     * Set ExpenseItemID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $expenseItemID
     * @return \StructType\ExpenseReceipt
     */
    public function setExpenseItemID(\StructType\StringValue $expenseItemID = null)
    {
        if (is_null($expenseItemID) || (is_array($expenseItemID) && empty($expenseItemID))) {
            unset($this->ExpenseItemID);
        } else {
            $this->ExpenseItemID = $expenseItemID;
        }
        return $this;
    }
    /**
     * Get LastModifiedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getLastModifiedDateTime()
    {
        return isset($this->LastModifiedDateTime) ? $this->LastModifiedDateTime : null;
    }
    /**
     * Set LastModifiedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $lastModifiedDateTime
     * @return \StructType\ExpenseReceipt
     */
    public function setLastModifiedDateTime(\StructType\DateTimeValue $lastModifiedDateTime = null)
    {
        if (is_null($lastModifiedDateTime) || (is_array($lastModifiedDateTime) && empty($lastModifiedDateTime))) {
            unset($this->LastModifiedDateTime);
        } else {
            $this->LastModifiedDateTime = $lastModifiedDateTime;
        }
        return $this;
    }
    /**
     * Get ReceiptDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ExpenseReceiptDetails|null
     */
    public function getReceiptDetails()
    {
        return isset($this->ReceiptDetails) ? $this->ReceiptDetails : null;
    }
    /**
     * Set ReceiptDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ExpenseReceiptDetails $receiptDetails
     * @return \StructType\ExpenseReceipt
     */
    public function setReceiptDetails(\StructType\ExpenseReceiptDetails $receiptDetails = null)
    {
        if (is_null($receiptDetails) || (is_array($receiptDetails) && empty($receiptDetails))) {
            unset($this->ReceiptDetails);
        } else {
            $this->ReceiptDetails = $receiptDetails;
        }
        return $this;
    }
    /**
     * Get ReceiptID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IntValue|null
     */
    public function getReceiptID()
    {
        return isset($this->ReceiptID) ? $this->ReceiptID : null;
    }
    /**
     * Set ReceiptID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\IntValue $receiptID
     * @return \StructType\ExpenseReceipt
     */
    public function setReceiptID(\StructType\IntValue $receiptID = null)
    {
        if (is_null($receiptID) || (is_array($receiptID) && empty($receiptID))) {
            unset($this->ReceiptID);
        } else {
            $this->ReceiptID = $receiptID;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $status
     * @return \StructType\ExpenseReceipt
     */
    public function setStatus(\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TaxDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TaxDetails|null
     */
    public function getTaxDetails()
    {
        return isset($this->TaxDetails) ? $this->TaxDetails : null;
    }
    /**
     * Set TaxDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\TaxDetails $taxDetails
     * @return \StructType\ExpenseReceipt
     */
    public function setTaxDetails(\StructType\TaxDetails $taxDetails = null)
    {
        if (is_null($taxDetails) || (is_array($taxDetails) && empty($taxDetails))) {
            unset($this->TaxDetails);
        } else {
            $this->TaxDetails = $taxDetails;
        }
        return $this;
    }
    /**
     * Get TaxTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getTaxTotal()
    {
        return isset($this->TaxTotal) ? $this->TaxTotal : null;
    }
    /**
     * Set TaxTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $taxTotal
     * @return \StructType\ExpenseReceipt
     */
    public function setTaxTotal(\StructType\DecimalValue $taxTotal = null)
    {
        if (is_null($taxTotal) || (is_array($taxTotal) && empty($taxTotal))) {
            unset($this->TaxTotal);
        } else {
            $this->TaxTotal = $taxTotal;
        }
        return $this;
    }
}
