<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExpenseClaimDetails StructType
 * @subpackage Structs
 */
class ExpenseClaimDetails extends Entity
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $Amount;
    /**
     * The AmountInClaimCurrency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $AmountInClaimCurrency;
    /**
     * The APRefNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $APRefNbr;
    /**
     * The ARRefNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ARRefNbr;
    /**
     * The Billable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $Billable;
    /**
     * The Branch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Branch;
    /**
     * The ClaimAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $ClaimAmount;
    /**
     * The CostCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CostCode;
    /**
     * The CurrencyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CurrencyID;
    /**
     * The CustomerID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CustomerID;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $Date;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Description;
    /**
     * The EmployeePart
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $EmployeePart;
    /**
     * The ExpenseAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ExpenseAccount;
    /**
     * The ExpenseItemID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ExpenseItemID;
    /**
     * The ExpenseSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ExpenseSubaccount;
    /**
     * The LocationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $LocationID;
    /**
     * The NetAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $NetAmount;
    /**
     * The ProjectID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ProjectID;
    /**
     * The ProjectTaskID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ProjectTaskID;
    /**
     * The Qty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $Qty;
    /**
     * The RefNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $RefNbr;
    /**
     * The SalesAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $SalesAccount;
    /**
     * The SalesSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $SalesSubaccount;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Status;
    /**
     * The TaxAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $TaxAmount;
    /**
     * The TaxCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $TaxCategory;
    /**
     * The TaxZone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $TaxZone;
    /**
     * The TipAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $TipAmount;
    /**
     * The UnitCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $UnitCost;
    /**
     * The UOM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $UOM;
    /**
     * Constructor method for ExpenseClaimDetails
     * @uses ExpenseClaimDetails::setAmount()
     * @uses ExpenseClaimDetails::setAmountInClaimCurrency()
     * @uses ExpenseClaimDetails::setAPRefNbr()
     * @uses ExpenseClaimDetails::setARRefNbr()
     * @uses ExpenseClaimDetails::setBillable()
     * @uses ExpenseClaimDetails::setBranch()
     * @uses ExpenseClaimDetails::setClaimAmount()
     * @uses ExpenseClaimDetails::setCostCode()
     * @uses ExpenseClaimDetails::setCurrencyID()
     * @uses ExpenseClaimDetails::setCustomerID()
     * @uses ExpenseClaimDetails::setDate()
     * @uses ExpenseClaimDetails::setDescription()
     * @uses ExpenseClaimDetails::setEmployeePart()
     * @uses ExpenseClaimDetails::setExpenseAccount()
     * @uses ExpenseClaimDetails::setExpenseItemID()
     * @uses ExpenseClaimDetails::setExpenseSubaccount()
     * @uses ExpenseClaimDetails::setLocationID()
     * @uses ExpenseClaimDetails::setNetAmount()
     * @uses ExpenseClaimDetails::setProjectID()
     * @uses ExpenseClaimDetails::setProjectTaskID()
     * @uses ExpenseClaimDetails::setQty()
     * @uses ExpenseClaimDetails::setRefNbr()
     * @uses ExpenseClaimDetails::setSalesAccount()
     * @uses ExpenseClaimDetails::setSalesSubaccount()
     * @uses ExpenseClaimDetails::setStatus()
     * @uses ExpenseClaimDetails::setTaxAmount()
     * @uses ExpenseClaimDetails::setTaxCategory()
     * @uses ExpenseClaimDetails::setTaxZone()
     * @uses ExpenseClaimDetails::setTipAmount()
     * @uses ExpenseClaimDetails::setUnitCost()
     * @uses ExpenseClaimDetails::setUOM()
     * @param \StructType\DecimalValue $amount
     * @param \StructType\DecimalValue $amountInClaimCurrency
     * @param \StructType\StringValue $aPRefNbr
     * @param \StructType\StringValue $aRRefNbr
     * @param \StructType\BooleanValue $billable
     * @param \StructType\StringValue $branch
     * @param \StructType\DecimalValue $claimAmount
     * @param \StructType\StringValue $costCode
     * @param \StructType\StringValue $currencyID
     * @param \StructType\StringValue $customerID
     * @param \StructType\DateTimeValue $date
     * @param \StructType\StringValue $description
     * @param \StructType\DecimalValue $employeePart
     * @param \StructType\StringValue $expenseAccount
     * @param \StructType\StringValue $expenseItemID
     * @param \StructType\StringValue $expenseSubaccount
     * @param \StructType\StringValue $locationID
     * @param \StructType\DecimalValue $netAmount
     * @param \StructType\StringValue $projectID
     * @param \StructType\StringValue $projectTaskID
     * @param \StructType\DecimalValue $qty
     * @param \StructType\StringValue $refNbr
     * @param \StructType\StringValue $salesAccount
     * @param \StructType\StringValue $salesSubaccount
     * @param \StructType\StringValue $status
     * @param \StructType\DecimalValue $taxAmount
     * @param \StructType\StringValue $taxCategory
     * @param \StructType\StringValue $taxZone
     * @param \StructType\DecimalValue $tipAmount
     * @param \StructType\DecimalValue $unitCost
     * @param \StructType\StringValue $uOM
     */
    public function __construct(\StructType\DecimalValue $amount = null, \StructType\DecimalValue $amountInClaimCurrency = null, \StructType\StringValue $aPRefNbr = null, \StructType\StringValue $aRRefNbr = null, \StructType\BooleanValue $billable = null, \StructType\StringValue $branch = null, \StructType\DecimalValue $claimAmount = null, \StructType\StringValue $costCode = null, \StructType\StringValue $currencyID = null, \StructType\StringValue $customerID = null, \StructType\DateTimeValue $date = null, \StructType\StringValue $description = null, \StructType\DecimalValue $employeePart = null, \StructType\StringValue $expenseAccount = null, \StructType\StringValue $expenseItemID = null, \StructType\StringValue $expenseSubaccount = null, \StructType\StringValue $locationID = null, \StructType\DecimalValue $netAmount = null, \StructType\StringValue $projectID = null, \StructType\StringValue $projectTaskID = null, \StructType\DecimalValue $qty = null, \StructType\StringValue $refNbr = null, \StructType\StringValue $salesAccount = null, \StructType\StringValue $salesSubaccount = null, \StructType\StringValue $status = null, \StructType\DecimalValue $taxAmount = null, \StructType\StringValue $taxCategory = null, \StructType\StringValue $taxZone = null, \StructType\DecimalValue $tipAmount = null, \StructType\DecimalValue $unitCost = null, \StructType\StringValue $uOM = null)
    {
        $this
            ->setAmount($amount)
            ->setAmountInClaimCurrency($amountInClaimCurrency)
            ->setAPRefNbr($aPRefNbr)
            ->setARRefNbr($aRRefNbr)
            ->setBillable($billable)
            ->setBranch($branch)
            ->setClaimAmount($claimAmount)
            ->setCostCode($costCode)
            ->setCurrencyID($currencyID)
            ->setCustomerID($customerID)
            ->setDate($date)
            ->setDescription($description)
            ->setEmployeePart($employeePart)
            ->setExpenseAccount($expenseAccount)
            ->setExpenseItemID($expenseItemID)
            ->setExpenseSubaccount($expenseSubaccount)
            ->setLocationID($locationID)
            ->setNetAmount($netAmount)
            ->setProjectID($projectID)
            ->setProjectTaskID($projectTaskID)
            ->setQty($qty)
            ->setRefNbr($refNbr)
            ->setSalesAccount($salesAccount)
            ->setSalesSubaccount($salesSubaccount)
            ->setStatus($status)
            ->setTaxAmount($taxAmount)
            ->setTaxCategory($taxCategory)
            ->setTaxZone($taxZone)
            ->setTipAmount($tipAmount)
            ->setUnitCost($unitCost)
            ->setUOM($uOM);
    }
    /**
     * Get Amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * Set Amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $amount
     * @return \StructType\ExpenseClaimDetails
     */
    public function setAmount(\StructType\DecimalValue $amount = null)
    {
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get AmountInClaimCurrency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getAmountInClaimCurrency()
    {
        return isset($this->AmountInClaimCurrency) ? $this->AmountInClaimCurrency : null;
    }
    /**
     * Set AmountInClaimCurrency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $amountInClaimCurrency
     * @return \StructType\ExpenseClaimDetails
     */
    public function setAmountInClaimCurrency(\StructType\DecimalValue $amountInClaimCurrency = null)
    {
        if (is_null($amountInClaimCurrency) || (is_array($amountInClaimCurrency) && empty($amountInClaimCurrency))) {
            unset($this->AmountInClaimCurrency);
        } else {
            $this->AmountInClaimCurrency = $amountInClaimCurrency;
        }
        return $this;
    }
    /**
     * Get APRefNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getAPRefNbr()
    {
        return isset($this->APRefNbr) ? $this->APRefNbr : null;
    }
    /**
     * Set APRefNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $aPRefNbr
     * @return \StructType\ExpenseClaimDetails
     */
    public function setAPRefNbr(\StructType\StringValue $aPRefNbr = null)
    {
        if (is_null($aPRefNbr) || (is_array($aPRefNbr) && empty($aPRefNbr))) {
            unset($this->APRefNbr);
        } else {
            $this->APRefNbr = $aPRefNbr;
        }
        return $this;
    }
    /**
     * Get ARRefNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getARRefNbr()
    {
        return isset($this->ARRefNbr) ? $this->ARRefNbr : null;
    }
    /**
     * Set ARRefNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $aRRefNbr
     * @return \StructType\ExpenseClaimDetails
     */
    public function setARRefNbr(\StructType\StringValue $aRRefNbr = null)
    {
        if (is_null($aRRefNbr) || (is_array($aRRefNbr) && empty($aRRefNbr))) {
            unset($this->ARRefNbr);
        } else {
            $this->ARRefNbr = $aRRefNbr;
        }
        return $this;
    }
    /**
     * Get Billable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getBillable()
    {
        return isset($this->Billable) ? $this->Billable : null;
    }
    /**
     * Set Billable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $billable
     * @return \StructType\ExpenseClaimDetails
     */
    public function setBillable(\StructType\BooleanValue $billable = null)
    {
        if (is_null($billable) || (is_array($billable) && empty($billable))) {
            unset($this->Billable);
        } else {
            $this->Billable = $billable;
        }
        return $this;
    }
    /**
     * Get Branch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getBranch()
    {
        return isset($this->Branch) ? $this->Branch : null;
    }
    /**
     * Set Branch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $branch
     * @return \StructType\ExpenseClaimDetails
     */
    public function setBranch(\StructType\StringValue $branch = null)
    {
        if (is_null($branch) || (is_array($branch) && empty($branch))) {
            unset($this->Branch);
        } else {
            $this->Branch = $branch;
        }
        return $this;
    }
    /**
     * Get ClaimAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getClaimAmount()
    {
        return isset($this->ClaimAmount) ? $this->ClaimAmount : null;
    }
    /**
     * Set ClaimAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $claimAmount
     * @return \StructType\ExpenseClaimDetails
     */
    public function setClaimAmount(\StructType\DecimalValue $claimAmount = null)
    {
        if (is_null($claimAmount) || (is_array($claimAmount) && empty($claimAmount))) {
            unset($this->ClaimAmount);
        } else {
            $this->ClaimAmount = $claimAmount;
        }
        return $this;
    }
    /**
     * Get CostCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCostCode()
    {
        return isset($this->CostCode) ? $this->CostCode : null;
    }
    /**
     * Set CostCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $costCode
     * @return \StructType\ExpenseClaimDetails
     */
    public function setCostCode(\StructType\StringValue $costCode = null)
    {
        if (is_null($costCode) || (is_array($costCode) && empty($costCode))) {
            unset($this->CostCode);
        } else {
            $this->CostCode = $costCode;
        }
        return $this;
    }
    /**
     * Get CurrencyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCurrencyID()
    {
        return isset($this->CurrencyID) ? $this->CurrencyID : null;
    }
    /**
     * Set CurrencyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $currencyID
     * @return \StructType\ExpenseClaimDetails
     */
    public function setCurrencyID(\StructType\StringValue $currencyID = null)
    {
        if (is_null($currencyID) || (is_array($currencyID) && empty($currencyID))) {
            unset($this->CurrencyID);
        } else {
            $this->CurrencyID = $currencyID;
        }
        return $this;
    }
    /**
     * Get CustomerID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCustomerID()
    {
        return isset($this->CustomerID) ? $this->CustomerID : null;
    }
    /**
     * Set CustomerID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $customerID
     * @return \StructType\ExpenseClaimDetails
     */
    public function setCustomerID(\StructType\StringValue $customerID = null)
    {
        if (is_null($customerID) || (is_array($customerID) && empty($customerID))) {
            unset($this->CustomerID);
        } else {
            $this->CustomerID = $customerID;
        }
        return $this;
    }
    /**
     * Get Date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getDate()
    {
        return isset($this->Date) ? $this->Date : null;
    }
    /**
     * Set Date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $date
     * @return \StructType\ExpenseClaimDetails
     */
    public function setDate(\StructType\DateTimeValue $date = null)
    {
        if (is_null($date) || (is_array($date) && empty($date))) {
            unset($this->Date);
        } else {
            $this->Date = $date;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $description
     * @return \StructType\ExpenseClaimDetails
     */
    public function setDescription(\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get EmployeePart value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getEmployeePart()
    {
        return isset($this->EmployeePart) ? $this->EmployeePart : null;
    }
    /**
     * Set EmployeePart value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $employeePart
     * @return \StructType\ExpenseClaimDetails
     */
    public function setEmployeePart(\StructType\DecimalValue $employeePart = null)
    {
        if (is_null($employeePart) || (is_array($employeePart) && empty($employeePart))) {
            unset($this->EmployeePart);
        } else {
            $this->EmployeePart = $employeePart;
        }
        return $this;
    }
    /**
     * Get ExpenseAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getExpenseAccount()
    {
        return isset($this->ExpenseAccount) ? $this->ExpenseAccount : null;
    }
    /**
     * Set ExpenseAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $expenseAccount
     * @return \StructType\ExpenseClaimDetails
     */
    public function setExpenseAccount(\StructType\StringValue $expenseAccount = null)
    {
        if (is_null($expenseAccount) || (is_array($expenseAccount) && empty($expenseAccount))) {
            unset($this->ExpenseAccount);
        } else {
            $this->ExpenseAccount = $expenseAccount;
        }
        return $this;
    }
    /**
     * Get ExpenseItemID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getExpenseItemID()
    {
        return isset($this->ExpenseItemID) ? $this->ExpenseItemID : null;
    }
    /**
     * Set ExpenseItemID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $expenseItemID
     * @return \StructType\ExpenseClaimDetails
     */
    public function setExpenseItemID(\StructType\StringValue $expenseItemID = null)
    {
        if (is_null($expenseItemID) || (is_array($expenseItemID) && empty($expenseItemID))) {
            unset($this->ExpenseItemID);
        } else {
            $this->ExpenseItemID = $expenseItemID;
        }
        return $this;
    }
    /**
     * Get ExpenseSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getExpenseSubaccount()
    {
        return isset($this->ExpenseSubaccount) ? $this->ExpenseSubaccount : null;
    }
    /**
     * Set ExpenseSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $expenseSubaccount
     * @return \StructType\ExpenseClaimDetails
     */
    public function setExpenseSubaccount(\StructType\StringValue $expenseSubaccount = null)
    {
        if (is_null($expenseSubaccount) || (is_array($expenseSubaccount) && empty($expenseSubaccount))) {
            unset($this->ExpenseSubaccount);
        } else {
            $this->ExpenseSubaccount = $expenseSubaccount;
        }
        return $this;
    }
    /**
     * Get LocationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getLocationID()
    {
        return isset($this->LocationID) ? $this->LocationID : null;
    }
    /**
     * Set LocationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $locationID
     * @return \StructType\ExpenseClaimDetails
     */
    public function setLocationID(\StructType\StringValue $locationID = null)
    {
        if (is_null($locationID) || (is_array($locationID) && empty($locationID))) {
            unset($this->LocationID);
        } else {
            $this->LocationID = $locationID;
        }
        return $this;
    }
    /**
     * Get NetAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getNetAmount()
    {
        return isset($this->NetAmount) ? $this->NetAmount : null;
    }
    /**
     * Set NetAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $netAmount
     * @return \StructType\ExpenseClaimDetails
     */
    public function setNetAmount(\StructType\DecimalValue $netAmount = null)
    {
        if (is_null($netAmount) || (is_array($netAmount) && empty($netAmount))) {
            unset($this->NetAmount);
        } else {
            $this->NetAmount = $netAmount;
        }
        return $this;
    }
    /**
     * Get ProjectID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getProjectID()
    {
        return isset($this->ProjectID) ? $this->ProjectID : null;
    }
    /**
     * Set ProjectID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $projectID
     * @return \StructType\ExpenseClaimDetails
     */
    public function setProjectID(\StructType\StringValue $projectID = null)
    {
        if (is_null($projectID) || (is_array($projectID) && empty($projectID))) {
            unset($this->ProjectID);
        } else {
            $this->ProjectID = $projectID;
        }
        return $this;
    }
    /**
     * Get ProjectTaskID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getProjectTaskID()
    {
        return isset($this->ProjectTaskID) ? $this->ProjectTaskID : null;
    }
    /**
     * Set ProjectTaskID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $projectTaskID
     * @return \StructType\ExpenseClaimDetails
     */
    public function setProjectTaskID(\StructType\StringValue $projectTaskID = null)
    {
        if (is_null($projectTaskID) || (is_array($projectTaskID) && empty($projectTaskID))) {
            unset($this->ProjectTaskID);
        } else {
            $this->ProjectTaskID = $projectTaskID;
        }
        return $this;
    }
    /**
     * Get Qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getQty()
    {
        return isset($this->Qty) ? $this->Qty : null;
    }
    /**
     * Set Qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $qty
     * @return \StructType\ExpenseClaimDetails
     */
    public function setQty(\StructType\DecimalValue $qty = null)
    {
        if (is_null($qty) || (is_array($qty) && empty($qty))) {
            unset($this->Qty);
        } else {
            $this->Qty = $qty;
        }
        return $this;
    }
    /**
     * Get RefNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getRefNbr()
    {
        return isset($this->RefNbr) ? $this->RefNbr : null;
    }
    /**
     * Set RefNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $refNbr
     * @return \StructType\ExpenseClaimDetails
     */
    public function setRefNbr(\StructType\StringValue $refNbr = null)
    {
        if (is_null($refNbr) || (is_array($refNbr) && empty($refNbr))) {
            unset($this->RefNbr);
        } else {
            $this->RefNbr = $refNbr;
        }
        return $this;
    }
    /**
     * Get SalesAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getSalesAccount()
    {
        return isset($this->SalesAccount) ? $this->SalesAccount : null;
    }
    /**
     * Set SalesAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $salesAccount
     * @return \StructType\ExpenseClaimDetails
     */
    public function setSalesAccount(\StructType\StringValue $salesAccount = null)
    {
        if (is_null($salesAccount) || (is_array($salesAccount) && empty($salesAccount))) {
            unset($this->SalesAccount);
        } else {
            $this->SalesAccount = $salesAccount;
        }
        return $this;
    }
    /**
     * Get SalesSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getSalesSubaccount()
    {
        return isset($this->SalesSubaccount) ? $this->SalesSubaccount : null;
    }
    /**
     * Set SalesSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $salesSubaccount
     * @return \StructType\ExpenseClaimDetails
     */
    public function setSalesSubaccount(\StructType\StringValue $salesSubaccount = null)
    {
        if (is_null($salesSubaccount) || (is_array($salesSubaccount) && empty($salesSubaccount))) {
            unset($this->SalesSubaccount);
        } else {
            $this->SalesSubaccount = $salesSubaccount;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $status
     * @return \StructType\ExpenseClaimDetails
     */
    public function setStatus(\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TaxAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getTaxAmount()
    {
        return isset($this->TaxAmount) ? $this->TaxAmount : null;
    }
    /**
     * Set TaxAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $taxAmount
     * @return \StructType\ExpenseClaimDetails
     */
    public function setTaxAmount(\StructType\DecimalValue $taxAmount = null)
    {
        if (is_null($taxAmount) || (is_array($taxAmount) && empty($taxAmount))) {
            unset($this->TaxAmount);
        } else {
            $this->TaxAmount = $taxAmount;
        }
        return $this;
    }
    /**
     * Get TaxCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getTaxCategory()
    {
        return isset($this->TaxCategory) ? $this->TaxCategory : null;
    }
    /**
     * Set TaxCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $taxCategory
     * @return \StructType\ExpenseClaimDetails
     */
    public function setTaxCategory(\StructType\StringValue $taxCategory = null)
    {
        if (is_null($taxCategory) || (is_array($taxCategory) && empty($taxCategory))) {
            unset($this->TaxCategory);
        } else {
            $this->TaxCategory = $taxCategory;
        }
        return $this;
    }
    /**
     * Get TaxZone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getTaxZone()
    {
        return isset($this->TaxZone) ? $this->TaxZone : null;
    }
    /**
     * Set TaxZone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $taxZone
     * @return \StructType\ExpenseClaimDetails
     */
    public function setTaxZone(\StructType\StringValue $taxZone = null)
    {
        if (is_null($taxZone) || (is_array($taxZone) && empty($taxZone))) {
            unset($this->TaxZone);
        } else {
            $this->TaxZone = $taxZone;
        }
        return $this;
    }
    /**
     * Get TipAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getTipAmount()
    {
        return isset($this->TipAmount) ? $this->TipAmount : null;
    }
    /**
     * Set TipAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $tipAmount
     * @return \StructType\ExpenseClaimDetails
     */
    public function setTipAmount(\StructType\DecimalValue $tipAmount = null)
    {
        if (is_null($tipAmount) || (is_array($tipAmount) && empty($tipAmount))) {
            unset($this->TipAmount);
        } else {
            $this->TipAmount = $tipAmount;
        }
        return $this;
    }
    /**
     * Get UnitCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getUnitCost()
    {
        return isset($this->UnitCost) ? $this->UnitCost : null;
    }
    /**
     * Set UnitCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $unitCost
     * @return \StructType\ExpenseClaimDetails
     */
    public function setUnitCost(\StructType\DecimalValue $unitCost = null)
    {
        if (is_null($unitCost) || (is_array($unitCost) && empty($unitCost))) {
            unset($this->UnitCost);
        } else {
            $this->UnitCost = $unitCost;
        }
        return $this;
    }
    /**
     * Get UOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getUOM()
    {
        return isset($this->UOM) ? $this->UOM : null;
    }
    /**
     * Set UOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $uOM
     * @return \StructType\ExpenseClaimDetails
     */
    public function setUOM(\StructType\StringValue $uOM = null)
    {
        if (is_null($uOM) || (is_array($uOM) && empty($uOM))) {
            unset($this->UOM);
        } else {
            $this->UOM = $uOM;
        }
        return $this;
    }
}
