<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillToSettings StructType
 * @subpackage Structs
 */
class BillToSettings extends Entity
{
    /**
     * The BillToAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Address
     */
    public $BillToAddress;
    /**
     * The BillToAddressOverride
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $BillToAddressOverride;
    /**
     * The BillToContact
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DocContact
     */
    public $BillToContact;
    /**
     * The BillToContactOverride
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $BillToContactOverride;
    /**
     * The CustomerLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CustomerLocation;
    /**
     * Constructor method for BillToSettings
     * @uses BillToSettings::setBillToAddress()
     * @uses BillToSettings::setBillToAddressOverride()
     * @uses BillToSettings::setBillToContact()
     * @uses BillToSettings::setBillToContactOverride()
     * @uses BillToSettings::setCustomerLocation()
     * @param \StructType\Address $billToAddress
     * @param \StructType\BooleanValue $billToAddressOverride
     * @param \StructType\DocContact $billToContact
     * @param \StructType\BooleanValue $billToContactOverride
     * @param \StructType\StringValue $customerLocation
     */
    public function __construct(\StructType\Address $billToAddress = null, \StructType\BooleanValue $billToAddressOverride = null, \StructType\DocContact $billToContact = null, \StructType\BooleanValue $billToContactOverride = null, \StructType\StringValue $customerLocation = null)
    {
        $this
            ->setBillToAddress($billToAddress)
            ->setBillToAddressOverride($billToAddressOverride)
            ->setBillToContact($billToContact)
            ->setBillToContactOverride($billToContactOverride)
            ->setCustomerLocation($customerLocation);
    }
    /**
     * Get BillToAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Address|null
     */
    public function getBillToAddress()
    {
        return isset($this->BillToAddress) ? $this->BillToAddress : null;
    }
    /**
     * Set BillToAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Address $billToAddress
     * @return \StructType\BillToSettings
     */
    public function setBillToAddress(\StructType\Address $billToAddress = null)
    {
        if (is_null($billToAddress) || (is_array($billToAddress) && empty($billToAddress))) {
            unset($this->BillToAddress);
        } else {
            $this->BillToAddress = $billToAddress;
        }
        return $this;
    }
    /**
     * Get BillToAddressOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getBillToAddressOverride()
    {
        return isset($this->BillToAddressOverride) ? $this->BillToAddressOverride : null;
    }
    /**
     * Set BillToAddressOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $billToAddressOverride
     * @return \StructType\BillToSettings
     */
    public function setBillToAddressOverride(\StructType\BooleanValue $billToAddressOverride = null)
    {
        if (is_null($billToAddressOverride) || (is_array($billToAddressOverride) && empty($billToAddressOverride))) {
            unset($this->BillToAddressOverride);
        } else {
            $this->BillToAddressOverride = $billToAddressOverride;
        }
        return $this;
    }
    /**
     * Get BillToContact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DocContact|null
     */
    public function getBillToContact()
    {
        return isset($this->BillToContact) ? $this->BillToContact : null;
    }
    /**
     * Set BillToContact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DocContact $billToContact
     * @return \StructType\BillToSettings
     */
    public function setBillToContact(\StructType\DocContact $billToContact = null)
    {
        if (is_null($billToContact) || (is_array($billToContact) && empty($billToContact))) {
            unset($this->BillToContact);
        } else {
            $this->BillToContact = $billToContact;
        }
        return $this;
    }
    /**
     * Get BillToContactOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getBillToContactOverride()
    {
        return isset($this->BillToContactOverride) ? $this->BillToContactOverride : null;
    }
    /**
     * Set BillToContactOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $billToContactOverride
     * @return \StructType\BillToSettings
     */
    public function setBillToContactOverride(\StructType\BooleanValue $billToContactOverride = null)
    {
        if (is_null($billToContactOverride) || (is_array($billToContactOverride) && empty($billToContactOverride))) {
            unset($this->BillToContactOverride);
        } else {
            $this->BillToContactOverride = $billToContactOverride;
        }
        return $this;
    }
    /**
     * Get CustomerLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCustomerLocation()
    {
        return isset($this->CustomerLocation) ? $this->CustomerLocation : null;
    }
    /**
     * Set CustomerLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $customerLocation
     * @return \StructType\BillToSettings
     */
    public function setCustomerLocation(\StructType\StringValue $customerLocation = null)
    {
        if (is_null($customerLocation) || (is_array($customerLocation) && empty($customerLocation))) {
            unset($this->CustomerLocation);
        } else {
            $this->CustomerLocation = $customerLocation;
        }
        return $this;
    }
}
