<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Activity StructType
 * @subpackage Structs
 */
class Activity extends Entity
{
    /**
     * The Body
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Body;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $Date;
    /**
     * The Internal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $Internal;
    /**
     * The NoteID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GuidValue
     */
    public $NoteID;
    /**
     * The Owner
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Owner;
    /**
     * The RelatedEntityDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $RelatedEntityDescription;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Status;
    /**
     * The Summary
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Summary;
    /**
     * The Task
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Task;
    /**
     * The TimeActivity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TimeActivity
     */
    public $TimeActivity;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Type;
    /**
     * The Workgroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Workgroup;
    /**
     * Constructor method for Activity
     * @uses Activity::setBody()
     * @uses Activity::setDate()
     * @uses Activity::setInternal()
     * @uses Activity::setNoteID()
     * @uses Activity::setOwner()
     * @uses Activity::setRelatedEntityDescription()
     * @uses Activity::setStatus()
     * @uses Activity::setSummary()
     * @uses Activity::setTask()
     * @uses Activity::setTimeActivity()
     * @uses Activity::setType()
     * @uses Activity::setWorkgroup()
     * @param \StructType\StringValue $body
     * @param \StructType\DateTimeValue $date
     * @param \StructType\BooleanValue $internal
     * @param \StructType\GuidValue $noteID
     * @param \StructType\StringValue $owner
     * @param \StructType\StringValue $relatedEntityDescription
     * @param \StructType\StringValue $status
     * @param \StructType\StringValue $summary
     * @param \StructType\StringValue $task
     * @param \StructType\TimeActivity $timeActivity
     * @param \StructType\StringValue $type
     * @param \StructType\StringValue $workgroup
     */
    public function __construct(\StructType\StringValue $body = null, \StructType\DateTimeValue $date = null, \StructType\BooleanValue $internal = null, \StructType\GuidValue $noteID = null, \StructType\StringValue $owner = null, \StructType\StringValue $relatedEntityDescription = null, \StructType\StringValue $status = null, \StructType\StringValue $summary = null, \StructType\StringValue $task = null, \StructType\TimeActivity $timeActivity = null, \StructType\StringValue $type = null, \StructType\StringValue $workgroup = null)
    {
        $this
            ->setBody($body)
            ->setDate($date)
            ->setInternal($internal)
            ->setNoteID($noteID)
            ->setOwner($owner)
            ->setRelatedEntityDescription($relatedEntityDescription)
            ->setStatus($status)
            ->setSummary($summary)
            ->setTask($task)
            ->setTimeActivity($timeActivity)
            ->setType($type)
            ->setWorkgroup($workgroup);
    }
    /**
     * Get Body value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getBody()
    {
        return isset($this->Body) ? $this->Body : null;
    }
    /**
     * Set Body value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $body
     * @return \StructType\Activity
     */
    public function setBody(\StructType\StringValue $body = null)
    {
        if (is_null($body) || (is_array($body) && empty($body))) {
            unset($this->Body);
        } else {
            $this->Body = $body;
        }
        return $this;
    }
    /**
     * Get Date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getDate()
    {
        return isset($this->Date) ? $this->Date : null;
    }
    /**
     * Set Date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $date
     * @return \StructType\Activity
     */
    public function setDate(\StructType\DateTimeValue $date = null)
    {
        if (is_null($date) || (is_array($date) && empty($date))) {
            unset($this->Date);
        } else {
            $this->Date = $date;
        }
        return $this;
    }
    /**
     * Get Internal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getInternal()
    {
        return isset($this->Internal) ? $this->Internal : null;
    }
    /**
     * Set Internal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $internal
     * @return \StructType\Activity
     */
    public function setInternal(\StructType\BooleanValue $internal = null)
    {
        if (is_null($internal) || (is_array($internal) && empty($internal))) {
            unset($this->Internal);
        } else {
            $this->Internal = $internal;
        }
        return $this;
    }
    /**
     * Get NoteID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GuidValue|null
     */
    public function getNoteID()
    {
        return isset($this->NoteID) ? $this->NoteID : null;
    }
    /**
     * Set NoteID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\GuidValue $noteID
     * @return \StructType\Activity
     */
    public function setNoteID(\StructType\GuidValue $noteID = null)
    {
        if (is_null($noteID) || (is_array($noteID) && empty($noteID))) {
            unset($this->NoteID);
        } else {
            $this->NoteID = $noteID;
        }
        return $this;
    }
    /**
     * Get Owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getOwner()
    {
        return isset($this->Owner) ? $this->Owner : null;
    }
    /**
     * Set Owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $owner
     * @return \StructType\Activity
     */
    public function setOwner(\StructType\StringValue $owner = null)
    {
        if (is_null($owner) || (is_array($owner) && empty($owner))) {
            unset($this->Owner);
        } else {
            $this->Owner = $owner;
        }
        return $this;
    }
    /**
     * Get RelatedEntityDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getRelatedEntityDescription()
    {
        return isset($this->RelatedEntityDescription) ? $this->RelatedEntityDescription : null;
    }
    /**
     * Set RelatedEntityDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $relatedEntityDescription
     * @return \StructType\Activity
     */
    public function setRelatedEntityDescription(\StructType\StringValue $relatedEntityDescription = null)
    {
        if (is_null($relatedEntityDescription) || (is_array($relatedEntityDescription) && empty($relatedEntityDescription))) {
            unset($this->RelatedEntityDescription);
        } else {
            $this->RelatedEntityDescription = $relatedEntityDescription;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $status
     * @return \StructType\Activity
     */
    public function setStatus(\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get Summary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getSummary()
    {
        return isset($this->Summary) ? $this->Summary : null;
    }
    /**
     * Set Summary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $summary
     * @return \StructType\Activity
     */
    public function setSummary(\StructType\StringValue $summary = null)
    {
        if (is_null($summary) || (is_array($summary) && empty($summary))) {
            unset($this->Summary);
        } else {
            $this->Summary = $summary;
        }
        return $this;
    }
    /**
     * Get Task value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getTask()
    {
        return isset($this->Task) ? $this->Task : null;
    }
    /**
     * Set Task value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $task
     * @return \StructType\Activity
     */
    public function setTask(\StructType\StringValue $task = null)
    {
        if (is_null($task) || (is_array($task) && empty($task))) {
            unset($this->Task);
        } else {
            $this->Task = $task;
        }
        return $this;
    }
    /**
     * Get TimeActivity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TimeActivity|null
     */
    public function getTimeActivity()
    {
        return isset($this->TimeActivity) ? $this->TimeActivity : null;
    }
    /**
     * Set TimeActivity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\TimeActivity $timeActivity
     * @return \StructType\Activity
     */
    public function setTimeActivity(\StructType\TimeActivity $timeActivity = null)
    {
        if (is_null($timeActivity) || (is_array($timeActivity) && empty($timeActivity))) {
            unset($this->TimeActivity);
        } else {
            $this->TimeActivity = $timeActivity;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $type
     * @return \StructType\Activity
     */
    public function setType(\StructType\StringValue $type = null)
    {
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Get Workgroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getWorkgroup()
    {
        return isset($this->Workgroup) ? $this->Workgroup : null;
    }
    /**
     * Set Workgroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $workgroup
     * @return \StructType\Activity
     */
    public function setWorkgroup(\StructType\StringValue $workgroup = null)
    {
        if (is_null($workgroup) || (is_array($workgroup) && empty($workgroup))) {
            unset($this->Workgroup);
        } else {
            $this->Workgroup = $workgroup;
        }
        return $this;
    }
}
