<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Activities StructType
 * @subpackage Structs
 */
class Activities extends AbstractStructBase
{
    /**
     * The ActivityDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ActivityDetail[]
     */
    public $ActivityDetail;
    /**
     * The CaseActivityDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CaseActivityDetail[]
     */
    public $CaseActivityDetail;
    /**
     * The BusinessAccountActivityDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BusinessAccountActivityDetail[]
     */
    public $BusinessAccountActivityDetail;
    /**
     * Constructor method for Activities
     * @uses Activities::setActivityDetail()
     * @uses Activities::setCaseActivityDetail()
     * @uses Activities::setBusinessAccountActivityDetail()
     * @param \StructType\ActivityDetail[] $activityDetail
     * @param \StructType\CaseActivityDetail[] $caseActivityDetail
     * @param \StructType\BusinessAccountActivityDetail[] $businessAccountActivityDetail
     */
    public function __construct(array $activityDetail = array(), array $caseActivityDetail = array(), array $businessAccountActivityDetail = array())
    {
        $this
            ->setActivityDetail($activityDetail)
            ->setCaseActivityDetail($caseActivityDetail)
            ->setBusinessAccountActivityDetail($businessAccountActivityDetail);
    }
    /**
     * Get ActivityDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ActivityDetail[]|null
     */
    public function getActivityDetail()
    {
        return isset($this->ActivityDetail) ? $this->ActivityDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setActivityDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setActivityDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateActivityDetailForArrayConstraintsFromSetActivityDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $activitiesActivityDetailItem) {
            // validation for constraint: itemType
            if (!$activitiesActivityDetailItem instanceof \StructType\ActivityDetail) {
                $invalidValues[] = is_object($activitiesActivityDetailItem) ? get_class($activitiesActivityDetailItem) : sprintf('%s(%s)', gettype($activitiesActivityDetailItem), var_export($activitiesActivityDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ActivityDetail property can only contain items of type \StructType\ActivityDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ActivityDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ActivityDetail[] $activityDetail
     * @return \StructType\Activities
     */
    public function setActivityDetail(array $activityDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($activityDetailArrayErrorMessage = self::validateActivityDetailForArrayConstraintsFromSetActivityDetail($activityDetail))) {
            throw new \InvalidArgumentException($activityDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($activityDetail) || (is_array($activityDetail) && empty($activityDetail))) {
            unset($this->ActivityDetail);
        } else {
            $this->ActivityDetail = $activityDetail;
        }
        return $this;
    }
    /**
     * Add item to ActivityDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\ActivityDetail $item
     * @return \StructType\Activities
     */
    public function addToActivityDetail(\StructType\ActivityDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ActivityDetail) {
            throw new \InvalidArgumentException(sprintf('The ActivityDetail property can only contain items of type \StructType\ActivityDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ActivityDetail[] = $item;
        return $this;
    }
    /**
     * Get CaseActivityDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CaseActivityDetail[]|null
     */
    public function getCaseActivityDetail()
    {
        return isset($this->CaseActivityDetail) ? $this->CaseActivityDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCaseActivityDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCaseActivityDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCaseActivityDetailForArrayConstraintsFromSetCaseActivityDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $activitiesCaseActivityDetailItem) {
            // validation for constraint: itemType
            if (!$activitiesCaseActivityDetailItem instanceof \StructType\CaseActivityDetail) {
                $invalidValues[] = is_object($activitiesCaseActivityDetailItem) ? get_class($activitiesCaseActivityDetailItem) : sprintf('%s(%s)', gettype($activitiesCaseActivityDetailItem), var_export($activitiesCaseActivityDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CaseActivityDetail property can only contain items of type \StructType\CaseActivityDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CaseActivityDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CaseActivityDetail[] $caseActivityDetail
     * @return \StructType\Activities
     */
    public function setCaseActivityDetail(array $caseActivityDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($caseActivityDetailArrayErrorMessage = self::validateCaseActivityDetailForArrayConstraintsFromSetCaseActivityDetail($caseActivityDetail))) {
            throw new \InvalidArgumentException($caseActivityDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($caseActivityDetail) || (is_array($caseActivityDetail) && empty($caseActivityDetail))) {
            unset($this->CaseActivityDetail);
        } else {
            $this->CaseActivityDetail = $caseActivityDetail;
        }
        return $this;
    }
    /**
     * Add item to CaseActivityDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\CaseActivityDetail $item
     * @return \StructType\Activities
     */
    public function addToCaseActivityDetail(\StructType\CaseActivityDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CaseActivityDetail) {
            throw new \InvalidArgumentException(sprintf('The CaseActivityDetail property can only contain items of type \StructType\CaseActivityDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CaseActivityDetail[] = $item;
        return $this;
    }
    /**
     * Get BusinessAccountActivityDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BusinessAccountActivityDetail[]|null
     */
    public function getBusinessAccountActivityDetail()
    {
        return isset($this->BusinessAccountActivityDetail) ? $this->BusinessAccountActivityDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBusinessAccountActivityDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBusinessAccountActivityDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBusinessAccountActivityDetailForArrayConstraintsFromSetBusinessAccountActivityDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $activitiesBusinessAccountActivityDetailItem) {
            // validation for constraint: itemType
            if (!$activitiesBusinessAccountActivityDetailItem instanceof \StructType\BusinessAccountActivityDetail) {
                $invalidValues[] = is_object($activitiesBusinessAccountActivityDetailItem) ? get_class($activitiesBusinessAccountActivityDetailItem) : sprintf('%s(%s)', gettype($activitiesBusinessAccountActivityDetailItem), var_export($activitiesBusinessAccountActivityDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BusinessAccountActivityDetail property can only contain items of type \StructType\BusinessAccountActivityDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BusinessAccountActivityDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BusinessAccountActivityDetail[] $businessAccountActivityDetail
     * @return \StructType\Activities
     */
    public function setBusinessAccountActivityDetail(array $businessAccountActivityDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($businessAccountActivityDetailArrayErrorMessage = self::validateBusinessAccountActivityDetailForArrayConstraintsFromSetBusinessAccountActivityDetail($businessAccountActivityDetail))) {
            throw new \InvalidArgumentException($businessAccountActivityDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($businessAccountActivityDetail) || (is_array($businessAccountActivityDetail) && empty($businessAccountActivityDetail))) {
            unset($this->BusinessAccountActivityDetail);
        } else {
            $this->BusinessAccountActivityDetail = $businessAccountActivityDetail;
        }
        return $this;
    }
    /**
     * Add item to BusinessAccountActivityDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\BusinessAccountActivityDetail $item
     * @return \StructType\Activities
     */
    public function addToBusinessAccountActivityDetail(\StructType\BusinessAccountActivityDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BusinessAccountActivityDetail) {
            throw new \InvalidArgumentException(sprintf('The BusinessAccountActivityDetail property can only contain items of type \StructType\BusinessAccountActivityDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BusinessAccountActivityDetail[] = $item;
        return $this;
    }
}
