<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountSummaryInquiry StructType
 * @subpackage Structs
 */
class AccountSummaryInquiry extends Entity
{
    /**
     * The AccountClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $AccountClass;
    /**
     * The Branch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Branch;
    /**
     * The Ledger
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Ledger;
    /**
     * The Period
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Period;
    /**
     * The Results
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Results
     */
    public $Results;
    /**
     * The Subaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Subaccount;
    /**
     * Constructor method for AccountSummaryInquiry
     * @uses AccountSummaryInquiry::setAccountClass()
     * @uses AccountSummaryInquiry::setBranch()
     * @uses AccountSummaryInquiry::setLedger()
     * @uses AccountSummaryInquiry::setPeriod()
     * @uses AccountSummaryInquiry::setResults()
     * @uses AccountSummaryInquiry::setSubaccount()
     * @param \StructType\StringValue $accountClass
     * @param \StructType\StringValue $branch
     * @param \StructType\StringValue $ledger
     * @param \StructType\StringValue $period
     * @param \StructType\Results $results
     * @param \StructType\StringValue $subaccount
     */
    public function __construct(\StructType\StringValue $accountClass = null, \StructType\StringValue $branch = null, \StructType\StringValue $ledger = null, \StructType\StringValue $period = null, \StructType\Results $results = null, \StructType\StringValue $subaccount = null)
    {
        $this
            ->setAccountClass($accountClass)
            ->setBranch($branch)
            ->setLedger($ledger)
            ->setPeriod($period)
            ->setResults($results)
            ->setSubaccount($subaccount);
    }
    /**
     * Get AccountClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getAccountClass()
    {
        return isset($this->AccountClass) ? $this->AccountClass : null;
    }
    /**
     * Set AccountClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $accountClass
     * @return \StructType\AccountSummaryInquiry
     */
    public function setAccountClass(\StructType\StringValue $accountClass = null)
    {
        if (is_null($accountClass) || (is_array($accountClass) && empty($accountClass))) {
            unset($this->AccountClass);
        } else {
            $this->AccountClass = $accountClass;
        }
        return $this;
    }
    /**
     * Get Branch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getBranch()
    {
        return isset($this->Branch) ? $this->Branch : null;
    }
    /**
     * Set Branch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $branch
     * @return \StructType\AccountSummaryInquiry
     */
    public function setBranch(\StructType\StringValue $branch = null)
    {
        if (is_null($branch) || (is_array($branch) && empty($branch))) {
            unset($this->Branch);
        } else {
            $this->Branch = $branch;
        }
        return $this;
    }
    /**
     * Get Ledger value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getLedger()
    {
        return isset($this->Ledger) ? $this->Ledger : null;
    }
    /**
     * Set Ledger value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $ledger
     * @return \StructType\AccountSummaryInquiry
     */
    public function setLedger(\StructType\StringValue $ledger = null)
    {
        if (is_null($ledger) || (is_array($ledger) && empty($ledger))) {
            unset($this->Ledger);
        } else {
            $this->Ledger = $ledger;
        }
        return $this;
    }
    /**
     * Get Period value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getPeriod()
    {
        return isset($this->Period) ? $this->Period : null;
    }
    /**
     * Set Period value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $period
     * @return \StructType\AccountSummaryInquiry
     */
    public function setPeriod(\StructType\StringValue $period = null)
    {
        if (is_null($period) || (is_array($period) && empty($period))) {
            unset($this->Period);
        } else {
            $this->Period = $period;
        }
        return $this;
    }
    /**
     * Get Results value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Results|null
     */
    public function getResults()
    {
        return isset($this->Results) ? $this->Results : null;
    }
    /**
     * Set Results value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Results $results
     * @return \StructType\AccountSummaryInquiry
     */
    public function setResults(\StructType\Results $results = null)
    {
        if (is_null($results) || (is_array($results) && empty($results))) {
            unset($this->Results);
        } else {
            $this->Results = $results;
        }
        return $this;
    }
    /**
     * Get Subaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getSubaccount()
    {
        return isset($this->Subaccount) ? $this->Subaccount : null;
    }
    /**
     * Set Subaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $subaccount
     * @return \StructType\AccountSummaryInquiry
     */
    public function setSubaccount(\StructType\StringValue $subaccount = null)
    {
        if (is_null($subaccount) || (is_array($subaccount) && empty($subaccount))) {
            unset($this->Subaccount);
        } else {
            $this->Subaccount = $subaccount;
        }
        return $this;
    }
}
