<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountDetailsInquiry StructType
 * @subpackage Structs
 */
class AccountDetailsInquiry extends Entity
{
    /**
     * The Account
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Account;
    /**
     * The BeginingBalance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $BeginingBalance;
    /**
     * The Branch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Branch;
    /**
     * The EndingBalance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $EndingBalance;
    /**
     * The FromDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $FromDate;
    /**
     * The FromPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $FromPeriod;
    /**
     * The IncludeReclassified
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $IncludeReclassified;
    /**
     * The IncludeUnposted
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $IncludeUnposted;
    /**
     * The IncludeUnreleased
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $IncludeUnreleased;
    /**
     * The Ledger
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Ledger;
    /**
     * The PeriodEndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $PeriodEndDate;
    /**
     * The PeriodStartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $PeriodStartDate;
    /**
     * The Results
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Results
     */
    public $Results;
    /**
     * The Subaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Subaccount;
    /**
     * The ToDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $ToDate;
    /**
     * The ToPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ToPeriod;
    /**
     * The Turnover
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $Turnover;
    /**
     * Constructor method for AccountDetailsInquiry
     * @uses AccountDetailsInquiry::setAccount()
     * @uses AccountDetailsInquiry::setBeginingBalance()
     * @uses AccountDetailsInquiry::setBranch()
     * @uses AccountDetailsInquiry::setEndingBalance()
     * @uses AccountDetailsInquiry::setFromDate()
     * @uses AccountDetailsInquiry::setFromPeriod()
     * @uses AccountDetailsInquiry::setIncludeReclassified()
     * @uses AccountDetailsInquiry::setIncludeUnposted()
     * @uses AccountDetailsInquiry::setIncludeUnreleased()
     * @uses AccountDetailsInquiry::setLedger()
     * @uses AccountDetailsInquiry::setPeriodEndDate()
     * @uses AccountDetailsInquiry::setPeriodStartDate()
     * @uses AccountDetailsInquiry::setResults()
     * @uses AccountDetailsInquiry::setSubaccount()
     * @uses AccountDetailsInquiry::setToDate()
     * @uses AccountDetailsInquiry::setToPeriod()
     * @uses AccountDetailsInquiry::setTurnover()
     * @param \StructType\StringValue $account
     * @param \StructType\DecimalValue $beginingBalance
     * @param \StructType\StringValue $branch
     * @param \StructType\DecimalValue $endingBalance
     * @param \StructType\DateTimeValue $fromDate
     * @param \StructType\StringValue $fromPeriod
     * @param \StructType\BooleanValue $includeReclassified
     * @param \StructType\BooleanValue $includeUnposted
     * @param \StructType\BooleanValue $includeUnreleased
     * @param \StructType\StringValue $ledger
     * @param \StructType\DateTimeValue $periodEndDate
     * @param \StructType\DateTimeValue $periodStartDate
     * @param \StructType\Results $results
     * @param \StructType\StringValue $subaccount
     * @param \StructType\DateTimeValue $toDate
     * @param \StructType\StringValue $toPeriod
     * @param \StructType\DecimalValue $turnover
     */
    public function __construct(\StructType\StringValue $account = null, \StructType\DecimalValue $beginingBalance = null, \StructType\StringValue $branch = null, \StructType\DecimalValue $endingBalance = null, \StructType\DateTimeValue $fromDate = null, \StructType\StringValue $fromPeriod = null, \StructType\BooleanValue $includeReclassified = null, \StructType\BooleanValue $includeUnposted = null, \StructType\BooleanValue $includeUnreleased = null, \StructType\StringValue $ledger = null, \StructType\DateTimeValue $periodEndDate = null, \StructType\DateTimeValue $periodStartDate = null, \StructType\Results $results = null, \StructType\StringValue $subaccount = null, \StructType\DateTimeValue $toDate = null, \StructType\StringValue $toPeriod = null, \StructType\DecimalValue $turnover = null)
    {
        $this
            ->setAccount($account)
            ->setBeginingBalance($beginingBalance)
            ->setBranch($branch)
            ->setEndingBalance($endingBalance)
            ->setFromDate($fromDate)
            ->setFromPeriod($fromPeriod)
            ->setIncludeReclassified($includeReclassified)
            ->setIncludeUnposted($includeUnposted)
            ->setIncludeUnreleased($includeUnreleased)
            ->setLedger($ledger)
            ->setPeriodEndDate($periodEndDate)
            ->setPeriodStartDate($periodStartDate)
            ->setResults($results)
            ->setSubaccount($subaccount)
            ->setToDate($toDate)
            ->setToPeriod($toPeriod)
            ->setTurnover($turnover);
    }
    /**
     * Get Account value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getAccount()
    {
        return isset($this->Account) ? $this->Account : null;
    }
    /**
     * Set Account value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $account
     * @return \StructType\AccountDetailsInquiry
     */
    public function setAccount(\StructType\StringValue $account = null)
    {
        if (is_null($account) || (is_array($account) && empty($account))) {
            unset($this->Account);
        } else {
            $this->Account = $account;
        }
        return $this;
    }
    /**
     * Get BeginingBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getBeginingBalance()
    {
        return isset($this->BeginingBalance) ? $this->BeginingBalance : null;
    }
    /**
     * Set BeginingBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $beginingBalance
     * @return \StructType\AccountDetailsInquiry
     */
    public function setBeginingBalance(\StructType\DecimalValue $beginingBalance = null)
    {
        if (is_null($beginingBalance) || (is_array($beginingBalance) && empty($beginingBalance))) {
            unset($this->BeginingBalance);
        } else {
            $this->BeginingBalance = $beginingBalance;
        }
        return $this;
    }
    /**
     * Get Branch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getBranch()
    {
        return isset($this->Branch) ? $this->Branch : null;
    }
    /**
     * Set Branch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $branch
     * @return \StructType\AccountDetailsInquiry
     */
    public function setBranch(\StructType\StringValue $branch = null)
    {
        if (is_null($branch) || (is_array($branch) && empty($branch))) {
            unset($this->Branch);
        } else {
            $this->Branch = $branch;
        }
        return $this;
    }
    /**
     * Get EndingBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getEndingBalance()
    {
        return isset($this->EndingBalance) ? $this->EndingBalance : null;
    }
    /**
     * Set EndingBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $endingBalance
     * @return \StructType\AccountDetailsInquiry
     */
    public function setEndingBalance(\StructType\DecimalValue $endingBalance = null)
    {
        if (is_null($endingBalance) || (is_array($endingBalance) && empty($endingBalance))) {
            unset($this->EndingBalance);
        } else {
            $this->EndingBalance = $endingBalance;
        }
        return $this;
    }
    /**
     * Get FromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getFromDate()
    {
        return isset($this->FromDate) ? $this->FromDate : null;
    }
    /**
     * Set FromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $fromDate
     * @return \StructType\AccountDetailsInquiry
     */
    public function setFromDate(\StructType\DateTimeValue $fromDate = null)
    {
        if (is_null($fromDate) || (is_array($fromDate) && empty($fromDate))) {
            unset($this->FromDate);
        } else {
            $this->FromDate = $fromDate;
        }
        return $this;
    }
    /**
     * Get FromPeriod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getFromPeriod()
    {
        return isset($this->FromPeriod) ? $this->FromPeriod : null;
    }
    /**
     * Set FromPeriod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $fromPeriod
     * @return \StructType\AccountDetailsInquiry
     */
    public function setFromPeriod(\StructType\StringValue $fromPeriod = null)
    {
        if (is_null($fromPeriod) || (is_array($fromPeriod) && empty($fromPeriod))) {
            unset($this->FromPeriod);
        } else {
            $this->FromPeriod = $fromPeriod;
        }
        return $this;
    }
    /**
     * Get IncludeReclassified value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getIncludeReclassified()
    {
        return isset($this->IncludeReclassified) ? $this->IncludeReclassified : null;
    }
    /**
     * Set IncludeReclassified value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $includeReclassified
     * @return \StructType\AccountDetailsInquiry
     */
    public function setIncludeReclassified(\StructType\BooleanValue $includeReclassified = null)
    {
        if (is_null($includeReclassified) || (is_array($includeReclassified) && empty($includeReclassified))) {
            unset($this->IncludeReclassified);
        } else {
            $this->IncludeReclassified = $includeReclassified;
        }
        return $this;
    }
    /**
     * Get IncludeUnposted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getIncludeUnposted()
    {
        return isset($this->IncludeUnposted) ? $this->IncludeUnposted : null;
    }
    /**
     * Set IncludeUnposted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $includeUnposted
     * @return \StructType\AccountDetailsInquiry
     */
    public function setIncludeUnposted(\StructType\BooleanValue $includeUnposted = null)
    {
        if (is_null($includeUnposted) || (is_array($includeUnposted) && empty($includeUnposted))) {
            unset($this->IncludeUnposted);
        } else {
            $this->IncludeUnposted = $includeUnposted;
        }
        return $this;
    }
    /**
     * Get IncludeUnreleased value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getIncludeUnreleased()
    {
        return isset($this->IncludeUnreleased) ? $this->IncludeUnreleased : null;
    }
    /**
     * Set IncludeUnreleased value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $includeUnreleased
     * @return \StructType\AccountDetailsInquiry
     */
    public function setIncludeUnreleased(\StructType\BooleanValue $includeUnreleased = null)
    {
        if (is_null($includeUnreleased) || (is_array($includeUnreleased) && empty($includeUnreleased))) {
            unset($this->IncludeUnreleased);
        } else {
            $this->IncludeUnreleased = $includeUnreleased;
        }
        return $this;
    }
    /**
     * Get Ledger value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getLedger()
    {
        return isset($this->Ledger) ? $this->Ledger : null;
    }
    /**
     * Set Ledger value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $ledger
     * @return \StructType\AccountDetailsInquiry
     */
    public function setLedger(\StructType\StringValue $ledger = null)
    {
        if (is_null($ledger) || (is_array($ledger) && empty($ledger))) {
            unset($this->Ledger);
        } else {
            $this->Ledger = $ledger;
        }
        return $this;
    }
    /**
     * Get PeriodEndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getPeriodEndDate()
    {
        return isset($this->PeriodEndDate) ? $this->PeriodEndDate : null;
    }
    /**
     * Set PeriodEndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $periodEndDate
     * @return \StructType\AccountDetailsInquiry
     */
    public function setPeriodEndDate(\StructType\DateTimeValue $periodEndDate = null)
    {
        if (is_null($periodEndDate) || (is_array($periodEndDate) && empty($periodEndDate))) {
            unset($this->PeriodEndDate);
        } else {
            $this->PeriodEndDate = $periodEndDate;
        }
        return $this;
    }
    /**
     * Get PeriodStartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getPeriodStartDate()
    {
        return isset($this->PeriodStartDate) ? $this->PeriodStartDate : null;
    }
    /**
     * Set PeriodStartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $periodStartDate
     * @return \StructType\AccountDetailsInquiry
     */
    public function setPeriodStartDate(\StructType\DateTimeValue $periodStartDate = null)
    {
        if (is_null($periodStartDate) || (is_array($periodStartDate) && empty($periodStartDate))) {
            unset($this->PeriodStartDate);
        } else {
            $this->PeriodStartDate = $periodStartDate;
        }
        return $this;
    }
    /**
     * Get Results value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Results|null
     */
    public function getResults()
    {
        return isset($this->Results) ? $this->Results : null;
    }
    /**
     * Set Results value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Results $results
     * @return \StructType\AccountDetailsInquiry
     */
    public function setResults(\StructType\Results $results = null)
    {
        if (is_null($results) || (is_array($results) && empty($results))) {
            unset($this->Results);
        } else {
            $this->Results = $results;
        }
        return $this;
    }
    /**
     * Get Subaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getSubaccount()
    {
        return isset($this->Subaccount) ? $this->Subaccount : null;
    }
    /**
     * Set Subaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $subaccount
     * @return \StructType\AccountDetailsInquiry
     */
    public function setSubaccount(\StructType\StringValue $subaccount = null)
    {
        if (is_null($subaccount) || (is_array($subaccount) && empty($subaccount))) {
            unset($this->Subaccount);
        } else {
            $this->Subaccount = $subaccount;
        }
        return $this;
    }
    /**
     * Get ToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getToDate()
    {
        return isset($this->ToDate) ? $this->ToDate : null;
    }
    /**
     * Set ToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $toDate
     * @return \StructType\AccountDetailsInquiry
     */
    public function setToDate(\StructType\DateTimeValue $toDate = null)
    {
        if (is_null($toDate) || (is_array($toDate) && empty($toDate))) {
            unset($this->ToDate);
        } else {
            $this->ToDate = $toDate;
        }
        return $this;
    }
    /**
     * Get ToPeriod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getToPeriod()
    {
        return isset($this->ToPeriod) ? $this->ToPeriod : null;
    }
    /**
     * Set ToPeriod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $toPeriod
     * @return \StructType\AccountDetailsInquiry
     */
    public function setToPeriod(\StructType\StringValue $toPeriod = null)
    {
        if (is_null($toPeriod) || (is_array($toPeriod) && empty($toPeriod))) {
            unset($this->ToPeriod);
        } else {
            $this->ToPeriod = $toPeriod;
        }
        return $this;
    }
    /**
     * Get Turnover value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getTurnover()
    {
        return isset($this->Turnover) ? $this->Turnover : null;
    }
    /**
     * Set Turnover value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $turnover
     * @return \StructType\AccountDetailsInquiry
     */
    public function setTurnover(\StructType\DecimalValue $turnover = null)
    {
        if (is_null($turnover) || (is_array($turnover) && empty($turnover))) {
            unset($this->Turnover);
        } else {
            $this->Turnover = $turnover;
        }
        return $this;
    }
}
