<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Invoke ServiceType
 * @subpackage Services
 */
class Invoke extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Invoke
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Invoke $parameters
     * @return \StructType\InvokeResponse|bool
     */
    public function Invoke(\StructType\Invoke $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Invoke($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\InvokeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
