<?php
/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'GetList' => '\\StructType\\GetList',
            'Entity' => '\\StructType\\Entity',
            'LongValue' => '\\StructType\\LongValue',
            'ArrayOfCustomField' => '\\ArrayType\\ArrayOfCustomField',
            'CustomField' => '\\StructType\\CustomField',
            'GetListResponse' => '\\StructType\\GetListResponse',
            'ArrayOfEntity' => '\\ArrayType\\ArrayOfEntity',
            'Get' => '\\StructType\\Get',
            'GetResponse' => '\\StructType\\GetResponse',
            'Put' => '\\StructType\\Put',
            'PutResponse' => '\\StructType\\PutResponse',
            'GetCustomFieldSchema' => '\\StructType\\GetCustomFieldSchema',
            'GetCustomFieldSchemaResponse' => '\\StructType\\GetCustomFieldSchemaResponse',
            'SanityCheck' => '\\StructType\\SanityCheck',
            'SanityCheckResponse' => '\\StructType\\SanityCheckResponse',
            'Login' => '\\StructType\\Login',
            'LoginResponse' => '\\StructType\\LoginResponse',
            'Logout' => '\\StructType\\Logout',
            'LogoutResponse' => '\\StructType\\LogoutResponse',
            'SetBusinessDate' => '\\StructType\\SetBusinessDate',
            'SetBusinessDateResponse' => '\\StructType\\SetBusinessDateResponse',
            'GetProcessStatus' => '\\StructType\\GetProcessStatus',
            'InvokeResult' => '\\StructType\\InvokeResult',
            'GetProcessStatusResponse' => '\\StructType\\GetProcessStatusResponse',
            'ProcessResult' => '\\StructType\\ProcessResult',
            'Delete' => '\\StructType\\Delete',
            'DeleteResponse' => '\\StructType\\DeleteResponse',
            'Invoke' => '\\StructType\\Invoke',
            'Action' => '\\StructType\\Action',
            'InvokeResponse' => '\\StructType\\InvokeResponse',
            'GetFiles' => '\\StructType\\GetFiles',
            'GetFilesResponse' => '\\StructType\\GetFilesResponse',
            'ArrayOfFile' => '\\ArrayType\\ArrayOfFile',
            'File' => '\\StructType\\File',
            'PutFiles' => '\\StructType\\PutFiles',
            'PutFilesResponse' => '\\StructType\\PutFilesResponse',
            'StringSearch' => '\\StructType\\StringSearch',
            'DecimalSearch' => '\\StructType\\DecimalSearch',
            'DateTimeSearch' => '\\StructType\\DateTimeSearch',
            'BooleanSearch' => '\\StructType\\BooleanSearch',
            'IntSearch' => '\\StructType\\IntSearch',
            'LongSearch' => '\\StructType\\LongSearch',
            'ShortSearch' => '\\StructType\\ShortSearch',
            'ByteSearch' => '\\StructType\\ByteSearch',
            'DoubleSearch' => '\\StructType\\DoubleSearch',
            'GuidSearch' => '\\StructType\\GuidSearch',
            'StringValue' => '\\StructType\\StringValue',
            'DecimalValue' => '\\StructType\\DecimalValue',
            'DateTimeValue' => '\\StructType\\DateTimeValue',
            'BooleanValue' => '\\StructType\\BooleanValue',
            'IntValue' => '\\StructType\\IntValue',
            'ShortValue' => '\\StructType\\ShortValue',
            'ByteValue' => '\\StructType\\ByteValue',
            'DoubleValue' => '\\StructType\\DoubleValue',
            'GuidValue' => '\\StructType\\GuidValue',
            'CustomStringField' => '\\StructType\\CustomStringField',
            'StringSkip' => '\\StructType\\StringSkip',
            'StringReturn' => '\\StructType\\StringReturn',
            'CustomDecimalField' => '\\StructType\\CustomDecimalField',
            'DecimalSkip' => '\\StructType\\DecimalSkip',
            'DecimalReturn' => '\\StructType\\DecimalReturn',
            'CustomDateTimeField' => '\\StructType\\CustomDateTimeField',
            'DateTimeSkip' => '\\StructType\\DateTimeSkip',
            'DateTimeReturn' => '\\StructType\\DateTimeReturn',
            'CustomBooleanField' => '\\StructType\\CustomBooleanField',
            'BooleanSkip' => '\\StructType\\BooleanSkip',
            'BooleanReturn' => '\\StructType\\BooleanReturn',
            'CustomIntField' => '\\StructType\\CustomIntField',
            'IntSkip' => '\\StructType\\IntSkip',
            'IntReturn' => '\\StructType\\IntReturn',
            'CustomLongField' => '\\StructType\\CustomLongField',
            'LongSkip' => '\\StructType\\LongSkip',
            'LongReturn' => '\\StructType\\LongReturn',
            'CustomShortField' => '\\StructType\\CustomShortField',
            'ShortSkip' => '\\StructType\\ShortSkip',
            'ShortReturn' => '\\StructType\\ShortReturn',
            'CustomByteField' => '\\StructType\\CustomByteField',
            'ByteSkip' => '\\StructType\\ByteSkip',
            'ByteReturn' => '\\StructType\\ByteReturn',
            'CustomDoubleField' => '\\StructType\\CustomDoubleField',
            'DoubleSkip' => '\\StructType\\DoubleSkip',
            'DoubleReturn' => '\\StructType\\DoubleReturn',
            'CustomGuidField' => '\\StructType\\CustomGuidField',
            'GuidSkip' => '\\StructType\\GuidSkip',
            'GuidReturn' => '\\StructType\\GuidReturn',
            'EventTimeActivity' => '\\StructType\\EventTimeActivity',
            'StatementCycle' => '\\StructType\\StatementCycle',
            'TaskRelatedActivity' => '\\StructType\\TaskRelatedActivity',
            'BusinessAccountShippingContact' => '\\StructType\\BusinessAccountShippingContact',
            'CheckHistoryDetail' => '\\StructType\\CheckHistoryDetail',
            'SalesOrdersDiscountDetails' => '\\StructType\\SalesOrdersDiscountDetails',
            'ContactRoles' => '\\StructType\\ContactRoles',
            'PaymentOrderDetail' => '\\StructType\\PaymentOrderDetail',
            'VendorClass' => '\\StructType\\VendorClass',
            'Attributes' => '\\StructType\\Attributes',
            'CustomerPriceClass' => '\\StructType\\CustomerPriceClass',
            'ProjectBillingDetails' => '\\StructType\\ProjectBillingDetails',
            'KitStockComponent' => '\\StructType\\KitStockComponent',
            'ExpenseReceipt' => '\\StructType\\ExpenseReceipt',
            'TaxDetails' => '\\StructType\\TaxDetails',
            'Lead' => '\\StructType\\Lead',
            'Activities' => '\\StructType\\Activities',
            'Campaigns' => '\\StructType\\Campaigns',
            'Duplicates' => '\\StructType\\Duplicates',
            'MarketingLists' => '\\StructType\\MarketingLists',
            'Relations' => '\\StructType\\Relations',
            'AccountLocationContact' => '\\StructType\\AccountLocationContact',
            'StockItemWarehouseDetail' => '\\StructType\\StockItemWarehouseDetail',
            'Contact' => '\\StructType\\Contact',
            'Cases' => '\\StructType\\Cases',
            'Notifications' => '\\StructType\\Notifications',
            'Opportunities' => '\\StructType\\Opportunities',
            'ExpenseClaimAPDocument' => '\\StructType\\ExpenseClaimAPDocument',
            'TaskRelatedTask' => '\\StructType\\TaskRelatedTask',
            'ProFormaFinancialDetails' => '\\StructType\\ProFormaFinancialDetails',
            'CommonTask' => '\\StructType\\CommonTask',
            'CreditVerificationRules' => '\\StructType\\CreditVerificationRules',
            'ShippingZones' => '\\StructType\\ShippingZones',
            'ProjectEquipment' => '\\StructType\\ProjectEquipment',
            'Discount' => '\\StructType\\Discount',
            'CustomerPriceClasses' => '\\StructType\\CustomerPriceClasses',
            'Customers' => '\\StructType\\Customers',
            'DiscountBreakpoints' => '\\StructType\\DiscountBreakpoints',
            'ItemPriceClasses' => '\\StructType\\ItemPriceClasses',
            'Items' => '\\StructType\\Items',
            'Warehouses' => '\\StructType\\Warehouses',
            'ProjectGLAccount' => '\\StructType\\ProjectGLAccount',
            'DefaultTaskForGLAccounts' => '\\StructType\\DefaultTaskForGLAccounts',
            'InterBranchAccountMappingTransactionInSourceBranchDetail' => '\\StructType\\InterBranchAccountMappingTransactionInSourceBranchDetail',
            'PaymentApplicationHistoryDetail' => '\\StructType\\PaymentApplicationHistoryDetail',
            'PurchaseReceiptDetailAllocation' => '\\StructType\\PurchaseReceiptDetailAllocation',
            'Account' => '\\StructType\\Account',
            'ExpenseReceiptTaxDetails' => '\\StructType\\ExpenseReceiptTaxDetails',
            'BillToSettings' => '\\StructType\\BillToSettings',
            'ContractUsage' => '\\StructType\\ContractUsage',
            'BilledTransactions' => '\\StructType\\BilledTransactions',
            'UnbilledTransactions' => '\\StructType\\UnbilledTransactions',
            'BusinessAccountOpportunityDetail' => '\\StructType\\BusinessAccountOpportunityDetail',
            'ProjectTaskToCRMLink' => '\\StructType\\ProjectTaskToCRMLink',
            'DiscountBreakpointDetail' => '\\StructType\\DiscountBreakpointDetail',
            'PhysicalInventoryReviewDetail' => '\\StructType\\PhysicalInventoryReviewDetail',
            'ExpenseReceiptDetails' => '\\StructType\\ExpenseReceiptDetails',
            'ContactDuplicateDetail' => '\\StructType\\ContactDuplicateDetail',
            'ReminderDetail' => '\\StructType\\ReminderDetail',
            'ExternalCommitment' => '\\StructType\\ExternalCommitment',
            'SalesInvoiceDiscountDetails' => '\\StructType\\SalesInvoiceDiscountDetails',
            'AccountByPeriodRow' => '\\StructType\\AccountByPeriodRow',
            'ProjectTemplate' => '\\StructType\\ProjectTemplate',
            'Employees' => '\\StructType\\Employees',
            'Equipments' => '\\StructType\\Equipments',
            'CategoryStockItem' => '\\StructType\\CategoryStockItem',
            'ExpenseClaim' => '\\StructType\\ExpenseClaim',
            'ApprovalDetails' => '\\StructType\\ApprovalDetails',
            'Details' => '\\StructType\\Details',
            'TaxZoneDetail' => '\\StructType\\TaxZoneDetail',
            'Check' => '\\StructType\\Check',
            'History' => '\\StructType\\History',
            'EmailProcessing' => '\\StructType\\EmailProcessing',
            'Result' => '\\StructType\\Result',
            'ReportingGroup' => '\\StructType\\ReportingGroup',
            'PhysicalInventoryCount' => '\\StructType\\PhysicalInventoryCount',
            'Approval' => '\\StructType\\Approval',
            'ShopForRates' => '\\StructType\\ShopForRates',
            'ContactUserInfo' => '\\StructType\\ContactUserInfo',
            'Roles' => '\\StructType\\Roles',
            'JournalVoucher' => '\\StructType\\JournalVoucher',
            'GLTransactions' => '\\StructType\\GLTransactions',
            'SubItemStockItem' => '\\StructType\\SubItemStockItem',
            'SalesOrder' => '\\StructType\\SalesOrder',
            'DiscountDetails' => '\\StructType\\DiscountDetails',
            'Payments' => '\\StructType\\Payments',
            'Shipments' => '\\StructType\\Shipments',
            'DiscountItemDetail' => '\\StructType\\DiscountItemDetail',
            'AdjustmentDetail' => '\\StructType\\AdjustmentDetail',
            'DocContact' => '\\StructType\\DocContact',
            'Vendor' => '\\StructType\\Vendor',
            'Contacts' => '\\StructType\\Contacts',
            'PaymentInstructions' => '\\StructType\\PaymentInstructions',
            'RelationDetail' => '\\StructType\\RelationDetail',
            'ItemsDetails' => '\\StructType\\ItemsDetails',
            'ProFormaTaxDetail' => '\\StructType\\ProFormaTaxDetail',
            'ExpenseClaimDetails' => '\\StructType\\ExpenseClaimDetails',
            'Address' => '\\StructType\\Address',
            'CarrierCustomerAccount' => '\\StructType\\CarrierCustomerAccount',
            'Bill' => '\\StructType\\Bill',
            'Applications' => '\\StructType\\Applications',
            'SalesOrderDetailAllocation' => '\\StructType\\SalesOrderDetailAllocation',
            'AccountLocation' => '\\StructType\\AccountLocation',
            'JournalVoucherDetailAPDocumentToApply' => '\\StructType\\JournalVoucherDetailAPDocumentToApply',
            'AccountBySubaccountRow' => '\\StructType\\AccountBySubaccountRow',
            'Case' => '\\StructType\\_Case',
            'RelatedCases' => '\\StructType\\RelatedCases',
            'SalesPriceWorksheet' => '\\StructType\\SalesPriceWorksheet',
            'SalesPrices' => '\\StructType\\SalesPrices',
            'ReplenishmentParameterStockItem' => '\\StructType\\ReplenishmentParameterStockItem',
            'Project' => '\\StructType\\Project',
            'ActivityHistory' => '\\StructType\\ActivityHistory',
            'Balances' => '\\StructType\\Balances',
            'Invoices' => '\\StructType\\Invoices',
            'UnionLocals' => '\\StructType\\UnionLocals',
            'ProjectBudget' => '\\StructType\\ProjectBudget',
            'LotSerialClass' => '\\StructType\\LotSerialClass',
            'Segments' => '\\StructType\\Segments',
            'EventRelatedActivity' => '\\StructType\\EventRelatedActivity',
            'Customer' => '\\StructType\\Customer',
            'Salespersons' => '\\StructType\\Salespersons',
            'TransferOrderDetail' => '\\StructType\\TransferOrderDetail',
            'Allocations' => '\\StructType\\Allocations',
            'ChangeOrderRevenueBudget' => '\\StructType\\ChangeOrderRevenueBudget',
            'BillApplicationDetail' => '\\StructType\\BillApplicationDetail',
            'SalesPricesWorksheetDetail' => '\\StructType\\SalesPricesWorksheetDetail',
            'ShipViaFreightRate' => '\\StructType\\ShipViaFreightRate',
            'JournalVoucherDetailARDocumentToApply' => '\\StructType\\JournalVoucherDetailARDocumentToApply',
            'AccountByPeriodInquiry' => '\\StructType\\AccountByPeriodInquiry',
            'Results' => '\\StructType\\Results',
            'PurchaseReceipt' => '\\StructType\\PurchaseReceipt',
            'PaymentDetail' => '\\StructType\\PaymentDetail',
            'Tax' => '\\StructType\\Tax',
            'TaxSchedule' => '\\StructType\\TaxSchedule',
            'Zones' => '\\StructType\\Zones',
            'AccountDetailsInquiry' => '\\StructType\\AccountDetailsInquiry',
            'FinancialYearPeriodDetail' => '\\StructType\\FinancialYearPeriodDetail',
            'KitAssemblyStockComponentAllocation' => '\\StructType\\KitAssemblyStockComponentAllocation',
            'DuplicateDetail' => '\\StructType\\DuplicateDetail',
            'BusinessAccountCaseDetail' => '\\StructType\\BusinessAccountCaseDetail',
            'ProjectTemplateTask' => '\\StructType\\ProjectTemplateTask',
            'AccountDetailsRow' => '\\StructType\\AccountDetailsRow',
            'CashSale' => '\\StructType\\CashSale',
            'CustomerContact' => '\\StructType\\CustomerContact',
            'StockItem' => '\\StructType\\StockItem',
            'Boxes' => '\\StructType\\Boxes',
            'Categories' => '\\StructType\\Categories',
            'CrossReferences' => '\\StructType\\CrossReferences',
            'ReplenishmentParameters' => '\\StructType\\ReplenishmentParameters',
            'SubItems' => '\\StructType\\SubItems',
            'UOMConversions' => '\\StructType\\UOMConversions',
            'VendorDetails' => '\\StructType\\VendorDetails',
            'WarehouseDetails' => '\\StructType\\WarehouseDetails',
            'TaxScheduleDetail' => '\\StructType\\TaxScheduleDetail',
            'SalesPricesInquiry' => '\\StructType\\SalesPricesInquiry',
            'SalesPriceDetails' => '\\StructType\\SalesPriceDetails',
            'ProjectBillingAndAllocationSettings' => '\\StructType\\ProjectBillingAndAllocationSettings',
            'Commissions' => '\\StructType\\Commissions',
            'SalesPersons' => '\\StructType\\SalesPersons_1',
            'FinancialSettings' => '\\StructType\\FinancialSettings',
            'BillDetail' => '\\StructType\\BillDetail',
            'PurchaseReceiptDetail' => '\\StructType\\PurchaseReceiptDetail',
            'JournalTransactionDetail' => '\\StructType\\JournalTransactionDetail',
            'CustomerPaymentMethod' => '\\StructType\\CustomerPaymentMethod',
            'CompanyFinancialPeriod' => '\\StructType\\CompanyFinancialPeriod',
            'OpportunityDetail' => '\\StructType\\OpportunityDetail',
            'EmployeeSettings' => '\\StructType\\EmployeeSettings',
            'BusinessAccountMainContact' => '\\StructType\\BusinessAccountMainContact',
            'AccountSummaryInquiry' => '\\StructType\\AccountSummaryInquiry',
            'Carrier' => '\\StructType\\Carrier',
            'CustomerAccounts' => '\\StructType\\CustomerAccounts',
            'PlugInParameters' => '\\StructType\\PlugInParameters',
            'KitNonStockComponent' => '\\StructType\\KitNonStockComponent',
            'VendorPricesInquiry' => '\\StructType\\VendorPricesInquiry',
            'VendorPriceDetails' => '\\StructType\\VendorPriceDetails',
            'ProjectTask' => '\\StructType\\ProjectTask',
            'Attribute' => '\\StructType\\Attribute',
            'ActivityDetail' => '\\StructType\\ActivityDetail',
            'ShipmentOrderDetail' => '\\StructType\\ShipmentOrderDetail',
            'Warehouse' => '\\StructType\\Warehouse',
            'Locations' => '\\StructType\\Locations',
            'DefaultTaskForGLAccount' => '\\StructType\\DefaultTaskForGLAccount',
            'BusinessAccountOrder' => '\\StructType\\BusinessAccountOrder',
            'JournalVoucherGLTransaction' => '\\StructType\\JournalVoucherGLTransaction',
            'TaxDetail' => '\\StructType\\TaxDetail',
            'TaxZoneApplicableTaxDetail' => '\\StructType\\TaxZoneApplicableTaxDetail',
            'PurchaseOrderDetail' => '\\StructType\\PurchaseOrderDetail',
            'TaskTimeActivity' => '\\StructType\\TaskTimeActivity',
            'KitAssemblyStockComponent' => '\\StructType\\KitAssemblyStockComponent',
            'NonStockItem' => '\\StructType\\NonStockItem',
            'SalesCategories' => '\\StructType\\SalesCategories',
            'EmailProcessingRow' => '\\StructType\\EmailProcessingRow',
            'CustomerClass' => '\\StructType\\CustomerClass',
            'TrialBalance' => '\\StructType\\TrialBalance',
            'ShippingTerm' => '\\StructType\\ShippingTerm',
            'CustomerPaymentMethodDetail' => '\\StructType\\CustomerPaymentMethodDetail',
            'Totals' => '\\StructType\\Totals',
            'InventoryAllocationInquiry' => '\\StructType\\InventoryAllocationInquiry',
            'SalesPersonDetail' => '\\StructType\\SalesPersonDetail',
            'WarehouseLocation' => '\\StructType\\WarehouseLocation',
            'TimeEntry' => '\\StructType\\TimeEntry',
            'TransferOrderDetailAllocation' => '\\StructType\\TransferOrderDetailAllocation',
            'BusinessAccountDefaultLocationSetting' => '\\StructType\\BusinessAccountDefaultLocationSetting',
            'CreditCardProcessingDetail' => '\\StructType\\CreditCardProcessingDetail',
            'ShipToSettings' => '\\StructType\\ShipToSettings',
            'Email' => '\\StructType\\Email',
            'FinancialPeriod' => '\\StructType\\FinancialPeriod',
            'LotSerialClassSegment' => '\\StructType\\LotSerialClassSegment',
            'ExpenseClaimFinancialDetail' => '\\StructType\\ExpenseClaimFinancialDetail',
            'APDocuments' => '\\StructType\\APDocuments',
            'ProjectTemplateTaskProperties' => '\\StructType\\ProjectTemplateTaskProperties',
            'ProjectBilling' => '\\StructType\\ProjectBilling',
            'PhysicalInventoryCountDetail' => '\\StructType\\PhysicalInventoryCountDetail',
            'Salesperson' => '\\StructType\\Salesperson',
            'ShippingBox' => '\\StructType\\ShippingBox',
            'ItemClass' => '\\StructType\\ItemClass',
            'ItemSalesCategory' => '\\StructType\\ItemSalesCategory',
            'Members' => '\\StructType\\Members',
            'StockItemVendorDetail' => '\\StructType\\StockItemVendorDetail',
            'ShipmentDetail' => '\\StructType\\ShipmentDetail',
            'ItemSalesCategoryMember' => '\\StructType\\ItemSalesCategoryMember',
            'ChangeOrder' => '\\StructType\\ChangeOrder',
            'Commitments' => '\\StructType\\Commitments',
            'CostBudget' => '\\StructType\\CostBudget',
            'RevenueBudget' => '\\StructType\\RevenueBudget',
            'BusinessAccountContact' => '\\StructType\\BusinessAccountContact',
            'OpportunityProduct' => '\\StructType\\OpportunityProduct',
            'PurchaseSettings' => '\\StructType\\PurchaseSettings',
            'InventoryItemUOMConversion' => '\\StructType\\InventoryItemUOMConversion',
            'SalesInvoiceDetail' => '\\StructType\\SalesInvoiceDetail',
            'UnionLocal' => '\\StructType\\UnionLocal',
            'TimeAndMaterial' => '\\StructType\\TimeAndMaterial',
            'SalesInvoiceTotals' => '\\StructType\\SalesInvoiceTotals',
            'Opportunity' => '\\StructType\\Opportunity',
            'Discounts' => '\\StructType\\Discounts',
            'Products' => '\\StructType\\Products',
            'LaborCostRate' => '\\StructType\\LaborCostRate',
            'EmployeeDelegate' => '\\StructType\\EmployeeDelegate',
            'Event' => '\\StructType\\Event',
            'Attendees' => '\\StructType\\Attendees',
            'RelatedActivities' => '\\StructType\\RelatedActivities',
            'ProjectTaskBillingAndAllocationSettings' => '\\StructType\\ProjectTaskBillingAndAllocationSettings',
            'WorkClassCompensationCode' => '\\StructType\\WorkClassCompensationCode',
            'SalesOrderShipment' => '\\StructType\\SalesOrderShipment',
            'ProjectTransactionDetail' => '\\StructType\\ProjectTransactionDetail',
            'Invoice' => '\\StructType\\Invoice',
            'ApplicationsCreditMemo' => '\\StructType\\ApplicationsCreditMemo',
            'ApplicationsDefault' => '\\StructType\\ApplicationsDefault',
            'Task' => '\\StructType\\Task',
            'RelatedTasks' => '\\StructType\\RelatedTasks',
            'SalesInvoiceTaxDetail' => '\\StructType\\SalesInvoiceTaxDetail',
            'CustomerSalesPerson' => '\\StructType\\CustomerSalesPerson',
            'VendorPriceDetail' => '\\StructType\\VendorPriceDetail',
            'ManageFinancialPeriods' => '\\StructType\\ManageFinancialPeriods',
            'BusinessAccountClassAttributeDetail' => '\\StructType\\BusinessAccountClassAttributeDetail',
            'SalesInvoiceSalesPersonDetail' => '\\StructType\\SalesInvoiceSalesPersonDetail',
            'KitSpecification' => '\\StructType\\KitSpecification',
            'NonStockComponents' => '\\StructType\\NonStockComponents',
            'StockComponents' => '\\StructType\\StockComponents',
            'ProgressBilling' => '\\StructType\\ProgressBilling',
            'ExpenseClaimTaxDetail' => '\\StructType\\ExpenseClaimTaxDetail',
            'EmployeeFinancialSettings' => '\\StructType\\EmployeeFinancialSettings',
            'InventorySummaryInquiry' => '\\StructType\\InventorySummaryInquiry',
            'KitAssembly' => '\\StructType\\KitAssembly',
            'CaseDetail' => '\\StructType\\CaseDetail',
            'AccountGroup' => '\\StructType\\AccountGroup',
            'Employee' => '\\StructType\\Employee',
            'Delegates' => '\\StructType\\Delegates',
            'EmploymentHistory' => '\\StructType\\EmploymentHistory',
            'OpportunityContact' => '\\StructType\\OpportunityContact',
            'ShipVia' => '\\StructType\\ShipVia',
            'FreightRates' => '\\StructType\\FreightRates',
            'Packages' => '\\StructType\\Packages',
            'ContractUsageTransactionDetail' => '\\StructType\\ContractUsageTransactionDetail',
            'InventoryItemCrossReference' => '\\StructType\\InventoryItemCrossReference',
            'ProjectProFormaDetails' => '\\StructType\\ProjectProFormaDetails',
            'AttributeDetail' => '\\StructType\\AttributeDetail',
            'ShipmentPackage' => '\\StructType\\ShipmentPackage',
            'InvoiceApplicationsCreditMemo' => '\\StructType\\InvoiceApplicationsCreditMemo',
            'InventorySummaryRow' => '\\StructType\\InventorySummaryRow',
            'AccountSummaryRow' => '\\StructType\\AccountSummaryRow',
            'ItemPriceClassesDetails' => '\\StructType\\ItemPriceClassesDetails',
            'CheckDetail' => '\\StructType\\CheckDetail',
            'ShippingInstructions' => '\\StructType\\ShippingInstructions',
            'ProjectTaskProperties' => '\\StructType\\ProjectTaskProperties',
            'AllocationRule' => '\\StructType\\AllocationRule',
            'UnitsOfMeasure' => '\\StructType\\UnitsOfMeasure',
            'CashSaleDetail' => '\\StructType\\CashSaleDetail',
            'InterBranchAccountMappingTransactionInDestinationBranchDetail' => '\\StructType\\InterBranchAccountMappingTransactionInDestinationBranchDetail',
            'AccountBySubaccountInquiry' => '\\StructType\\AccountBySubaccountInquiry',
            'VisibilitySettings' => '\\StructType\\VisibilitySettings',
            'Payment' => '\\StructType\\Payment',
            'ApplicationHistory' => '\\StructType\\ApplicationHistory',
            'CreditCardProcessingInfo' => '\\StructType\\CreditCardProcessingInfo',
            'DocumentsToApply' => '\\StructType\\DocumentsToApply',
            'OrdersToApply' => '\\StructType\\OrdersToApply',
            'DiscountItemPriceClassesDetail' => '\\StructType\\DiscountItemPriceClassesDetail',
            'VoucherEntryCode' => '\\StructType\\VoucherEntryCode',
            'SalesInvoiceApplicationInvoice' => '\\StructType\\SalesInvoiceApplicationInvoice',
            'TrialBalanceDetail' => '\\StructType\\TrialBalanceDetail',
            'ItemClassAtrribute' => '\\StructType\\ItemClassAtrribute',
            'AttributeValue' => '\\StructType\\AttributeValue',
            'DiscountWarehouseDetail' => '\\StructType\\DiscountWarehouseDetail',
            'ProjectEmployee' => '\\StructType\\ProjectEmployee',
            'InventoryReceiptDetailAllocation' => '\\StructType\\InventoryReceiptDetailAllocation',
            'DiscountCode' => '\\StructType\\DiscountCode',
            'FOBPoint' => '\\StructType\\FOBPoint',
            'BusinessAccountPaymentInstructionDetail' => '\\StructType\\BusinessAccountPaymentInstructionDetail',
            'EmploymentHistoryRecord' => '\\StructType\\EmploymentHistoryRecord',
            'Adjustment' => '\\StructType\\Adjustment',
            'OpportunityDiscount' => '\\StructType\\OpportunityDiscount',
            'JournalTransaction' => '\\StructType\\JournalTransaction',
            'InterBranchAccountMapping' => '\\StructType\\InterBranchAccountMapping',
            'TransactionsInDestinationBranch' => '\\StructType\\TransactionsInDestinationBranch',
            'TransactionsInSourceBranch' => '\\StructType\\TransactionsInSourceBranch',
            'BusinessAccountActivityDetail' => '\\StructType\\BusinessAccountActivityDetail',
            'FinancialPeriodDetail' => '\\StructType\\FinancialPeriodDetail',
            'InventoryReceipt' => '\\StructType\\InventoryReceipt',
            'AttributeDefinition' => '\\StructType\\AttributeDefinition',
            'Values' => '\\StructType\\Values',
            'ProjectActivity' => '\\StructType\\ProjectActivity',
            'CaseRelatedCase' => '\\StructType\\CaseRelatedCase',
            'SalesInvoiceCommissions' => '\\StructType\\SalesInvoiceCommissions',
            'ChangeOrderClass' => '\\StructType\\ChangeOrderClass',
            'AttributeDefinitionValue' => '\\StructType\\AttributeDefinitionValue',
            'BusinessAccountContract' => '\\StructType\\BusinessAccountContract',
            'ManageFinancialPeriodsDetail' => '\\StructType\\ManageFinancialPeriodsDetail',
            'ChangeOrderCommitment' => '\\StructType\\ChangeOrderCommitment',
            'SalesInvoiceApplicationCreditMemo' => '\\StructType\\SalesInvoiceApplicationCreditMemo',
            'ProjectUnionLocal' => '\\StructType\\ProjectUnionLocal',
            'SalesInvoiceFinancialDetails' => '\\StructType\\SalesInvoiceFinancialDetails',
            'InvoiceDetail' => '\\StructType\\InvoiceDetail',
            'ProFormaInvoice' => '\\StructType\\ProFormaInvoice',
            'CostCode' => '\\StructType\\CostCode',
            'BusinessAccountMarketingListDetail' => '\\StructType\\BusinessAccountMarketingListDetail',
            'SalesInvoiceFreightDetail' => '\\StructType\\SalesInvoiceFreightDetail',
            'TimeActivity' => '\\StructType\\TimeActivity',
            'CampaignDetail' => '\\StructType\\CampaignDetail',
            'SalesInvoice' => '\\StructType\\SalesInvoice',
            'ApplicationsInvoice' => '\\StructType\\ApplicationsInvoice',
            'FreightDetails' => '\\StructType\\FreightDetails',
            'SalesOrderDetail' => '\\StructType\\SalesOrderDetail',
            'BusinessAccount' => '\\StructType\\BusinessAccount',
            'Contracts' => '\\StructType\\Contracts',
            'Orders' => '\\StructType\\Orders',
            'TaxZone' => '\\StructType\\TaxZone',
            'ApplicableTaxes' => '\\StructType\\ApplicableTaxes',
            'TaxCategoryTaxDetail' => '\\StructType\\TaxCategoryTaxDetail',
            'InventoryAllocationRow' => '\\StructType\\InventoryAllocationRow',
            'SalesPriceDetail' => '\\StructType\\SalesPriceDetail',
            'Subaccount' => '\\StructType\\Subaccount',
            'CarrierPluginParameter' => '\\StructType\\CarrierPluginParameter',
            'ProjectProperties' => '\\StructType\\ProjectProperties',
            'Currency' => '\\StructType\\Currency',
            'NonStockItemSalesCategory' => '\\StructType\\NonStockItemSalesCategory',
            'CaseActivityDetail' => '\\StructType\\CaseActivityDetail',
            'EventAttendee' => '\\StructType\\EventAttendee',
            'Shipment' => '\\StructType\\Shipment',
            'BillTaxDetail' => '\\StructType\\BillTaxDetail',
            'InvoiceTaxDetail' => '\\StructType\\InvoiceTaxDetail',
            'PaymentMethodAllowedCashAccountDetail' => '\\StructType\\PaymentMethodAllowedCashAccountDetail',
            'DiscountCustomerPriceClassesDetail' => '\\StructType\\DiscountCustomerPriceClassesDetail',
            'JournalVoucherDetail' => '\\StructType\\JournalVoucherDetail',
            'APDocumentsToApply' => '\\StructType\\APDocumentsToApply',
            'ARDocumentsToApply' => '\\StructType\\ARDocumentsToApply',
            'KitAssemblyAllocation' => '\\StructType\\KitAssemblyAllocation',
            'CustomerLocation' => '\\StructType\\CustomerLocation',
            'TaxCategory' => '\\StructType\\TaxCategory',
            'ChangeOrderCostBudget' => '\\StructType\\ChangeOrderCostBudget',
            'FinancialYear' => '\\StructType\\FinancialYear',
            'ShippingTermDetail' => '\\StructType\\ShippingTermDetail',
            'ProjectBillingRules' => '\\StructType\\ProjectBillingRules',
            'ContactNotification' => '\\StructType\\ContactNotification',
            'PaymentMethodProcessingCenterDetail' => '\\StructType\\PaymentMethodProcessingCenterDetail',
            'ProjectTransaction' => '\\StructType\\ProjectTransaction',
            'ItemWarehouse' => '\\StructType\\ItemWarehouse',
            'Activity' => '\\StructType\\Activity',
            'ProjectBalance' => '\\StructType\\ProjectBalance',
            'ShippingSettings' => '\\StructType\\ShippingSettings',
            'TransferOrder' => '\\StructType\\TransferOrder',
            'ProjectTaskDefaultValues' => '\\StructType\\ProjectTaskDefaultValues',
            'ShipmentDetailAllocation' => '\\StructType\\ShipmentDetailAllocation',
            'DiscountCustomerDetail' => '\\StructType\\DiscountCustomerDetail',
            'ReportingSettings' => '\\StructType\\ReportingSettings',
            'ReportingGroups' => '\\StructType\\ReportingGroups',
            'PurchaseOrder' => '\\StructType\\PurchaseOrder',
            'VendorPriceWorksheetDetail' => '\\StructType\\VendorPriceWorksheetDetail',
            'BusinessAccountLocation' => '\\StructType\\BusinessAccountLocation',
            'InvoiceApplicationsDefault' => '\\StructType\\InvoiceApplicationsDefault',
            'InvoiceDiscountDetail' => '\\StructType\\InvoiceDiscountDetail',
            'KitAssemblyNonStockComponent' => '\\StructType\\KitAssemblyNonStockComponent',
            'VendorPriceWorksheet' => '\\StructType\\VendorPriceWorksheet',
            'VendorSalesPrices' => '\\StructType\\VendorSalesPrices',
            'OpportunityTaxDetail' => '\\StructType\\OpportunityTaxDetail',
            'PaymentMethod' => '\\StructType\\PaymentMethod',
            'AllowedCashAccounts' => '\\StructType\\AllowedCashAccounts',
            'ProcessingCenters' => '\\StructType\\ProcessingCenters',
            'BoxStockItem' => '\\StructType\\BoxStockItem',
            'NonStockItemVendorDetail' => '\\StructType\\NonStockItemVendorDetail',
            'NonStockItemAttribute' => '\\StructType\\NonStockItemAttribute',
            'PurchaseOrderTaxDetail' => '\\StructType\\PurchaseOrderTaxDetail',
            'PhysicalInventoryReview' => '\\StructType\\PhysicalInventoryReview',
            'InventoryReceiptDetail' => '\\StructType\\InventoryReceiptDetail',
            'MarketingListDetail' => '\\StructType\\MarketingListDetail',
            'SubmitExpenseReceipt' => '\\StructType\\SubmitExpenseReceipt',
            'ApproveExpenseReceipt' => '\\StructType\\ApproveExpenseReceipt',
            'RejectExpenseReceipt' => '\\StructType\\RejectExpenseReceipt',
            'PutOnHoldExpenseReceipt' => '\\StructType\\PutOnHoldExpenseReceipt',
            'ClaimExpenseReceipt' => '\\StructType\\ClaimExpenseReceipt',
            'CheckLeadForDuplicates' => '\\StructType\\CheckLeadForDuplicates',
            'CloseLeadAsDuplicate' => '\\StructType\\CloseLeadAsDuplicate',
            'ConvertLeadToBAccount' => '\\StructType\\ConvertLeadToBAccount',
            'ConvertLeadToContact' => '\\StructType\\ConvertLeadToContact',
            'ConvertLeadToOpportunity' => '\\StructType\\ConvertLeadToOpportunity',
            'ValidateLeadAddress' => '\\StructType\\ValidateLeadAddress',
            'MarkLeadAsValidated' => '\\StructType\\MarkLeadAsValidated',
            'CheckForContactDuplicates' => '\\StructType\\CheckForContactDuplicates',
            'ConvertContactToBusinessAccount' => '\\StructType\\ConvertContactToBusinessAccount',
            'CopyFromCompany' => '\\StructType\\CopyFromCompany',
            'MarkContactAsValidated' => '\\StructType\\MarkContactAsValidated',
            'ValidateContactAddress' => '\\StructType\\ValidateContactAddress',
            'CloseContactAsDuplicate' => '\\StructType\\CloseContactAsDuplicate',
            'UpdateDiscounts' => '\\StructType\\UpdateDiscounts',
            'ApproveExpenseClaim' => '\\StructType\\ApproveExpenseClaim',
            'RejectExpenseClaim' => '\\StructType\\RejectExpenseClaim',
            'SubmitExpenseClaim' => '\\StructType\\SubmitExpenseClaim',
            'ReleaseExpenseClaim' => '\\StructType\\ReleaseExpenseClaim',
            'PutOnHoldExpenseClaim' => '\\StructType\\PutOnHoldExpenseClaim',
            'ReleaseCheck' => '\\StructType\\ReleaseCheck',
            'ProcessEmailProcessing' => '\\StructType\\ProcessEmailProcessing',
            'ProcessAllEmailProcessing' => '\\StructType\\ProcessAllEmailProcessing',
            'ReleaseJournalVoucher' => '\\StructType\\ReleaseJournalVoucher',
            'CancelSalesOrder' => '\\StructType\\CancelSalesOrder',
            'ReopenSalesOrder' => '\\StructType\\ReopenSalesOrder',
            'PrepareSalesInvoice' => '\\StructType\\PrepareSalesInvoice',
            'OpenSalesOrder' => '\\StructType\\OpenSalesOrder',
            'ReleaseFromCreditHoldSalesOrder' => '\\StructType\\ReleaseFromCreditHoldSalesOrder',
            'SalesOrderAddInvoice' => '\\StructType\\SalesOrderAddInvoice',
            'SalesOrderAddStockItem' => '\\StructType\\SalesOrderAddStockItem',
            'SalesOrderCreatePurchaseOrder' => '\\StructType\\SalesOrderCreatePurchaseOrder',
            'SalesOrderCreateReceipt' => '\\StructType\\SalesOrderCreateReceipt',
            'SalesOrderCreateShipment' => '\\StructType\\SalesOrderCreateShipment',
            'AutoRecalculateDiscounts' => '\\StructType\\AutoRecalculateDiscounts',
            'ReleaseBill' => '\\StructType\\ReleaseBill',
            'ReverseBill' => '\\StructType\\ReverseBill',
            'ReleaseCase' => '\\StructType\\ReleaseCase',
            'TakeCase' => '\\StructType\\TakeCase',
            'AssignCase' => '\\StructType\\AssignCase',
            'ReleaseSalesPriceWorksheet' => '\\StructType\\ReleaseSalesPriceWorksheet',
            'RunProjectAllocation' => '\\StructType\\RunProjectAllocation',
            'ValidateProjectBalance' => '\\StructType\\ValidateProjectBalance',
            'RunProjectBilling' => '\\StructType\\RunProjectBilling',
            'ApproveProject' => '\\StructType\\ApproveProject',
            'RejectProject' => '\\StructType\\RejectProject',
            'LockProjectBudget' => '\\StructType\\LockProjectBudget',
            'UnlockProjectBudget' => '\\StructType\\UnlockProjectBudget',
            'LockProjectCommitments' => '\\StructType\\LockProjectCommitments',
            'UnlockProjectCommitments' => '\\StructType\\UnlockProjectCommitments',
            'ChangeProjectID' => '\\StructType\\ChangeProjectID',
            'ReleasePurchaseReceipt' => '\\StructType\\ReleasePurchaseReceipt',
            'CreateAPBill' => '\\StructType\\CreateAPBill',
            'ReleaseCashSale' => '\\StructType\\ReleaseCashSale',
            'UpdateStandardCostStockItem' => '\\StructType\\UpdateStandardCostStockItem',
            'UpdateStandardCostNonStockItem' => '\\StructType\\UpdateStandardCostNonStockItem',
            'TrialBalanceProcess' => '\\StructType\\TrialBalanceProcess',
            'TrialBalanceProcessAll' => '\\StructType\\TrialBalanceProcessAll',
            'ReleaseTrialBalance' => '\\StructType\\ReleaseTrialBalance',
            'CompleteTimeEntry' => '\\StructType\\CompleteTimeEntry',
            'OpenTimeEntry' => '\\StructType\\OpenTimeEntry',
            'SendEmail' => '\\StructType\\SendEmail',
            'CreateContactFromEmail' => '\\StructType\\CreateContactFromEmail',
            'CreateEventFromEmail' => '\\StructType\\CreateEventFromEmail',
            'CreateLeadFromEmail' => '\\StructType\\CreateLeadFromEmail',
            'CreateCaseFromEmail' => '\\StructType\\CreateCaseFromEmail',
            'CreateTaskFromEmail' => '\\StructType\\CreateTaskFromEmail',
            'RestoreDeletedEmail' => '\\StructType\\RestoreDeletedEmail',
            'RestoreArchivedEmail' => '\\StructType\\RestoreArchivedEmail',
            'ProcessEmail' => '\\StructType\\ProcessEmail',
            'DownloadEmlFileEmail' => '\\StructType\\DownloadEmlFileEmail',
            'CancelSendingEmail' => '\\StructType\\CancelSendingEmail',
            'ArchiveEmail' => '\\StructType\\ArchiveEmail',
            'LinkEntityToEmail' => '\\StructType\\LinkEntityToEmail',
            'GeneratePeriods' => '\\StructType\\GeneratePeriods',
            'ProjectBillingProcess' => '\\StructType\\ProjectBillingProcess',
            'ProjectBillingProcessAll' => '\\StructType\\ProjectBillingProcessAll',
            'ReleaseChangeOrder' => '\\StructType\\ReleaseChangeOrder',
            'ApproveChangeOrder' => '\\StructType\\ApproveChangeOrder',
            'RejectChangeOrder' => '\\StructType\\RejectChangeOrder',
            'EmailChangeOrder' => '\\StructType\\EmailChangeOrder',
            'ReverseChangeOrder' => '\\StructType\\ReverseChangeOrder',
            'CreateAccountFromOpportunity' => '\\StructType\\CreateAccountFromOpportunity',
            'CreateContactFromOpportunity' => '\\StructType\\CreateContactFromOpportunity',
            'CreateOpportunityInvoice' => '\\StructType\\CreateOpportunityInvoice',
            'CreateOpportunitySalesOrder' => '\\StructType\\CreateOpportunitySalesOrder',
            'AcceptInvitationEvent' => '\\StructType\\AcceptInvitationEvent',
            'CancelActivityEvent' => '\\StructType\\CancelActivityEvent',
            'CompleteEvent' => '\\StructType\\CompleteEvent',
            'CompleteAndFollowUpEvent' => '\\StructType\\CompleteAndFollowUpEvent',
            'ExportCardEvent' => '\\StructType\\ExportCardEvent',
            'RejectInvitationEvent' => '\\StructType\\RejectInvitationEvent',
            'InviteAllEvent' => '\\StructType\\InviteAllEvent',
            'InviteEvent' => '\\StructType\\InviteEvent',
            'LinkEntityToEvent' => '\\StructType\\LinkEntityToEvent',
            'ReleaseInvoice' => '\\StructType\\ReleaseInvoice',
            'ReverseInvoice' => '\\StructType\\ReverseInvoice',
            'CompleteTask' => '\\StructType\\CompleteTask',
            'CompleteAndFollowUpTask' => '\\StructType\\CompleteAndFollowUpTask',
            'CancelActivityTask' => '\\StructType\\CancelActivityTask',
            'LinkEntityToTask' => '\\StructType\\LinkEntityToTask',
            'ProcessManageFinancialPeriods' => '\\StructType\\ProcessManageFinancialPeriods',
            'ProcessAllManageFinancialPeriods' => '\\StructType\\ProcessAllManageFinancialPeriods',
            'ReleaseKitAssembly' => '\\StructType\\ReleaseKitAssembly',
            'ChangeEmployeeID' => '\\StructType\\ChangeEmployeeID',
            'CaptureCreditCardPayment' => '\\StructType\\CaptureCreditCardPayment',
            'ReleasePayment' => '\\StructType\\ReleasePayment',
            'VoidPayment' => '\\StructType\\VoidPayment',
            'PaymentLoadDocuments' => '\\StructType\\PaymentLoadDocuments',
            'PaymentLoadOrders' => '\\StructType\\PaymentLoadOrders',
            'ReleaseAdjustment' => '\\StructType\\ReleaseAdjustment',
            'ReleaseJournalTransaction' => '\\StructType\\ReleaseJournalTransaction',
            'ReleaseInventoryReceipt' => '\\StructType\\ReleaseInventoryReceipt',
            'ReleaseProFormaInvoice' => '\\StructType\\ReleaseProFormaInvoice',
            'ApproveProFormaInvoice' => '\\StructType\\ApproveProFormaInvoice',
            'RejectProFormaInvoice' => '\\StructType\\RejectProFormaInvoice',
            'EmailProFormaInvoice' => '\\StructType\\EmailProFormaInvoice',
            'ChangeCostCodeID' => '\\StructType\\ChangeCostCodeID',
            'ReleaseSalesInvoice' => '\\StructType\\ReleaseSalesInvoice',
            'SalesInvoiceAddOrder' => '\\StructType\\SalesInvoiceAddOrder',
            'SalesInvoiceAutoApply' => '\\StructType\\SalesInvoiceAutoApply',
            'ConvertBusinessAccountToCustomer' => '\\StructType\\ConvertBusinessAccountToCustomer',
            'ConvertBusinessAccountToVendor' => '\\StructType\\ConvertBusinessAccountToVendor',
            'MarkBusinessAccountAsValidated' => '\\StructType\\MarkBusinessAccountAsValidated',
            'ValidateBusinessAccountAddresses' => '\\StructType\\ValidateBusinessAccountAddresses',
            'ChangeBusinessAccountID' => '\\StructType\\ChangeBusinessAccountID',
            'CheckForBusinessAccountDuplicates' => '\\StructType\\CheckForBusinessAccountDuplicates',
            'ConfirmShipment' => '\\StructType\\ConfirmShipment',
            'CorrectShipment' => '\\StructType\\CorrectShipment',
            'UpdateIN' => '\\StructType\\UpdateIN',
            'PrepareInvoice' => '\\StructType\\PrepareInvoice',
            'ReleaseTransactions' => '\\StructType\\ReleaseTransactions',
            'CompleteActivity' => '\\StructType\\CompleteActivity',
            'LinkEntityToActivity' => '\\StructType\\LinkEntityToActivity',
            'ReleaseTransferOrder' => '\\StructType\\ReleaseTransferOrder',
            'EnterPOReceipt' => '\\StructType\\EnterPOReceipt',
            'EnterAPBill' => '\\StructType\\EnterAPBill',
            'ReleaseVendorPriceWorksheet' => '\\StructType\\ReleaseVendorPriceWorksheet',
            'CancelPhysicalInventory' => '\\StructType\\CancelPhysicalInventory',
            'CompletePhysicalInventory' => '\\StructType\\CompletePhysicalInventory',
            'FinishCountingPhysicalInventory' => '\\StructType\\FinishCountingPhysicalInventory',
        );
    }
}
