<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WarehouseDetails StructType
 * @subpackage Structs
 */
class WarehouseDetails extends AbstractStructBase
{
    /**
     * The StockItemWarehouseDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StockItemWarehouseDetail[]
     */
    public $StockItemWarehouseDetail;
    /**
     * Constructor method for WarehouseDetails
     * @uses WarehouseDetails::setStockItemWarehouseDetail()
     * @param \StructType\StockItemWarehouseDetail[] $stockItemWarehouseDetail
     */
    public function __construct(array $stockItemWarehouseDetail = array())
    {
        $this
            ->setStockItemWarehouseDetail($stockItemWarehouseDetail);
    }
    /**
     * Get StockItemWarehouseDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StockItemWarehouseDetail[]|null
     */
    public function getStockItemWarehouseDetail()
    {
        return isset($this->StockItemWarehouseDetail) ? $this->StockItemWarehouseDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setStockItemWarehouseDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStockItemWarehouseDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStockItemWarehouseDetailForArrayConstraintsFromSetStockItemWarehouseDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $warehouseDetailsStockItemWarehouseDetailItem) {
            // validation for constraint: itemType
            if (!$warehouseDetailsStockItemWarehouseDetailItem instanceof \StructType\StockItemWarehouseDetail) {
                $invalidValues[] = is_object($warehouseDetailsStockItemWarehouseDetailItem) ? get_class($warehouseDetailsStockItemWarehouseDetailItem) : sprintf('%s(%s)', gettype($warehouseDetailsStockItemWarehouseDetailItem), var_export($warehouseDetailsStockItemWarehouseDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The StockItemWarehouseDetail property can only contain items of type \StructType\StockItemWarehouseDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set StockItemWarehouseDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\StockItemWarehouseDetail[] $stockItemWarehouseDetail
     * @return \StructType\WarehouseDetails
     */
    public function setStockItemWarehouseDetail(array $stockItemWarehouseDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($stockItemWarehouseDetailArrayErrorMessage = self::validateStockItemWarehouseDetailForArrayConstraintsFromSetStockItemWarehouseDetail($stockItemWarehouseDetail))) {
            throw new \InvalidArgumentException($stockItemWarehouseDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($stockItemWarehouseDetail) || (is_array($stockItemWarehouseDetail) && empty($stockItemWarehouseDetail))) {
            unset($this->StockItemWarehouseDetail);
        } else {
            $this->StockItemWarehouseDetail = $stockItemWarehouseDetail;
        }
        return $this;
    }
    /**
     * Add item to StockItemWarehouseDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\StockItemWarehouseDetail $item
     * @return \StructType\WarehouseDetails
     */
    public function addToStockItemWarehouseDetail(\StructType\StockItemWarehouseDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StockItemWarehouseDetail) {
            throw new \InvalidArgumentException(sprintf('The StockItemWarehouseDetail property can only contain items of type \StructType\StockItemWarehouseDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->StockItemWarehouseDetail[] = $item;
        return $this;
    }
}
