<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxDetails StructType
 * @subpackage Structs
 */
class TaxDetails extends AbstractStructBase
{
    /**
     * The ExpenseReceiptTaxDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ExpenseReceiptTaxDetails[]
     */
    public $ExpenseReceiptTaxDetails;
    /**
     * The ExpenseClaimTaxDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ExpenseClaimTaxDetail[]
     */
    public $ExpenseClaimTaxDetail;
    /**
     * The TaxDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TaxDetail[]
     */
    public $TaxDetail;
    /**
     * The BillTaxDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BillTaxDetail[]
     */
    public $BillTaxDetail;
    /**
     * The OpportunityTaxDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OpportunityTaxDetail[]
     */
    public $OpportunityTaxDetail;
    /**
     * The InvoiceTaxDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\InvoiceTaxDetail[]
     */
    public $InvoiceTaxDetail;
    /**
     * The ProFormaTaxDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProFormaTaxDetail[]
     */
    public $ProFormaTaxDetail;
    /**
     * The SalesInvoiceTaxDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SalesInvoiceTaxDetail[]
     */
    public $SalesInvoiceTaxDetail;
    /**
     * The PurchaseOrderTaxDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PurchaseOrderTaxDetail[]
     */
    public $PurchaseOrderTaxDetail;
    /**
     * Constructor method for TaxDetails
     * @uses TaxDetails::setExpenseReceiptTaxDetails()
     * @uses TaxDetails::setExpenseClaimTaxDetail()
     * @uses TaxDetails::setTaxDetail()
     * @uses TaxDetails::setBillTaxDetail()
     * @uses TaxDetails::setOpportunityTaxDetail()
     * @uses TaxDetails::setInvoiceTaxDetail()
     * @uses TaxDetails::setProFormaTaxDetail()
     * @uses TaxDetails::setSalesInvoiceTaxDetail()
     * @uses TaxDetails::setPurchaseOrderTaxDetail()
     * @param \StructType\ExpenseReceiptTaxDetails[] $expenseReceiptTaxDetails
     * @param \StructType\ExpenseClaimTaxDetail[] $expenseClaimTaxDetail
     * @param \StructType\TaxDetail[] $taxDetail
     * @param \StructType\BillTaxDetail[] $billTaxDetail
     * @param \StructType\OpportunityTaxDetail[] $opportunityTaxDetail
     * @param \StructType\InvoiceTaxDetail[] $invoiceTaxDetail
     * @param \StructType\ProFormaTaxDetail[] $proFormaTaxDetail
     * @param \StructType\SalesInvoiceTaxDetail[] $salesInvoiceTaxDetail
     * @param \StructType\PurchaseOrderTaxDetail[] $purchaseOrderTaxDetail
     */
    public function __construct(array $expenseReceiptTaxDetails = array(), array $expenseClaimTaxDetail = array(), array $taxDetail = array(), array $billTaxDetail = array(), array $opportunityTaxDetail = array(), array $invoiceTaxDetail = array(), array $proFormaTaxDetail = array(), array $salesInvoiceTaxDetail = array(), array $purchaseOrderTaxDetail = array())
    {
        $this
            ->setExpenseReceiptTaxDetails($expenseReceiptTaxDetails)
            ->setExpenseClaimTaxDetail($expenseClaimTaxDetail)
            ->setTaxDetail($taxDetail)
            ->setBillTaxDetail($billTaxDetail)
            ->setOpportunityTaxDetail($opportunityTaxDetail)
            ->setInvoiceTaxDetail($invoiceTaxDetail)
            ->setProFormaTaxDetail($proFormaTaxDetail)
            ->setSalesInvoiceTaxDetail($salesInvoiceTaxDetail)
            ->setPurchaseOrderTaxDetail($purchaseOrderTaxDetail);
    }
    /**
     * Get ExpenseReceiptTaxDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ExpenseReceiptTaxDetails[]|null
     */
    public function getExpenseReceiptTaxDetails()
    {
        return isset($this->ExpenseReceiptTaxDetails) ? $this->ExpenseReceiptTaxDetails : null;
    }
    /**
     * This method is responsible for validating the values passed to the setExpenseReceiptTaxDetails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpenseReceiptTaxDetails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpenseReceiptTaxDetailsForArrayConstraintsFromSetExpenseReceiptTaxDetails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxDetailsExpenseReceiptTaxDetailsItem) {
            // validation for constraint: itemType
            if (!$taxDetailsExpenseReceiptTaxDetailsItem instanceof \StructType\ExpenseReceiptTaxDetails) {
                $invalidValues[] = is_object($taxDetailsExpenseReceiptTaxDetailsItem) ? get_class($taxDetailsExpenseReceiptTaxDetailsItem) : sprintf('%s(%s)', gettype($taxDetailsExpenseReceiptTaxDetailsItem), var_export($taxDetailsExpenseReceiptTaxDetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ExpenseReceiptTaxDetails property can only contain items of type \StructType\ExpenseReceiptTaxDetails, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ExpenseReceiptTaxDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ExpenseReceiptTaxDetails[] $expenseReceiptTaxDetails
     * @return \StructType\TaxDetails
     */
    public function setExpenseReceiptTaxDetails(array $expenseReceiptTaxDetails = array())
    {
        // validation for constraint: array
        if ('' !== ($expenseReceiptTaxDetailsArrayErrorMessage = self::validateExpenseReceiptTaxDetailsForArrayConstraintsFromSetExpenseReceiptTaxDetails($expenseReceiptTaxDetails))) {
            throw new \InvalidArgumentException($expenseReceiptTaxDetailsArrayErrorMessage, __LINE__);
        }
        if (is_null($expenseReceiptTaxDetails) || (is_array($expenseReceiptTaxDetails) && empty($expenseReceiptTaxDetails))) {
            unset($this->ExpenseReceiptTaxDetails);
        } else {
            $this->ExpenseReceiptTaxDetails = $expenseReceiptTaxDetails;
        }
        return $this;
    }
    /**
     * Add item to ExpenseReceiptTaxDetails value
     * @throws \InvalidArgumentException
     * @param \StructType\ExpenseReceiptTaxDetails $item
     * @return \StructType\TaxDetails
     */
    public function addToExpenseReceiptTaxDetails(\StructType\ExpenseReceiptTaxDetails $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExpenseReceiptTaxDetails) {
            throw new \InvalidArgumentException(sprintf('The ExpenseReceiptTaxDetails property can only contain items of type \StructType\ExpenseReceiptTaxDetails, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ExpenseReceiptTaxDetails[] = $item;
        return $this;
    }
    /**
     * Get ExpenseClaimTaxDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ExpenseClaimTaxDetail[]|null
     */
    public function getExpenseClaimTaxDetail()
    {
        return isset($this->ExpenseClaimTaxDetail) ? $this->ExpenseClaimTaxDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setExpenseClaimTaxDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpenseClaimTaxDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpenseClaimTaxDetailForArrayConstraintsFromSetExpenseClaimTaxDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxDetailsExpenseClaimTaxDetailItem) {
            // validation for constraint: itemType
            if (!$taxDetailsExpenseClaimTaxDetailItem instanceof \StructType\ExpenseClaimTaxDetail) {
                $invalidValues[] = is_object($taxDetailsExpenseClaimTaxDetailItem) ? get_class($taxDetailsExpenseClaimTaxDetailItem) : sprintf('%s(%s)', gettype($taxDetailsExpenseClaimTaxDetailItem), var_export($taxDetailsExpenseClaimTaxDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ExpenseClaimTaxDetail property can only contain items of type \StructType\ExpenseClaimTaxDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ExpenseClaimTaxDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ExpenseClaimTaxDetail[] $expenseClaimTaxDetail
     * @return \StructType\TaxDetails
     */
    public function setExpenseClaimTaxDetail(array $expenseClaimTaxDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($expenseClaimTaxDetailArrayErrorMessage = self::validateExpenseClaimTaxDetailForArrayConstraintsFromSetExpenseClaimTaxDetail($expenseClaimTaxDetail))) {
            throw new \InvalidArgumentException($expenseClaimTaxDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($expenseClaimTaxDetail) || (is_array($expenseClaimTaxDetail) && empty($expenseClaimTaxDetail))) {
            unset($this->ExpenseClaimTaxDetail);
        } else {
            $this->ExpenseClaimTaxDetail = $expenseClaimTaxDetail;
        }
        return $this;
    }
    /**
     * Add item to ExpenseClaimTaxDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\ExpenseClaimTaxDetail $item
     * @return \StructType\TaxDetails
     */
    public function addToExpenseClaimTaxDetail(\StructType\ExpenseClaimTaxDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExpenseClaimTaxDetail) {
            throw new \InvalidArgumentException(sprintf('The ExpenseClaimTaxDetail property can only contain items of type \StructType\ExpenseClaimTaxDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ExpenseClaimTaxDetail[] = $item;
        return $this;
    }
    /**
     * Get TaxDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TaxDetail[]|null
     */
    public function getTaxDetail()
    {
        return isset($this->TaxDetail) ? $this->TaxDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxDetailForArrayConstraintsFromSetTaxDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxDetailsTaxDetailItem) {
            // validation for constraint: itemType
            if (!$taxDetailsTaxDetailItem instanceof \StructType\TaxDetail) {
                $invalidValues[] = is_object($taxDetailsTaxDetailItem) ? get_class($taxDetailsTaxDetailItem) : sprintf('%s(%s)', gettype($taxDetailsTaxDetailItem), var_export($taxDetailsTaxDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxDetail property can only contain items of type \StructType\TaxDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaxDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TaxDetail[] $taxDetail
     * @return \StructType\TaxDetails
     */
    public function setTaxDetail(array $taxDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($taxDetailArrayErrorMessage = self::validateTaxDetailForArrayConstraintsFromSetTaxDetail($taxDetail))) {
            throw new \InvalidArgumentException($taxDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($taxDetail) || (is_array($taxDetail) && empty($taxDetail))) {
            unset($this->TaxDetail);
        } else {
            $this->TaxDetail = $taxDetail;
        }
        return $this;
    }
    /**
     * Add item to TaxDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxDetail $item
     * @return \StructType\TaxDetails
     */
    public function addToTaxDetail(\StructType\TaxDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TaxDetail) {
            throw new \InvalidArgumentException(sprintf('The TaxDetail property can only contain items of type \StructType\TaxDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TaxDetail[] = $item;
        return $this;
    }
    /**
     * Get BillTaxDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BillTaxDetail[]|null
     */
    public function getBillTaxDetail()
    {
        return isset($this->BillTaxDetail) ? $this->BillTaxDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBillTaxDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBillTaxDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBillTaxDetailForArrayConstraintsFromSetBillTaxDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxDetailsBillTaxDetailItem) {
            // validation for constraint: itemType
            if (!$taxDetailsBillTaxDetailItem instanceof \StructType\BillTaxDetail) {
                $invalidValues[] = is_object($taxDetailsBillTaxDetailItem) ? get_class($taxDetailsBillTaxDetailItem) : sprintf('%s(%s)', gettype($taxDetailsBillTaxDetailItem), var_export($taxDetailsBillTaxDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BillTaxDetail property can only contain items of type \StructType\BillTaxDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BillTaxDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BillTaxDetail[] $billTaxDetail
     * @return \StructType\TaxDetails
     */
    public function setBillTaxDetail(array $billTaxDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($billTaxDetailArrayErrorMessage = self::validateBillTaxDetailForArrayConstraintsFromSetBillTaxDetail($billTaxDetail))) {
            throw new \InvalidArgumentException($billTaxDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($billTaxDetail) || (is_array($billTaxDetail) && empty($billTaxDetail))) {
            unset($this->BillTaxDetail);
        } else {
            $this->BillTaxDetail = $billTaxDetail;
        }
        return $this;
    }
    /**
     * Add item to BillTaxDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\BillTaxDetail $item
     * @return \StructType\TaxDetails
     */
    public function addToBillTaxDetail(\StructType\BillTaxDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BillTaxDetail) {
            throw new \InvalidArgumentException(sprintf('The BillTaxDetail property can only contain items of type \StructType\BillTaxDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BillTaxDetail[] = $item;
        return $this;
    }
    /**
     * Get OpportunityTaxDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OpportunityTaxDetail[]|null
     */
    public function getOpportunityTaxDetail()
    {
        return isset($this->OpportunityTaxDetail) ? $this->OpportunityTaxDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setOpportunityTaxDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOpportunityTaxDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOpportunityTaxDetailForArrayConstraintsFromSetOpportunityTaxDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxDetailsOpportunityTaxDetailItem) {
            // validation for constraint: itemType
            if (!$taxDetailsOpportunityTaxDetailItem instanceof \StructType\OpportunityTaxDetail) {
                $invalidValues[] = is_object($taxDetailsOpportunityTaxDetailItem) ? get_class($taxDetailsOpportunityTaxDetailItem) : sprintf('%s(%s)', gettype($taxDetailsOpportunityTaxDetailItem), var_export($taxDetailsOpportunityTaxDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OpportunityTaxDetail property can only contain items of type \StructType\OpportunityTaxDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OpportunityTaxDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OpportunityTaxDetail[] $opportunityTaxDetail
     * @return \StructType\TaxDetails
     */
    public function setOpportunityTaxDetail(array $opportunityTaxDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($opportunityTaxDetailArrayErrorMessage = self::validateOpportunityTaxDetailForArrayConstraintsFromSetOpportunityTaxDetail($opportunityTaxDetail))) {
            throw new \InvalidArgumentException($opportunityTaxDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($opportunityTaxDetail) || (is_array($opportunityTaxDetail) && empty($opportunityTaxDetail))) {
            unset($this->OpportunityTaxDetail);
        } else {
            $this->OpportunityTaxDetail = $opportunityTaxDetail;
        }
        return $this;
    }
    /**
     * Add item to OpportunityTaxDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\OpportunityTaxDetail $item
     * @return \StructType\TaxDetails
     */
    public function addToOpportunityTaxDetail(\StructType\OpportunityTaxDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OpportunityTaxDetail) {
            throw new \InvalidArgumentException(sprintf('The OpportunityTaxDetail property can only contain items of type \StructType\OpportunityTaxDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OpportunityTaxDetail[] = $item;
        return $this;
    }
    /**
     * Get InvoiceTaxDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\InvoiceTaxDetail[]|null
     */
    public function getInvoiceTaxDetail()
    {
        return isset($this->InvoiceTaxDetail) ? $this->InvoiceTaxDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoiceTaxDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoiceTaxDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoiceTaxDetailForArrayConstraintsFromSetInvoiceTaxDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxDetailsInvoiceTaxDetailItem) {
            // validation for constraint: itemType
            if (!$taxDetailsInvoiceTaxDetailItem instanceof \StructType\InvoiceTaxDetail) {
                $invalidValues[] = is_object($taxDetailsInvoiceTaxDetailItem) ? get_class($taxDetailsInvoiceTaxDetailItem) : sprintf('%s(%s)', gettype($taxDetailsInvoiceTaxDetailItem), var_export($taxDetailsInvoiceTaxDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InvoiceTaxDetail property can only contain items of type \StructType\InvoiceTaxDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InvoiceTaxDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceTaxDetail[] $invoiceTaxDetail
     * @return \StructType\TaxDetails
     */
    public function setInvoiceTaxDetail(array $invoiceTaxDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($invoiceTaxDetailArrayErrorMessage = self::validateInvoiceTaxDetailForArrayConstraintsFromSetInvoiceTaxDetail($invoiceTaxDetail))) {
            throw new \InvalidArgumentException($invoiceTaxDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($invoiceTaxDetail) || (is_array($invoiceTaxDetail) && empty($invoiceTaxDetail))) {
            unset($this->InvoiceTaxDetail);
        } else {
            $this->InvoiceTaxDetail = $invoiceTaxDetail;
        }
        return $this;
    }
    /**
     * Add item to InvoiceTaxDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceTaxDetail $item
     * @return \StructType\TaxDetails
     */
    public function addToInvoiceTaxDetail(\StructType\InvoiceTaxDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InvoiceTaxDetail) {
            throw new \InvalidArgumentException(sprintf('The InvoiceTaxDetail property can only contain items of type \StructType\InvoiceTaxDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InvoiceTaxDetail[] = $item;
        return $this;
    }
    /**
     * Get ProFormaTaxDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProFormaTaxDetail[]|null
     */
    public function getProFormaTaxDetail()
    {
        return isset($this->ProFormaTaxDetail) ? $this->ProFormaTaxDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setProFormaTaxDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProFormaTaxDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProFormaTaxDetailForArrayConstraintsFromSetProFormaTaxDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxDetailsProFormaTaxDetailItem) {
            // validation for constraint: itemType
            if (!$taxDetailsProFormaTaxDetailItem instanceof \StructType\ProFormaTaxDetail) {
                $invalidValues[] = is_object($taxDetailsProFormaTaxDetailItem) ? get_class($taxDetailsProFormaTaxDetailItem) : sprintf('%s(%s)', gettype($taxDetailsProFormaTaxDetailItem), var_export($taxDetailsProFormaTaxDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProFormaTaxDetail property can only contain items of type \StructType\ProFormaTaxDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProFormaTaxDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ProFormaTaxDetail[] $proFormaTaxDetail
     * @return \StructType\TaxDetails
     */
    public function setProFormaTaxDetail(array $proFormaTaxDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($proFormaTaxDetailArrayErrorMessage = self::validateProFormaTaxDetailForArrayConstraintsFromSetProFormaTaxDetail($proFormaTaxDetail))) {
            throw new \InvalidArgumentException($proFormaTaxDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($proFormaTaxDetail) || (is_array($proFormaTaxDetail) && empty($proFormaTaxDetail))) {
            unset($this->ProFormaTaxDetail);
        } else {
            $this->ProFormaTaxDetail = $proFormaTaxDetail;
        }
        return $this;
    }
    /**
     * Add item to ProFormaTaxDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\ProFormaTaxDetail $item
     * @return \StructType\TaxDetails
     */
    public function addToProFormaTaxDetail(\StructType\ProFormaTaxDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProFormaTaxDetail) {
            throw new \InvalidArgumentException(sprintf('The ProFormaTaxDetail property can only contain items of type \StructType\ProFormaTaxDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ProFormaTaxDetail[] = $item;
        return $this;
    }
    /**
     * Get SalesInvoiceTaxDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SalesInvoiceTaxDetail[]|null
     */
    public function getSalesInvoiceTaxDetail()
    {
        return isset($this->SalesInvoiceTaxDetail) ? $this->SalesInvoiceTaxDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSalesInvoiceTaxDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSalesInvoiceTaxDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSalesInvoiceTaxDetailForArrayConstraintsFromSetSalesInvoiceTaxDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxDetailsSalesInvoiceTaxDetailItem) {
            // validation for constraint: itemType
            if (!$taxDetailsSalesInvoiceTaxDetailItem instanceof \StructType\SalesInvoiceTaxDetail) {
                $invalidValues[] = is_object($taxDetailsSalesInvoiceTaxDetailItem) ? get_class($taxDetailsSalesInvoiceTaxDetailItem) : sprintf('%s(%s)', gettype($taxDetailsSalesInvoiceTaxDetailItem), var_export($taxDetailsSalesInvoiceTaxDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SalesInvoiceTaxDetail property can only contain items of type \StructType\SalesInvoiceTaxDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SalesInvoiceTaxDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SalesInvoiceTaxDetail[] $salesInvoiceTaxDetail
     * @return \StructType\TaxDetails
     */
    public function setSalesInvoiceTaxDetail(array $salesInvoiceTaxDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($salesInvoiceTaxDetailArrayErrorMessage = self::validateSalesInvoiceTaxDetailForArrayConstraintsFromSetSalesInvoiceTaxDetail($salesInvoiceTaxDetail))) {
            throw new \InvalidArgumentException($salesInvoiceTaxDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($salesInvoiceTaxDetail) || (is_array($salesInvoiceTaxDetail) && empty($salesInvoiceTaxDetail))) {
            unset($this->SalesInvoiceTaxDetail);
        } else {
            $this->SalesInvoiceTaxDetail = $salesInvoiceTaxDetail;
        }
        return $this;
    }
    /**
     * Add item to SalesInvoiceTaxDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\SalesInvoiceTaxDetail $item
     * @return \StructType\TaxDetails
     */
    public function addToSalesInvoiceTaxDetail(\StructType\SalesInvoiceTaxDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SalesInvoiceTaxDetail) {
            throw new \InvalidArgumentException(sprintf('The SalesInvoiceTaxDetail property can only contain items of type \StructType\SalesInvoiceTaxDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SalesInvoiceTaxDetail[] = $item;
        return $this;
    }
    /**
     * Get PurchaseOrderTaxDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PurchaseOrderTaxDetail[]|null
     */
    public function getPurchaseOrderTaxDetail()
    {
        return isset($this->PurchaseOrderTaxDetail) ? $this->PurchaseOrderTaxDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchaseOrderTaxDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchaseOrderTaxDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchaseOrderTaxDetailForArrayConstraintsFromSetPurchaseOrderTaxDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxDetailsPurchaseOrderTaxDetailItem) {
            // validation for constraint: itemType
            if (!$taxDetailsPurchaseOrderTaxDetailItem instanceof \StructType\PurchaseOrderTaxDetail) {
                $invalidValues[] = is_object($taxDetailsPurchaseOrderTaxDetailItem) ? get_class($taxDetailsPurchaseOrderTaxDetailItem) : sprintf('%s(%s)', gettype($taxDetailsPurchaseOrderTaxDetailItem), var_export($taxDetailsPurchaseOrderTaxDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PurchaseOrderTaxDetail property can only contain items of type \StructType\PurchaseOrderTaxDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PurchaseOrderTaxDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PurchaseOrderTaxDetail[] $purchaseOrderTaxDetail
     * @return \StructType\TaxDetails
     */
    public function setPurchaseOrderTaxDetail(array $purchaseOrderTaxDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($purchaseOrderTaxDetailArrayErrorMessage = self::validatePurchaseOrderTaxDetailForArrayConstraintsFromSetPurchaseOrderTaxDetail($purchaseOrderTaxDetail))) {
            throw new \InvalidArgumentException($purchaseOrderTaxDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($purchaseOrderTaxDetail) || (is_array($purchaseOrderTaxDetail) && empty($purchaseOrderTaxDetail))) {
            unset($this->PurchaseOrderTaxDetail);
        } else {
            $this->PurchaseOrderTaxDetail = $purchaseOrderTaxDetail;
        }
        return $this;
    }
    /**
     * Add item to PurchaseOrderTaxDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\PurchaseOrderTaxDetail $item
     * @return \StructType\TaxDetails
     */
    public function addToPurchaseOrderTaxDetail(\StructType\PurchaseOrderTaxDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PurchaseOrderTaxDetail) {
            throw new \InvalidArgumentException(sprintf('The PurchaseOrderTaxDetail property can only contain items of type \StructType\PurchaseOrderTaxDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PurchaseOrderTaxDetail[] = $item;
        return $this;
    }
}
