<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Task StructType
 * @subpackage Structs
 */
class Task extends Entity
{
    /**
     * The Body
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Body;
    /**
     * The Category
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Category;
    /**
     * The CompletedAt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $CompletedAt;
    /**
     * The CompletionPercentage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IntValue
     */
    public $CompletionPercentage;
    /**
     * The DueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $DueDate;
    /**
     * The Internal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $Internal;
    /**
     * The NoteID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GuidValue
     */
    public $NoteID;
    /**
     * The Owner
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Owner;
    /**
     * The Parent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GuidValue
     */
    public $Parent;
    /**
     * The ParentSummary
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ParentSummary;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Priority;
    /**
     * The RelatedActivities
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RelatedActivities
     */
    public $RelatedActivities;
    /**
     * The RelatedEntityDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $RelatedEntityDescription;
    /**
     * The RelatedTasks
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RelatedTasks
     */
    public $RelatedTasks;
    /**
     * The Reminder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ReminderDetail
     */
    public $Reminder;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $StartDate;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Status;
    /**
     * The Summary
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Summary;
    /**
     * The TimeActivity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TaskTimeActivity
     */
    public $TimeActivity;
    /**
     * The WorkgroupID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $WorkgroupID;
    /**
     * Constructor method for Task
     * @uses Task::setBody()
     * @uses Task::setCategory()
     * @uses Task::setCompletedAt()
     * @uses Task::setCompletionPercentage()
     * @uses Task::setDueDate()
     * @uses Task::setInternal()
     * @uses Task::setNoteID()
     * @uses Task::setOwner()
     * @uses Task::setParent()
     * @uses Task::setParentSummary()
     * @uses Task::setPriority()
     * @uses Task::setRelatedActivities()
     * @uses Task::setRelatedEntityDescription()
     * @uses Task::setRelatedTasks()
     * @uses Task::setReminder()
     * @uses Task::setStartDate()
     * @uses Task::setStatus()
     * @uses Task::setSummary()
     * @uses Task::setTimeActivity()
     * @uses Task::setWorkgroupID()
     * @param \StructType\StringValue $body
     * @param \StructType\StringValue $category
     * @param \StructType\DateTimeValue $completedAt
     * @param \StructType\IntValue $completionPercentage
     * @param \StructType\DateTimeValue $dueDate
     * @param \StructType\BooleanValue $internal
     * @param \StructType\GuidValue $noteID
     * @param \StructType\StringValue $owner
     * @param \StructType\GuidValue $parent
     * @param \StructType\StringValue $parentSummary
     * @param \StructType\StringValue $priority
     * @param \StructType\RelatedActivities $relatedActivities
     * @param \StructType\StringValue $relatedEntityDescription
     * @param \StructType\RelatedTasks $relatedTasks
     * @param \StructType\ReminderDetail $reminder
     * @param \StructType\DateTimeValue $startDate
     * @param \StructType\StringValue $status
     * @param \StructType\StringValue $summary
     * @param \StructType\TaskTimeActivity $timeActivity
     * @param \StructType\StringValue $workgroupID
     */
    public function __construct(\StructType\StringValue $body = null, \StructType\StringValue $category = null, \StructType\DateTimeValue $completedAt = null, \StructType\IntValue $completionPercentage = null, \StructType\DateTimeValue $dueDate = null, \StructType\BooleanValue $internal = null, \StructType\GuidValue $noteID = null, \StructType\StringValue $owner = null, \StructType\GuidValue $parent = null, \StructType\StringValue $parentSummary = null, \StructType\StringValue $priority = null, \StructType\RelatedActivities $relatedActivities = null, \StructType\StringValue $relatedEntityDescription = null, \StructType\RelatedTasks $relatedTasks = null, \StructType\ReminderDetail $reminder = null, \StructType\DateTimeValue $startDate = null, \StructType\StringValue $status = null, \StructType\StringValue $summary = null, \StructType\TaskTimeActivity $timeActivity = null, \StructType\StringValue $workgroupID = null)
    {
        $this
            ->setBody($body)
            ->setCategory($category)
            ->setCompletedAt($completedAt)
            ->setCompletionPercentage($completionPercentage)
            ->setDueDate($dueDate)
            ->setInternal($internal)
            ->setNoteID($noteID)
            ->setOwner($owner)
            ->setParent($parent)
            ->setParentSummary($parentSummary)
            ->setPriority($priority)
            ->setRelatedActivities($relatedActivities)
            ->setRelatedEntityDescription($relatedEntityDescription)
            ->setRelatedTasks($relatedTasks)
            ->setReminder($reminder)
            ->setStartDate($startDate)
            ->setStatus($status)
            ->setSummary($summary)
            ->setTimeActivity($timeActivity)
            ->setWorkgroupID($workgroupID);
    }
    /**
     * Get Body value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getBody()
    {
        return isset($this->Body) ? $this->Body : null;
    }
    /**
     * Set Body value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $body
     * @return \StructType\Task
     */
    public function setBody(\StructType\StringValue $body = null)
    {
        if (is_null($body) || (is_array($body) && empty($body))) {
            unset($this->Body);
        } else {
            $this->Body = $body;
        }
        return $this;
    }
    /**
     * Get Category value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCategory()
    {
        return isset($this->Category) ? $this->Category : null;
    }
    /**
     * Set Category value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $category
     * @return \StructType\Task
     */
    public function setCategory(\StructType\StringValue $category = null)
    {
        if (is_null($category) || (is_array($category) && empty($category))) {
            unset($this->Category);
        } else {
            $this->Category = $category;
        }
        return $this;
    }
    /**
     * Get CompletedAt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getCompletedAt()
    {
        return isset($this->CompletedAt) ? $this->CompletedAt : null;
    }
    /**
     * Set CompletedAt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $completedAt
     * @return \StructType\Task
     */
    public function setCompletedAt(\StructType\DateTimeValue $completedAt = null)
    {
        if (is_null($completedAt) || (is_array($completedAt) && empty($completedAt))) {
            unset($this->CompletedAt);
        } else {
            $this->CompletedAt = $completedAt;
        }
        return $this;
    }
    /**
     * Get CompletionPercentage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IntValue|null
     */
    public function getCompletionPercentage()
    {
        return isset($this->CompletionPercentage) ? $this->CompletionPercentage : null;
    }
    /**
     * Set CompletionPercentage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\IntValue $completionPercentage
     * @return \StructType\Task
     */
    public function setCompletionPercentage(\StructType\IntValue $completionPercentage = null)
    {
        if (is_null($completionPercentage) || (is_array($completionPercentage) && empty($completionPercentage))) {
            unset($this->CompletionPercentage);
        } else {
            $this->CompletionPercentage = $completionPercentage;
        }
        return $this;
    }
    /**
     * Get DueDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getDueDate()
    {
        return isset($this->DueDate) ? $this->DueDate : null;
    }
    /**
     * Set DueDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $dueDate
     * @return \StructType\Task
     */
    public function setDueDate(\StructType\DateTimeValue $dueDate = null)
    {
        if (is_null($dueDate) || (is_array($dueDate) && empty($dueDate))) {
            unset($this->DueDate);
        } else {
            $this->DueDate = $dueDate;
        }
        return $this;
    }
    /**
     * Get Internal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getInternal()
    {
        return isset($this->Internal) ? $this->Internal : null;
    }
    /**
     * Set Internal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $internal
     * @return \StructType\Task
     */
    public function setInternal(\StructType\BooleanValue $internal = null)
    {
        if (is_null($internal) || (is_array($internal) && empty($internal))) {
            unset($this->Internal);
        } else {
            $this->Internal = $internal;
        }
        return $this;
    }
    /**
     * Get NoteID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GuidValue|null
     */
    public function getNoteID()
    {
        return isset($this->NoteID) ? $this->NoteID : null;
    }
    /**
     * Set NoteID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\GuidValue $noteID
     * @return \StructType\Task
     */
    public function setNoteID(\StructType\GuidValue $noteID = null)
    {
        if (is_null($noteID) || (is_array($noteID) && empty($noteID))) {
            unset($this->NoteID);
        } else {
            $this->NoteID = $noteID;
        }
        return $this;
    }
    /**
     * Get Owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getOwner()
    {
        return isset($this->Owner) ? $this->Owner : null;
    }
    /**
     * Set Owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $owner
     * @return \StructType\Task
     */
    public function setOwner(\StructType\StringValue $owner = null)
    {
        if (is_null($owner) || (is_array($owner) && empty($owner))) {
            unset($this->Owner);
        } else {
            $this->Owner = $owner;
        }
        return $this;
    }
    /**
     * Get Parent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GuidValue|null
     */
    public function getParent()
    {
        return isset($this->Parent) ? $this->Parent : null;
    }
    /**
     * Set Parent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\GuidValue $parent
     * @return \StructType\Task
     */
    public function setParent(\StructType\GuidValue $parent = null)
    {
        if (is_null($parent) || (is_array($parent) && empty($parent))) {
            unset($this->Parent);
        } else {
            $this->Parent = $parent;
        }
        return $this;
    }
    /**
     * Get ParentSummary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getParentSummary()
    {
        return isset($this->ParentSummary) ? $this->ParentSummary : null;
    }
    /**
     * Set ParentSummary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $parentSummary
     * @return \StructType\Task
     */
    public function setParentSummary(\StructType\StringValue $parentSummary = null)
    {
        if (is_null($parentSummary) || (is_array($parentSummary) && empty($parentSummary))) {
            unset($this->ParentSummary);
        } else {
            $this->ParentSummary = $parentSummary;
        }
        return $this;
    }
    /**
     * Get Priority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getPriority()
    {
        return isset($this->Priority) ? $this->Priority : null;
    }
    /**
     * Set Priority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $priority
     * @return \StructType\Task
     */
    public function setPriority(\StructType\StringValue $priority = null)
    {
        if (is_null($priority) || (is_array($priority) && empty($priority))) {
            unset($this->Priority);
        } else {
            $this->Priority = $priority;
        }
        return $this;
    }
    /**
     * Get RelatedActivities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RelatedActivities|null
     */
    public function getRelatedActivities()
    {
        return isset($this->RelatedActivities) ? $this->RelatedActivities : null;
    }
    /**
     * Set RelatedActivities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RelatedActivities $relatedActivities
     * @return \StructType\Task
     */
    public function setRelatedActivities(\StructType\RelatedActivities $relatedActivities = null)
    {
        if (is_null($relatedActivities) || (is_array($relatedActivities) && empty($relatedActivities))) {
            unset($this->RelatedActivities);
        } else {
            $this->RelatedActivities = $relatedActivities;
        }
        return $this;
    }
    /**
     * Get RelatedEntityDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getRelatedEntityDescription()
    {
        return isset($this->RelatedEntityDescription) ? $this->RelatedEntityDescription : null;
    }
    /**
     * Set RelatedEntityDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $relatedEntityDescription
     * @return \StructType\Task
     */
    public function setRelatedEntityDescription(\StructType\StringValue $relatedEntityDescription = null)
    {
        if (is_null($relatedEntityDescription) || (is_array($relatedEntityDescription) && empty($relatedEntityDescription))) {
            unset($this->RelatedEntityDescription);
        } else {
            $this->RelatedEntityDescription = $relatedEntityDescription;
        }
        return $this;
    }
    /**
     * Get RelatedTasks value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RelatedTasks|null
     */
    public function getRelatedTasks()
    {
        return isset($this->RelatedTasks) ? $this->RelatedTasks : null;
    }
    /**
     * Set RelatedTasks value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RelatedTasks $relatedTasks
     * @return \StructType\Task
     */
    public function setRelatedTasks(\StructType\RelatedTasks $relatedTasks = null)
    {
        if (is_null($relatedTasks) || (is_array($relatedTasks) && empty($relatedTasks))) {
            unset($this->RelatedTasks);
        } else {
            $this->RelatedTasks = $relatedTasks;
        }
        return $this;
    }
    /**
     * Get Reminder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ReminderDetail|null
     */
    public function getReminder()
    {
        return isset($this->Reminder) ? $this->Reminder : null;
    }
    /**
     * Set Reminder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ReminderDetail $reminder
     * @return \StructType\Task
     */
    public function setReminder(\StructType\ReminderDetail $reminder = null)
    {
        if (is_null($reminder) || (is_array($reminder) && empty($reminder))) {
            unset($this->Reminder);
        } else {
            $this->Reminder = $reminder;
        }
        return $this;
    }
    /**
     * Get StartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getStartDate()
    {
        return isset($this->StartDate) ? $this->StartDate : null;
    }
    /**
     * Set StartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $startDate
     * @return \StructType\Task
     */
    public function setStartDate(\StructType\DateTimeValue $startDate = null)
    {
        if (is_null($startDate) || (is_array($startDate) && empty($startDate))) {
            unset($this->StartDate);
        } else {
            $this->StartDate = $startDate;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $status
     * @return \StructType\Task
     */
    public function setStatus(\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get Summary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getSummary()
    {
        return isset($this->Summary) ? $this->Summary : null;
    }
    /**
     * Set Summary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $summary
     * @return \StructType\Task
     */
    public function setSummary(\StructType\StringValue $summary = null)
    {
        if (is_null($summary) || (is_array($summary) && empty($summary))) {
            unset($this->Summary);
        } else {
            $this->Summary = $summary;
        }
        return $this;
    }
    /**
     * Get TimeActivity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TaskTimeActivity|null
     */
    public function getTimeActivity()
    {
        return isset($this->TimeActivity) ? $this->TimeActivity : null;
    }
    /**
     * Set TimeActivity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\TaskTimeActivity $timeActivity
     * @return \StructType\Task
     */
    public function setTimeActivity(\StructType\TaskTimeActivity $timeActivity = null)
    {
        if (is_null($timeActivity) || (is_array($timeActivity) && empty($timeActivity))) {
            unset($this->TimeActivity);
        } else {
            $this->TimeActivity = $timeActivity;
        }
        return $this;
    }
    /**
     * Get WorkgroupID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getWorkgroupID()
    {
        return isset($this->WorkgroupID) ? $this->WorkgroupID : null;
    }
    /**
     * Set WorkgroupID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $workgroupID
     * @return \StructType\Task
     */
    public function setWorkgroupID(\StructType\StringValue $workgroupID = null)
    {
        if (is_null($workgroupID) || (is_array($workgroupID) && empty($workgroupID))) {
            unset($this->WorkgroupID);
        } else {
            $this->WorkgroupID = $workgroupID;
        }
        return $this;
    }
}
