<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShippingTermDetail StructType
 * @subpackage Structs
 */
class ShippingTermDetail extends Entity
{
    /**
     * The BreakAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $BreakAmount;
    /**
     * The FreightCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $FreightCost;
    /**
     * The InvoiceAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $InvoiceAmount;
    /**
     * The LineHandling
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $LineHandling;
    /**
     * The LineNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IntValue
     */
    public $LineNbr;
    /**
     * The ShippingandHandling
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $ShippingandHandling;
    /**
     * Constructor method for ShippingTermDetail
     * @uses ShippingTermDetail::setBreakAmount()
     * @uses ShippingTermDetail::setFreightCost()
     * @uses ShippingTermDetail::setInvoiceAmount()
     * @uses ShippingTermDetail::setLineHandling()
     * @uses ShippingTermDetail::setLineNbr()
     * @uses ShippingTermDetail::setShippingandHandling()
     * @param \StructType\DecimalValue $breakAmount
     * @param \StructType\DecimalValue $freightCost
     * @param \StructType\DecimalValue $invoiceAmount
     * @param \StructType\DecimalValue $lineHandling
     * @param \StructType\IntValue $lineNbr
     * @param \StructType\DecimalValue $shippingandHandling
     */
    public function __construct(\StructType\DecimalValue $breakAmount = null, \StructType\DecimalValue $freightCost = null, \StructType\DecimalValue $invoiceAmount = null, \StructType\DecimalValue $lineHandling = null, \StructType\IntValue $lineNbr = null, \StructType\DecimalValue $shippingandHandling = null)
    {
        $this
            ->setBreakAmount($breakAmount)
            ->setFreightCost($freightCost)
            ->setInvoiceAmount($invoiceAmount)
            ->setLineHandling($lineHandling)
            ->setLineNbr($lineNbr)
            ->setShippingandHandling($shippingandHandling);
    }
    /**
     * Get BreakAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getBreakAmount()
    {
        return isset($this->BreakAmount) ? $this->BreakAmount : null;
    }
    /**
     * Set BreakAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $breakAmount
     * @return \StructType\ShippingTermDetail
     */
    public function setBreakAmount(\StructType\DecimalValue $breakAmount = null)
    {
        if (is_null($breakAmount) || (is_array($breakAmount) && empty($breakAmount))) {
            unset($this->BreakAmount);
        } else {
            $this->BreakAmount = $breakAmount;
        }
        return $this;
    }
    /**
     * Get FreightCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getFreightCost()
    {
        return isset($this->FreightCost) ? $this->FreightCost : null;
    }
    /**
     * Set FreightCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $freightCost
     * @return \StructType\ShippingTermDetail
     */
    public function setFreightCost(\StructType\DecimalValue $freightCost = null)
    {
        if (is_null($freightCost) || (is_array($freightCost) && empty($freightCost))) {
            unset($this->FreightCost);
        } else {
            $this->FreightCost = $freightCost;
        }
        return $this;
    }
    /**
     * Get InvoiceAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getInvoiceAmount()
    {
        return isset($this->InvoiceAmount) ? $this->InvoiceAmount : null;
    }
    /**
     * Set InvoiceAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $invoiceAmount
     * @return \StructType\ShippingTermDetail
     */
    public function setInvoiceAmount(\StructType\DecimalValue $invoiceAmount = null)
    {
        if (is_null($invoiceAmount) || (is_array($invoiceAmount) && empty($invoiceAmount))) {
            unset($this->InvoiceAmount);
        } else {
            $this->InvoiceAmount = $invoiceAmount;
        }
        return $this;
    }
    /**
     * Get LineHandling value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getLineHandling()
    {
        return isset($this->LineHandling) ? $this->LineHandling : null;
    }
    /**
     * Set LineHandling value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $lineHandling
     * @return \StructType\ShippingTermDetail
     */
    public function setLineHandling(\StructType\DecimalValue $lineHandling = null)
    {
        if (is_null($lineHandling) || (is_array($lineHandling) && empty($lineHandling))) {
            unset($this->LineHandling);
        } else {
            $this->LineHandling = $lineHandling;
        }
        return $this;
    }
    /**
     * Get LineNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IntValue|null
     */
    public function getLineNbr()
    {
        return isset($this->LineNbr) ? $this->LineNbr : null;
    }
    /**
     * Set LineNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\IntValue $lineNbr
     * @return \StructType\ShippingTermDetail
     */
    public function setLineNbr(\StructType\IntValue $lineNbr = null)
    {
        if (is_null($lineNbr) || (is_array($lineNbr) && empty($lineNbr))) {
            unset($this->LineNbr);
        } else {
            $this->LineNbr = $lineNbr;
        }
        return $this;
    }
    /**
     * Get ShippingandHandling value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getShippingandHandling()
    {
        return isset($this->ShippingandHandling) ? $this->ShippingandHandling : null;
    }
    /**
     * Set ShippingandHandling value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $shippingandHandling
     * @return \StructType\ShippingTermDetail
     */
    public function setShippingandHandling(\StructType\DecimalValue $shippingandHandling = null)
    {
        if (is_null($shippingandHandling) || (is_array($shippingandHandling) && empty($shippingandHandling))) {
            unset($this->ShippingandHandling);
        } else {
            $this->ShippingandHandling = $shippingandHandling;
        }
        return $this;
    }
}
