<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipViaFreightRate StructType
 * @subpackage Structs
 */
class ShipViaFreightRate extends Entity
{
    /**
     * The LineNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IntValue
     */
    public $LineNbr;
    /**
     * The Rate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $Rate;
    /**
     * The Volume
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $Volume;
    /**
     * The Weight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $Weight;
    /**
     * The ZoneID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ZoneID;
    /**
     * Constructor method for ShipViaFreightRate
     * @uses ShipViaFreightRate::setLineNbr()
     * @uses ShipViaFreightRate::setRate()
     * @uses ShipViaFreightRate::setVolume()
     * @uses ShipViaFreightRate::setWeight()
     * @uses ShipViaFreightRate::setZoneID()
     * @param \StructType\IntValue $lineNbr
     * @param \StructType\DecimalValue $rate
     * @param \StructType\DecimalValue $volume
     * @param \StructType\DecimalValue $weight
     * @param \StructType\StringValue $zoneID
     */
    public function __construct(\StructType\IntValue $lineNbr = null, \StructType\DecimalValue $rate = null, \StructType\DecimalValue $volume = null, \StructType\DecimalValue $weight = null, \StructType\StringValue $zoneID = null)
    {
        $this
            ->setLineNbr($lineNbr)
            ->setRate($rate)
            ->setVolume($volume)
            ->setWeight($weight)
            ->setZoneID($zoneID);
    }
    /**
     * Get LineNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IntValue|null
     */
    public function getLineNbr()
    {
        return isset($this->LineNbr) ? $this->LineNbr : null;
    }
    /**
     * Set LineNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\IntValue $lineNbr
     * @return \StructType\ShipViaFreightRate
     */
    public function setLineNbr(\StructType\IntValue $lineNbr = null)
    {
        if (is_null($lineNbr) || (is_array($lineNbr) && empty($lineNbr))) {
            unset($this->LineNbr);
        } else {
            $this->LineNbr = $lineNbr;
        }
        return $this;
    }
    /**
     * Get Rate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getRate()
    {
        return isset($this->Rate) ? $this->Rate : null;
    }
    /**
     * Set Rate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $rate
     * @return \StructType\ShipViaFreightRate
     */
    public function setRate(\StructType\DecimalValue $rate = null)
    {
        if (is_null($rate) || (is_array($rate) && empty($rate))) {
            unset($this->Rate);
        } else {
            $this->Rate = $rate;
        }
        return $this;
    }
    /**
     * Get Volume value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getVolume()
    {
        return isset($this->Volume) ? $this->Volume : null;
    }
    /**
     * Set Volume value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $volume
     * @return \StructType\ShipViaFreightRate
     */
    public function setVolume(\StructType\DecimalValue $volume = null)
    {
        if (is_null($volume) || (is_array($volume) && empty($volume))) {
            unset($this->Volume);
        } else {
            $this->Volume = $volume;
        }
        return $this;
    }
    /**
     * Get Weight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getWeight()
    {
        return isset($this->Weight) ? $this->Weight : null;
    }
    /**
     * Set Weight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $weight
     * @return \StructType\ShipViaFreightRate
     */
    public function setWeight(\StructType\DecimalValue $weight = null)
    {
        if (is_null($weight) || (is_array($weight) && empty($weight))) {
            unset($this->Weight);
        } else {
            $this->Weight = $weight;
        }
        return $this;
    }
    /**
     * Get ZoneID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getZoneID()
    {
        return isset($this->ZoneID) ? $this->ZoneID : null;
    }
    /**
     * Set ZoneID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $zoneID
     * @return \StructType\ShipViaFreightRate
     */
    public function setZoneID(\StructType\StringValue $zoneID = null)
    {
        if (is_null($zoneID) || (is_array($zoneID) && empty($zoneID))) {
            unset($this->ZoneID);
        } else {
            $this->ZoneID = $zoneID;
        }
        return $this;
    }
}
