<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesOrdersDiscountDetails StructType
 * @subpackage Structs
 */
class SalesOrdersDiscountDetails extends Entity
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Description;
    /**
     * The DiscountableAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $DiscountableAmount;
    /**
     * The DiscountableQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $DiscountableQty;
    /**
     * The DiscountAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $DiscountAmount;
    /**
     * The DiscountCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $DiscountCode;
    /**
     * The DiscountPercent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $DiscountPercent;
    /**
     * The ExternalDiscountCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ExternalDiscountCode;
    /**
     * The FreeItem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $FreeItem;
    /**
     * The FreeItemQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $FreeItemQty;
    /**
     * The ManualDiscount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $ManualDiscount;
    /**
     * The SequenceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $SequenceID;
    /**
     * The SkipDiscount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $SkipDiscount;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Type;
    /**
     * Constructor method for SalesOrdersDiscountDetails
     * @uses SalesOrdersDiscountDetails::setDescription()
     * @uses SalesOrdersDiscountDetails::setDiscountableAmount()
     * @uses SalesOrdersDiscountDetails::setDiscountableQty()
     * @uses SalesOrdersDiscountDetails::setDiscountAmount()
     * @uses SalesOrdersDiscountDetails::setDiscountCode()
     * @uses SalesOrdersDiscountDetails::setDiscountPercent()
     * @uses SalesOrdersDiscountDetails::setExternalDiscountCode()
     * @uses SalesOrdersDiscountDetails::setFreeItem()
     * @uses SalesOrdersDiscountDetails::setFreeItemQty()
     * @uses SalesOrdersDiscountDetails::setManualDiscount()
     * @uses SalesOrdersDiscountDetails::setSequenceID()
     * @uses SalesOrdersDiscountDetails::setSkipDiscount()
     * @uses SalesOrdersDiscountDetails::setType()
     * @param \StructType\StringValue $description
     * @param \StructType\DecimalValue $discountableAmount
     * @param \StructType\DecimalValue $discountableQty
     * @param \StructType\DecimalValue $discountAmount
     * @param \StructType\StringValue $discountCode
     * @param \StructType\DecimalValue $discountPercent
     * @param \StructType\StringValue $externalDiscountCode
     * @param \StructType\StringValue $freeItem
     * @param \StructType\DecimalValue $freeItemQty
     * @param \StructType\BooleanValue $manualDiscount
     * @param \StructType\StringValue $sequenceID
     * @param \StructType\BooleanValue $skipDiscount
     * @param \StructType\StringValue $type
     */
    public function __construct(\StructType\StringValue $description = null, \StructType\DecimalValue $discountableAmount = null, \StructType\DecimalValue $discountableQty = null, \StructType\DecimalValue $discountAmount = null, \StructType\StringValue $discountCode = null, \StructType\DecimalValue $discountPercent = null, \StructType\StringValue $externalDiscountCode = null, \StructType\StringValue $freeItem = null, \StructType\DecimalValue $freeItemQty = null, \StructType\BooleanValue $manualDiscount = null, \StructType\StringValue $sequenceID = null, \StructType\BooleanValue $skipDiscount = null, \StructType\StringValue $type = null)
    {
        $this
            ->setDescription($description)
            ->setDiscountableAmount($discountableAmount)
            ->setDiscountableQty($discountableQty)
            ->setDiscountAmount($discountAmount)
            ->setDiscountCode($discountCode)
            ->setDiscountPercent($discountPercent)
            ->setExternalDiscountCode($externalDiscountCode)
            ->setFreeItem($freeItem)
            ->setFreeItemQty($freeItemQty)
            ->setManualDiscount($manualDiscount)
            ->setSequenceID($sequenceID)
            ->setSkipDiscount($skipDiscount)
            ->setType($type);
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $description
     * @return \StructType\SalesOrdersDiscountDetails
     */
    public function setDescription(\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DiscountableAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getDiscountableAmount()
    {
        return isset($this->DiscountableAmount) ? $this->DiscountableAmount : null;
    }
    /**
     * Set DiscountableAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $discountableAmount
     * @return \StructType\SalesOrdersDiscountDetails
     */
    public function setDiscountableAmount(\StructType\DecimalValue $discountableAmount = null)
    {
        if (is_null($discountableAmount) || (is_array($discountableAmount) && empty($discountableAmount))) {
            unset($this->DiscountableAmount);
        } else {
            $this->DiscountableAmount = $discountableAmount;
        }
        return $this;
    }
    /**
     * Get DiscountableQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getDiscountableQty()
    {
        return isset($this->DiscountableQty) ? $this->DiscountableQty : null;
    }
    /**
     * Set DiscountableQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $discountableQty
     * @return \StructType\SalesOrdersDiscountDetails
     */
    public function setDiscountableQty(\StructType\DecimalValue $discountableQty = null)
    {
        if (is_null($discountableQty) || (is_array($discountableQty) && empty($discountableQty))) {
            unset($this->DiscountableQty);
        } else {
            $this->DiscountableQty = $discountableQty;
        }
        return $this;
    }
    /**
     * Get DiscountAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getDiscountAmount()
    {
        return isset($this->DiscountAmount) ? $this->DiscountAmount : null;
    }
    /**
     * Set DiscountAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $discountAmount
     * @return \StructType\SalesOrdersDiscountDetails
     */
    public function setDiscountAmount(\StructType\DecimalValue $discountAmount = null)
    {
        if (is_null($discountAmount) || (is_array($discountAmount) && empty($discountAmount))) {
            unset($this->DiscountAmount);
        } else {
            $this->DiscountAmount = $discountAmount;
        }
        return $this;
    }
    /**
     * Get DiscountCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDiscountCode()
    {
        return isset($this->DiscountCode) ? $this->DiscountCode : null;
    }
    /**
     * Set DiscountCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $discountCode
     * @return \StructType\SalesOrdersDiscountDetails
     */
    public function setDiscountCode(\StructType\StringValue $discountCode = null)
    {
        if (is_null($discountCode) || (is_array($discountCode) && empty($discountCode))) {
            unset($this->DiscountCode);
        } else {
            $this->DiscountCode = $discountCode;
        }
        return $this;
    }
    /**
     * Get DiscountPercent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getDiscountPercent()
    {
        return isset($this->DiscountPercent) ? $this->DiscountPercent : null;
    }
    /**
     * Set DiscountPercent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $discountPercent
     * @return \StructType\SalesOrdersDiscountDetails
     */
    public function setDiscountPercent(\StructType\DecimalValue $discountPercent = null)
    {
        if (is_null($discountPercent) || (is_array($discountPercent) && empty($discountPercent))) {
            unset($this->DiscountPercent);
        } else {
            $this->DiscountPercent = $discountPercent;
        }
        return $this;
    }
    /**
     * Get ExternalDiscountCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getExternalDiscountCode()
    {
        return isset($this->ExternalDiscountCode) ? $this->ExternalDiscountCode : null;
    }
    /**
     * Set ExternalDiscountCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $externalDiscountCode
     * @return \StructType\SalesOrdersDiscountDetails
     */
    public function setExternalDiscountCode(\StructType\StringValue $externalDiscountCode = null)
    {
        if (is_null($externalDiscountCode) || (is_array($externalDiscountCode) && empty($externalDiscountCode))) {
            unset($this->ExternalDiscountCode);
        } else {
            $this->ExternalDiscountCode = $externalDiscountCode;
        }
        return $this;
    }
    /**
     * Get FreeItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getFreeItem()
    {
        return isset($this->FreeItem) ? $this->FreeItem : null;
    }
    /**
     * Set FreeItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $freeItem
     * @return \StructType\SalesOrdersDiscountDetails
     */
    public function setFreeItem(\StructType\StringValue $freeItem = null)
    {
        if (is_null($freeItem) || (is_array($freeItem) && empty($freeItem))) {
            unset($this->FreeItem);
        } else {
            $this->FreeItem = $freeItem;
        }
        return $this;
    }
    /**
     * Get FreeItemQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getFreeItemQty()
    {
        return isset($this->FreeItemQty) ? $this->FreeItemQty : null;
    }
    /**
     * Set FreeItemQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $freeItemQty
     * @return \StructType\SalesOrdersDiscountDetails
     */
    public function setFreeItemQty(\StructType\DecimalValue $freeItemQty = null)
    {
        if (is_null($freeItemQty) || (is_array($freeItemQty) && empty($freeItemQty))) {
            unset($this->FreeItemQty);
        } else {
            $this->FreeItemQty = $freeItemQty;
        }
        return $this;
    }
    /**
     * Get ManualDiscount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getManualDiscount()
    {
        return isset($this->ManualDiscount) ? $this->ManualDiscount : null;
    }
    /**
     * Set ManualDiscount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $manualDiscount
     * @return \StructType\SalesOrdersDiscountDetails
     */
    public function setManualDiscount(\StructType\BooleanValue $manualDiscount = null)
    {
        if (is_null($manualDiscount) || (is_array($manualDiscount) && empty($manualDiscount))) {
            unset($this->ManualDiscount);
        } else {
            $this->ManualDiscount = $manualDiscount;
        }
        return $this;
    }
    /**
     * Get SequenceID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getSequenceID()
    {
        return isset($this->SequenceID) ? $this->SequenceID : null;
    }
    /**
     * Set SequenceID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $sequenceID
     * @return \StructType\SalesOrdersDiscountDetails
     */
    public function setSequenceID(\StructType\StringValue $sequenceID = null)
    {
        if (is_null($sequenceID) || (is_array($sequenceID) && empty($sequenceID))) {
            unset($this->SequenceID);
        } else {
            $this->SequenceID = $sequenceID;
        }
        return $this;
    }
    /**
     * Get SkipDiscount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getSkipDiscount()
    {
        return isset($this->SkipDiscount) ? $this->SkipDiscount : null;
    }
    /**
     * Set SkipDiscount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $skipDiscount
     * @return \StructType\SalesOrdersDiscountDetails
     */
    public function setSkipDiscount(\StructType\BooleanValue $skipDiscount = null)
    {
        if (is_null($skipDiscount) || (is_array($skipDiscount) && empty($skipDiscount))) {
            unset($this->SkipDiscount);
        } else {
            $this->SkipDiscount = $skipDiscount;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $type
     * @return \StructType\SalesOrdersDiscountDetails
     */
    public function setType(\StructType\StringValue $type = null)
    {
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
}
