<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReportingGroup StructType
 * @subpackage Structs
 */
class ReportingGroup extends Entity
{
    /**
     * The GroupType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $GroupType;
    /**
     * The LastModifiedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $LastModifiedDateTime;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Name;
    /**
     * Constructor method for ReportingGroup
     * @uses ReportingGroup::setGroupType()
     * @uses ReportingGroup::setLastModifiedDateTime()
     * @uses ReportingGroup::setName()
     * @param \StructType\StringValue $groupType
     * @param \StructType\DateTimeValue $lastModifiedDateTime
     * @param \StructType\StringValue $name
     */
    public function __construct(\StructType\StringValue $groupType = null, \StructType\DateTimeValue $lastModifiedDateTime = null, \StructType\StringValue $name = null)
    {
        $this
            ->setGroupType($groupType)
            ->setLastModifiedDateTime($lastModifiedDateTime)
            ->setName($name);
    }
    /**
     * Get GroupType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getGroupType()
    {
        return isset($this->GroupType) ? $this->GroupType : null;
    }
    /**
     * Set GroupType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $groupType
     * @return \StructType\ReportingGroup
     */
    public function setGroupType(\StructType\StringValue $groupType = null)
    {
        if (is_null($groupType) || (is_array($groupType) && empty($groupType))) {
            unset($this->GroupType);
        } else {
            $this->GroupType = $groupType;
        }
        return $this;
    }
    /**
     * Get LastModifiedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getLastModifiedDateTime()
    {
        return isset($this->LastModifiedDateTime) ? $this->LastModifiedDateTime : null;
    }
    /**
     * Set LastModifiedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $lastModifiedDateTime
     * @return \StructType\ReportingGroup
     */
    public function setLastModifiedDateTime(\StructType\DateTimeValue $lastModifiedDateTime = null)
    {
        if (is_null($lastModifiedDateTime) || (is_array($lastModifiedDateTime) && empty($lastModifiedDateTime))) {
            unset($this->LastModifiedDateTime);
        } else {
            $this->LastModifiedDateTime = $lastModifiedDateTime;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $name
     * @return \StructType\ReportingGroup
     */
    public function setName(\StructType\StringValue $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
}
