<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Relations StructType
 * @subpackage Structs
 */
class Relations extends AbstractStructBase
{
    /**
     * The RelationDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RelationDetail[]
     */
    public $RelationDetail;
    /**
     * Constructor method for Relations
     * @uses Relations::setRelationDetail()
     * @param \StructType\RelationDetail[] $relationDetail
     */
    public function __construct(array $relationDetail = array())
    {
        $this
            ->setRelationDetail($relationDetail);
    }
    /**
     * Get RelationDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RelationDetail[]|null
     */
    public function getRelationDetail()
    {
        return isset($this->RelationDetail) ? $this->RelationDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRelationDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelationDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRelationDetailForArrayConstraintsFromSetRelationDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $relationsRelationDetailItem) {
            // validation for constraint: itemType
            if (!$relationsRelationDetailItem instanceof \StructType\RelationDetail) {
                $invalidValues[] = is_object($relationsRelationDetailItem) ? get_class($relationsRelationDetailItem) : sprintf('%s(%s)', gettype($relationsRelationDetailItem), var_export($relationsRelationDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RelationDetail property can only contain items of type \StructType\RelationDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RelationDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RelationDetail[] $relationDetail
     * @return \StructType\Relations
     */
    public function setRelationDetail(array $relationDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($relationDetailArrayErrorMessage = self::validateRelationDetailForArrayConstraintsFromSetRelationDetail($relationDetail))) {
            throw new \InvalidArgumentException($relationDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($relationDetail) || (is_array($relationDetail) && empty($relationDetail))) {
            unset($this->RelationDetail);
        } else {
            $this->RelationDetail = $relationDetail;
        }
        return $this;
    }
    /**
     * Add item to RelationDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\RelationDetail $item
     * @return \StructType\Relations
     */
    public function addToRelationDetail(\StructType\RelationDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RelationDetail) {
            throw new \InvalidArgumentException(sprintf('The RelationDetail property can only contain items of type \StructType\RelationDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RelationDetail[] = $item;
        return $this;
    }
}
