<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PurchaseReceipt StructType
 * @subpackage Structs
 */
class PurchaseReceipt extends Entity
{
    /**
     * The BillDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $BillDate;
    /**
     * The Branch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Branch;
    /**
     * The ControlAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $ControlAmount;
    /**
     * The ControlQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $ControlQty;
    /**
     * The CreateBill
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $CreateBill;
    /**
     * The CurrencyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CurrencyID;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $Date;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Details
     */
    public $Details;
    /**
     * The Hold
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $Hold;
    /**
     * The PostPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $PostPeriod;
    /**
     * The ReceiptNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ReceiptNbr;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Status;
    /**
     * The TotalAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $TotalAmount;
    /**
     * The TotalQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $TotalQty;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Type;
    /**
     * The UnbilledQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $UnbilledQuantity;
    /**
     * The VendorID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $VendorID;
    /**
     * The VendorRef
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $VendorRef;
    /**
     * The Warehouse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Warehouse;
    /**
     * Constructor method for PurchaseReceipt
     * @uses PurchaseReceipt::setBillDate()
     * @uses PurchaseReceipt::setBranch()
     * @uses PurchaseReceipt::setControlAmount()
     * @uses PurchaseReceipt::setControlQty()
     * @uses PurchaseReceipt::setCreateBill()
     * @uses PurchaseReceipt::setCurrencyID()
     * @uses PurchaseReceipt::setDate()
     * @uses PurchaseReceipt::setDetails()
     * @uses PurchaseReceipt::setHold()
     * @uses PurchaseReceipt::setPostPeriod()
     * @uses PurchaseReceipt::setReceiptNbr()
     * @uses PurchaseReceipt::setStatus()
     * @uses PurchaseReceipt::setTotalAmount()
     * @uses PurchaseReceipt::setTotalQty()
     * @uses PurchaseReceipt::setType()
     * @uses PurchaseReceipt::setUnbilledQuantity()
     * @uses PurchaseReceipt::setVendorID()
     * @uses PurchaseReceipt::setVendorRef()
     * @uses PurchaseReceipt::setWarehouse()
     * @param \StructType\DateTimeValue $billDate
     * @param \StructType\StringValue $branch
     * @param \StructType\DecimalValue $controlAmount
     * @param \StructType\DecimalValue $controlQty
     * @param \StructType\BooleanValue $createBill
     * @param \StructType\StringValue $currencyID
     * @param \StructType\DateTimeValue $date
     * @param \StructType\Details $details
     * @param \StructType\BooleanValue $hold
     * @param \StructType\StringValue $postPeriod
     * @param \StructType\StringValue $receiptNbr
     * @param \StructType\StringValue $status
     * @param \StructType\DecimalValue $totalAmount
     * @param \StructType\DecimalValue $totalQty
     * @param \StructType\StringValue $type
     * @param \StructType\DecimalValue $unbilledQuantity
     * @param \StructType\StringValue $vendorID
     * @param \StructType\StringValue $vendorRef
     * @param \StructType\StringValue $warehouse
     */
    public function __construct(\StructType\DateTimeValue $billDate = null, \StructType\StringValue $branch = null, \StructType\DecimalValue $controlAmount = null, \StructType\DecimalValue $controlQty = null, \StructType\BooleanValue $createBill = null, \StructType\StringValue $currencyID = null, \StructType\DateTimeValue $date = null, \StructType\Details $details = null, \StructType\BooleanValue $hold = null, \StructType\StringValue $postPeriod = null, \StructType\StringValue $receiptNbr = null, \StructType\StringValue $status = null, \StructType\DecimalValue $totalAmount = null, \StructType\DecimalValue $totalQty = null, \StructType\StringValue $type = null, \StructType\DecimalValue $unbilledQuantity = null, \StructType\StringValue $vendorID = null, \StructType\StringValue $vendorRef = null, \StructType\StringValue $warehouse = null)
    {
        $this
            ->setBillDate($billDate)
            ->setBranch($branch)
            ->setControlAmount($controlAmount)
            ->setControlQty($controlQty)
            ->setCreateBill($createBill)
            ->setCurrencyID($currencyID)
            ->setDate($date)
            ->setDetails($details)
            ->setHold($hold)
            ->setPostPeriod($postPeriod)
            ->setReceiptNbr($receiptNbr)
            ->setStatus($status)
            ->setTotalAmount($totalAmount)
            ->setTotalQty($totalQty)
            ->setType($type)
            ->setUnbilledQuantity($unbilledQuantity)
            ->setVendorID($vendorID)
            ->setVendorRef($vendorRef)
            ->setWarehouse($warehouse);
    }
    /**
     * Get BillDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getBillDate()
    {
        return isset($this->BillDate) ? $this->BillDate : null;
    }
    /**
     * Set BillDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $billDate
     * @return \StructType\PurchaseReceipt
     */
    public function setBillDate(\StructType\DateTimeValue $billDate = null)
    {
        if (is_null($billDate) || (is_array($billDate) && empty($billDate))) {
            unset($this->BillDate);
        } else {
            $this->BillDate = $billDate;
        }
        return $this;
    }
    /**
     * Get Branch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getBranch()
    {
        return isset($this->Branch) ? $this->Branch : null;
    }
    /**
     * Set Branch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $branch
     * @return \StructType\PurchaseReceipt
     */
    public function setBranch(\StructType\StringValue $branch = null)
    {
        if (is_null($branch) || (is_array($branch) && empty($branch))) {
            unset($this->Branch);
        } else {
            $this->Branch = $branch;
        }
        return $this;
    }
    /**
     * Get ControlAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getControlAmount()
    {
        return isset($this->ControlAmount) ? $this->ControlAmount : null;
    }
    /**
     * Set ControlAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $controlAmount
     * @return \StructType\PurchaseReceipt
     */
    public function setControlAmount(\StructType\DecimalValue $controlAmount = null)
    {
        if (is_null($controlAmount) || (is_array($controlAmount) && empty($controlAmount))) {
            unset($this->ControlAmount);
        } else {
            $this->ControlAmount = $controlAmount;
        }
        return $this;
    }
    /**
     * Get ControlQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getControlQty()
    {
        return isset($this->ControlQty) ? $this->ControlQty : null;
    }
    /**
     * Set ControlQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $controlQty
     * @return \StructType\PurchaseReceipt
     */
    public function setControlQty(\StructType\DecimalValue $controlQty = null)
    {
        if (is_null($controlQty) || (is_array($controlQty) && empty($controlQty))) {
            unset($this->ControlQty);
        } else {
            $this->ControlQty = $controlQty;
        }
        return $this;
    }
    /**
     * Get CreateBill value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getCreateBill()
    {
        return isset($this->CreateBill) ? $this->CreateBill : null;
    }
    /**
     * Set CreateBill value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $createBill
     * @return \StructType\PurchaseReceipt
     */
    public function setCreateBill(\StructType\BooleanValue $createBill = null)
    {
        if (is_null($createBill) || (is_array($createBill) && empty($createBill))) {
            unset($this->CreateBill);
        } else {
            $this->CreateBill = $createBill;
        }
        return $this;
    }
    /**
     * Get CurrencyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCurrencyID()
    {
        return isset($this->CurrencyID) ? $this->CurrencyID : null;
    }
    /**
     * Set CurrencyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $currencyID
     * @return \StructType\PurchaseReceipt
     */
    public function setCurrencyID(\StructType\StringValue $currencyID = null)
    {
        if (is_null($currencyID) || (is_array($currencyID) && empty($currencyID))) {
            unset($this->CurrencyID);
        } else {
            $this->CurrencyID = $currencyID;
        }
        return $this;
    }
    /**
     * Get Date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getDate()
    {
        return isset($this->Date) ? $this->Date : null;
    }
    /**
     * Set Date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $date
     * @return \StructType\PurchaseReceipt
     */
    public function setDate(\StructType\DateTimeValue $date = null)
    {
        if (is_null($date) || (is_array($date) && empty($date))) {
            unset($this->Date);
        } else {
            $this->Date = $date;
        }
        return $this;
    }
    /**
     * Get Details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Details|null
     */
    public function getDetails()
    {
        return isset($this->Details) ? $this->Details : null;
    }
    /**
     * Set Details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Details $details
     * @return \StructType\PurchaseReceipt
     */
    public function setDetails(\StructType\Details $details = null)
    {
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->Details);
        } else {
            $this->Details = $details;
        }
        return $this;
    }
    /**
     * Get Hold value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getHold()
    {
        return isset($this->Hold) ? $this->Hold : null;
    }
    /**
     * Set Hold value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $hold
     * @return \StructType\PurchaseReceipt
     */
    public function setHold(\StructType\BooleanValue $hold = null)
    {
        if (is_null($hold) || (is_array($hold) && empty($hold))) {
            unset($this->Hold);
        } else {
            $this->Hold = $hold;
        }
        return $this;
    }
    /**
     * Get PostPeriod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getPostPeriod()
    {
        return isset($this->PostPeriod) ? $this->PostPeriod : null;
    }
    /**
     * Set PostPeriod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $postPeriod
     * @return \StructType\PurchaseReceipt
     */
    public function setPostPeriod(\StructType\StringValue $postPeriod = null)
    {
        if (is_null($postPeriod) || (is_array($postPeriod) && empty($postPeriod))) {
            unset($this->PostPeriod);
        } else {
            $this->PostPeriod = $postPeriod;
        }
        return $this;
    }
    /**
     * Get ReceiptNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getReceiptNbr()
    {
        return isset($this->ReceiptNbr) ? $this->ReceiptNbr : null;
    }
    /**
     * Set ReceiptNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $receiptNbr
     * @return \StructType\PurchaseReceipt
     */
    public function setReceiptNbr(\StructType\StringValue $receiptNbr = null)
    {
        if (is_null($receiptNbr) || (is_array($receiptNbr) && empty($receiptNbr))) {
            unset($this->ReceiptNbr);
        } else {
            $this->ReceiptNbr = $receiptNbr;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $status
     * @return \StructType\PurchaseReceipt
     */
    public function setStatus(\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TotalAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getTotalAmount()
    {
        return isset($this->TotalAmount) ? $this->TotalAmount : null;
    }
    /**
     * Set TotalAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $totalAmount
     * @return \StructType\PurchaseReceipt
     */
    public function setTotalAmount(\StructType\DecimalValue $totalAmount = null)
    {
        if (is_null($totalAmount) || (is_array($totalAmount) && empty($totalAmount))) {
            unset($this->TotalAmount);
        } else {
            $this->TotalAmount = $totalAmount;
        }
        return $this;
    }
    /**
     * Get TotalQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getTotalQty()
    {
        return isset($this->TotalQty) ? $this->TotalQty : null;
    }
    /**
     * Set TotalQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $totalQty
     * @return \StructType\PurchaseReceipt
     */
    public function setTotalQty(\StructType\DecimalValue $totalQty = null)
    {
        if (is_null($totalQty) || (is_array($totalQty) && empty($totalQty))) {
            unset($this->TotalQty);
        } else {
            $this->TotalQty = $totalQty;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $type
     * @return \StructType\PurchaseReceipt
     */
    public function setType(\StructType\StringValue $type = null)
    {
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Get UnbilledQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getUnbilledQuantity()
    {
        return isset($this->UnbilledQuantity) ? $this->UnbilledQuantity : null;
    }
    /**
     * Set UnbilledQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $unbilledQuantity
     * @return \StructType\PurchaseReceipt
     */
    public function setUnbilledQuantity(\StructType\DecimalValue $unbilledQuantity = null)
    {
        if (is_null($unbilledQuantity) || (is_array($unbilledQuantity) && empty($unbilledQuantity))) {
            unset($this->UnbilledQuantity);
        } else {
            $this->UnbilledQuantity = $unbilledQuantity;
        }
        return $this;
    }
    /**
     * Get VendorID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getVendorID()
    {
        return isset($this->VendorID) ? $this->VendorID : null;
    }
    /**
     * Set VendorID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $vendorID
     * @return \StructType\PurchaseReceipt
     */
    public function setVendorID(\StructType\StringValue $vendorID = null)
    {
        if (is_null($vendorID) || (is_array($vendorID) && empty($vendorID))) {
            unset($this->VendorID);
        } else {
            $this->VendorID = $vendorID;
        }
        return $this;
    }
    /**
     * Get VendorRef value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getVendorRef()
    {
        return isset($this->VendorRef) ? $this->VendorRef : null;
    }
    /**
     * Set VendorRef value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $vendorRef
     * @return \StructType\PurchaseReceipt
     */
    public function setVendorRef(\StructType\StringValue $vendorRef = null)
    {
        if (is_null($vendorRef) || (is_array($vendorRef) && empty($vendorRef))) {
            unset($this->VendorRef);
        } else {
            $this->VendorRef = $vendorRef;
        }
        return $this;
    }
    /**
     * Get Warehouse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getWarehouse()
    {
        return isset($this->Warehouse) ? $this->Warehouse : null;
    }
    /**
     * Set Warehouse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $warehouse
     * @return \StructType\PurchaseReceipt
     */
    public function setWarehouse(\StructType\StringValue $warehouse = null)
    {
        if (is_null($warehouse) || (is_array($warehouse) && empty($warehouse))) {
            unset($this->Warehouse);
        } else {
            $this->Warehouse = $warehouse;
        }
        return $this;
    }
}
