<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProjectTransactionDetail StructType
 * @subpackage Structs
 */
class ProjectTransactionDetail extends Entity
{
    /**
     * The AccountGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $AccountGroup;
    /**
     * The AccountGroupDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $AccountGroupDescription;
    /**
     * The Allocated
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $Allocated;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $Amount;
    /**
     * The BatchNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $BatchNbr;
    /**
     * The Billable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $Billable;
    /**
     * The BillableQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $BillableQty;
    /**
     * The Billed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $Billed;
    /**
     * The Branch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Branch;
    /**
     * The CostCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CostCode;
    /**
     * The CreditAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CreditAccount;
    /**
     * The CreditSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CreditSubaccount;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $Date;
    /**
     * The DebitAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $DebitAccount;
    /**
     * The DebitSubaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $DebitSubaccount;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Description;
    /**
     * The EarningType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $EarningType;
    /**
     * The Employee
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Employee;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $EndDate;
    /**
     * The ExternalRefNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ExternalRefNbr;
    /**
     * The FinPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $FinPeriod;
    /**
     * The InventoryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $InventoryID;
    /**
     * The Location
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Location;
    /**
     * The Multiplier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $Multiplier;
    /**
     * The Project
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Project;
    /**
     * The ProjectTask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ProjectTask;
    /**
     * The Qty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $Qty;
    /**
     * The Released
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $Released;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $StartDate;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\LongValue
     */
    public $TransactionID;
    /**
     * The UnitRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $UnitRate;
    /**
     * The UOM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $UOM;
    /**
     * The UseBillableQtyInAmountFormula
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $UseBillableQtyInAmountFormula;
    /**
     * The VendorOrCustomer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $VendorOrCustomer;
    /**
     * Constructor method for ProjectTransactionDetail
     * @uses ProjectTransactionDetail::setAccountGroup()
     * @uses ProjectTransactionDetail::setAccountGroupDescription()
     * @uses ProjectTransactionDetail::setAllocated()
     * @uses ProjectTransactionDetail::setAmount()
     * @uses ProjectTransactionDetail::setBatchNbr()
     * @uses ProjectTransactionDetail::setBillable()
     * @uses ProjectTransactionDetail::setBillableQty()
     * @uses ProjectTransactionDetail::setBilled()
     * @uses ProjectTransactionDetail::setBranch()
     * @uses ProjectTransactionDetail::setCostCode()
     * @uses ProjectTransactionDetail::setCreditAccount()
     * @uses ProjectTransactionDetail::setCreditSubaccount()
     * @uses ProjectTransactionDetail::setDate()
     * @uses ProjectTransactionDetail::setDebitAccount()
     * @uses ProjectTransactionDetail::setDebitSubaccount()
     * @uses ProjectTransactionDetail::setDescription()
     * @uses ProjectTransactionDetail::setEarningType()
     * @uses ProjectTransactionDetail::setEmployee()
     * @uses ProjectTransactionDetail::setEndDate()
     * @uses ProjectTransactionDetail::setExternalRefNbr()
     * @uses ProjectTransactionDetail::setFinPeriod()
     * @uses ProjectTransactionDetail::setInventoryID()
     * @uses ProjectTransactionDetail::setLocation()
     * @uses ProjectTransactionDetail::setMultiplier()
     * @uses ProjectTransactionDetail::setProject()
     * @uses ProjectTransactionDetail::setProjectTask()
     * @uses ProjectTransactionDetail::setQty()
     * @uses ProjectTransactionDetail::setReleased()
     * @uses ProjectTransactionDetail::setStartDate()
     * @uses ProjectTransactionDetail::setTransactionID()
     * @uses ProjectTransactionDetail::setUnitRate()
     * @uses ProjectTransactionDetail::setUOM()
     * @uses ProjectTransactionDetail::setUseBillableQtyInAmountFormula()
     * @uses ProjectTransactionDetail::setVendorOrCustomer()
     * @param \StructType\StringValue $accountGroup
     * @param \StructType\StringValue $accountGroupDescription
     * @param \StructType\BooleanValue $allocated
     * @param \StructType\DecimalValue $amount
     * @param \StructType\StringValue $batchNbr
     * @param \StructType\BooleanValue $billable
     * @param \StructType\DecimalValue $billableQty
     * @param \StructType\BooleanValue $billed
     * @param \StructType\StringValue $branch
     * @param \StructType\StringValue $costCode
     * @param \StructType\StringValue $creditAccount
     * @param \StructType\StringValue $creditSubaccount
     * @param \StructType\DateTimeValue $date
     * @param \StructType\StringValue $debitAccount
     * @param \StructType\StringValue $debitSubaccount
     * @param \StructType\StringValue $description
     * @param \StructType\StringValue $earningType
     * @param \StructType\StringValue $employee
     * @param \StructType\DateTimeValue $endDate
     * @param \StructType\StringValue $externalRefNbr
     * @param \StructType\StringValue $finPeriod
     * @param \StructType\StringValue $inventoryID
     * @param \StructType\StringValue $location
     * @param \StructType\DecimalValue $multiplier
     * @param \StructType\StringValue $project
     * @param \StructType\StringValue $projectTask
     * @param \StructType\DecimalValue $qty
     * @param \StructType\BooleanValue $released
     * @param \StructType\DateTimeValue $startDate
     * @param \StructType\LongValue $transactionID
     * @param \StructType\DecimalValue $unitRate
     * @param \StructType\StringValue $uOM
     * @param \StructType\BooleanValue $useBillableQtyInAmountFormula
     * @param \StructType\StringValue $vendorOrCustomer
     */
    public function __construct(\StructType\StringValue $accountGroup = null, \StructType\StringValue $accountGroupDescription = null, \StructType\BooleanValue $allocated = null, \StructType\DecimalValue $amount = null, \StructType\StringValue $batchNbr = null, \StructType\BooleanValue $billable = null, \StructType\DecimalValue $billableQty = null, \StructType\BooleanValue $billed = null, \StructType\StringValue $branch = null, \StructType\StringValue $costCode = null, \StructType\StringValue $creditAccount = null, \StructType\StringValue $creditSubaccount = null, \StructType\DateTimeValue $date = null, \StructType\StringValue $debitAccount = null, \StructType\StringValue $debitSubaccount = null, \StructType\StringValue $description = null, \StructType\StringValue $earningType = null, \StructType\StringValue $employee = null, \StructType\DateTimeValue $endDate = null, \StructType\StringValue $externalRefNbr = null, \StructType\StringValue $finPeriod = null, \StructType\StringValue $inventoryID = null, \StructType\StringValue $location = null, \StructType\DecimalValue $multiplier = null, \StructType\StringValue $project = null, \StructType\StringValue $projectTask = null, \StructType\DecimalValue $qty = null, \StructType\BooleanValue $released = null, \StructType\DateTimeValue $startDate = null, \StructType\LongValue $transactionID = null, \StructType\DecimalValue $unitRate = null, \StructType\StringValue $uOM = null, \StructType\BooleanValue $useBillableQtyInAmountFormula = null, \StructType\StringValue $vendorOrCustomer = null)
    {
        $this
            ->setAccountGroup($accountGroup)
            ->setAccountGroupDescription($accountGroupDescription)
            ->setAllocated($allocated)
            ->setAmount($amount)
            ->setBatchNbr($batchNbr)
            ->setBillable($billable)
            ->setBillableQty($billableQty)
            ->setBilled($billed)
            ->setBranch($branch)
            ->setCostCode($costCode)
            ->setCreditAccount($creditAccount)
            ->setCreditSubaccount($creditSubaccount)
            ->setDate($date)
            ->setDebitAccount($debitAccount)
            ->setDebitSubaccount($debitSubaccount)
            ->setDescription($description)
            ->setEarningType($earningType)
            ->setEmployee($employee)
            ->setEndDate($endDate)
            ->setExternalRefNbr($externalRefNbr)
            ->setFinPeriod($finPeriod)
            ->setInventoryID($inventoryID)
            ->setLocation($location)
            ->setMultiplier($multiplier)
            ->setProject($project)
            ->setProjectTask($projectTask)
            ->setQty($qty)
            ->setReleased($released)
            ->setStartDate($startDate)
            ->setTransactionID($transactionID)
            ->setUnitRate($unitRate)
            ->setUOM($uOM)
            ->setUseBillableQtyInAmountFormula($useBillableQtyInAmountFormula)
            ->setVendorOrCustomer($vendorOrCustomer);
    }
    /**
     * Get AccountGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getAccountGroup()
    {
        return isset($this->AccountGroup) ? $this->AccountGroup : null;
    }
    /**
     * Set AccountGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $accountGroup
     * @return \StructType\ProjectTransactionDetail
     */
    public function setAccountGroup(\StructType\StringValue $accountGroup = null)
    {
        if (is_null($accountGroup) || (is_array($accountGroup) && empty($accountGroup))) {
            unset($this->AccountGroup);
        } else {
            $this->AccountGroup = $accountGroup;
        }
        return $this;
    }
    /**
     * Get AccountGroupDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getAccountGroupDescription()
    {
        return isset($this->AccountGroupDescription) ? $this->AccountGroupDescription : null;
    }
    /**
     * Set AccountGroupDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $accountGroupDescription
     * @return \StructType\ProjectTransactionDetail
     */
    public function setAccountGroupDescription(\StructType\StringValue $accountGroupDescription = null)
    {
        if (is_null($accountGroupDescription) || (is_array($accountGroupDescription) && empty($accountGroupDescription))) {
            unset($this->AccountGroupDescription);
        } else {
            $this->AccountGroupDescription = $accountGroupDescription;
        }
        return $this;
    }
    /**
     * Get Allocated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getAllocated()
    {
        return isset($this->Allocated) ? $this->Allocated : null;
    }
    /**
     * Set Allocated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $allocated
     * @return \StructType\ProjectTransactionDetail
     */
    public function setAllocated(\StructType\BooleanValue $allocated = null)
    {
        if (is_null($allocated) || (is_array($allocated) && empty($allocated))) {
            unset($this->Allocated);
        } else {
            $this->Allocated = $allocated;
        }
        return $this;
    }
    /**
     * Get Amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * Set Amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $amount
     * @return \StructType\ProjectTransactionDetail
     */
    public function setAmount(\StructType\DecimalValue $amount = null)
    {
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get BatchNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getBatchNbr()
    {
        return isset($this->BatchNbr) ? $this->BatchNbr : null;
    }
    /**
     * Set BatchNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $batchNbr
     * @return \StructType\ProjectTransactionDetail
     */
    public function setBatchNbr(\StructType\StringValue $batchNbr = null)
    {
        if (is_null($batchNbr) || (is_array($batchNbr) && empty($batchNbr))) {
            unset($this->BatchNbr);
        } else {
            $this->BatchNbr = $batchNbr;
        }
        return $this;
    }
    /**
     * Get Billable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getBillable()
    {
        return isset($this->Billable) ? $this->Billable : null;
    }
    /**
     * Set Billable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $billable
     * @return \StructType\ProjectTransactionDetail
     */
    public function setBillable(\StructType\BooleanValue $billable = null)
    {
        if (is_null($billable) || (is_array($billable) && empty($billable))) {
            unset($this->Billable);
        } else {
            $this->Billable = $billable;
        }
        return $this;
    }
    /**
     * Get BillableQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getBillableQty()
    {
        return isset($this->BillableQty) ? $this->BillableQty : null;
    }
    /**
     * Set BillableQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $billableQty
     * @return \StructType\ProjectTransactionDetail
     */
    public function setBillableQty(\StructType\DecimalValue $billableQty = null)
    {
        if (is_null($billableQty) || (is_array($billableQty) && empty($billableQty))) {
            unset($this->BillableQty);
        } else {
            $this->BillableQty = $billableQty;
        }
        return $this;
    }
    /**
     * Get Billed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getBilled()
    {
        return isset($this->Billed) ? $this->Billed : null;
    }
    /**
     * Set Billed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $billed
     * @return \StructType\ProjectTransactionDetail
     */
    public function setBilled(\StructType\BooleanValue $billed = null)
    {
        if (is_null($billed) || (is_array($billed) && empty($billed))) {
            unset($this->Billed);
        } else {
            $this->Billed = $billed;
        }
        return $this;
    }
    /**
     * Get Branch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getBranch()
    {
        return isset($this->Branch) ? $this->Branch : null;
    }
    /**
     * Set Branch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $branch
     * @return \StructType\ProjectTransactionDetail
     */
    public function setBranch(\StructType\StringValue $branch = null)
    {
        if (is_null($branch) || (is_array($branch) && empty($branch))) {
            unset($this->Branch);
        } else {
            $this->Branch = $branch;
        }
        return $this;
    }
    /**
     * Get CostCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCostCode()
    {
        return isset($this->CostCode) ? $this->CostCode : null;
    }
    /**
     * Set CostCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $costCode
     * @return \StructType\ProjectTransactionDetail
     */
    public function setCostCode(\StructType\StringValue $costCode = null)
    {
        if (is_null($costCode) || (is_array($costCode) && empty($costCode))) {
            unset($this->CostCode);
        } else {
            $this->CostCode = $costCode;
        }
        return $this;
    }
    /**
     * Get CreditAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCreditAccount()
    {
        return isset($this->CreditAccount) ? $this->CreditAccount : null;
    }
    /**
     * Set CreditAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $creditAccount
     * @return \StructType\ProjectTransactionDetail
     */
    public function setCreditAccount(\StructType\StringValue $creditAccount = null)
    {
        if (is_null($creditAccount) || (is_array($creditAccount) && empty($creditAccount))) {
            unset($this->CreditAccount);
        } else {
            $this->CreditAccount = $creditAccount;
        }
        return $this;
    }
    /**
     * Get CreditSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCreditSubaccount()
    {
        return isset($this->CreditSubaccount) ? $this->CreditSubaccount : null;
    }
    /**
     * Set CreditSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $creditSubaccount
     * @return \StructType\ProjectTransactionDetail
     */
    public function setCreditSubaccount(\StructType\StringValue $creditSubaccount = null)
    {
        if (is_null($creditSubaccount) || (is_array($creditSubaccount) && empty($creditSubaccount))) {
            unset($this->CreditSubaccount);
        } else {
            $this->CreditSubaccount = $creditSubaccount;
        }
        return $this;
    }
    /**
     * Get Date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getDate()
    {
        return isset($this->Date) ? $this->Date : null;
    }
    /**
     * Set Date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $date
     * @return \StructType\ProjectTransactionDetail
     */
    public function setDate(\StructType\DateTimeValue $date = null)
    {
        if (is_null($date) || (is_array($date) && empty($date))) {
            unset($this->Date);
        } else {
            $this->Date = $date;
        }
        return $this;
    }
    /**
     * Get DebitAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDebitAccount()
    {
        return isset($this->DebitAccount) ? $this->DebitAccount : null;
    }
    /**
     * Set DebitAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $debitAccount
     * @return \StructType\ProjectTransactionDetail
     */
    public function setDebitAccount(\StructType\StringValue $debitAccount = null)
    {
        if (is_null($debitAccount) || (is_array($debitAccount) && empty($debitAccount))) {
            unset($this->DebitAccount);
        } else {
            $this->DebitAccount = $debitAccount;
        }
        return $this;
    }
    /**
     * Get DebitSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDebitSubaccount()
    {
        return isset($this->DebitSubaccount) ? $this->DebitSubaccount : null;
    }
    /**
     * Set DebitSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $debitSubaccount
     * @return \StructType\ProjectTransactionDetail
     */
    public function setDebitSubaccount(\StructType\StringValue $debitSubaccount = null)
    {
        if (is_null($debitSubaccount) || (is_array($debitSubaccount) && empty($debitSubaccount))) {
            unset($this->DebitSubaccount);
        } else {
            $this->DebitSubaccount = $debitSubaccount;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $description
     * @return \StructType\ProjectTransactionDetail
     */
    public function setDescription(\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get EarningType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getEarningType()
    {
        return isset($this->EarningType) ? $this->EarningType : null;
    }
    /**
     * Set EarningType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $earningType
     * @return \StructType\ProjectTransactionDetail
     */
    public function setEarningType(\StructType\StringValue $earningType = null)
    {
        if (is_null($earningType) || (is_array($earningType) && empty($earningType))) {
            unset($this->EarningType);
        } else {
            $this->EarningType = $earningType;
        }
        return $this;
    }
    /**
     * Get Employee value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getEmployee()
    {
        return isset($this->Employee) ? $this->Employee : null;
    }
    /**
     * Set Employee value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $employee
     * @return \StructType\ProjectTransactionDetail
     */
    public function setEmployee(\StructType\StringValue $employee = null)
    {
        if (is_null($employee) || (is_array($employee) && empty($employee))) {
            unset($this->Employee);
        } else {
            $this->Employee = $employee;
        }
        return $this;
    }
    /**
     * Get EndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getEndDate()
    {
        return isset($this->EndDate) ? $this->EndDate : null;
    }
    /**
     * Set EndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $endDate
     * @return \StructType\ProjectTransactionDetail
     */
    public function setEndDate(\StructType\DateTimeValue $endDate = null)
    {
        if (is_null($endDate) || (is_array($endDate) && empty($endDate))) {
            unset($this->EndDate);
        } else {
            $this->EndDate = $endDate;
        }
        return $this;
    }
    /**
     * Get ExternalRefNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getExternalRefNbr()
    {
        return isset($this->ExternalRefNbr) ? $this->ExternalRefNbr : null;
    }
    /**
     * Set ExternalRefNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $externalRefNbr
     * @return \StructType\ProjectTransactionDetail
     */
    public function setExternalRefNbr(\StructType\StringValue $externalRefNbr = null)
    {
        if (is_null($externalRefNbr) || (is_array($externalRefNbr) && empty($externalRefNbr))) {
            unset($this->ExternalRefNbr);
        } else {
            $this->ExternalRefNbr = $externalRefNbr;
        }
        return $this;
    }
    /**
     * Get FinPeriod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getFinPeriod()
    {
        return isset($this->FinPeriod) ? $this->FinPeriod : null;
    }
    /**
     * Set FinPeriod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $finPeriod
     * @return \StructType\ProjectTransactionDetail
     */
    public function setFinPeriod(\StructType\StringValue $finPeriod = null)
    {
        if (is_null($finPeriod) || (is_array($finPeriod) && empty($finPeriod))) {
            unset($this->FinPeriod);
        } else {
            $this->FinPeriod = $finPeriod;
        }
        return $this;
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $inventoryID
     * @return \StructType\ProjectTransactionDetail
     */
    public function setInventoryID(\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get Location value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getLocation()
    {
        return isset($this->Location) ? $this->Location : null;
    }
    /**
     * Set Location value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $location
     * @return \StructType\ProjectTransactionDetail
     */
    public function setLocation(\StructType\StringValue $location = null)
    {
        if (is_null($location) || (is_array($location) && empty($location))) {
            unset($this->Location);
        } else {
            $this->Location = $location;
        }
        return $this;
    }
    /**
     * Get Multiplier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getMultiplier()
    {
        return isset($this->Multiplier) ? $this->Multiplier : null;
    }
    /**
     * Set Multiplier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $multiplier
     * @return \StructType\ProjectTransactionDetail
     */
    public function setMultiplier(\StructType\DecimalValue $multiplier = null)
    {
        if (is_null($multiplier) || (is_array($multiplier) && empty($multiplier))) {
            unset($this->Multiplier);
        } else {
            $this->Multiplier = $multiplier;
        }
        return $this;
    }
    /**
     * Get Project value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getProject()
    {
        return isset($this->Project) ? $this->Project : null;
    }
    /**
     * Set Project value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $project
     * @return \StructType\ProjectTransactionDetail
     */
    public function setProject(\StructType\StringValue $project = null)
    {
        if (is_null($project) || (is_array($project) && empty($project))) {
            unset($this->Project);
        } else {
            $this->Project = $project;
        }
        return $this;
    }
    /**
     * Get ProjectTask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getProjectTask()
    {
        return isset($this->ProjectTask) ? $this->ProjectTask : null;
    }
    /**
     * Set ProjectTask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $projectTask
     * @return \StructType\ProjectTransactionDetail
     */
    public function setProjectTask(\StructType\StringValue $projectTask = null)
    {
        if (is_null($projectTask) || (is_array($projectTask) && empty($projectTask))) {
            unset($this->ProjectTask);
        } else {
            $this->ProjectTask = $projectTask;
        }
        return $this;
    }
    /**
     * Get Qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getQty()
    {
        return isset($this->Qty) ? $this->Qty : null;
    }
    /**
     * Set Qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $qty
     * @return \StructType\ProjectTransactionDetail
     */
    public function setQty(\StructType\DecimalValue $qty = null)
    {
        if (is_null($qty) || (is_array($qty) && empty($qty))) {
            unset($this->Qty);
        } else {
            $this->Qty = $qty;
        }
        return $this;
    }
    /**
     * Get Released value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getReleased()
    {
        return isset($this->Released) ? $this->Released : null;
    }
    /**
     * Set Released value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $released
     * @return \StructType\ProjectTransactionDetail
     */
    public function setReleased(\StructType\BooleanValue $released = null)
    {
        if (is_null($released) || (is_array($released) && empty($released))) {
            unset($this->Released);
        } else {
            $this->Released = $released;
        }
        return $this;
    }
    /**
     * Get StartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getStartDate()
    {
        return isset($this->StartDate) ? $this->StartDate : null;
    }
    /**
     * Set StartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $startDate
     * @return \StructType\ProjectTransactionDetail
     */
    public function setStartDate(\StructType\DateTimeValue $startDate = null)
    {
        if (is_null($startDate) || (is_array($startDate) && empty($startDate))) {
            unset($this->StartDate);
        } else {
            $this->StartDate = $startDate;
        }
        return $this;
    }
    /**
     * Get TransactionID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\LongValue|null
     */
    public function getTransactionID()
    {
        return isset($this->TransactionID) ? $this->TransactionID : null;
    }
    /**
     * Set TransactionID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\LongValue $transactionID
     * @return \StructType\ProjectTransactionDetail
     */
    public function setTransactionID(\StructType\LongValue $transactionID = null)
    {
        if (is_null($transactionID) || (is_array($transactionID) && empty($transactionID))) {
            unset($this->TransactionID);
        } else {
            $this->TransactionID = $transactionID;
        }
        return $this;
    }
    /**
     * Get UnitRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getUnitRate()
    {
        return isset($this->UnitRate) ? $this->UnitRate : null;
    }
    /**
     * Set UnitRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $unitRate
     * @return \StructType\ProjectTransactionDetail
     */
    public function setUnitRate(\StructType\DecimalValue $unitRate = null)
    {
        if (is_null($unitRate) || (is_array($unitRate) && empty($unitRate))) {
            unset($this->UnitRate);
        } else {
            $this->UnitRate = $unitRate;
        }
        return $this;
    }
    /**
     * Get UOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getUOM()
    {
        return isset($this->UOM) ? $this->UOM : null;
    }
    /**
     * Set UOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $uOM
     * @return \StructType\ProjectTransactionDetail
     */
    public function setUOM(\StructType\StringValue $uOM = null)
    {
        if (is_null($uOM) || (is_array($uOM) && empty($uOM))) {
            unset($this->UOM);
        } else {
            $this->UOM = $uOM;
        }
        return $this;
    }
    /**
     * Get UseBillableQtyInAmountFormula value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getUseBillableQtyInAmountFormula()
    {
        return isset($this->UseBillableQtyInAmountFormula) ? $this->UseBillableQtyInAmountFormula : null;
    }
    /**
     * Set UseBillableQtyInAmountFormula value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $useBillableQtyInAmountFormula
     * @return \StructType\ProjectTransactionDetail
     */
    public function setUseBillableQtyInAmountFormula(\StructType\BooleanValue $useBillableQtyInAmountFormula = null)
    {
        if (is_null($useBillableQtyInAmountFormula) || (is_array($useBillableQtyInAmountFormula) && empty($useBillableQtyInAmountFormula))) {
            unset($this->UseBillableQtyInAmountFormula);
        } else {
            $this->UseBillableQtyInAmountFormula = $useBillableQtyInAmountFormula;
        }
        return $this;
    }
    /**
     * Get VendorOrCustomer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getVendorOrCustomer()
    {
        return isset($this->VendorOrCustomer) ? $this->VendorOrCustomer : null;
    }
    /**
     * Set VendorOrCustomer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $vendorOrCustomer
     * @return \StructType\ProjectTransactionDetail
     */
    public function setVendorOrCustomer(\StructType\StringValue $vendorOrCustomer = null)
    {
        if (is_null($vendorOrCustomer) || (is_array($vendorOrCustomer) && empty($vendorOrCustomer))) {
            unset($this->VendorOrCustomer);
        } else {
            $this->VendorOrCustomer = $vendorOrCustomer;
        }
        return $this;
    }
}
