<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PhysicalInventoryReviewDetail StructType
 * @subpackage Structs
 */
class PhysicalInventoryReviewDetail extends Entity
{
    /**
     * The BookQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $BookQty;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Description;
    /**
     * The ExpirationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $ExpirationDate;
    /**
     * The ExtendedVarianceCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $ExtendedVarianceCost;
    /**
     * The InventoryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $InventoryID;
    /**
     * The LineNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IntValue
     */
    public $LineNbr;
    /**
     * The LocationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $LocationID;
    /**
     * The LotSerialNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $LotSerialNbr;
    /**
     * The PhysicalQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $PhysicalQty;
    /**
     * The ReasonCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ReasonCode;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Status;
    /**
     * The Subitem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Subitem;
    /**
     * The TagNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IntValue
     */
    public $TagNbr;
    /**
     * The UnitCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $UnitCost;
    /**
     * The VarianceQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $VarianceQty;
    /**
     * Constructor method for PhysicalInventoryReviewDetail
     * @uses PhysicalInventoryReviewDetail::setBookQty()
     * @uses PhysicalInventoryReviewDetail::setDescription()
     * @uses PhysicalInventoryReviewDetail::setExpirationDate()
     * @uses PhysicalInventoryReviewDetail::setExtendedVarianceCost()
     * @uses PhysicalInventoryReviewDetail::setInventoryID()
     * @uses PhysicalInventoryReviewDetail::setLineNbr()
     * @uses PhysicalInventoryReviewDetail::setLocationID()
     * @uses PhysicalInventoryReviewDetail::setLotSerialNbr()
     * @uses PhysicalInventoryReviewDetail::setPhysicalQty()
     * @uses PhysicalInventoryReviewDetail::setReasonCode()
     * @uses PhysicalInventoryReviewDetail::setStatus()
     * @uses PhysicalInventoryReviewDetail::setSubitem()
     * @uses PhysicalInventoryReviewDetail::setTagNbr()
     * @uses PhysicalInventoryReviewDetail::setUnitCost()
     * @uses PhysicalInventoryReviewDetail::setVarianceQty()
     * @param \StructType\DecimalValue $bookQty
     * @param \StructType\StringValue $description
     * @param \StructType\DateTimeValue $expirationDate
     * @param \StructType\DecimalValue $extendedVarianceCost
     * @param \StructType\StringValue $inventoryID
     * @param \StructType\IntValue $lineNbr
     * @param \StructType\StringValue $locationID
     * @param \StructType\StringValue $lotSerialNbr
     * @param \StructType\DecimalValue $physicalQty
     * @param \StructType\StringValue $reasonCode
     * @param \StructType\StringValue $status
     * @param \StructType\StringValue $subitem
     * @param \StructType\IntValue $tagNbr
     * @param \StructType\DecimalValue $unitCost
     * @param \StructType\DecimalValue $varianceQty
     */
    public function __construct(\StructType\DecimalValue $bookQty = null, \StructType\StringValue $description = null, \StructType\DateTimeValue $expirationDate = null, \StructType\DecimalValue $extendedVarianceCost = null, \StructType\StringValue $inventoryID = null, \StructType\IntValue $lineNbr = null, \StructType\StringValue $locationID = null, \StructType\StringValue $lotSerialNbr = null, \StructType\DecimalValue $physicalQty = null, \StructType\StringValue $reasonCode = null, \StructType\StringValue $status = null, \StructType\StringValue $subitem = null, \StructType\IntValue $tagNbr = null, \StructType\DecimalValue $unitCost = null, \StructType\DecimalValue $varianceQty = null)
    {
        $this
            ->setBookQty($bookQty)
            ->setDescription($description)
            ->setExpirationDate($expirationDate)
            ->setExtendedVarianceCost($extendedVarianceCost)
            ->setInventoryID($inventoryID)
            ->setLineNbr($lineNbr)
            ->setLocationID($locationID)
            ->setLotSerialNbr($lotSerialNbr)
            ->setPhysicalQty($physicalQty)
            ->setReasonCode($reasonCode)
            ->setStatus($status)
            ->setSubitem($subitem)
            ->setTagNbr($tagNbr)
            ->setUnitCost($unitCost)
            ->setVarianceQty($varianceQty);
    }
    /**
     * Get BookQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getBookQty()
    {
        return isset($this->BookQty) ? $this->BookQty : null;
    }
    /**
     * Set BookQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $bookQty
     * @return \StructType\PhysicalInventoryReviewDetail
     */
    public function setBookQty(\StructType\DecimalValue $bookQty = null)
    {
        if (is_null($bookQty) || (is_array($bookQty) && empty($bookQty))) {
            unset($this->BookQty);
        } else {
            $this->BookQty = $bookQty;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $description
     * @return \StructType\PhysicalInventoryReviewDetail
     */
    public function setDescription(\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get ExpirationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getExpirationDate()
    {
        return isset($this->ExpirationDate) ? $this->ExpirationDate : null;
    }
    /**
     * Set ExpirationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $expirationDate
     * @return \StructType\PhysicalInventoryReviewDetail
     */
    public function setExpirationDate(\StructType\DateTimeValue $expirationDate = null)
    {
        if (is_null($expirationDate) || (is_array($expirationDate) && empty($expirationDate))) {
            unset($this->ExpirationDate);
        } else {
            $this->ExpirationDate = $expirationDate;
        }
        return $this;
    }
    /**
     * Get ExtendedVarianceCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getExtendedVarianceCost()
    {
        return isset($this->ExtendedVarianceCost) ? $this->ExtendedVarianceCost : null;
    }
    /**
     * Set ExtendedVarianceCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $extendedVarianceCost
     * @return \StructType\PhysicalInventoryReviewDetail
     */
    public function setExtendedVarianceCost(\StructType\DecimalValue $extendedVarianceCost = null)
    {
        if (is_null($extendedVarianceCost) || (is_array($extendedVarianceCost) && empty($extendedVarianceCost))) {
            unset($this->ExtendedVarianceCost);
        } else {
            $this->ExtendedVarianceCost = $extendedVarianceCost;
        }
        return $this;
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $inventoryID
     * @return \StructType\PhysicalInventoryReviewDetail
     */
    public function setInventoryID(\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get LineNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IntValue|null
     */
    public function getLineNbr()
    {
        return isset($this->LineNbr) ? $this->LineNbr : null;
    }
    /**
     * Set LineNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\IntValue $lineNbr
     * @return \StructType\PhysicalInventoryReviewDetail
     */
    public function setLineNbr(\StructType\IntValue $lineNbr = null)
    {
        if (is_null($lineNbr) || (is_array($lineNbr) && empty($lineNbr))) {
            unset($this->LineNbr);
        } else {
            $this->LineNbr = $lineNbr;
        }
        return $this;
    }
    /**
     * Get LocationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getLocationID()
    {
        return isset($this->LocationID) ? $this->LocationID : null;
    }
    /**
     * Set LocationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $locationID
     * @return \StructType\PhysicalInventoryReviewDetail
     */
    public function setLocationID(\StructType\StringValue $locationID = null)
    {
        if (is_null($locationID) || (is_array($locationID) && empty($locationID))) {
            unset($this->LocationID);
        } else {
            $this->LocationID = $locationID;
        }
        return $this;
    }
    /**
     * Get LotSerialNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getLotSerialNbr()
    {
        return isset($this->LotSerialNbr) ? $this->LotSerialNbr : null;
    }
    /**
     * Set LotSerialNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $lotSerialNbr
     * @return \StructType\PhysicalInventoryReviewDetail
     */
    public function setLotSerialNbr(\StructType\StringValue $lotSerialNbr = null)
    {
        if (is_null($lotSerialNbr) || (is_array($lotSerialNbr) && empty($lotSerialNbr))) {
            unset($this->LotSerialNbr);
        } else {
            $this->LotSerialNbr = $lotSerialNbr;
        }
        return $this;
    }
    /**
     * Get PhysicalQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getPhysicalQty()
    {
        return isset($this->PhysicalQty) ? $this->PhysicalQty : null;
    }
    /**
     * Set PhysicalQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $physicalQty
     * @return \StructType\PhysicalInventoryReviewDetail
     */
    public function setPhysicalQty(\StructType\DecimalValue $physicalQty = null)
    {
        if (is_null($physicalQty) || (is_array($physicalQty) && empty($physicalQty))) {
            unset($this->PhysicalQty);
        } else {
            $this->PhysicalQty = $physicalQty;
        }
        return $this;
    }
    /**
     * Get ReasonCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getReasonCode()
    {
        return isset($this->ReasonCode) ? $this->ReasonCode : null;
    }
    /**
     * Set ReasonCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $reasonCode
     * @return \StructType\PhysicalInventoryReviewDetail
     */
    public function setReasonCode(\StructType\StringValue $reasonCode = null)
    {
        if (is_null($reasonCode) || (is_array($reasonCode) && empty($reasonCode))) {
            unset($this->ReasonCode);
        } else {
            $this->ReasonCode = $reasonCode;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $status
     * @return \StructType\PhysicalInventoryReviewDetail
     */
    public function setStatus(\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get Subitem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getSubitem()
    {
        return isset($this->Subitem) ? $this->Subitem : null;
    }
    /**
     * Set Subitem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $subitem
     * @return \StructType\PhysicalInventoryReviewDetail
     */
    public function setSubitem(\StructType\StringValue $subitem = null)
    {
        if (is_null($subitem) || (is_array($subitem) && empty($subitem))) {
            unset($this->Subitem);
        } else {
            $this->Subitem = $subitem;
        }
        return $this;
    }
    /**
     * Get TagNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IntValue|null
     */
    public function getTagNbr()
    {
        return isset($this->TagNbr) ? $this->TagNbr : null;
    }
    /**
     * Set TagNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\IntValue $tagNbr
     * @return \StructType\PhysicalInventoryReviewDetail
     */
    public function setTagNbr(\StructType\IntValue $tagNbr = null)
    {
        if (is_null($tagNbr) || (is_array($tagNbr) && empty($tagNbr))) {
            unset($this->TagNbr);
        } else {
            $this->TagNbr = $tagNbr;
        }
        return $this;
    }
    /**
     * Get UnitCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getUnitCost()
    {
        return isset($this->UnitCost) ? $this->UnitCost : null;
    }
    /**
     * Set UnitCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $unitCost
     * @return \StructType\PhysicalInventoryReviewDetail
     */
    public function setUnitCost(\StructType\DecimalValue $unitCost = null)
    {
        if (is_null($unitCost) || (is_array($unitCost) && empty($unitCost))) {
            unset($this->UnitCost);
        } else {
            $this->UnitCost = $unitCost;
        }
        return $this;
    }
    /**
     * Get VarianceQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getVarianceQty()
    {
        return isset($this->VarianceQty) ? $this->VarianceQty : null;
    }
    /**
     * Set VarianceQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $varianceQty
     * @return \StructType\PhysicalInventoryReviewDetail
     */
    public function setVarianceQty(\StructType\DecimalValue $varianceQty = null)
    {
        if (is_null($varianceQty) || (is_array($varianceQty) && empty($varianceQty))) {
            unset($this->VarianceQty);
        } else {
            $this->VarianceQty = $varianceQty;
        }
        return $this;
    }
}
