<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NonStockComponents StructType
 * @subpackage Structs
 */
class NonStockComponents extends AbstractStructBase
{
    /**
     * The KitNonStockComponent
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\KitNonStockComponent[]
     */
    public $KitNonStockComponent;
    /**
     * The KitAssemblyNonStockComponent
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\KitAssemblyNonStockComponent[]
     */
    public $KitAssemblyNonStockComponent;
    /**
     * Constructor method for NonStockComponents
     * @uses NonStockComponents::setKitNonStockComponent()
     * @uses NonStockComponents::setKitAssemblyNonStockComponent()
     * @param \StructType\KitNonStockComponent[] $kitNonStockComponent
     * @param \StructType\KitAssemblyNonStockComponent[] $kitAssemblyNonStockComponent
     */
    public function __construct(array $kitNonStockComponent = array(), array $kitAssemblyNonStockComponent = array())
    {
        $this
            ->setKitNonStockComponent($kitNonStockComponent)
            ->setKitAssemblyNonStockComponent($kitAssemblyNonStockComponent);
    }
    /**
     * Get KitNonStockComponent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\KitNonStockComponent[]|null
     */
    public function getKitNonStockComponent()
    {
        return isset($this->KitNonStockComponent) ? $this->KitNonStockComponent : null;
    }
    /**
     * This method is responsible for validating the values passed to the setKitNonStockComponent method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKitNonStockComponent method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKitNonStockComponentForArrayConstraintsFromSetKitNonStockComponent(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $nonStockComponentsKitNonStockComponentItem) {
            // validation for constraint: itemType
            if (!$nonStockComponentsKitNonStockComponentItem instanceof \StructType\KitNonStockComponent) {
                $invalidValues[] = is_object($nonStockComponentsKitNonStockComponentItem) ? get_class($nonStockComponentsKitNonStockComponentItem) : sprintf('%s(%s)', gettype($nonStockComponentsKitNonStockComponentItem), var_export($nonStockComponentsKitNonStockComponentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The KitNonStockComponent property can only contain items of type \StructType\KitNonStockComponent, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set KitNonStockComponent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\KitNonStockComponent[] $kitNonStockComponent
     * @return \StructType\NonStockComponents
     */
    public function setKitNonStockComponent(array $kitNonStockComponent = array())
    {
        // validation for constraint: array
        if ('' !== ($kitNonStockComponentArrayErrorMessage = self::validateKitNonStockComponentForArrayConstraintsFromSetKitNonStockComponent($kitNonStockComponent))) {
            throw new \InvalidArgumentException($kitNonStockComponentArrayErrorMessage, __LINE__);
        }
        if (is_null($kitNonStockComponent) || (is_array($kitNonStockComponent) && empty($kitNonStockComponent))) {
            unset($this->KitNonStockComponent);
        } else {
            $this->KitNonStockComponent = $kitNonStockComponent;
        }
        return $this;
    }
    /**
     * Add item to KitNonStockComponent value
     * @throws \InvalidArgumentException
     * @param \StructType\KitNonStockComponent $item
     * @return \StructType\NonStockComponents
     */
    public function addToKitNonStockComponent(\StructType\KitNonStockComponent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KitNonStockComponent) {
            throw new \InvalidArgumentException(sprintf('The KitNonStockComponent property can only contain items of type \StructType\KitNonStockComponent, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->KitNonStockComponent[] = $item;
        return $this;
    }
    /**
     * Get KitAssemblyNonStockComponent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\KitAssemblyNonStockComponent[]|null
     */
    public function getKitAssemblyNonStockComponent()
    {
        return isset($this->KitAssemblyNonStockComponent) ? $this->KitAssemblyNonStockComponent : null;
    }
    /**
     * This method is responsible for validating the values passed to the setKitAssemblyNonStockComponent method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKitAssemblyNonStockComponent method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKitAssemblyNonStockComponentForArrayConstraintsFromSetKitAssemblyNonStockComponent(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $nonStockComponentsKitAssemblyNonStockComponentItem) {
            // validation for constraint: itemType
            if (!$nonStockComponentsKitAssemblyNonStockComponentItem instanceof \StructType\KitAssemblyNonStockComponent) {
                $invalidValues[] = is_object($nonStockComponentsKitAssemblyNonStockComponentItem) ? get_class($nonStockComponentsKitAssemblyNonStockComponentItem) : sprintf('%s(%s)', gettype($nonStockComponentsKitAssemblyNonStockComponentItem), var_export($nonStockComponentsKitAssemblyNonStockComponentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The KitAssemblyNonStockComponent property can only contain items of type \StructType\KitAssemblyNonStockComponent, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set KitAssemblyNonStockComponent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\KitAssemblyNonStockComponent[] $kitAssemblyNonStockComponent
     * @return \StructType\NonStockComponents
     */
    public function setKitAssemblyNonStockComponent(array $kitAssemblyNonStockComponent = array())
    {
        // validation for constraint: array
        if ('' !== ($kitAssemblyNonStockComponentArrayErrorMessage = self::validateKitAssemblyNonStockComponentForArrayConstraintsFromSetKitAssemblyNonStockComponent($kitAssemblyNonStockComponent))) {
            throw new \InvalidArgumentException($kitAssemblyNonStockComponentArrayErrorMessage, __LINE__);
        }
        if (is_null($kitAssemblyNonStockComponent) || (is_array($kitAssemblyNonStockComponent) && empty($kitAssemblyNonStockComponent))) {
            unset($this->KitAssemblyNonStockComponent);
        } else {
            $this->KitAssemblyNonStockComponent = $kitAssemblyNonStockComponent;
        }
        return $this;
    }
    /**
     * Add item to KitAssemblyNonStockComponent value
     * @throws \InvalidArgumentException
     * @param \StructType\KitAssemblyNonStockComponent $item
     * @return \StructType\NonStockComponents
     */
    public function addToKitAssemblyNonStockComponent(\StructType\KitAssemblyNonStockComponent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KitAssemblyNonStockComponent) {
            throw new \InvalidArgumentException(sprintf('The KitAssemblyNonStockComponent property can only contain items of type \StructType\KitAssemblyNonStockComponent, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->KitAssemblyNonStockComponent[] = $item;
        return $this;
    }
}
