<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Locations StructType
 * @subpackage Structs
 */
class Locations extends AbstractStructBase
{
    /**
     * The WarehouseLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WarehouseLocation[]
     */
    public $WarehouseLocation;
    /**
     * The BusinessAccountLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BusinessAccountLocation[]
     */
    public $BusinessAccountLocation;
    /**
     * Constructor method for Locations
     * @uses Locations::setWarehouseLocation()
     * @uses Locations::setBusinessAccountLocation()
     * @param \StructType\WarehouseLocation[] $warehouseLocation
     * @param \StructType\BusinessAccountLocation[] $businessAccountLocation
     */
    public function __construct(array $warehouseLocation = array(), array $businessAccountLocation = array())
    {
        $this
            ->setWarehouseLocation($warehouseLocation)
            ->setBusinessAccountLocation($businessAccountLocation);
    }
    /**
     * Get WarehouseLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WarehouseLocation[]|null
     */
    public function getWarehouseLocation()
    {
        return isset($this->WarehouseLocation) ? $this->WarehouseLocation : null;
    }
    /**
     * This method is responsible for validating the values passed to the setWarehouseLocation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWarehouseLocation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWarehouseLocationForArrayConstraintsFromSetWarehouseLocation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationsWarehouseLocationItem) {
            // validation for constraint: itemType
            if (!$locationsWarehouseLocationItem instanceof \StructType\WarehouseLocation) {
                $invalidValues[] = is_object($locationsWarehouseLocationItem) ? get_class($locationsWarehouseLocationItem) : sprintf('%s(%s)', gettype($locationsWarehouseLocationItem), var_export($locationsWarehouseLocationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WarehouseLocation property can only contain items of type \StructType\WarehouseLocation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WarehouseLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WarehouseLocation[] $warehouseLocation
     * @return \StructType\Locations
     */
    public function setWarehouseLocation(array $warehouseLocation = array())
    {
        // validation for constraint: array
        if ('' !== ($warehouseLocationArrayErrorMessage = self::validateWarehouseLocationForArrayConstraintsFromSetWarehouseLocation($warehouseLocation))) {
            throw new \InvalidArgumentException($warehouseLocationArrayErrorMessage, __LINE__);
        }
        if (is_null($warehouseLocation) || (is_array($warehouseLocation) && empty($warehouseLocation))) {
            unset($this->WarehouseLocation);
        } else {
            $this->WarehouseLocation = $warehouseLocation;
        }
        return $this;
    }
    /**
     * Add item to WarehouseLocation value
     * @throws \InvalidArgumentException
     * @param \StructType\WarehouseLocation $item
     * @return \StructType\Locations
     */
    public function addToWarehouseLocation(\StructType\WarehouseLocation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WarehouseLocation) {
            throw new \InvalidArgumentException(sprintf('The WarehouseLocation property can only contain items of type \StructType\WarehouseLocation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WarehouseLocation[] = $item;
        return $this;
    }
    /**
     * Get BusinessAccountLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BusinessAccountLocation[]|null
     */
    public function getBusinessAccountLocation()
    {
        return isset($this->BusinessAccountLocation) ? $this->BusinessAccountLocation : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBusinessAccountLocation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBusinessAccountLocation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBusinessAccountLocationForArrayConstraintsFromSetBusinessAccountLocation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationsBusinessAccountLocationItem) {
            // validation for constraint: itemType
            if (!$locationsBusinessAccountLocationItem instanceof \StructType\BusinessAccountLocation) {
                $invalidValues[] = is_object($locationsBusinessAccountLocationItem) ? get_class($locationsBusinessAccountLocationItem) : sprintf('%s(%s)', gettype($locationsBusinessAccountLocationItem), var_export($locationsBusinessAccountLocationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BusinessAccountLocation property can only contain items of type \StructType\BusinessAccountLocation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BusinessAccountLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BusinessAccountLocation[] $businessAccountLocation
     * @return \StructType\Locations
     */
    public function setBusinessAccountLocation(array $businessAccountLocation = array())
    {
        // validation for constraint: array
        if ('' !== ($businessAccountLocationArrayErrorMessage = self::validateBusinessAccountLocationForArrayConstraintsFromSetBusinessAccountLocation($businessAccountLocation))) {
            throw new \InvalidArgumentException($businessAccountLocationArrayErrorMessage, __LINE__);
        }
        if (is_null($businessAccountLocation) || (is_array($businessAccountLocation) && empty($businessAccountLocation))) {
            unset($this->BusinessAccountLocation);
        } else {
            $this->BusinessAccountLocation = $businessAccountLocation;
        }
        return $this;
    }
    /**
     * Add item to BusinessAccountLocation value
     * @throws \InvalidArgumentException
     * @param \StructType\BusinessAccountLocation $item
     * @return \StructType\Locations
     */
    public function addToBusinessAccountLocation(\StructType\BusinessAccountLocation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BusinessAccountLocation) {
            throw new \InvalidArgumentException(sprintf('The BusinessAccountLocation property can only contain items of type \StructType\BusinessAccountLocation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BusinessAccountLocation[] = $item;
        return $this;
    }
}
