<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LinkEntityToTask StructType
 * @subpackage Structs
 */
class LinkEntityToTask extends Action
{
    /**
     * The RelatedEntity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $RelatedEntity;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Type;
    /**
     * Constructor method for LinkEntityToTask
     * @uses LinkEntityToTask::setRelatedEntity()
     * @uses LinkEntityToTask::setType()
     * @param \StructType\StringValue $relatedEntity
     * @param \StructType\StringValue $type
     */
    public function __construct(\StructType\StringValue $relatedEntity = null, \StructType\StringValue $type = null)
    {
        $this
            ->setRelatedEntity($relatedEntity)
            ->setType($type);
    }
    /**
     * Get RelatedEntity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getRelatedEntity()
    {
        return isset($this->RelatedEntity) ? $this->RelatedEntity : null;
    }
    /**
     * Set RelatedEntity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $relatedEntity
     * @return \StructType\LinkEntityToTask
     */
    public function setRelatedEntity(\StructType\StringValue $relatedEntity = null)
    {
        if (is_null($relatedEntity) || (is_array($relatedEntity) && empty($relatedEntity))) {
            unset($this->RelatedEntity);
        } else {
            $this->RelatedEntity = $relatedEntity;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $type
     * @return \StructType\LinkEntityToTask
     */
    public function setType(\StructType\StringValue $type = null)
    {
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
}
