<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Items StructType
 * @subpackage Structs
 */
class Items extends AbstractStructBase
{
    /**
     * The DiscountItemDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DiscountItemDetail[]
     */
    public $DiscountItemDetail;
    /**
     * Constructor method for Items
     * @uses Items::setDiscountItemDetail()
     * @param \StructType\DiscountItemDetail[] $discountItemDetail
     */
    public function __construct(array $discountItemDetail = array())
    {
        $this
            ->setDiscountItemDetail($discountItemDetail);
    }
    /**
     * Get DiscountItemDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DiscountItemDetail[]|null
     */
    public function getDiscountItemDetail()
    {
        return isset($this->DiscountItemDetail) ? $this->DiscountItemDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDiscountItemDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDiscountItemDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDiscountItemDetailForArrayConstraintsFromSetDiscountItemDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemsDiscountItemDetailItem) {
            // validation for constraint: itemType
            if (!$itemsDiscountItemDetailItem instanceof \StructType\DiscountItemDetail) {
                $invalidValues[] = is_object($itemsDiscountItemDetailItem) ? get_class($itemsDiscountItemDetailItem) : sprintf('%s(%s)', gettype($itemsDiscountItemDetailItem), var_export($itemsDiscountItemDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DiscountItemDetail property can only contain items of type \StructType\DiscountItemDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DiscountItemDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DiscountItemDetail[] $discountItemDetail
     * @return \StructType\Items
     */
    public function setDiscountItemDetail(array $discountItemDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($discountItemDetailArrayErrorMessage = self::validateDiscountItemDetailForArrayConstraintsFromSetDiscountItemDetail($discountItemDetail))) {
            throw new \InvalidArgumentException($discountItemDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($discountItemDetail) || (is_array($discountItemDetail) && empty($discountItemDetail))) {
            unset($this->DiscountItemDetail);
        } else {
            $this->DiscountItemDetail = $discountItemDetail;
        }
        return $this;
    }
    /**
     * Add item to DiscountItemDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\DiscountItemDetail $item
     * @return \StructType\Items
     */
    public function addToDiscountItemDetail(\StructType\DiscountItemDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DiscountItemDetail) {
            throw new \InvalidArgumentException(sprintf('The DiscountItemDetail property can only contain items of type \StructType\DiscountItemDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DiscountItemDetail[] = $item;
        return $this;
    }
}
