<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Invoices StructType
 * @subpackage Structs
 */
class Invoices extends AbstractStructBase
{
    /**
     * The ProjectProFormaDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProjectProFormaDetails[]
     */
    public $ProjectProFormaDetails;
    /**
     * Constructor method for Invoices
     * @uses Invoices::setProjectProFormaDetails()
     * @param \StructType\ProjectProFormaDetails[] $projectProFormaDetails
     */
    public function __construct(array $projectProFormaDetails = array())
    {
        $this
            ->setProjectProFormaDetails($projectProFormaDetails);
    }
    /**
     * Get ProjectProFormaDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProjectProFormaDetails[]|null
     */
    public function getProjectProFormaDetails()
    {
        return isset($this->ProjectProFormaDetails) ? $this->ProjectProFormaDetails : null;
    }
    /**
     * This method is responsible for validating the values passed to the setProjectProFormaDetails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProjectProFormaDetails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProjectProFormaDetailsForArrayConstraintsFromSetProjectProFormaDetails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoicesProjectProFormaDetailsItem) {
            // validation for constraint: itemType
            if (!$invoicesProjectProFormaDetailsItem instanceof \StructType\ProjectProFormaDetails) {
                $invalidValues[] = is_object($invoicesProjectProFormaDetailsItem) ? get_class($invoicesProjectProFormaDetailsItem) : sprintf('%s(%s)', gettype($invoicesProjectProFormaDetailsItem), var_export($invoicesProjectProFormaDetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProjectProFormaDetails property can only contain items of type \StructType\ProjectProFormaDetails, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProjectProFormaDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ProjectProFormaDetails[] $projectProFormaDetails
     * @return \StructType\Invoices
     */
    public function setProjectProFormaDetails(array $projectProFormaDetails = array())
    {
        // validation for constraint: array
        if ('' !== ($projectProFormaDetailsArrayErrorMessage = self::validateProjectProFormaDetailsForArrayConstraintsFromSetProjectProFormaDetails($projectProFormaDetails))) {
            throw new \InvalidArgumentException($projectProFormaDetailsArrayErrorMessage, __LINE__);
        }
        if (is_null($projectProFormaDetails) || (is_array($projectProFormaDetails) && empty($projectProFormaDetails))) {
            unset($this->ProjectProFormaDetails);
        } else {
            $this->ProjectProFormaDetails = $projectProFormaDetails;
        }
        return $this;
    }
    /**
     * Add item to ProjectProFormaDetails value
     * @throws \InvalidArgumentException
     * @param \StructType\ProjectProFormaDetails $item
     * @return \StructType\Invoices
     */
    public function addToProjectProFormaDetails(\StructType\ProjectProFormaDetails $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProjectProFormaDetails) {
            throw new \InvalidArgumentException(sprintf('The ProjectProFormaDetails property can only contain items of type \StructType\ProjectProFormaDetails, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ProjectProFormaDetails[] = $item;
        return $this;
    }
}
