<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InventoryItemCrossReference StructType
 * @subpackage Structs
 */
class InventoryItemCrossReference extends Entity
{
    /**
     * The AlternateID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $AlternateID;
    /**
     * The AlternateType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $AlternateType;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Description;
    /**
     * The Subitem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Subitem;
    /**
     * The VendorOrCustomer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $VendorOrCustomer;
    /**
     * Constructor method for InventoryItemCrossReference
     * @uses InventoryItemCrossReference::setAlternateID()
     * @uses InventoryItemCrossReference::setAlternateType()
     * @uses InventoryItemCrossReference::setDescription()
     * @uses InventoryItemCrossReference::setSubitem()
     * @uses InventoryItemCrossReference::setVendorOrCustomer()
     * @param \StructType\StringValue $alternateID
     * @param \StructType\StringValue $alternateType
     * @param \StructType\StringValue $description
     * @param \StructType\StringValue $subitem
     * @param \StructType\StringValue $vendorOrCustomer
     */
    public function __construct(\StructType\StringValue $alternateID = null, \StructType\StringValue $alternateType = null, \StructType\StringValue $description = null, \StructType\StringValue $subitem = null, \StructType\StringValue $vendorOrCustomer = null)
    {
        $this
            ->setAlternateID($alternateID)
            ->setAlternateType($alternateType)
            ->setDescription($description)
            ->setSubitem($subitem)
            ->setVendorOrCustomer($vendorOrCustomer);
    }
    /**
     * Get AlternateID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getAlternateID()
    {
        return isset($this->AlternateID) ? $this->AlternateID : null;
    }
    /**
     * Set AlternateID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $alternateID
     * @return \StructType\InventoryItemCrossReference
     */
    public function setAlternateID(\StructType\StringValue $alternateID = null)
    {
        if (is_null($alternateID) || (is_array($alternateID) && empty($alternateID))) {
            unset($this->AlternateID);
        } else {
            $this->AlternateID = $alternateID;
        }
        return $this;
    }
    /**
     * Get AlternateType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getAlternateType()
    {
        return isset($this->AlternateType) ? $this->AlternateType : null;
    }
    /**
     * Set AlternateType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $alternateType
     * @return \StructType\InventoryItemCrossReference
     */
    public function setAlternateType(\StructType\StringValue $alternateType = null)
    {
        if (is_null($alternateType) || (is_array($alternateType) && empty($alternateType))) {
            unset($this->AlternateType);
        } else {
            $this->AlternateType = $alternateType;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $description
     * @return \StructType\InventoryItemCrossReference
     */
    public function setDescription(\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Subitem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getSubitem()
    {
        return isset($this->Subitem) ? $this->Subitem : null;
    }
    /**
     * Set Subitem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $subitem
     * @return \StructType\InventoryItemCrossReference
     */
    public function setSubitem(\StructType\StringValue $subitem = null)
    {
        if (is_null($subitem) || (is_array($subitem) && empty($subitem))) {
            unset($this->Subitem);
        } else {
            $this->Subitem = $subitem;
        }
        return $this;
    }
    /**
     * Get VendorOrCustomer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getVendorOrCustomer()
    {
        return isset($this->VendorOrCustomer) ? $this->VendorOrCustomer : null;
    }
    /**
     * Set VendorOrCustomer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $vendorOrCustomer
     * @return \StructType\InventoryItemCrossReference
     */
    public function setVendorOrCustomer(\StructType\StringValue $vendorOrCustomer = null)
    {
        if (is_null($vendorOrCustomer) || (is_array($vendorOrCustomer) && empty($vendorOrCustomer))) {
            unset($this->VendorOrCustomer);
        } else {
            $this->VendorOrCustomer = $vendorOrCustomer;
        }
        return $this;
    }
}
