<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Equipments StructType
 * @subpackage Structs
 */
class Equipments extends AbstractStructBase
{
    /**
     * The ProjectEquipment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProjectEquipment[]
     */
    public $ProjectEquipment;
    /**
     * Constructor method for Equipments
     * @uses Equipments::setProjectEquipment()
     * @param \StructType\ProjectEquipment[] $projectEquipment
     */
    public function __construct(array $projectEquipment = array())
    {
        $this
            ->setProjectEquipment($projectEquipment);
    }
    /**
     * Get ProjectEquipment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProjectEquipment[]|null
     */
    public function getProjectEquipment()
    {
        return isset($this->ProjectEquipment) ? $this->ProjectEquipment : null;
    }
    /**
     * This method is responsible for validating the values passed to the setProjectEquipment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProjectEquipment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProjectEquipmentForArrayConstraintsFromSetProjectEquipment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $equipmentsProjectEquipmentItem) {
            // validation for constraint: itemType
            if (!$equipmentsProjectEquipmentItem instanceof \StructType\ProjectEquipment) {
                $invalidValues[] = is_object($equipmentsProjectEquipmentItem) ? get_class($equipmentsProjectEquipmentItem) : sprintf('%s(%s)', gettype($equipmentsProjectEquipmentItem), var_export($equipmentsProjectEquipmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProjectEquipment property can only contain items of type \StructType\ProjectEquipment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProjectEquipment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ProjectEquipment[] $projectEquipment
     * @return \StructType\Equipments
     */
    public function setProjectEquipment(array $projectEquipment = array())
    {
        // validation for constraint: array
        if ('' !== ($projectEquipmentArrayErrorMessage = self::validateProjectEquipmentForArrayConstraintsFromSetProjectEquipment($projectEquipment))) {
            throw new \InvalidArgumentException($projectEquipmentArrayErrorMessage, __LINE__);
        }
        if (is_null($projectEquipment) || (is_array($projectEquipment) && empty($projectEquipment))) {
            unset($this->ProjectEquipment);
        } else {
            $this->ProjectEquipment = $projectEquipment;
        }
        return $this;
    }
    /**
     * Add item to ProjectEquipment value
     * @throws \InvalidArgumentException
     * @param \StructType\ProjectEquipment $item
     * @return \StructType\Equipments
     */
    public function addToProjectEquipment(\StructType\ProjectEquipment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProjectEquipment) {
            throw new \InvalidArgumentException(sprintf('The ProjectEquipment property can only contain items of type \StructType\ProjectEquipment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ProjectEquipment[] = $item;
        return $this;
    }
}
