<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmployeeDelegate StructType
 * @subpackage Structs
 */
class EmployeeDelegate extends Entity
{
    /**
     * The Delegate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Delegate;
    /**
     * The EmployeeName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $EmployeeName;
    /**
     * Constructor method for EmployeeDelegate
     * @uses EmployeeDelegate::setDelegate()
     * @uses EmployeeDelegate::setEmployeeName()
     * @param \StructType\StringValue $delegate
     * @param \StructType\StringValue $employeeName
     */
    public function __construct(\StructType\StringValue $delegate = null, \StructType\StringValue $employeeName = null)
    {
        $this
            ->setDelegate($delegate)
            ->setEmployeeName($employeeName);
    }
    /**
     * Get Delegate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDelegate()
    {
        return isset($this->Delegate) ? $this->Delegate : null;
    }
    /**
     * Set Delegate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $delegate
     * @return \StructType\EmployeeDelegate
     */
    public function setDelegate(\StructType\StringValue $delegate = null)
    {
        if (is_null($delegate) || (is_array($delegate) && empty($delegate))) {
            unset($this->Delegate);
        } else {
            $this->Delegate = $delegate;
        }
        return $this;
    }
    /**
     * Get EmployeeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getEmployeeName()
    {
        return isset($this->EmployeeName) ? $this->EmployeeName : null;
    }
    /**
     * Set EmployeeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $employeeName
     * @return \StructType\EmployeeDelegate
     */
    public function setEmployeeName(\StructType\StringValue $employeeName = null)
    {
        if (is_null($employeeName) || (is_array($employeeName) && empty($employeeName))) {
            unset($this->EmployeeName);
        } else {
            $this->EmployeeName = $employeeName;
        }
        return $this;
    }
}
