<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Categories StructType
 * @subpackage Structs
 */
class Categories extends AbstractStructBase
{
    /**
     * The CategoryStockItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CategoryStockItem[]
     */
    public $CategoryStockItem;
    /**
     * Constructor method for Categories
     * @uses Categories::setCategoryStockItem()
     * @param \StructType\CategoryStockItem[] $categoryStockItem
     */
    public function __construct(array $categoryStockItem = array())
    {
        $this
            ->setCategoryStockItem($categoryStockItem);
    }
    /**
     * Get CategoryStockItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CategoryStockItem[]|null
     */
    public function getCategoryStockItem()
    {
        return isset($this->CategoryStockItem) ? $this->CategoryStockItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCategoryStockItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCategoryStockItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCategoryStockItemForArrayConstraintsFromSetCategoryStockItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $categoriesCategoryStockItemItem) {
            // validation for constraint: itemType
            if (!$categoriesCategoryStockItemItem instanceof \StructType\CategoryStockItem) {
                $invalidValues[] = is_object($categoriesCategoryStockItemItem) ? get_class($categoriesCategoryStockItemItem) : sprintf('%s(%s)', gettype($categoriesCategoryStockItemItem), var_export($categoriesCategoryStockItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CategoryStockItem property can only contain items of type \StructType\CategoryStockItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CategoryStockItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CategoryStockItem[] $categoryStockItem
     * @return \StructType\Categories
     */
    public function setCategoryStockItem(array $categoryStockItem = array())
    {
        // validation for constraint: array
        if ('' !== ($categoryStockItemArrayErrorMessage = self::validateCategoryStockItemForArrayConstraintsFromSetCategoryStockItem($categoryStockItem))) {
            throw new \InvalidArgumentException($categoryStockItemArrayErrorMessage, __LINE__);
        }
        if (is_null($categoryStockItem) || (is_array($categoryStockItem) && empty($categoryStockItem))) {
            unset($this->CategoryStockItem);
        } else {
            $this->CategoryStockItem = $categoryStockItem;
        }
        return $this;
    }
    /**
     * Add item to CategoryStockItem value
     * @throws \InvalidArgumentException
     * @param \StructType\CategoryStockItem $item
     * @return \StructType\Categories
     */
    public function addToCategoryStockItem(\StructType\CategoryStockItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CategoryStockItem) {
            throw new \InvalidArgumentException(sprintf('The CategoryStockItem property can only contain items of type \StructType\CategoryStockItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CategoryStockItem[] = $item;
        return $this;
    }
}
