<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CarrierPluginParameter StructType
 * @subpackage Structs
 */
class CarrierPluginParameter extends Entity
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Description;
    /**
     * The PluginID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $PluginID;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Value;
    /**
     * Constructor method for CarrierPluginParameter
     * @uses CarrierPluginParameter::setDescription()
     * @uses CarrierPluginParameter::setPluginID()
     * @uses CarrierPluginParameter::setValue()
     * @param \StructType\StringValue $description
     * @param \StructType\StringValue $pluginID
     * @param \StructType\StringValue $value
     */
    public function __construct(\StructType\StringValue $description = null, \StructType\StringValue $pluginID = null, \StructType\StringValue $value = null)
    {
        $this
            ->setDescription($description)
            ->setPluginID($pluginID)
            ->setValue($value);
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $description
     * @return \StructType\CarrierPluginParameter
     */
    public function setDescription(\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get PluginID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getPluginID()
    {
        return isset($this->PluginID) ? $this->PluginID : null;
    }
    /**
     * Set PluginID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $pluginID
     * @return \StructType\CarrierPluginParameter
     */
    public function setPluginID(\StructType\StringValue $pluginID = null)
    {
        if (is_null($pluginID) || (is_array($pluginID) && empty($pluginID))) {
            unset($this->PluginID);
        } else {
            $this->PluginID = $pluginID;
        }
        return $this;
    }
    /**
     * Get Value value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getValue()
    {
        return isset($this->Value) ? $this->Value : null;
    }
    /**
     * Set Value value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $value
     * @return \StructType\CarrierPluginParameter
     */
    public function setValue(\StructType\StringValue $value = null)
    {
        if (is_null($value) || (is_array($value) && empty($value))) {
            unset($this->Value);
        } else {
            $this->Value = $value;
        }
        return $this;
    }
}
