<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillDetail StructType
 * @subpackage Structs
 */
class BillDetail extends Entity
{
    /**
     * The Account
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Account;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $Amount;
    /**
     * The Branch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Branch;
    /**
     * The CalculateDiscountsOnImport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $CalculateDiscountsOnImport;
    /**
     * The CostCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CostCode;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Description;
    /**
     * The ExtendedCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $ExtendedCost;
    /**
     * The InventoryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $InventoryID;
    /**
     * The NonBillable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $NonBillable;
    /**
     * The POLine
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IntValue
     */
    public $POLine;
    /**
     * The POOrderNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $POOrderNbr;
    /**
     * The POOrderType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $POOrderType;
    /**
     * The POReceiptLine
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IntValue
     */
    public $POReceiptLine;
    /**
     * The POReceiptNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $POReceiptNbr;
    /**
     * The Project
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Project;
    /**
     * The ProjectTask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ProjectTask;
    /**
     * The Qty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $Qty;
    /**
     * The Subaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Subaccount;
    /**
     * The TaxCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $TaxCategory;
    /**
     * The TransactionDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $TransactionDescription;
    /**
     * The UnitCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $UnitCost;
    /**
     * The UOM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $UOM;
    /**
     * Constructor method for BillDetail
     * @uses BillDetail::setAccount()
     * @uses BillDetail::setAmount()
     * @uses BillDetail::setBranch()
     * @uses BillDetail::setCalculateDiscountsOnImport()
     * @uses BillDetail::setCostCode()
     * @uses BillDetail::setDescription()
     * @uses BillDetail::setExtendedCost()
     * @uses BillDetail::setInventoryID()
     * @uses BillDetail::setNonBillable()
     * @uses BillDetail::setPOLine()
     * @uses BillDetail::setPOOrderNbr()
     * @uses BillDetail::setPOOrderType()
     * @uses BillDetail::setPOReceiptLine()
     * @uses BillDetail::setPOReceiptNbr()
     * @uses BillDetail::setProject()
     * @uses BillDetail::setProjectTask()
     * @uses BillDetail::setQty()
     * @uses BillDetail::setSubaccount()
     * @uses BillDetail::setTaxCategory()
     * @uses BillDetail::setTransactionDescription()
     * @uses BillDetail::setUnitCost()
     * @uses BillDetail::setUOM()
     * @param \StructType\StringValue $account
     * @param \StructType\DecimalValue $amount
     * @param \StructType\StringValue $branch
     * @param \StructType\BooleanValue $calculateDiscountsOnImport
     * @param \StructType\StringValue $costCode
     * @param \StructType\StringValue $description
     * @param \StructType\DecimalValue $extendedCost
     * @param \StructType\StringValue $inventoryID
     * @param \StructType\BooleanValue $nonBillable
     * @param \StructType\IntValue $pOLine
     * @param \StructType\StringValue $pOOrderNbr
     * @param \StructType\StringValue $pOOrderType
     * @param \StructType\IntValue $pOReceiptLine
     * @param \StructType\StringValue $pOReceiptNbr
     * @param \StructType\StringValue $project
     * @param \StructType\StringValue $projectTask
     * @param \StructType\DecimalValue $qty
     * @param \StructType\StringValue $subaccount
     * @param \StructType\StringValue $taxCategory
     * @param \StructType\StringValue $transactionDescription
     * @param \StructType\DecimalValue $unitCost
     * @param \StructType\StringValue $uOM
     */
    public function __construct(\StructType\StringValue $account = null, \StructType\DecimalValue $amount = null, \StructType\StringValue $branch = null, \StructType\BooleanValue $calculateDiscountsOnImport = null, \StructType\StringValue $costCode = null, \StructType\StringValue $description = null, \StructType\DecimalValue $extendedCost = null, \StructType\StringValue $inventoryID = null, \StructType\BooleanValue $nonBillable = null, \StructType\IntValue $pOLine = null, \StructType\StringValue $pOOrderNbr = null, \StructType\StringValue $pOOrderType = null, \StructType\IntValue $pOReceiptLine = null, \StructType\StringValue $pOReceiptNbr = null, \StructType\StringValue $project = null, \StructType\StringValue $projectTask = null, \StructType\DecimalValue $qty = null, \StructType\StringValue $subaccount = null, \StructType\StringValue $taxCategory = null, \StructType\StringValue $transactionDescription = null, \StructType\DecimalValue $unitCost = null, \StructType\StringValue $uOM = null)
    {
        $this
            ->setAccount($account)
            ->setAmount($amount)
            ->setBranch($branch)
            ->setCalculateDiscountsOnImport($calculateDiscountsOnImport)
            ->setCostCode($costCode)
            ->setDescription($description)
            ->setExtendedCost($extendedCost)
            ->setInventoryID($inventoryID)
            ->setNonBillable($nonBillable)
            ->setPOLine($pOLine)
            ->setPOOrderNbr($pOOrderNbr)
            ->setPOOrderType($pOOrderType)
            ->setPOReceiptLine($pOReceiptLine)
            ->setPOReceiptNbr($pOReceiptNbr)
            ->setProject($project)
            ->setProjectTask($projectTask)
            ->setQty($qty)
            ->setSubaccount($subaccount)
            ->setTaxCategory($taxCategory)
            ->setTransactionDescription($transactionDescription)
            ->setUnitCost($unitCost)
            ->setUOM($uOM);
    }
    /**
     * Get Account value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getAccount()
    {
        return isset($this->Account) ? $this->Account : null;
    }
    /**
     * Set Account value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $account
     * @return \StructType\BillDetail
     */
    public function setAccount(\StructType\StringValue $account = null)
    {
        if (is_null($account) || (is_array($account) && empty($account))) {
            unset($this->Account);
        } else {
            $this->Account = $account;
        }
        return $this;
    }
    /**
     * Get Amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * Set Amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $amount
     * @return \StructType\BillDetail
     */
    public function setAmount(\StructType\DecimalValue $amount = null)
    {
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get Branch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getBranch()
    {
        return isset($this->Branch) ? $this->Branch : null;
    }
    /**
     * Set Branch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $branch
     * @return \StructType\BillDetail
     */
    public function setBranch(\StructType\StringValue $branch = null)
    {
        if (is_null($branch) || (is_array($branch) && empty($branch))) {
            unset($this->Branch);
        } else {
            $this->Branch = $branch;
        }
        return $this;
    }
    /**
     * Get CalculateDiscountsOnImport value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getCalculateDiscountsOnImport()
    {
        return isset($this->CalculateDiscountsOnImport) ? $this->CalculateDiscountsOnImport : null;
    }
    /**
     * Set CalculateDiscountsOnImport value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $calculateDiscountsOnImport
     * @return \StructType\BillDetail
     */
    public function setCalculateDiscountsOnImport(\StructType\BooleanValue $calculateDiscountsOnImport = null)
    {
        if (is_null($calculateDiscountsOnImport) || (is_array($calculateDiscountsOnImport) && empty($calculateDiscountsOnImport))) {
            unset($this->CalculateDiscountsOnImport);
        } else {
            $this->CalculateDiscountsOnImport = $calculateDiscountsOnImport;
        }
        return $this;
    }
    /**
     * Get CostCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCostCode()
    {
        return isset($this->CostCode) ? $this->CostCode : null;
    }
    /**
     * Set CostCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $costCode
     * @return \StructType\BillDetail
     */
    public function setCostCode(\StructType\StringValue $costCode = null)
    {
        if (is_null($costCode) || (is_array($costCode) && empty($costCode))) {
            unset($this->CostCode);
        } else {
            $this->CostCode = $costCode;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $description
     * @return \StructType\BillDetail
     */
    public function setDescription(\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get ExtendedCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getExtendedCost()
    {
        return isset($this->ExtendedCost) ? $this->ExtendedCost : null;
    }
    /**
     * Set ExtendedCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $extendedCost
     * @return \StructType\BillDetail
     */
    public function setExtendedCost(\StructType\DecimalValue $extendedCost = null)
    {
        if (is_null($extendedCost) || (is_array($extendedCost) && empty($extendedCost))) {
            unset($this->ExtendedCost);
        } else {
            $this->ExtendedCost = $extendedCost;
        }
        return $this;
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $inventoryID
     * @return \StructType\BillDetail
     */
    public function setInventoryID(\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get NonBillable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getNonBillable()
    {
        return isset($this->NonBillable) ? $this->NonBillable : null;
    }
    /**
     * Set NonBillable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $nonBillable
     * @return \StructType\BillDetail
     */
    public function setNonBillable(\StructType\BooleanValue $nonBillable = null)
    {
        if (is_null($nonBillable) || (is_array($nonBillable) && empty($nonBillable))) {
            unset($this->NonBillable);
        } else {
            $this->NonBillable = $nonBillable;
        }
        return $this;
    }
    /**
     * Get POLine value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IntValue|null
     */
    public function getPOLine()
    {
        return isset($this->POLine) ? $this->POLine : null;
    }
    /**
     * Set POLine value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\IntValue $pOLine
     * @return \StructType\BillDetail
     */
    public function setPOLine(\StructType\IntValue $pOLine = null)
    {
        if (is_null($pOLine) || (is_array($pOLine) && empty($pOLine))) {
            unset($this->POLine);
        } else {
            $this->POLine = $pOLine;
        }
        return $this;
    }
    /**
     * Get POOrderNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getPOOrderNbr()
    {
        return isset($this->POOrderNbr) ? $this->POOrderNbr : null;
    }
    /**
     * Set POOrderNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $pOOrderNbr
     * @return \StructType\BillDetail
     */
    public function setPOOrderNbr(\StructType\StringValue $pOOrderNbr = null)
    {
        if (is_null($pOOrderNbr) || (is_array($pOOrderNbr) && empty($pOOrderNbr))) {
            unset($this->POOrderNbr);
        } else {
            $this->POOrderNbr = $pOOrderNbr;
        }
        return $this;
    }
    /**
     * Get POOrderType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getPOOrderType()
    {
        return isset($this->POOrderType) ? $this->POOrderType : null;
    }
    /**
     * Set POOrderType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $pOOrderType
     * @return \StructType\BillDetail
     */
    public function setPOOrderType(\StructType\StringValue $pOOrderType = null)
    {
        if (is_null($pOOrderType) || (is_array($pOOrderType) && empty($pOOrderType))) {
            unset($this->POOrderType);
        } else {
            $this->POOrderType = $pOOrderType;
        }
        return $this;
    }
    /**
     * Get POReceiptLine value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IntValue|null
     */
    public function getPOReceiptLine()
    {
        return isset($this->POReceiptLine) ? $this->POReceiptLine : null;
    }
    /**
     * Set POReceiptLine value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\IntValue $pOReceiptLine
     * @return \StructType\BillDetail
     */
    public function setPOReceiptLine(\StructType\IntValue $pOReceiptLine = null)
    {
        if (is_null($pOReceiptLine) || (is_array($pOReceiptLine) && empty($pOReceiptLine))) {
            unset($this->POReceiptLine);
        } else {
            $this->POReceiptLine = $pOReceiptLine;
        }
        return $this;
    }
    /**
     * Get POReceiptNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getPOReceiptNbr()
    {
        return isset($this->POReceiptNbr) ? $this->POReceiptNbr : null;
    }
    /**
     * Set POReceiptNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $pOReceiptNbr
     * @return \StructType\BillDetail
     */
    public function setPOReceiptNbr(\StructType\StringValue $pOReceiptNbr = null)
    {
        if (is_null($pOReceiptNbr) || (is_array($pOReceiptNbr) && empty($pOReceiptNbr))) {
            unset($this->POReceiptNbr);
        } else {
            $this->POReceiptNbr = $pOReceiptNbr;
        }
        return $this;
    }
    /**
     * Get Project value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getProject()
    {
        return isset($this->Project) ? $this->Project : null;
    }
    /**
     * Set Project value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $project
     * @return \StructType\BillDetail
     */
    public function setProject(\StructType\StringValue $project = null)
    {
        if (is_null($project) || (is_array($project) && empty($project))) {
            unset($this->Project);
        } else {
            $this->Project = $project;
        }
        return $this;
    }
    /**
     * Get ProjectTask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getProjectTask()
    {
        return isset($this->ProjectTask) ? $this->ProjectTask : null;
    }
    /**
     * Set ProjectTask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $projectTask
     * @return \StructType\BillDetail
     */
    public function setProjectTask(\StructType\StringValue $projectTask = null)
    {
        if (is_null($projectTask) || (is_array($projectTask) && empty($projectTask))) {
            unset($this->ProjectTask);
        } else {
            $this->ProjectTask = $projectTask;
        }
        return $this;
    }
    /**
     * Get Qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getQty()
    {
        return isset($this->Qty) ? $this->Qty : null;
    }
    /**
     * Set Qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $qty
     * @return \StructType\BillDetail
     */
    public function setQty(\StructType\DecimalValue $qty = null)
    {
        if (is_null($qty) || (is_array($qty) && empty($qty))) {
            unset($this->Qty);
        } else {
            $this->Qty = $qty;
        }
        return $this;
    }
    /**
     * Get Subaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getSubaccount()
    {
        return isset($this->Subaccount) ? $this->Subaccount : null;
    }
    /**
     * Set Subaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $subaccount
     * @return \StructType\BillDetail
     */
    public function setSubaccount(\StructType\StringValue $subaccount = null)
    {
        if (is_null($subaccount) || (is_array($subaccount) && empty($subaccount))) {
            unset($this->Subaccount);
        } else {
            $this->Subaccount = $subaccount;
        }
        return $this;
    }
    /**
     * Get TaxCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getTaxCategory()
    {
        return isset($this->TaxCategory) ? $this->TaxCategory : null;
    }
    /**
     * Set TaxCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $taxCategory
     * @return \StructType\BillDetail
     */
    public function setTaxCategory(\StructType\StringValue $taxCategory = null)
    {
        if (is_null($taxCategory) || (is_array($taxCategory) && empty($taxCategory))) {
            unset($this->TaxCategory);
        } else {
            $this->TaxCategory = $taxCategory;
        }
        return $this;
    }
    /**
     * Get TransactionDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getTransactionDescription()
    {
        return isset($this->TransactionDescription) ? $this->TransactionDescription : null;
    }
    /**
     * Set TransactionDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $transactionDescription
     * @return \StructType\BillDetail
     */
    public function setTransactionDescription(\StructType\StringValue $transactionDescription = null)
    {
        if (is_null($transactionDescription) || (is_array($transactionDescription) && empty($transactionDescription))) {
            unset($this->TransactionDescription);
        } else {
            $this->TransactionDescription = $transactionDescription;
        }
        return $this;
    }
    /**
     * Get UnitCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getUnitCost()
    {
        return isset($this->UnitCost) ? $this->UnitCost : null;
    }
    /**
     * Set UnitCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $unitCost
     * @return \StructType\BillDetail
     */
    public function setUnitCost(\StructType\DecimalValue $unitCost = null)
    {
        if (is_null($unitCost) || (is_array($unitCost) && empty($unitCost))) {
            unset($this->UnitCost);
        } else {
            $this->UnitCost = $unitCost;
        }
        return $this;
    }
    /**
     * Get UOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getUOM()
    {
        return isset($this->UOM) ? $this->UOM : null;
    }
    /**
     * Set UOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $uOM
     * @return \StructType\BillDetail
     */
    public function setUOM(\StructType\StringValue $uOM = null)
    {
        if (is_null($uOM) || (is_array($uOM) && empty($uOM))) {
            unset($this->UOM);
        } else {
            $this->UOM = $uOM;
        }
        return $this;
    }
}
