<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Balances StructType
 * @subpackage Structs
 */
class Balances extends AbstractStructBase
{
    /**
     * The ProjectBalance
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProjectBalance[]
     */
    public $ProjectBalance;
    /**
     * Constructor method for Balances
     * @uses Balances::setProjectBalance()
     * @param \StructType\ProjectBalance[] $projectBalance
     */
    public function __construct(array $projectBalance = array())
    {
        $this
            ->setProjectBalance($projectBalance);
    }
    /**
     * Get ProjectBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProjectBalance[]|null
     */
    public function getProjectBalance()
    {
        return isset($this->ProjectBalance) ? $this->ProjectBalance : null;
    }
    /**
     * This method is responsible for validating the values passed to the setProjectBalance method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProjectBalance method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProjectBalanceForArrayConstraintsFromSetProjectBalance(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $balancesProjectBalanceItem) {
            // validation for constraint: itemType
            if (!$balancesProjectBalanceItem instanceof \StructType\ProjectBalance) {
                $invalidValues[] = is_object($balancesProjectBalanceItem) ? get_class($balancesProjectBalanceItem) : sprintf('%s(%s)', gettype($balancesProjectBalanceItem), var_export($balancesProjectBalanceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProjectBalance property can only contain items of type \StructType\ProjectBalance, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProjectBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ProjectBalance[] $projectBalance
     * @return \StructType\Balances
     */
    public function setProjectBalance(array $projectBalance = array())
    {
        // validation for constraint: array
        if ('' !== ($projectBalanceArrayErrorMessage = self::validateProjectBalanceForArrayConstraintsFromSetProjectBalance($projectBalance))) {
            throw new \InvalidArgumentException($projectBalanceArrayErrorMessage, __LINE__);
        }
        if (is_null($projectBalance) || (is_array($projectBalance) && empty($projectBalance))) {
            unset($this->ProjectBalance);
        } else {
            $this->ProjectBalance = $projectBalance;
        }
        return $this;
    }
    /**
     * Add item to ProjectBalance value
     * @throws \InvalidArgumentException
     * @param \StructType\ProjectBalance $item
     * @return \StructType\Balances
     */
    public function addToProjectBalance(\StructType\ProjectBalance $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProjectBalance) {
            throw new \InvalidArgumentException(sprintf('The ProjectBalance property can only contain items of type \StructType\ProjectBalance, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ProjectBalance[] = $item;
        return $this;
    }
}
