<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApprovalDetails StructType
 * @subpackage Structs
 */
class ApprovalDetails extends AbstractStructBase
{
    /**
     * The Approval
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Approval[]
     */
    public $Approval;
    /**
     * Constructor method for ApprovalDetails
     * @uses ApprovalDetails::setApproval()
     * @param \StructType\Approval[] $approval
     */
    public function __construct(array $approval = array())
    {
        $this
            ->setApproval($approval);
    }
    /**
     * Get Approval value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Approval[]|null
     */
    public function getApproval()
    {
        return isset($this->Approval) ? $this->Approval : null;
    }
    /**
     * This method is responsible for validating the values passed to the setApproval method
     * This method is willingly generated in order to preserve the one-line inline validation within the setApproval method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateApprovalForArrayConstraintsFromSetApproval(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $approvalDetailsApprovalItem) {
            // validation for constraint: itemType
            if (!$approvalDetailsApprovalItem instanceof \StructType\Approval) {
                $invalidValues[] = is_object($approvalDetailsApprovalItem) ? get_class($approvalDetailsApprovalItem) : sprintf('%s(%s)', gettype($approvalDetailsApprovalItem), var_export($approvalDetailsApprovalItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Approval property can only contain items of type \StructType\Approval, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Approval value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Approval[] $approval
     * @return \StructType\ApprovalDetails
     */
    public function setApproval(array $approval = array())
    {
        // validation for constraint: array
        if ('' !== ($approvalArrayErrorMessage = self::validateApprovalForArrayConstraintsFromSetApproval($approval))) {
            throw new \InvalidArgumentException($approvalArrayErrorMessage, __LINE__);
        }
        if (is_null($approval) || (is_array($approval) && empty($approval))) {
            unset($this->Approval);
        } else {
            $this->Approval = $approval;
        }
        return $this;
    }
    /**
     * Add item to Approval value
     * @throws \InvalidArgumentException
     * @param \StructType\Approval $item
     * @return \StructType\ApprovalDetails
     */
    public function addToApproval(\StructType\Approval $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Approval) {
            throw new \InvalidArgumentException(sprintf('The Approval property can only contain items of type \StructType\Approval, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Approval[] = $item;
        return $this;
    }
}
