<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApplicationHistory StructType
 * @subpackage Structs
 */
class ApplicationHistory extends AbstractStructBase
{
    /**
     * The PaymentApplicationHistoryDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PaymentApplicationHistoryDetail[]
     */
    public $PaymentApplicationHistoryDetail;
    /**
     * Constructor method for ApplicationHistory
     * @uses ApplicationHistory::setPaymentApplicationHistoryDetail()
     * @param \StructType\PaymentApplicationHistoryDetail[] $paymentApplicationHistoryDetail
     */
    public function __construct(array $paymentApplicationHistoryDetail = array())
    {
        $this
            ->setPaymentApplicationHistoryDetail($paymentApplicationHistoryDetail);
    }
    /**
     * Get PaymentApplicationHistoryDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PaymentApplicationHistoryDetail[]|null
     */
    public function getPaymentApplicationHistoryDetail()
    {
        return isset($this->PaymentApplicationHistoryDetail) ? $this->PaymentApplicationHistoryDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentApplicationHistoryDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentApplicationHistoryDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentApplicationHistoryDetailForArrayConstraintsFromSetPaymentApplicationHistoryDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $applicationHistoryPaymentApplicationHistoryDetailItem) {
            // validation for constraint: itemType
            if (!$applicationHistoryPaymentApplicationHistoryDetailItem instanceof \StructType\PaymentApplicationHistoryDetail) {
                $invalidValues[] = is_object($applicationHistoryPaymentApplicationHistoryDetailItem) ? get_class($applicationHistoryPaymentApplicationHistoryDetailItem) : sprintf('%s(%s)', gettype($applicationHistoryPaymentApplicationHistoryDetailItem), var_export($applicationHistoryPaymentApplicationHistoryDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentApplicationHistoryDetail property can only contain items of type \StructType\PaymentApplicationHistoryDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentApplicationHistoryDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentApplicationHistoryDetail[] $paymentApplicationHistoryDetail
     * @return \StructType\ApplicationHistory
     */
    public function setPaymentApplicationHistoryDetail(array $paymentApplicationHistoryDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentApplicationHistoryDetailArrayErrorMessage = self::validatePaymentApplicationHistoryDetailForArrayConstraintsFromSetPaymentApplicationHistoryDetail($paymentApplicationHistoryDetail))) {
            throw new \InvalidArgumentException($paymentApplicationHistoryDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($paymentApplicationHistoryDetail) || (is_array($paymentApplicationHistoryDetail) && empty($paymentApplicationHistoryDetail))) {
            unset($this->PaymentApplicationHistoryDetail);
        } else {
            $this->PaymentApplicationHistoryDetail = $paymentApplicationHistoryDetail;
        }
        return $this;
    }
    /**
     * Add item to PaymentApplicationHistoryDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentApplicationHistoryDetail $item
     * @return \StructType\ApplicationHistory
     */
    public function addToPaymentApplicationHistoryDetail(\StructType\PaymentApplicationHistoryDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentApplicationHistoryDetail) {
            throw new \InvalidArgumentException(sprintf('The PaymentApplicationHistoryDetail property can only contain items of type \StructType\PaymentApplicationHistoryDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentApplicationHistoryDetail[] = $item;
        return $this;
    }
}
