<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaskTimeActivity StructType
 * @subpackage Structs
 */
class TaskTimeActivity extends Entity
{
    /**
     * The BillableOvertime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $BillableOvertime;
    /**
     * The BillableTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $BillableTime;
    /**
     * The CostCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CostCode;
    /**
     * The Overtime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Overtime;
    /**
     * The Project
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Project;
    /**
     * The ProjectTask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ProjectTask;
    /**
     * The TimeSpent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $TimeSpent;
    /**
     * Constructor method for TaskTimeActivity
     * @uses TaskTimeActivity::setBillableOvertime()
     * @uses TaskTimeActivity::setBillableTime()
     * @uses TaskTimeActivity::setCostCode()
     * @uses TaskTimeActivity::setOvertime()
     * @uses TaskTimeActivity::setProject()
     * @uses TaskTimeActivity::setProjectTask()
     * @uses TaskTimeActivity::setTimeSpent()
     * @param \StructType\StringValue $billableOvertime
     * @param \StructType\StringValue $billableTime
     * @param \StructType\StringValue $costCode
     * @param \StructType\StringValue $overtime
     * @param \StructType\StringValue $project
     * @param \StructType\StringValue $projectTask
     * @param \StructType\StringValue $timeSpent
     */
    public function __construct(\StructType\StringValue $billableOvertime = null, \StructType\StringValue $billableTime = null, \StructType\StringValue $costCode = null, \StructType\StringValue $overtime = null, \StructType\StringValue $project = null, \StructType\StringValue $projectTask = null, \StructType\StringValue $timeSpent = null)
    {
        $this
            ->setBillableOvertime($billableOvertime)
            ->setBillableTime($billableTime)
            ->setCostCode($costCode)
            ->setOvertime($overtime)
            ->setProject($project)
            ->setProjectTask($projectTask)
            ->setTimeSpent($timeSpent);
    }
    /**
     * Get BillableOvertime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getBillableOvertime()
    {
        return isset($this->BillableOvertime) ? $this->BillableOvertime : null;
    }
    /**
     * Set BillableOvertime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $billableOvertime
     * @return \StructType\TaskTimeActivity
     */
    public function setBillableOvertime(\StructType\StringValue $billableOvertime = null)
    {
        if (is_null($billableOvertime) || (is_array($billableOvertime) && empty($billableOvertime))) {
            unset($this->BillableOvertime);
        } else {
            $this->BillableOvertime = $billableOvertime;
        }
        return $this;
    }
    /**
     * Get BillableTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getBillableTime()
    {
        return isset($this->BillableTime) ? $this->BillableTime : null;
    }
    /**
     * Set BillableTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $billableTime
     * @return \StructType\TaskTimeActivity
     */
    public function setBillableTime(\StructType\StringValue $billableTime = null)
    {
        if (is_null($billableTime) || (is_array($billableTime) && empty($billableTime))) {
            unset($this->BillableTime);
        } else {
            $this->BillableTime = $billableTime;
        }
        return $this;
    }
    /**
     * Get CostCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCostCode()
    {
        return isset($this->CostCode) ? $this->CostCode : null;
    }
    /**
     * Set CostCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $costCode
     * @return \StructType\TaskTimeActivity
     */
    public function setCostCode(\StructType\StringValue $costCode = null)
    {
        if (is_null($costCode) || (is_array($costCode) && empty($costCode))) {
            unset($this->CostCode);
        } else {
            $this->CostCode = $costCode;
        }
        return $this;
    }
    /**
     * Get Overtime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getOvertime()
    {
        return isset($this->Overtime) ? $this->Overtime : null;
    }
    /**
     * Set Overtime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $overtime
     * @return \StructType\TaskTimeActivity
     */
    public function setOvertime(\StructType\StringValue $overtime = null)
    {
        if (is_null($overtime) || (is_array($overtime) && empty($overtime))) {
            unset($this->Overtime);
        } else {
            $this->Overtime = $overtime;
        }
        return $this;
    }
    /**
     * Get Project value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getProject()
    {
        return isset($this->Project) ? $this->Project : null;
    }
    /**
     * Set Project value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $project
     * @return \StructType\TaskTimeActivity
     */
    public function setProject(\StructType\StringValue $project = null)
    {
        if (is_null($project) || (is_array($project) && empty($project))) {
            unset($this->Project);
        } else {
            $this->Project = $project;
        }
        return $this;
    }
    /**
     * Get ProjectTask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getProjectTask()
    {
        return isset($this->ProjectTask) ? $this->ProjectTask : null;
    }
    /**
     * Set ProjectTask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $projectTask
     * @return \StructType\TaskTimeActivity
     */
    public function setProjectTask(\StructType\StringValue $projectTask = null)
    {
        if (is_null($projectTask) || (is_array($projectTask) && empty($projectTask))) {
            unset($this->ProjectTask);
        } else {
            $this->ProjectTask = $projectTask;
        }
        return $this;
    }
    /**
     * Get TimeSpent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getTimeSpent()
    {
        return isset($this->TimeSpent) ? $this->TimeSpent : null;
    }
    /**
     * Set TimeSpent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $timeSpent
     * @return \StructType\TaskTimeActivity
     */
    public function setTimeSpent(\StructType\StringValue $timeSpent = null)
    {
        if (is_null($timeSpent) || (is_array($timeSpent) && empty($timeSpent))) {
            unset($this->TimeSpent);
        } else {
            $this->TimeSpent = $timeSpent;
        }
        return $this;
    }
}
