<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Salespersons StructType
 * @subpackage Structs
 */
class Salespersons extends AbstractStructBase
{
    /**
     * The CustomerSalesPerson
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomerSalesPerson[]
     */
    public $CustomerSalesPerson;
    /**
     * Constructor method for Salespersons
     * @uses Salespersons::setCustomerSalesPerson()
     * @param \StructType\CustomerSalesPerson[] $customerSalesPerson
     */
    public function __construct(array $customerSalesPerson = array())
    {
        $this
            ->setCustomerSalesPerson($customerSalesPerson);
    }
    /**
     * Get CustomerSalesPerson value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomerSalesPerson[]|null
     */
    public function getCustomerSalesPerson()
    {
        return isset($this->CustomerSalesPerson) ? $this->CustomerSalesPerson : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomerSalesPerson method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomerSalesPerson method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomerSalesPersonForArrayConstraintsFromSetCustomerSalesPerson(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $salespersonsCustomerSalesPersonItem) {
            // validation for constraint: itemType
            if (!$salespersonsCustomerSalesPersonItem instanceof \StructType\CustomerSalesPerson) {
                $invalidValues[] = is_object($salespersonsCustomerSalesPersonItem) ? get_class($salespersonsCustomerSalesPersonItem) : sprintf('%s(%s)', gettype($salespersonsCustomerSalesPersonItem), var_export($salespersonsCustomerSalesPersonItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomerSalesPerson property can only contain items of type \StructType\CustomerSalesPerson, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomerSalesPerson value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSalesPerson[] $customerSalesPerson
     * @return \StructType\Salespersons
     */
    public function setCustomerSalesPerson(array $customerSalesPerson = array())
    {
        // validation for constraint: array
        if ('' !== ($customerSalesPersonArrayErrorMessage = self::validateCustomerSalesPersonForArrayConstraintsFromSetCustomerSalesPerson($customerSalesPerson))) {
            throw new \InvalidArgumentException($customerSalesPersonArrayErrorMessage, __LINE__);
        }
        if (is_null($customerSalesPerson) || (is_array($customerSalesPerson) && empty($customerSalesPerson))) {
            unset($this->CustomerSalesPerson);
        } else {
            $this->CustomerSalesPerson = $customerSalesPerson;
        }
        return $this;
    }
    /**
     * Add item to CustomerSalesPerson value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSalesPerson $item
     * @return \StructType\Salespersons
     */
    public function addToCustomerSalesPerson(\StructType\CustomerSalesPerson $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerSalesPerson) {
            throw new \InvalidArgumentException(sprintf('The CustomerSalesPerson property can only contain items of type \StructType\CustomerSalesPerson, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomerSalesPerson[] = $item;
        return $this;
    }
}
