<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesOrderShipment StructType
 * @subpackage Structs
 */
class SalesOrderShipment extends Entity
{
    /**
     * The InventoryDocType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $InventoryDocType;
    /**
     * The InventoryRefNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $InventoryRefNbr;
    /**
     * The InvoiceNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $InvoiceNbr;
    /**
     * The InvoiceType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $InvoiceType;
    /**
     * The ShipmentDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $ShipmentDate;
    /**
     * The ShipmentNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ShipmentNbr;
    /**
     * The ShipmentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ShipmentType;
    /**
     * The ShippedQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $ShippedQty;
    /**
     * The ShippedVolume
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $ShippedVolume;
    /**
     * The ShippedWeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $ShippedWeight;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Status;
    /**
     * Constructor method for SalesOrderShipment
     * @uses SalesOrderShipment::setInventoryDocType()
     * @uses SalesOrderShipment::setInventoryRefNbr()
     * @uses SalesOrderShipment::setInvoiceNbr()
     * @uses SalesOrderShipment::setInvoiceType()
     * @uses SalesOrderShipment::setShipmentDate()
     * @uses SalesOrderShipment::setShipmentNbr()
     * @uses SalesOrderShipment::setShipmentType()
     * @uses SalesOrderShipment::setShippedQty()
     * @uses SalesOrderShipment::setShippedVolume()
     * @uses SalesOrderShipment::setShippedWeight()
     * @uses SalesOrderShipment::setStatus()
     * @param \StructType\StringValue $inventoryDocType
     * @param \StructType\StringValue $inventoryRefNbr
     * @param \StructType\StringValue $invoiceNbr
     * @param \StructType\StringValue $invoiceType
     * @param \StructType\DateTimeValue $shipmentDate
     * @param \StructType\StringValue $shipmentNbr
     * @param \StructType\StringValue $shipmentType
     * @param \StructType\DecimalValue $shippedQty
     * @param \StructType\DecimalValue $shippedVolume
     * @param \StructType\DecimalValue $shippedWeight
     * @param \StructType\StringValue $status
     */
    public function __construct(\StructType\StringValue $inventoryDocType = null, \StructType\StringValue $inventoryRefNbr = null, \StructType\StringValue $invoiceNbr = null, \StructType\StringValue $invoiceType = null, \StructType\DateTimeValue $shipmentDate = null, \StructType\StringValue $shipmentNbr = null, \StructType\StringValue $shipmentType = null, \StructType\DecimalValue $shippedQty = null, \StructType\DecimalValue $shippedVolume = null, \StructType\DecimalValue $shippedWeight = null, \StructType\StringValue $status = null)
    {
        $this
            ->setInventoryDocType($inventoryDocType)
            ->setInventoryRefNbr($inventoryRefNbr)
            ->setInvoiceNbr($invoiceNbr)
            ->setInvoiceType($invoiceType)
            ->setShipmentDate($shipmentDate)
            ->setShipmentNbr($shipmentNbr)
            ->setShipmentType($shipmentType)
            ->setShippedQty($shippedQty)
            ->setShippedVolume($shippedVolume)
            ->setShippedWeight($shippedWeight)
            ->setStatus($status);
    }
    /**
     * Get InventoryDocType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getInventoryDocType()
    {
        return isset($this->InventoryDocType) ? $this->InventoryDocType : null;
    }
    /**
     * Set InventoryDocType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $inventoryDocType
     * @return \StructType\SalesOrderShipment
     */
    public function setInventoryDocType(\StructType\StringValue $inventoryDocType = null)
    {
        if (is_null($inventoryDocType) || (is_array($inventoryDocType) && empty($inventoryDocType))) {
            unset($this->InventoryDocType);
        } else {
            $this->InventoryDocType = $inventoryDocType;
        }
        return $this;
    }
    /**
     * Get InventoryRefNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getInventoryRefNbr()
    {
        return isset($this->InventoryRefNbr) ? $this->InventoryRefNbr : null;
    }
    /**
     * Set InventoryRefNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $inventoryRefNbr
     * @return \StructType\SalesOrderShipment
     */
    public function setInventoryRefNbr(\StructType\StringValue $inventoryRefNbr = null)
    {
        if (is_null($inventoryRefNbr) || (is_array($inventoryRefNbr) && empty($inventoryRefNbr))) {
            unset($this->InventoryRefNbr);
        } else {
            $this->InventoryRefNbr = $inventoryRefNbr;
        }
        return $this;
    }
    /**
     * Get InvoiceNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getInvoiceNbr()
    {
        return isset($this->InvoiceNbr) ? $this->InvoiceNbr : null;
    }
    /**
     * Set InvoiceNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $invoiceNbr
     * @return \StructType\SalesOrderShipment
     */
    public function setInvoiceNbr(\StructType\StringValue $invoiceNbr = null)
    {
        if (is_null($invoiceNbr) || (is_array($invoiceNbr) && empty($invoiceNbr))) {
            unset($this->InvoiceNbr);
        } else {
            $this->InvoiceNbr = $invoiceNbr;
        }
        return $this;
    }
    /**
     * Get InvoiceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getInvoiceType()
    {
        return isset($this->InvoiceType) ? $this->InvoiceType : null;
    }
    /**
     * Set InvoiceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $invoiceType
     * @return \StructType\SalesOrderShipment
     */
    public function setInvoiceType(\StructType\StringValue $invoiceType = null)
    {
        if (is_null($invoiceType) || (is_array($invoiceType) && empty($invoiceType))) {
            unset($this->InvoiceType);
        } else {
            $this->InvoiceType = $invoiceType;
        }
        return $this;
    }
    /**
     * Get ShipmentDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getShipmentDate()
    {
        return isset($this->ShipmentDate) ? $this->ShipmentDate : null;
    }
    /**
     * Set ShipmentDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $shipmentDate
     * @return \StructType\SalesOrderShipment
     */
    public function setShipmentDate(\StructType\DateTimeValue $shipmentDate = null)
    {
        if (is_null($shipmentDate) || (is_array($shipmentDate) && empty($shipmentDate))) {
            unset($this->ShipmentDate);
        } else {
            $this->ShipmentDate = $shipmentDate;
        }
        return $this;
    }
    /**
     * Get ShipmentNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getShipmentNbr()
    {
        return isset($this->ShipmentNbr) ? $this->ShipmentNbr : null;
    }
    /**
     * Set ShipmentNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $shipmentNbr
     * @return \StructType\SalesOrderShipment
     */
    public function setShipmentNbr(\StructType\StringValue $shipmentNbr = null)
    {
        if (is_null($shipmentNbr) || (is_array($shipmentNbr) && empty($shipmentNbr))) {
            unset($this->ShipmentNbr);
        } else {
            $this->ShipmentNbr = $shipmentNbr;
        }
        return $this;
    }
    /**
     * Get ShipmentType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getShipmentType()
    {
        return isset($this->ShipmentType) ? $this->ShipmentType : null;
    }
    /**
     * Set ShipmentType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $shipmentType
     * @return \StructType\SalesOrderShipment
     */
    public function setShipmentType(\StructType\StringValue $shipmentType = null)
    {
        if (is_null($shipmentType) || (is_array($shipmentType) && empty($shipmentType))) {
            unset($this->ShipmentType);
        } else {
            $this->ShipmentType = $shipmentType;
        }
        return $this;
    }
    /**
     * Get ShippedQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getShippedQty()
    {
        return isset($this->ShippedQty) ? $this->ShippedQty : null;
    }
    /**
     * Set ShippedQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $shippedQty
     * @return \StructType\SalesOrderShipment
     */
    public function setShippedQty(\StructType\DecimalValue $shippedQty = null)
    {
        if (is_null($shippedQty) || (is_array($shippedQty) && empty($shippedQty))) {
            unset($this->ShippedQty);
        } else {
            $this->ShippedQty = $shippedQty;
        }
        return $this;
    }
    /**
     * Get ShippedVolume value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getShippedVolume()
    {
        return isset($this->ShippedVolume) ? $this->ShippedVolume : null;
    }
    /**
     * Set ShippedVolume value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $shippedVolume
     * @return \StructType\SalesOrderShipment
     */
    public function setShippedVolume(\StructType\DecimalValue $shippedVolume = null)
    {
        if (is_null($shippedVolume) || (is_array($shippedVolume) && empty($shippedVolume))) {
            unset($this->ShippedVolume);
        } else {
            $this->ShippedVolume = $shippedVolume;
        }
        return $this;
    }
    /**
     * Get ShippedWeight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getShippedWeight()
    {
        return isset($this->ShippedWeight) ? $this->ShippedWeight : null;
    }
    /**
     * Set ShippedWeight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $shippedWeight
     * @return \StructType\SalesOrderShipment
     */
    public function setShippedWeight(\StructType\DecimalValue $shippedWeight = null)
    {
        if (is_null($shippedWeight) || (is_array($shippedWeight) && empty($shippedWeight))) {
            unset($this->ShippedWeight);
        } else {
            $this->ShippedWeight = $shippedWeight;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $status
     * @return \StructType\SalesOrderShipment
     */
    public function setStatus(\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
}
